/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class AdminMetadataManagerTest {
    private final MockTime time = new MockTime();
    private final LogContext logContext = new LogContext();
    private final long refreshBackoffMs = 100L;
    private final long metadataExpireMs = 60000L;
    private final AdminMetadataManager mgr = new AdminMetadataManager(this.logContext, 100L, 60000L, false);

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testSetUsingBootstrapControllers(boolean usingBootstrapControllers) {
        AdminMetadataManager manager = new AdminMetadataManager(this.logContext, 100L, 60000L, usingBootstrapControllers);
        Assertions.assertEquals((Object)usingBootstrapControllers, (Object)manager.usingBootstrapControllers());
    }

    @Test
    public void testMetadataReady() {
        Assertions.assertFalse((boolean)this.mgr.isReady());
        Assertions.assertEquals((long)0L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.mgr.update(Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9999))), this.time.milliseconds());
        Assertions.assertFalse((boolean)this.mgr.isReady());
        Assertions.assertEquals((long)0L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.mgr.update(AdminMetadataManagerTest.mockCluster(), this.time.milliseconds());
        Assertions.assertTrue((boolean)this.mgr.isReady());
        Assertions.assertEquals((long)60000L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.time.sleep(60000L);
        Assertions.assertEquals((long)0L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
    }

    @Test
    public void testMetadataRefreshBackoff() {
        this.mgr.transitionToUpdatePending(this.time.milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.mgr.updateFailed((Throwable)new RuntimeException());
        Assertions.assertEquals((long)100L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.mgr.requestUpdate();
        Assertions.assertEquals((long)100L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.time.sleep(100L);
        Assertions.assertEquals((long)0L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
    }

    @Test
    public void testAuthenticationFailure() {
        this.mgr.transitionToUpdatePending(this.time.milliseconds());
        this.mgr.updateFailed((Throwable)new AuthenticationException("Authentication failed"));
        Assertions.assertEquals((long)100L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        Assertions.assertThrows(AuthenticationException.class, () -> ((AdminMetadataManager)this.mgr).isReady());
        this.mgr.update(AdminMetadataManagerTest.mockCluster(), this.time.milliseconds());
        Assertions.assertTrue((boolean)this.mgr.isReady());
    }

    @Test
    public void testNeedsRebootstrap() {
        long rebootstrapTriggerMs = 1000L;
        this.mgr.update(Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9999))), this.time.milliseconds());
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds(), rebootstrapTriggerMs));
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 2000L, rebootstrapTriggerMs));
        this.mgr.transitionToUpdatePending(this.time.milliseconds());
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds(), rebootstrapTriggerMs));
        Assertions.assertTrue((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 1001L, rebootstrapTriggerMs));
        this.time.sleep(100L);
        this.mgr.updateFailed((Throwable)new RuntimeException());
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 900L, rebootstrapTriggerMs));
        Assertions.assertTrue((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 901L, rebootstrapTriggerMs));
        this.time.sleep(1000L);
        this.mgr.update(AdminMetadataManagerTest.mockCluster(), this.time.milliseconds());
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds(), rebootstrapTriggerMs));
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 2000L, rebootstrapTriggerMs));
        this.time.sleep(1000L);
        this.mgr.transitionToUpdatePending(this.time.milliseconds());
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds(), rebootstrapTriggerMs));
        Assertions.assertTrue((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 1001L, rebootstrapTriggerMs));
        this.time.sleep(1001L);
        Assertions.assertTrue((boolean)this.mgr.needsRebootstrap(this.time.milliseconds(), rebootstrapTriggerMs));
        this.mgr.rebootstrap(this.time.milliseconds());
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds(), rebootstrapTriggerMs));
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 1000L, rebootstrapTriggerMs));
        Assertions.assertTrue((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 1001L, rebootstrapTriggerMs));
        this.mgr.initiateRebootstrap();
        Assertions.assertTrue((boolean)this.mgr.needsRebootstrap(this.time.milliseconds(), rebootstrapTriggerMs));
        this.mgr.rebootstrap(this.time.milliseconds());
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds(), rebootstrapTriggerMs));
        Assertions.assertFalse((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 1000L, rebootstrapTriggerMs));
        Assertions.assertTrue((boolean)this.mgr.needsRebootstrap(this.time.milliseconds() + 1001L, rebootstrapTriggerMs));
    }

    private static Cluster mockCluster() {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        nodes.put(1, new Node(1, "localhost", 8122));
        nodes.put(2, new Node(2, "localhost", 8123));
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
    }
}

