/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ErrorEvent;
import org.apache.kafka.clients.consumer.internals.metrics.AsyncConsumerMetrics;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BackgroundEventHandlerTest {
    private final BlockingQueue<BackgroundEvent> backgroundEventsQueue = new LinkedBlockingQueue<BackgroundEvent>();

    @Test
    public void testRecordBackgroundEventQueueSize() {
        try (Metrics metrics = new Metrics();
             AsyncConsumerMetrics asyncConsumerMetrics = new AsyncConsumerMetrics(metrics);){
            BackgroundEventHandler backgroundEventHandler = new BackgroundEventHandler(this.backgroundEventsQueue, (Time)new MockTime(0L), asyncConsumerMetrics);
            backgroundEventHandler.add((BackgroundEvent)new ErrorEvent(new Throwable()));
            Assertions.assertEquals((double)1.0, (double)((Double)metrics.metric(metrics.metricName("background-event-queue-size", "consumer-metrics")).metricValue()));
            backgroundEventHandler.drainEvents();
            Assertions.assertEquals((double)0.0, (double)((Double)metrics.metric(metrics.metricName("background-event-queue-size", "consumer-metrics")).metricValue()));
        }
    }
}

