/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.AcknowledgementCommitCallback;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ShareConsumerImpl;
import org.apache.kafka.clients.consumer.internals.ShareFetch;
import org.apache.kafka.clients.consumer.internals.ShareFetchBuffer;
import org.apache.kafka.clients.consumer.internals.ShareFetchCollector;
import org.apache.kafka.clients.consumer.internals.ShareInFlightBatch;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEventHandler;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableEventReaper;
import org.apache.kafka.clients.consumer.internals.events.ErrorEvent;
import org.apache.kafka.clients.consumer.internals.events.PollEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgeOnCloseEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareAcknowledgementCommitCallbackRegistrationEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareSubscriptionChangeEvent;
import org.apache.kafka.clients.consumer.internals.events.ShareUnsubscribeEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidGroupIdException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.test.MockConsumerInterceptor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ShareConsumerImplTest {
    private ShareConsumerImpl<String, String> consumer = null;
    private final Time time = new MockTime(1L);
    private final ShareFetchCollector<String, String> fetchCollector = (ShareFetchCollector)Mockito.mock(ShareFetchCollector.class);
    private final ConsumerMetadata metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
    private final ApplicationEventHandler applicationEventHandler = (ApplicationEventHandler)Mockito.mock(ApplicationEventHandler.class);
    private final LinkedBlockingQueue<BackgroundEvent> backgroundEventQueue = new LinkedBlockingQueue();
    private final CompletableEventReaper backgroundEventReaper = (CompletableEventReaper)Mockito.mock(CompletableEventReaper.class);

    @AfterEach
    public void resetAll() {
        this.backgroundEventQueue.clear();
        if (this.consumer != null) {
            this.consumer.close(Duration.ZERO);
        }
        this.consumer = null;
        Mockito.framework().clearInlineMocks();
        MockConsumerInterceptor.resetCounters();
    }

    private ShareConsumerImpl<String, String> newConsumer() {
        Properties props = this.requiredConsumerProperties();
        props.put("group.id", "group-id");
        return this.newConsumer(props);
    }

    private ShareConsumerImpl<String, String> newConsumerWithEmptyGroupId() {
        Properties props = this.requiredConsumerPropertiesAndGroupId("");
        return this.newConsumer(props);
    }

    private ShareConsumerImpl<String, String> newConsumer(Properties props) {
        ConsumerConfig config = new ConsumerConfig(props);
        return this.newConsumer(config);
    }

    private ShareConsumerImpl<String, String> newConsumer(ConsumerConfig config) {
        return new ShareConsumerImpl(config, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), this.time, (a, b, c, d, e, f, g, h) -> this.applicationEventHandler, a -> this.backgroundEventReaper, (a, b, c, d, e) -> this.fetchCollector, this.backgroundEventQueue);
    }

    private ShareConsumerImpl<String, String> newConsumer(SubscriptionState subscriptions) {
        return this.newConsumer((ShareFetchBuffer)Mockito.mock(ShareFetchBuffer.class), subscriptions, "group-id", "client-id");
    }

    private ShareConsumerImpl<String, String> newConsumer(ShareFetchBuffer fetchBuffer, SubscriptionState subscriptions, String groupId, String clientId) {
        int defaultApiTimeoutMs = 1000;
        return new ShareConsumerImpl(new LogContext(), clientId, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), fetchBuffer, this.fetchCollector, this.time, this.applicationEventHandler, this.backgroundEventQueue, this.backgroundEventReaper, new Metrics(), subscriptions, this.metadata, 1000, groupId);
    }

    @Test
    public void testSuccessfulStartupShutdown() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        this.completeShareAcknowledgeOnCloseApplicationEventSuccessfully();
        this.completeShareUnsubscribeApplicationEventSuccessfully(subscriptions);
        Assertions.assertDoesNotThrow(() -> this.consumer.close());
    }

    @Test
    public void testInvalidGroupId() {
        KafkaException e = (KafkaException)Assertions.assertThrows(KafkaException.class, this::newConsumerWithEmptyGroupId);
        Assertions.assertInstanceOf(InvalidGroupIdException.class, (Object)e.getCause());
    }

    @Test
    public void testFailConstructor() {
        Properties props = this.requiredConsumerProperties();
        props.put("group.id", "group-id");
        props.put("metric.reporters", "an.invalid.class");
        ConsumerConfig config = new ConsumerConfig(props);
        KafkaException ce = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.newConsumer(config));
        Assertions.assertTrue((boolean)ce.getMessage().contains("Failed to construct Kafka share consumer"), (String)("Unexpected exception message: " + ce.getMessage()));
        Assertions.assertTrue((boolean)ce.getCause().getMessage().contains("Class an.invalid.class cannot be found"), (String)("Unexpected cause: " + String.valueOf(ce.getCause())));
    }

    @Test
    public void testWakeupBeforeCallingPoll() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        String topicName = "foo";
        ((ShareFetchCollector)Mockito.doReturn((Object)ShareFetch.empty()).when(this.fetchCollector)).collect((ShareFetchBuffer)ArgumentMatchers.any(ShareFetchBuffer.class));
        List<String> subscriptionTopic = Collections.singletonList("foo");
        this.completeShareSubscriptionChangeApplicationEventSuccessfully(subscriptions, subscriptionTopic);
        this.consumer.subscribe(subscriptionTopic);
        this.consumer.wakeup();
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.poll(Duration.ZERO));
        Assertions.assertDoesNotThrow(() -> this.consumer.poll(Duration.ZERO));
    }

    @Test
    public void testWakeupAfterEmptyFetch() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        String topicName = "foo";
        ((ShareFetchCollector)Mockito.doAnswer(invocation -> {
            this.consumer.wakeup();
            return ShareFetch.empty();
        }).doAnswer(invocation -> ShareFetch.empty()).when(this.fetchCollector)).collect((ShareFetchBuffer)ArgumentMatchers.any(ShareFetchBuffer.class));
        List<String> subscriptionTopic = Collections.singletonList("foo");
        this.completeShareSubscriptionChangeApplicationEventSuccessfully(subscriptions, subscriptionTopic);
        this.consumer.subscribe(subscriptionTopic);
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.poll(Duration.ofMinutes(1L)));
        Assertions.assertDoesNotThrow(() -> this.consumer.poll(Duration.ZERO));
    }

    @Test
    public void testWakeupAfterNonEmptyFetch() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        String topicName = "foo";
        int partition = 3;
        TopicIdPartition tip = new TopicIdPartition(Uuid.randomUuid(), 3, "foo");
        ShareInFlightBatch batch = new ShareInFlightBatch(0, tip);
        batch.addRecord(new ConsumerRecord("foo", 3, 2L, (Object)"key1", (Object)"value1"));
        ((ShareFetchCollector)Mockito.doAnswer(invocation -> {
            this.consumer.wakeup();
            ShareFetch fetch = ShareFetch.empty();
            fetch.add(tip, batch);
            return fetch;
        }).when(this.fetchCollector)).collect((ShareFetchBuffer)Mockito.any(ShareFetchBuffer.class));
        List<String> subscriptionTopic = Collections.singletonList("foo");
        this.completeShareSubscriptionChangeApplicationEventSuccessfully(subscriptions, subscriptionTopic);
        this.consumer.subscribe(subscriptionTopic);
        Assertions.assertDoesNotThrow(() -> this.consumer.poll(Duration.ofMinutes(1L)));
        Assertions.assertThrows(WakeupException.class, () -> this.consumer.poll(Duration.ZERO));
    }

    @Test
    public void testFailOnClosedConsumer() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        this.completeShareAcknowledgeOnCloseApplicationEventSuccessfully();
        this.completeShareUnsubscribeApplicationEventSuccessfully(subscriptions);
        this.consumer.close();
        IllegalStateException res = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.consumer.subscription());
        Assertions.assertEquals((Object)"This consumer has already been closed.", (Object)res.getMessage());
    }

    @Test
    public void testVerifyApplicationEventOnShutdown() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        this.completeShareAcknowledgeOnCloseApplicationEventSuccessfully();
        this.completeShareUnsubscribeApplicationEventSuccessfully(subscriptions);
        this.consumer.close();
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(ShareAcknowledgeOnCloseEvent.class));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.any(ShareUnsubscribeEvent.class));
    }

    @Test
    public void testAcknowledgementCommitCallbackRegistrationEvent() {
        this.consumer = this.newConsumer();
        AcknowledgementCommitCallback callback = (AcknowledgementCommitCallback)Mockito.mock(AcknowledgementCommitCallback.class);
        this.consumer.setAcknowledgementCommitCallback(callback);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.argThat(event -> event instanceof ShareAcknowledgementCommitCallbackRegistrationEvent && ((ShareAcknowledgementCommitCallbackRegistrationEvent)event).isCallbackRegistered()));
        this.consumer.setAcknowledgementCommitCallback(callback);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.times((int)1))).add((ApplicationEvent)ArgumentMatchers.any(ShareAcknowledgementCommitCallbackRegistrationEvent.class));
    }

    @Test
    public void testAcknowledgementCommitCallbackRegistrationEvent_Null() {
        this.consumer = this.newConsumer();
        AcknowledgementCommitCallback callback = (AcknowledgementCommitCallback)Mockito.mock(AcknowledgementCommitCallback.class);
        this.consumer.setAcknowledgementCommitCallback(null);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.times((int)0))).add((ApplicationEvent)ArgumentMatchers.any(ShareAcknowledgementCommitCallbackRegistrationEvent.class));
        this.consumer.setAcknowledgementCommitCallback(callback);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler, (VerificationMode)Mockito.times((int)1))).add((ApplicationEvent)ArgumentMatchers.any(ShareAcknowledgementCommitCallbackRegistrationEvent.class));
        this.consumer.setAcknowledgementCommitCallback(null);
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.argThat(event -> event instanceof ShareAcknowledgementCommitCallbackRegistrationEvent && !((ShareAcknowledgementCommitCallbackRegistrationEvent)event).isCallbackRegistered()));
    }

    @Test
    public void testCompleteQuietly() {
        AtomicReference exception = new AtomicReference();
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        this.consumer = this.newConsumer();
        Assertions.assertDoesNotThrow(() -> this.consumer.completeQuietly(() -> future.get(0L, TimeUnit.MILLISECONDS), "test", exception));
        Assertions.assertNull(exception.get());
        Assertions.assertDoesNotThrow(() -> this.consumer.completeQuietly(() -> {
            throw new KafkaException("Test exception");
        }, "test", exception));
        Assertions.assertInstanceOf(KafkaException.class, exception.get());
    }

    @Test
    public void testSubscribeGeneratesEvent() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        String topic = "topic1";
        List<String> subscriptionTopic = Collections.singletonList(topic);
        this.completeShareSubscriptionChangeApplicationEventSuccessfully(subscriptions, subscriptionTopic);
        this.consumer.subscribe(subscriptionTopic);
        Assertions.assertEquals(Collections.singleton(topic), (Object)this.consumer.subscription());
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ShareSubscriptionChangeEvent.class));
    }

    @Test
    public void testUnsubscribeGeneratesUnsubscribeEvent() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        this.completeShareUnsubscribeApplicationEventSuccessfully(subscriptions);
        this.consumer.unsubscribe();
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ShareUnsubscribeEvent.class));
    }

    @Test
    public void testSubscribeToEmptyListActsAsUnsubscribe() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        this.completeShareUnsubscribeApplicationEventSuccessfully(subscriptions);
        this.consumer.subscribe(Collections.emptyList());
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ShareUnsubscribeEvent.class));
    }

    @Test
    public void testSubscribeToNullTopicCollection() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(null));
    }

    @Test
    public void testSubscriptionOnNullTopic() {
        this.consumer = this.newConsumer();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(Collections.singletonList(null)));
    }

    @Test
    public void testSubscriptionOnEmptyTopic() {
        this.consumer = this.newConsumer();
        String emptyTopic = "  ";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.consumer.subscribe(Collections.singletonList(emptyTopic)));
    }

    @Test
    public void testBackgroundError() {
        String groupId = "shareGroupA";
        ConsumerConfig config = new ConsumerConfig(this.requiredConsumerPropertiesAndGroupId("shareGroupA"));
        this.consumer = this.newConsumer(config);
        KafkaException expectedException = new KafkaException("Nobody expects the Spanish Inquisition");
        ErrorEvent errorBackgroundEvent = new ErrorEvent((Throwable)expectedException);
        this.backgroundEventQueue.add((BackgroundEvent)errorBackgroundEvent);
        this.consumer.subscribe(Collections.singletonList("t1"));
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.consumer.poll(Duration.ZERO));
        Assertions.assertEquals((Object)expectedException.getMessage(), (Object)exception.getMessage());
    }

    @Test
    public void testMultipleBackgroundErrors() {
        String groupId = "shareGroupA";
        ConsumerConfig config = new ConsumerConfig(this.requiredConsumerPropertiesAndGroupId("shareGroupA"));
        this.consumer = this.newConsumer(config);
        KafkaException expectedException1 = new KafkaException("Nobody expects the Spanish Inquisition");
        ErrorEvent errorBackgroundEvent1 = new ErrorEvent((Throwable)expectedException1);
        this.backgroundEventQueue.add((BackgroundEvent)errorBackgroundEvent1);
        KafkaException expectedException2 = new KafkaException("Spam, Spam, Spam");
        ErrorEvent errorBackgroundEvent2 = new ErrorEvent((Throwable)expectedException2);
        this.backgroundEventQueue.add((BackgroundEvent)errorBackgroundEvent2);
        this.consumer.subscribe(Collections.singletonList("t1"));
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.consumer.poll(Duration.ZERO));
        Assertions.assertEquals((Object)expectedException1.getMessage(), (Object)exception.getMessage());
        Assertions.assertTrue((boolean)this.backgroundEventQueue.isEmpty());
    }

    @Test
    public void testGroupIdNull() {
        Properties props = this.requiredConsumerProperties();
        ConsumerConfig config = new ConsumerConfig(props);
        Exception exception = (Exception)Assertions.assertThrows(KafkaException.class, () -> {
            this.consumer = this.newConsumer(config);
        });
        Assertions.assertEquals((Object)"Failed to construct Kafka share consumer", (Object)exception.getMessage());
    }

    @Test
    public void testGroupIdEmpty() {
        this.testInvalidGroupId("");
    }

    @Test
    public void testGroupIdOnlyWhitespaces() {
        this.testInvalidGroupId("       ");
    }

    private void testInvalidGroupId(String groupId) {
        Properties props = this.requiredConsumerPropertiesAndGroupId(groupId);
        ConsumerConfig config = new ConsumerConfig(props);
        Exception exception = (Exception)Assertions.assertThrows(KafkaException.class, () -> {
            this.consumer = this.newConsumer(config);
        });
        Assertions.assertEquals((Object)"Failed to construct Kafka share consumer", (Object)exception.getMessage());
    }

    @Test
    public void testEnsurePollEventSentOnConsumerPoll() {
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), AutoOffsetResetStrategy.NONE);
        this.consumer = this.newConsumer(subscriptions);
        TopicPartition tp = new TopicPartition("topic", 0);
        TopicIdPartition tip = new TopicIdPartition(Uuid.randomUuid(), tp);
        ShareInFlightBatch batch = new ShareInFlightBatch(0, tip);
        batch.addRecord(new ConsumerRecord("topic", 0, 2L, (Object)"key1", (Object)"value1"));
        ShareFetch fetch = ShareFetch.empty();
        fetch.add(tip, batch);
        ((ShareFetchCollector)Mockito.doAnswer(invocation -> fetch).when(this.fetchCollector)).collect((ShareFetchBuffer)Mockito.any(ShareFetchBuffer.class));
        List<String> subscriptionTopic = Collections.singletonList("topic");
        this.completeShareSubscriptionChangeApplicationEventSuccessfully(subscriptions, subscriptionTopic);
        this.consumer.subscribe(subscriptionTopic);
        this.consumer.poll(Duration.ofMillis(100L));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.any(PollEvent.class));
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(ShareSubscriptionChangeEvent.class));
        this.completeShareAcknowledgeOnCloseApplicationEventSuccessfully();
        this.completeShareUnsubscribeApplicationEventSuccessfully(subscriptions);
        this.consumer.close();
        ((ApplicationEventHandler)Mockito.verify((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.any(ShareAcknowledgeOnCloseEvent.class));
    }

    private Properties requiredConsumerPropertiesAndGroupId(String groupId) {
        Properties props = this.requiredConsumerProperties();
        props.put("group.id", groupId);
        return props;
    }

    private Properties requiredConsumerProperties() {
        Properties props = new Properties();
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.put("bootstrap.servers", "localhost:9091");
        return props;
    }

    @Test
    public void testProcessBackgroundEventsWithInitialDelay() throws Exception {
        this.consumer = this.newConsumer();
        MockTime time = new MockTime();
        Timer timer = time.timer(1000L);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        CountDownLatch latch = new CountDownLatch(3);
        ((CompletableFuture)Mockito.doAnswer(invocation -> {
            latch.countDown();
            if (latch.getCount() > 0L) {
                long timeout = (Long)invocation.getArgument(0, Long.class);
                timer.sleep(timeout);
                throw new TimeoutException("Intentional timeout");
            }
            future.complete(null);
            return null;
        }).when((Object)future)).get((Long)ArgumentMatchers.any(Long.class), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        this.consumer.processBackgroundEvents((Future)future, timer);
        Assertions.assertEquals((long)800L, (long)timer.remainingMs());
    }

    @Test
    public void testProcessBackgroundEventsWithoutDelay() {
        this.consumer = this.newConsumer();
        MockTime time = new MockTime();
        Timer timer = time.timer(1000L);
        CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
        this.consumer.processBackgroundEvents(future, timer);
        Assertions.assertEquals((long)1000L, (long)timer.remainingMs());
    }

    @Test
    public void testProcessBackgroundEventsTimesOut() throws Exception {
        this.consumer = this.newConsumer();
        MockTime time = new MockTime();
        Timer timer = time.timer(1000L);
        CompletableFuture future = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        ((CompletableFuture)Mockito.doAnswer(invocation -> {
            long timeout = (Long)invocation.getArgument(0, Long.class);
            timer.sleep(timeout);
            throw new TimeoutException("Intentional timeout");
        }).when((Object)future)).get((Long)ArgumentMatchers.any(Long.class), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        Assertions.assertThrows(org.apache.kafka.common.errors.TimeoutException.class, () -> this.consumer.processBackgroundEvents((Future)future, timer));
        Assertions.assertEquals((long)0L, (long)timer.remainingMs());
    }

    private void completeShareSubscriptionChangeApplicationEventSuccessfully(SubscriptionState subscriptions, List<String> topics) {
        ((ApplicationEventHandler)Mockito.doAnswer(invocation -> {
            ShareSubscriptionChangeEvent event = (ShareSubscriptionChangeEvent)invocation.getArgument(0);
            subscriptions.subscribeToShareGroup(new HashSet(topics));
            event.future().complete(null);
            return null;
        }).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ShareSubscriptionChangeEvent.class));
    }

    private void completeShareUnsubscribeApplicationEventSuccessfully(SubscriptionState subscriptions) {
        ((ApplicationEventHandler)Mockito.doAnswer(invocation -> {
            ShareUnsubscribeEvent event = (ShareUnsubscribeEvent)invocation.getArgument(0);
            subscriptions.unsubscribe();
            event.future().complete(null);
            return null;
        }).when((Object)this.applicationEventHandler)).add((ApplicationEvent)ArgumentMatchers.isA(ShareUnsubscribeEvent.class));
    }

    private void completeShareAcknowledgeOnCloseApplicationEventSuccessfully() {
        ((ApplicationEventHandler)Mockito.doAnswer(invocation -> {
            ShareAcknowledgeOnCloseEvent event = (ShareAcknowledgeOnCloseEvent)invocation.getArgument(0);
            event.future().complete(null);
            return null;
        }).when((Object)this.applicationEventHandler)).addAndGet((CompletableApplicationEvent)ArgumentMatchers.isA(ShareAcknowledgeOnCloseEvent.class));
    }
}

