/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.stream.Stream;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.DefaultChannelMetadataRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class ChannelMetadataRegistryTest {
    private static final String CLIENT_ID = "some_client_id";
    private static final String CLIENT_ID_2 = "some_client_id_2";
    private static final ClientInformation CLIENT_INFORMATION = new ClientInformation("some_name", "some_version");
    private ChannelMetadataRegistry metadataRegistry;

    @BeforeEach
    public void setUp() {
        this.metadataRegistry = new DefaultChannelMetadataRegistry();
    }

    @ParameterizedTest
    @ArgumentsSource(value=ClientInformationEmptyTestCaseProvider.class)
    public void testIsClientInformationEmpty(ClientInformation clientInformation, String clientId, boolean expected) {
        this.metadataRegistry.registerClientInformation(clientInformation);
        this.metadataRegistry.registerClientId(clientId);
        Assertions.assertEquals((Object)expected, (Object)(ClientInformation.isNullOrEmpty((ClientInformation)clientInformation) && clientId == null ? 1 : 0));
    }

    @ParameterizedTest
    @ArgumentsSource(value=ClientInformationFullTestCaseProvider.class)
    public void testIsClientInformationFull(ClientInformation clientInformation, String clientId, boolean expected) {
        this.metadataRegistry.registerClientInformation(clientInformation);
        this.metadataRegistry.registerClientId(clientId);
        Assertions.assertEquals((Object)expected, (Object)(!ClientInformation.isNullOrEmpty((ClientInformation)clientInformation) && clientId != null ? 1 : 0));
    }

    @Test
    public void testRegisterClientId() {
        Assertions.assertNull((Object)this.metadataRegistry.clientId(), (String)"ClientId should initially be null after metadata registry is created");
        this.metadataRegistry.registerClientId(null);
        Assertions.assertNull((Object)this.metadataRegistry.clientId(), (String)"ClientId should be null after null client id is registered");
        this.metadataRegistry.registerClientId(CLIENT_ID);
        Assertions.assertEquals((Object)CLIENT_ID, (Object)this.metadataRegistry.clientId());
        this.metadataRegistry.registerClientId(null);
        Assertions.assertEquals((Object)CLIENT_ID, (Object)this.metadataRegistry.clientId(), (String)"ClientId should only be registered once");
        this.metadataRegistry.registerClientId(CLIENT_ID_2);
        Assertions.assertEquals((Object)CLIENT_ID, (Object)this.metadataRegistry.clientId(), (String)"ClientId should only be registered once");
    }

    private static class ClientInformationFullTestCaseProvider
    implements ArgumentsProvider {
        private ClientInformationFullTestCaseProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
            return Stream.of(Arguments.of((Object[])new Object[]{null, null, false}), Arguments.of((Object[])new Object[]{ClientInformation.EMPTY, null, false}), Arguments.of((Object[])new Object[]{CLIENT_INFORMATION, null, false}), Arguments.of((Object[])new Object[]{null, ChannelMetadataRegistryTest.CLIENT_ID, false}), Arguments.of((Object[])new Object[]{ClientInformation.EMPTY, ChannelMetadataRegistryTest.CLIENT_ID, false}), Arguments.of((Object[])new Object[]{CLIENT_INFORMATION, ChannelMetadataRegistryTest.CLIENT_ID, true}));
        }
    }

    private static class ClientInformationEmptyTestCaseProvider
    implements ArgumentsProvider {
        private ClientInformationEmptyTestCaseProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext extensionContext) {
            return Stream.of(Arguments.of((Object[])new Object[]{null, null, true}), Arguments.of((Object[])new Object[]{ClientInformation.EMPTY, null, true}), Arguments.of((Object[])new Object[]{CLIENT_INFORMATION, null, false}), Arguments.of((Object[])new Object[]{null, ChannelMetadataRegistryTest.CLIENT_ID, false}), Arguments.of((Object[])new Object[]{ClientInformation.EMPTY, ChannelMetadataRegistryTest.CLIENT_ID, false}), Arguments.of((Object[])new Object[]{CLIENT_INFORMATION, ChannelMetadataRegistryTest.CLIENT_ID, false}));
        }
    }
}

