/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.Optional;
import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PublicCredentialTest {
    @Test
    public void testCredentialEquals() {
        PublicCredential cred1 = PublicCredential.authenticatedCredential((String)"user1", Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN");
        Assertions.assertEquals((Object)cred1, (Object)PublicCredential.authenticatedCredential((String)"user1", Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user2", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.authenticatedCredential((String)"user1", Optional.of("networkId1"), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, null));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", null, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential(null, null, null));
        cred1 = PublicCredential.authenticatedCredential((String)"user1", Optional.of("networkId1"), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN");
        Assertions.assertEquals((Object)cred1, (Object)PublicCredential.authenticatedCredential((String)"user1", Optional.of("networkId1"), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
    }

    @Test
    public void testCredentialMatches() {
        PublicCredential cred1 = PublicCredential.authenticatedCredential((String)"user1", Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN");
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.credential((String)"user2", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER")));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, null)));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.saslCredential((String)"user1", (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.saslCredential((String)"user2", (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.saslCredential((String)"user1", (String)"OAUTHBEARER")));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.saslCredential((String)"user1", null)));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential((String)"user1", null, (String)"PLAIN")));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN")));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential(null, null, null)));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)"user2", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(cred1));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"PLAIN").matches(cred1));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, null).matches(cred1));
        Assertions.assertFalse((boolean)PublicCredential.saslCredential((String)"user2", (String)"PLAIN").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.saslCredential((String)"user1", (String)"PLAIN").matches(cred1));
        Assertions.assertFalse((boolean)PublicCredential.saslCredential((String)"user1", (String)"OAUTHBEARER").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.saslCredential((String)"user1", null).matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.credential((String)"user1", null, (String)"PLAIN").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.credential(null, null, null).matches(cred1));
        String networkId = "networkId1";
        PublicCredential networkIdMatchingCredential = PublicCredential.saslNetworkIdCredential((String)networkId, (String)"PLAIN");
        Assertions.assertFalse((boolean)cred1.matches(networkIdMatchingCredential));
        Assertions.assertTrue((boolean)PublicCredential.authenticatedCredential((String)"user1", Optional.of(networkId), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(networkIdMatchingCredential));
        Assertions.assertTrue((boolean)PublicCredential.authenticatedCredential((String)"user2", Optional.of(networkId), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(networkIdMatchingCredential));
        Assertions.assertFalse((boolean)PublicCredential.authenticatedCredential((String)"user1", Optional.of("NetworkIdFoo"), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(networkIdMatchingCredential));
        Assertions.assertFalse((boolean)PublicCredential.authenticatedCredential((String)"user1", Optional.of(networkId), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER").matches(networkIdMatchingCredential));
    }

    @Test
    public void testMTlsCredentialMatches() {
        PublicCredential mTlsCred = PublicCredential.mTlsCredential((String)"orgId", (String)"providerId", (String)"CN=Private CA", (String)"00AAFF");
        String authnId = MultiTenantPrincipal.mTlsAuthenticationId((String)"orgId", (String)"providerId", (String)"CN=Private CA", (String)"00AAFF");
        Assertions.assertTrue((boolean)mTlsCred.matches(PublicCredential.authenticatedCredential((String)authnId, Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"MTLS")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.authenticatedCredential((String)authnId, Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.authenticatedCredential((String)authnId, Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"PLAIN")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.authenticatedCredential((String)authnId, Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.authenticatedCredential((String)authnId, Optional.empty(), (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"OAUTHBEARER")));
        Assertions.assertTrue((boolean)mTlsCred.matches(PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"MTLS")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"PLAIN")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"OAUTHBEARER")));
        Assertions.assertTrue((boolean)mTlsCred.matches(PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_SSL, null)));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, null)));
        Assertions.assertTrue((boolean)mTlsCred.matches(PublicCredential.saslCredential((String)authnId, (String)"MTLS")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.saslCredential((String)authnId, (String)"PLAIN")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.saslCredential((String)authnId, (String)"OAUTHBEARER")));
        Assertions.assertTrue((boolean)mTlsCred.matches(PublicCredential.saslCredential((String)authnId, null)));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.saslCredential((String)"user2", (String)"MTLS")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.saslCredential((String)"user2", (String)"OAUTHBEARER")));
        Assertions.assertFalse((boolean)mTlsCred.matches(PublicCredential.saslCredential((String)"user2", (String)"OAUTHBEARER")));
        Assertions.assertTrue((boolean)mTlsCred.matches(PublicCredential.credential((String)authnId, null, (String)"MTLS")));
        Assertions.assertTrue((boolean)mTlsCred.matches(PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"MTLS")));
        Assertions.assertTrue((boolean)mTlsCred.matches(PublicCredential.credential(null, null, null)));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)"user2", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"MTLS").matches(mTlsCred));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"MTLS").matches(mTlsCred));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(mTlsCred));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER").matches(mTlsCred));
        Assertions.assertTrue((boolean)PublicCredential.credential((String)authnId, (SecurityProtocol)SecurityProtocol.SASL_SSL, null).matches(mTlsCred));
        Assertions.assertFalse((boolean)PublicCredential.saslCredential((String)"user2", (String)"MTLS").matches(mTlsCred));
        Assertions.assertTrue((boolean)PublicCredential.saslCredential((String)authnId, (String)"MTLS").matches(mTlsCred));
        Assertions.assertFalse((boolean)PublicCredential.saslCredential((String)authnId, (String)"PLAIN").matches(mTlsCred));
        Assertions.assertFalse((boolean)PublicCredential.saslCredential((String)authnId, (String)"OAUTHBEARER").matches(mTlsCred));
        Assertions.assertTrue((boolean)PublicCredential.saslCredential((String)authnId, null).matches(mTlsCred));
        Assertions.assertTrue((boolean)PublicCredential.credential((String)authnId, null, (String)"MTLS").matches(mTlsCred));
        Assertions.assertTrue((boolean)PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"MTLS").matches(mTlsCred));
        Assertions.assertTrue((boolean)PublicCredential.credential(null, null, null).matches(mTlsCred));
        String networkId = "networkId1";
        PublicCredential networkIdMatchingCredential = PublicCredential.saslNetworkIdCredential((String)networkId, (String)"PLAIN");
        Assertions.assertFalse((boolean)mTlsCred.matches(networkIdMatchingCredential));
        Assertions.assertFalse((boolean)networkIdMatchingCredential.matches(mTlsCred));
        Assertions.assertTrue((boolean)PublicCredential.authenticatedCredential((String)"user1", Optional.of(networkId), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(networkIdMatchingCredential));
        Assertions.assertTrue((boolean)PublicCredential.authenticatedCredential((String)"user2", Optional.of(networkId), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(networkIdMatchingCredential));
        Assertions.assertFalse((boolean)mTlsCred.matches(networkIdMatchingCredential));
        Assertions.assertFalse((boolean)PublicCredential.authenticatedCredential((String)authnId, Optional.of("NetworkIdFoo"), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(networkIdMatchingCredential));
        Assertions.assertFalse((boolean)PublicCredential.authenticatedCredential((String)authnId, Optional.of(networkId), (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER").matches(networkIdMatchingCredential));
    }
}

