/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

public class LegacyRecordTest {
    @ParameterizedTest
    @ArgumentsSource(value=LegacyRecordArgumentsProvider.class)
    public void testFields(Args args) {
        LegacyRecord record = args.record;
        ByteBuffer key = args.key;
        Assertions.assertEquals((Object)args.compression, (Object)record.compressionType());
        Assertions.assertEquals((Object)(key != null ? 1 : 0), (Object)record.hasKey());
        Assertions.assertEquals((Object)key, (Object)record.key());
        if (key != null) {
            Assertions.assertEquals((int)key.limit(), (int)record.keySize());
        }
        Assertions.assertEquals((byte)args.magic, (byte)record.magic());
        Assertions.assertEquals((Object)args.value, (Object)record.value());
        if (args.value != null) {
            Assertions.assertEquals((int)args.value.limit(), (int)record.valueSize());
        }
        if (args.magic > 0) {
            Assertions.assertEquals((long)args.timestamp, (long)record.timestamp());
            Assertions.assertEquals((Object)args.timestampType, (Object)record.timestampType());
        } else {
            Assertions.assertEquals((long)-1L, (long)record.timestamp());
            Assertions.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)record.timestampType());
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=LegacyRecordArgumentsProvider.class)
    public void testChecksum(Args args) {
        LegacyRecord record = args.record;
        Assertions.assertEquals((long)record.checksum(), (long)record.computeChecksum());
        byte attributes = LegacyRecord.computeAttributes((byte)args.magic, (CompressionType)args.compression, (TimestampType)TimestampType.CREATE_TIME);
        Assertions.assertEquals((long)record.checksum(), (long)LegacyRecord.computeChecksum((byte)args.magic, (byte)attributes, (long)args.timestamp, (byte[])(args.key == null ? null : args.key.array()), args.value == null ? null : args.value.array()));
        Assertions.assertTrue((boolean)record.isValid());
        for (int i = 4; i < record.sizeInBytes(); ++i) {
            LegacyRecord copy = this.copyOf(record);
            copy.buffer().put(i, (byte)69);
            Assertions.assertFalse((boolean)copy.isValid());
            Assertions.assertThrows(CorruptRecordException.class, () -> ((LegacyRecord)copy).ensureValid());
        }
    }

    private LegacyRecord copyOf(LegacyRecord record) {
        ByteBuffer buffer = ByteBuffer.allocate(record.sizeInBytes());
        record.buffer().put(buffer);
        buffer.rewind();
        record.buffer().rewind();
        return new LegacyRecord(buffer);
    }

    @ParameterizedTest
    @ArgumentsSource(value=LegacyRecordArgumentsProvider.class)
    public void testEquality(Args args) {
        Assertions.assertEquals((Object)args.record, (Object)this.copyOf(args.record));
    }

    private static class Args {
        final byte magic;
        final long timestamp;
        final ByteBuffer key;
        final ByteBuffer value;
        final CompressionType compression;
        final TimestampType timestampType;
        final LegacyRecord record;

        public Args(byte magic, long timestamp, byte[] key, byte[] value, CompressionType compression) {
            this.magic = magic;
            this.timestamp = timestamp;
            this.timestampType = TimestampType.CREATE_TIME;
            this.key = key == null ? null : ByteBuffer.wrap(key);
            this.value = value == null ? null : ByteBuffer.wrap(value);
            this.compression = compression;
            this.record = LegacyRecord.create((byte)magic, (long)timestamp, (byte[])key, (byte[])value, (CompressionType)compression, (TimestampType)this.timestampType, (boolean)true);
        }

        public String toString() {
            return "magic=" + this.magic + ", compression=" + String.valueOf(this.compression) + ", timestamp=" + this.timestamp;
        }
    }

    private static class LegacyRecordArgumentsProvider
    implements ArgumentsProvider {
        private LegacyRecordArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            byte[] payload = new byte[1000];
            Arrays.fill(payload, (byte)1);
            ArrayList<Arguments> arguments = new ArrayList<Arguments>();
            for (byte magic : Arrays.asList((byte)0, (byte)1)) {
                for (long timestamp : Arrays.asList(-1L, 0L, 1L)) {
                    for (byte[] key : Arrays.asList(null, "".getBytes(), "key".getBytes(), payload)) {
                        for (byte[] value : Arrays.asList(null, "".getBytes(), "value".getBytes(), payload)) {
                            for (CompressionType compression : CompressionType.values()) {
                                arguments.add(Arguments.of((Object[])new Object[]{new Args(magic, timestamp, key, value, compression)}));
                            }
                        }
                    }
                }
            }
            return arguments.stream();
        }
    }
}

