/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DescribeBalancerStatusRequest;
import org.apache.kafka.common.requests.DescribeBalancerStatusResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DescribeBalancerStatusResponseTest {
    @Test
    public void testErrorCounts() {
        DescribeBalancerStatusRequest request = (DescribeBalancerStatusRequest)new DescribeBalancerStatusRequest.Builder().build();
        DescribeBalancerStatusResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    @Test
    public void testToString() {
        DescribeBalancerStatusRequest request = (DescribeBalancerStatusRequest)new DescribeBalancerStatusRequest.Builder().build();
        DescribeBalancerStatusResponse response = request.getErrorResponse(0, (Throwable)Errors.NOT_CONTROLLER.exception());
        String responseStr = response.toString();
        Assertions.assertTrue((boolean)responseStr.contains(DescribeBalancerStatusResponse.class.getSimpleName()));
        Assertions.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NOT_CONTROLLER.code()));
    }
}

