/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListOffsetsRequestTest {
    @Test
    public void testDuplicatePartitions() {
        List<ListOffsetsRequestData.ListOffsetsTopic> topics = Collections.singletonList(new ListOffsetsRequestData.ListOffsetsTopic().setName("topic").setPartitions(Arrays.asList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0), new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0))));
        ListOffsetsRequestData data = new ListOffsetsRequestData().setTopics(topics).setReplicaId(-1);
        ListOffsetsRequest request = ListOffsetsRequest.parse((Readable)MessageUtil.toByteBufferAccessor((Message)data, (short)1), (short)1, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals(Collections.singleton(new TopicPartition("topic", 0)), (Object)request.duplicatePartitions());
        Assertions.assertEquals((int)0, (int)data.timeoutMs());
    }

    @Test
    public void testGetErrorResponse() {
        for (short version = 1; version <= ApiKeys.LIST_OFFSETS.latestVersion(); version = (short)(version + 1)) {
            List<ListOffsetsRequestData.ListOffsetsTopic> topics = Collections.singletonList(new ListOffsetsRequestData.ListOffsetsTopic().setName("topic").setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0))));
            ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_COMMITTED).setTargetTimes(topics).build(version);
            ListOffsetsResponse response = (ListOffsetsResponse)request.getErrorResponse(0, (Throwable)Errors.NOT_LEADER_OR_FOLLOWER.exception());
            List<ListOffsetsResponseData.ListOffsetsTopicResponse> v = Collections.singletonList(new ListOffsetsResponseData.ListOffsetsTopicResponse().setName("topic").setPartitions(Collections.singletonList(new ListOffsetsResponseData.ListOffsetsPartitionResponse().setErrorCode(Errors.NOT_LEADER_OR_FOLLOWER.code()).setLeaderEpoch(-1).setOffset(-1L).setPartitionIndex(0).setTimestamp(-1L))));
            ListOffsetsResponseData data = new ListOffsetsResponseData().setThrottleTimeMs(0).setTopics(v);
            ListOffsetsResponse expectedResponse = new ListOffsetsResponse(data);
            Assertions.assertEquals((Object)expectedResponse.data().topics(), (Object)response.data().topics());
            Assertions.assertEquals((int)expectedResponse.throttleTimeMs(), (int)response.throttleTimeMs());
        }
    }

    @Test
    public void testToListOffsetsTopics() {
        ListOffsetsRequestData.ListOffsetsPartition lop0 = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(0).setCurrentLeaderEpoch(1).setTimestamp(123L);
        ListOffsetsRequestData.ListOffsetsPartition lop1 = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(1).setCurrentLeaderEpoch(3).setTimestamp(567L);
        HashMap<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> timestampsToSearch = new HashMap<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>();
        timestampsToSearch.put(new TopicPartition("topic", 0), lop0);
        timestampsToSearch.put(new TopicPartition("topic", 1), lop1);
        List listOffsetTopics = ListOffsetsRequest.toListOffsetsTopics(timestampsToSearch);
        Assertions.assertEquals((int)1, (int)listOffsetTopics.size());
        ListOffsetsRequestData.ListOffsetsTopic topic = (ListOffsetsRequestData.ListOffsetsTopic)listOffsetTopics.get(0);
        Assertions.assertEquals((Object)"topic", (Object)topic.name());
        Assertions.assertEquals((int)2, (int)topic.partitions().size());
        Assertions.assertTrue((boolean)topic.partitions().contains(lop0));
        Assertions.assertTrue((boolean)topic.partitions().contains(lop1));
    }

    @Test
    public void testListOffsetsRequestOldestVersion() {
        ListOffsetsRequest.Builder consumerRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED);
        ListOffsetsRequest.Builder requireTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED);
        ListOffsetsRequest.Builder requestCommittedRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_COMMITTED);
        ListOffsetsRequest.Builder maxTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)true, (boolean)false, (boolean)false);
        ListOffsetsRequest.Builder requireEarliestLocalTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)true, (boolean)false);
        ListOffsetsRequest.Builder requireTieredStorageTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)true);
        Assertions.assertEquals((short)0, (short)consumerRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)1, (short)requireTimestampRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)2, (short)requestCommittedRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)7, (short)maxTimestampRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)8, (short)requireEarliestLocalTimestampRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)9, (short)requireTieredStorageTimestampRequestBuilder.oldestAllowedVersion());
    }
}

