/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.errors;

import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;

public class AuthenticationException
extends ApiException {
    private static final long serialVersionUID = 1L;
    private AuthenticationErrorInfo errorInfo = AuthenticationErrorInfo.UNAUTHENTICATED_USER_ERROR;

    public AuthenticationException(String message) {
        super(message);
    }

    public AuthenticationException(Throwable cause) {
        super(cause);
    }

    public AuthenticationException(Throwable cause, AuthenticationErrorInfo errorInfo) {
        super(cause);
        this.errorInfo = errorInfo;
    }

    public AuthenticationException(String message, Throwable cause) {
        super(message, cause);
    }

    public AuthenticationException(String message, AuthenticationErrorInfo errorInfo) {
        super(message);
        this.errorInfo = errorInfo;
    }

    public AuthenticationException(String message, Throwable cause, AuthenticationErrorInfo errorInfo) {
        super(message, cause);
        this.errorInfo = errorInfo;
    }

    public AuthenticationErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public String logMessage() {
        StringBuilder logMessage = new StringBuilder();
        if (!this.errorInfo.identifier().isEmpty()) {
            logMessage.append("userId=").append(this.errorInfo.identifier()).append(", ");
        }
        if (!this.errorInfo.clusterId().isEmpty()) {
            logMessage.append("clusterId=").append(this.errorInfo.clusterId()).append(", ");
        }
        logMessage.append("errorMessage=").append(this.errorMessage());
        return logMessage.toString();
    }

    public String errorMessage() {
        if (!this.errorInfo.errorMessage().isEmpty()) {
            return this.errorInfo.errorMessage();
        }
        Throwable cause = this.getCause();
        if (cause != null) {
            return super.getMessage() + " caused by " + cause.getMessage();
        }
        return super.getMessage();
    }
}

