/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class StreamsGroupHeartbeatRequestData
implements ApiMessage {
    String groupId;
    String memberId;
    int memberEpoch;
    String instanceId;
    String rackId;
    int rebalanceTimeoutMs;
    Topology topology;
    List<TaskIds> activeTasks;
    List<TaskIds> standbyTasks;
    List<TaskIds> warmupTasks;
    String processId;
    Endpoint userEndpoint;
    List<KeyValue> clientTags;
    List<TaskOffset> taskOffsets;
    List<TaskOffset> taskEndOffsets;
    boolean shutdownApplication;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("member_id", Type.COMPACT_STRING, "The member ID generated by the streams consumer. The member ID must be kept during the entire lifetime of the streams consumer process."), new Field("member_epoch", Type.INT32, "The current member epoch; 0 to join the group; -1 to leave the group; -2 to indicate that the static member will rejoin."), new Field("instance_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the instance ID for static membership otherwise."), new Field("rack_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the rack ID of the member otherwise."), new Field("rebalance_timeout_ms", Type.INT32, "-1 if it didn't change since the last heartbeat; the maximum time in milliseconds that the coordinator will wait on the member to revoke its tasks otherwise."), new Field("topology", Topology.SCHEMA_0, "The topology metadata of the streams application. Used to initialize the topology of the group and to check if the topology corresponds to the topology initialized for the group. Only sent when memberEpoch = 0, must be non-empty. Null otherwise."), new Field("active_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Currently owned active tasks for this client. Null if unchanged since last heartbeat."), new Field("standby_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Currently owned standby tasks for this client. Null if unchanged since last heartbeat."), new Field("warmup_tasks", CompactArrayOf.nullable(TaskIds.SCHEMA_0), "Currently owned warm-up tasks for this client. Null if unchanged since last heartbeat."), new Field("process_id", Type.COMPACT_NULLABLE_STRING, "Identity of the streams instance that may have multiple consumers. Null if unchanged since last heartbeat."), new Field("user_endpoint", Endpoint.SCHEMA_0, "User-defined endpoint for Interactive Queries. Null if unchanged since last heartbeat, or if not defined on the client."), new Field("client_tags", CompactArrayOf.nullable(KeyValue.SCHEMA_0), "Used for rack-aware assignment algorithm. Null if unchanged since last heartbeat."), new Field("task_offsets", CompactArrayOf.nullable(TaskOffset.SCHEMA_0), "Cumulative changelog offsets for tasks. Only updated when a warm-up task has caught up, and according to the task offset interval. Null if unchanged since last heartbeat."), new Field("task_end_offsets", CompactArrayOf.nullable(TaskOffset.SCHEMA_0), "Cumulative changelog end-offsets for tasks. Only updated when a warm-up task has caught up, and according to the task offset interval. Null if unchanged since last heartbeat."), new Field("shutdown_application", Type.BOOLEAN, "Whether all Streams clients in the group should shut down."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public StreamsGroupHeartbeatRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public StreamsGroupHeartbeatRequestData() {
        this.groupId = "";
        this.memberId = "";
        this.memberEpoch = 0;
        this.instanceId = null;
        this.rackId = null;
        this.rebalanceTimeoutMs = -1;
        this.topology = null;
        this.activeTasks = null;
        this.standbyTasks = null;
        this.warmupTasks = null;
        this.processId = null;
        this.userEndpoint = null;
        this.clientTags = null;
        this.taskOffsets = null;
        this.taskEndOffsets = null;
        this.shutdownApplication = false;
    }

    @Override
    public short apiKey() {
        return 88;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<TaskIds> newCollection;
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _context.read(EntityType.GROUP_ID, _readable.readString(length));
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field memberId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field memberId had invalid length " + length);
        }
        this.memberId = _readable.readString(length);
        this.memberEpoch = _readable.readInt();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.instanceId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field instanceId had invalid length " + length);
            }
            this.instanceId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.rackId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            }
            this.rackId = _readable.readString(length);
        }
        this.rebalanceTimeoutMs = _readable.readInt();
        this.topology = _readable.readByte() < 0 ? null : new Topology(_readable, _version, _context);
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.activeTasks = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<TaskIds>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskIds(_readable, _version, _context));
            }
            this.activeTasks = newCollection;
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.standbyTasks = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskIds(_readable, _version, _context));
            }
            this.standbyTasks = newCollection;
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.warmupTasks = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TaskIds(_readable, _version, _context));
            }
            this.warmupTasks = newCollection;
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.processId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field processId had invalid length " + length);
            }
            this.processId = _readable.readString(length);
        }
        this.userEndpoint = _readable.readByte() < 0 ? null : new Endpoint(_readable, _version, _context);
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.clientTags = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((TaskIds)((Object)new KeyValue(_readable, _version, _context)));
            }
            this.clientTags = newCollection;
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.taskOffsets = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((TaskIds)((Object)new TaskOffset(_readable, _version, _context)));
            }
            this.taskOffsets = newCollection;
        }
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.taskEndOffsets = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((TaskIds)((Object)new TaskOffset(_readable, _version, _context)));
            }
            this.taskEndOffsets = newCollection;
        }
        this.shutdownApplication = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _stringBytes = _cache.getSerializedValue(this.memberId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.memberEpoch);
        if (this.instanceId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.instanceId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.rackId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.rackId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.rebalanceTimeoutMs);
        if (this.topology == null) {
            _writable.writeByte((byte)-1);
        } else {
            _writable.writeByte((byte)1);
            this.topology.write(_writable, _cache, _version, _context);
        }
        if (this.activeTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.activeTasks.size() + 1);
            _stringBytes = this.activeTasks.iterator();
            while (_stringBytes.hasNext()) {
                TaskIds activeTasksElement = (TaskIds)_stringBytes.next();
                activeTasksElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.standbyTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.standbyTasks.size() + 1);
            for (TaskIds standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.warmupTasks == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.warmupTasks.size() + 1);
            for (TaskIds warmupTasksElement : this.warmupTasks) {
                warmupTasksElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.processId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.processId);
            _writable.writeUnsignedVarint(((Object)_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.userEndpoint == null) {
            _writable.writeByte((byte)-1);
        } else {
            _writable.writeByte((byte)1);
            this.userEndpoint.write(_writable, _cache, _version, _context);
        }
        if (this.clientTags == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.clientTags.size() + 1);
            for (KeyValue clientTagsElement : this.clientTags) {
                clientTagsElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.taskOffsets == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.taskOffsets.size() + 1);
            for (TaskOffset taskOffsetsElement : this.taskOffsets) {
                taskOffsetsElement.write(_writable, _cache, _version, _context);
            }
        }
        if (this.taskEndOffsets == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.taskEndOffsets.size() + 1);
            for (TaskOffset taskEndOffsetsElement : this.taskEndOffsets) {
                taskEndOffsetsElement.write(_writable, _cache, _version, _context);
            }
        }
        _writable.writeByte(this.shutdownApplication ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        Object _stringBytes = _context.write(EntityType.GROUP_ID, this.groupId).getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, (byte[])_stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'memberId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.memberId, (byte[])_stringBytes);
        _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        _size.addBytes(4);
        if (this.instanceId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.instanceId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'instanceId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.instanceId, (byte[])_stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        }
        if (this.rackId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.rackId, (byte[])_stringBytes);
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        }
        _size.addBytes(4);
        if (this.topology == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(1);
            this.topology.addSize(_size, _cache, _version, _context);
        }
        if (this.activeTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.activeTasks.size() + 1));
            _stringBytes = this.activeTasks.iterator();
            while (_stringBytes.hasNext()) {
                TaskIds activeTasksElement = (TaskIds)_stringBytes.next();
                activeTasksElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.standbyTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.standbyTasks.size() + 1));
            for (TaskIds standbyTasksElement : this.standbyTasks) {
                standbyTasksElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.warmupTasks == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.warmupTasks.size() + 1));
            _stringBytes = this.warmupTasks.iterator();
            while (_stringBytes.hasNext()) {
                TaskIds warmupTasksElement = (TaskIds)_stringBytes.next();
                warmupTasksElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.processId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.processId.getBytes(StandardCharsets.UTF_8);
            if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                throw new RuntimeException("'processId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.processId, (byte[])_stringBytes);
            _size.addBytes(((Object)_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((Object)_stringBytes).length + 1));
        }
        if (this.userEndpoint == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(1);
            this.userEndpoint.addSize(_size, _cache, _version, _context);
        }
        if (this.clientTags == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clientTags.size() + 1));
            for (KeyValue clientTagsElement : this.clientTags) {
                clientTagsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.taskOffsets == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.taskOffsets.size() + 1));
            for (TaskOffset taskOffsetsElement : this.taskOffsets) {
                taskOffsetsElement.addSize(_size, _cache, _version, _context);
            }
        }
        if (this.taskEndOffsets == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.taskEndOffsets.size() + 1));
            for (TaskOffset taskEndOffsetsElement : this.taskEndOffsets) {
                taskEndOffsetsElement.addSize(_size, _cache, _version, _context);
            }
        }
        _size.addBytes(1);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamsGroupHeartbeatRequestData)) {
            return false;
        }
        StreamsGroupHeartbeatRequestData other = (StreamsGroupHeartbeatRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.memberEpoch != other.memberEpoch) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
            return false;
        }
        if (this.rebalanceTimeoutMs != other.rebalanceTimeoutMs) {
            return false;
        }
        if (this.topology == null ? other.topology != null : !this.topology.equals(other.topology)) {
            return false;
        }
        if (this.activeTasks == null ? other.activeTasks != null : !this.activeTasks.equals(other.activeTasks)) {
            return false;
        }
        if (this.standbyTasks == null ? other.standbyTasks != null : !this.standbyTasks.equals(other.standbyTasks)) {
            return false;
        }
        if (this.warmupTasks == null ? other.warmupTasks != null : !this.warmupTasks.equals(other.warmupTasks)) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.userEndpoint == null ? other.userEndpoint != null : !this.userEndpoint.equals(other.userEndpoint)) {
            return false;
        }
        if (this.clientTags == null ? other.clientTags != null : !this.clientTags.equals(other.clientTags)) {
            return false;
        }
        if (this.taskOffsets == null ? other.taskOffsets != null : !this.taskOffsets.equals(other.taskOffsets)) {
            return false;
        }
        if (this.taskEndOffsets == null ? other.taskEndOffsets != null : !this.taskEndOffsets.equals(other.taskEndOffsets)) {
            return false;
        }
        if (this.shutdownApplication != other.shutdownApplication) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + this.memberEpoch;
        hashCode = 31 * hashCode + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
        hashCode = 31 * hashCode + this.rebalanceTimeoutMs;
        hashCode = 31 * hashCode + (this.topology == null ? 0 : this.topology.hashCode());
        hashCode = 31 * hashCode + (this.activeTasks == null ? 0 : this.activeTasks.hashCode());
        hashCode = 31 * hashCode + (this.standbyTasks == null ? 0 : this.standbyTasks.hashCode());
        hashCode = 31 * hashCode + (this.warmupTasks == null ? 0 : this.warmupTasks.hashCode());
        hashCode = 31 * hashCode + (this.processId == null ? 0 : this.processId.hashCode());
        hashCode = 31 * hashCode + (this.userEndpoint == null ? 0 : this.userEndpoint.hashCode());
        hashCode = 31 * hashCode + (this.clientTags == null ? 0 : this.clientTags.hashCode());
        hashCode = 31 * hashCode + (this.taskOffsets == null ? 0 : this.taskOffsets.hashCode());
        hashCode = 31 * hashCode + (this.taskEndOffsets == null ? 0 : this.taskEndOffsets.hashCode());
        hashCode = 31 * hashCode + (this.shutdownApplication ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public StreamsGroupHeartbeatRequestData duplicate() {
        StreamsGroupHeartbeatRequestData _duplicate = new StreamsGroupHeartbeatRequestData();
        _duplicate.groupId = this.groupId;
        _duplicate.memberId = this.memberId;
        _duplicate.memberEpoch = this.memberEpoch;
        _duplicate.instanceId = this.instanceId == null ? null : this.instanceId;
        _duplicate.rackId = this.rackId == null ? null : this.rackId;
        _duplicate.rebalanceTimeoutMs = this.rebalanceTimeoutMs;
        _duplicate.topology = this.topology == null ? null : this.topology.duplicate();
        if (this.activeTasks == null) {
            _duplicate.activeTasks = null;
        } else {
            ArrayList<TaskIds> newActiveTasks = new ArrayList<TaskIds>(this.activeTasks.size());
            for (TaskIds taskIds : this.activeTasks) {
                newActiveTasks.add(taskIds.duplicate());
            }
            _duplicate.activeTasks = newActiveTasks;
        }
        if (this.standbyTasks == null) {
            _duplicate.standbyTasks = null;
        } else {
            ArrayList<TaskIds> newStandbyTasks = new ArrayList<TaskIds>(this.standbyTasks.size());
            for (TaskIds taskIds : this.standbyTasks) {
                newStandbyTasks.add(taskIds.duplicate());
            }
            _duplicate.standbyTasks = newStandbyTasks;
        }
        if (this.warmupTasks == null) {
            _duplicate.warmupTasks = null;
        } else {
            ArrayList<TaskIds> newWarmupTasks = new ArrayList<TaskIds>(this.warmupTasks.size());
            for (TaskIds taskIds : this.warmupTasks) {
                newWarmupTasks.add(taskIds.duplicate());
            }
            _duplicate.warmupTasks = newWarmupTasks;
        }
        _duplicate.processId = this.processId == null ? null : this.processId;
        _duplicate.userEndpoint = this.userEndpoint == null ? null : this.userEndpoint.duplicate();
        if (this.clientTags == null) {
            _duplicate.clientTags = null;
        } else {
            ArrayList<KeyValue> newClientTags = new ArrayList<KeyValue>(this.clientTags.size());
            for (KeyValue keyValue : this.clientTags) {
                newClientTags.add(keyValue.duplicate());
            }
            _duplicate.clientTags = newClientTags;
        }
        if (this.taskOffsets == null) {
            _duplicate.taskOffsets = null;
        } else {
            ArrayList<TaskOffset> newTaskOffsets = new ArrayList<TaskOffset>(this.taskOffsets.size());
            for (TaskOffset taskOffset : this.taskOffsets) {
                newTaskOffsets.add(taskOffset.duplicate());
            }
            _duplicate.taskOffsets = newTaskOffsets;
        }
        if (this.taskEndOffsets == null) {
            _duplicate.taskEndOffsets = null;
        } else {
            ArrayList<TaskOffset> newTaskEndOffsets = new ArrayList<TaskOffset>(this.taskEndOffsets.size());
            for (TaskOffset taskOffset : this.taskEndOffsets) {
                newTaskEndOffsets.add(taskOffset.duplicate());
            }
            _duplicate.taskEndOffsets = newTaskEndOffsets;
        }
        _duplicate.shutdownApplication = this.shutdownApplication;
        return _duplicate;
    }

    public String toString() {
        return "StreamsGroupHeartbeatRequestData(groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", memberId=" + (String)(this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", memberEpoch=" + this.memberEpoch + ", instanceId=" + (String)(this.instanceId == null ? "null" : "'" + this.instanceId.toString() + "'") + ", rackId=" + (String)(this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", topology=" + (this.topology == null ? "null" : this.topology.toString()) + ", activeTasks=" + (this.activeTasks == null ? "null" : MessageUtil.deepToString(this.activeTasks.iterator())) + ", standbyTasks=" + (this.standbyTasks == null ? "null" : MessageUtil.deepToString(this.standbyTasks.iterator())) + ", warmupTasks=" + (this.warmupTasks == null ? "null" : MessageUtil.deepToString(this.warmupTasks.iterator())) + ", processId=" + (String)(this.processId == null ? "null" : "'" + this.processId.toString() + "'") + ", userEndpoint=" + (this.userEndpoint == null ? "null" : this.userEndpoint.toString()) + ", clientTags=" + (this.clientTags == null ? "null" : MessageUtil.deepToString(this.clientTags.iterator())) + ", taskOffsets=" + (this.taskOffsets == null ? "null" : MessageUtil.deepToString(this.taskOffsets.iterator())) + ", taskEndOffsets=" + (this.taskEndOffsets == null ? "null" : MessageUtil.deepToString(this.taskEndOffsets.iterator())) + ", shutdownApplication=" + (this.shutdownApplication ? "true" : "false") + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String rackId() {
        return this.rackId;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public Topology topology() {
        return this.topology;
    }

    public List<TaskIds> activeTasks() {
        return this.activeTasks;
    }

    public List<TaskIds> standbyTasks() {
        return this.standbyTasks;
    }

    public List<TaskIds> warmupTasks() {
        return this.warmupTasks;
    }

    public String processId() {
        return this.processId;
    }

    public Endpoint userEndpoint() {
        return this.userEndpoint;
    }

    public List<KeyValue> clientTags() {
        return this.clientTags;
    }

    public List<TaskOffset> taskOffsets() {
        return this.taskOffsets;
    }

    public List<TaskOffset> taskEndOffsets() {
        return this.taskEndOffsets;
    }

    public boolean shutdownApplication() {
        return this.shutdownApplication;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public StreamsGroupHeartbeatRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setInstanceId(String v) {
        this.instanceId = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setRackId(String v) {
        this.rackId = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setRebalanceTimeoutMs(int v) {
        this.rebalanceTimeoutMs = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setTopology(Topology v) {
        this.topology = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setActiveTasks(List<TaskIds> v) {
        this.activeTasks = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setStandbyTasks(List<TaskIds> v) {
        this.standbyTasks = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setWarmupTasks(List<TaskIds> v) {
        this.warmupTasks = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setProcessId(String v) {
        this.processId = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setUserEndpoint(Endpoint v) {
        this.userEndpoint = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setClientTags(List<KeyValue> v) {
        this.clientTags = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setTaskOffsets(List<TaskOffset> v) {
        this.taskOffsets = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setTaskEndOffsets(List<TaskOffset> v) {
        this.taskEndOffsets = v;
        return this;
    }

    public StreamsGroupHeartbeatRequestData setShutdownApplication(boolean v) {
        this.shutdownApplication = v;
        return this;
    }

    public static class Topology
    implements Message {
        int epoch;
        List<Subtopology> subtopologies;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("epoch", Type.INT32, "The epoch of the topology. Used to check if the topology corresponds to the topology initialized on the brokers."), new Field("subtopologies", new CompactArrayOf(Subtopology.SCHEMA_0), "The sub-topologies of the streams application."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Topology(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Topology() {
            this.epoch = 0;
            this.subtopologies = new ArrayList<Subtopology>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Topology");
            }
            this.epoch = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field subtopologies was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Subtopology> newCollection = new ArrayList<Subtopology>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new Subtopology(_readable, _version, _context));
            }
            this.subtopologies = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.epoch);
            _writable.writeUnsignedVarint(this.subtopologies.size() + 1);
            for (Subtopology subtopologiesElement : this.subtopologies) {
                subtopologiesElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Topology");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.subtopologies.size() + 1));
            for (Subtopology subtopologiesElement : this.subtopologies) {
                subtopologiesElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Topology)) {
                return false;
            }
            Topology other = (Topology)obj;
            if (this.epoch != other.epoch) {
                return false;
            }
            if (this.subtopologies == null ? other.subtopologies != null : !this.subtopologies.equals(other.subtopologies)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.epoch;
            hashCode = 31 * hashCode + (this.subtopologies == null ? 0 : this.subtopologies.hashCode());
            return hashCode;
        }

        @Override
        public Topology duplicate() {
            Topology _duplicate = new Topology();
            _duplicate.epoch = this.epoch;
            ArrayList<Subtopology> newSubtopologies = new ArrayList<Subtopology>(this.subtopologies.size());
            for (Subtopology _element : this.subtopologies) {
                newSubtopologies.add(_element.duplicate());
            }
            _duplicate.subtopologies = newSubtopologies;
            return _duplicate;
        }

        public String toString() {
            return "Topology(epoch=" + this.epoch + ", subtopologies=" + MessageUtil.deepToString(this.subtopologies.iterator()) + ")";
        }

        public int epoch() {
            return this.epoch;
        }

        public List<Subtopology> subtopologies() {
            return this.subtopologies;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Topology setEpoch(int v) {
            this.epoch = v;
            return this;
        }

        public Topology setSubtopologies(List<Subtopology> v) {
            this.subtopologies = v;
            return this;
        }
    }

    public static class Endpoint
    implements Message {
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("host", Type.COMPACT_STRING, "host of the endpoint"), new Field("port", Type.UINT16, "port of the endpoint"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Endpoint(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Endpoint() {
            this.host = "";
            this.port = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Endpoint)) {
                return false;
            }
            Endpoint other = (Endpoint)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.port;
            return hashCode;
        }

        @Override
        public Endpoint duplicate() {
            Endpoint _duplicate = new Endpoint();
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "Endpoint(host=" + (String)(this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ")";
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Endpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public Endpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }
    }

    public static class TaskIds
    implements Message {
        String subtopologyId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("subtopology_id", Type.COMPACT_STRING, "The subtopology identifier."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions of the input topics processed by this member."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TaskIds(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TaskIds() {
            this.subtopologyId = "";
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length);
            }
            this.subtopologyId = _readable.readString(length);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.subtopologyId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.subtopologyId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskIds)) {
                return false;
            }
            TaskIds other = (TaskIds)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TaskIds duplicate() {
            TaskIds _duplicate = new TaskIds();
            _duplicate.subtopologyId = this.subtopologyId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TaskIds(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskIds setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public TaskIds setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class KeyValue
    implements Message {
        String key;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("key", Type.COMPACT_STRING, "key of the config"), new Field("value", Type.COMPACT_STRING, "value of the config"), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public KeyValue(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public KeyValue() {
            this.key = "";
            this.value = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.key);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.key, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        @Override
        public KeyValue duplicate() {
            KeyValue _duplicate = new KeyValue();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "KeyValue(key=" + (String)(this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + (String)(this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public KeyValue setKey(String v) {
            this.key = v;
            return this;
        }

        public KeyValue setValue(String v) {
            this.value = v;
            return this;
        }
    }

    public static class TaskOffset
    implements Message {
        String subtopologyId;
        int partition;
        long offset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("subtopology_id", Type.COMPACT_STRING, "The subtopology identifier."), new Field("partition", Type.INT32, "The partition."), new Field("offset", Type.INT64, "The offset."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TaskOffset(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TaskOffset() {
            this.subtopologyId = "";
            this.partition = 0;
            this.offset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length);
            }
            this.subtopologyId = _readable.readString(length);
            this.partition = _readable.readInt();
            this.offset = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.subtopologyId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.partition);
            _writable.writeLong(this.offset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.subtopologyId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TaskOffset)) {
                return false;
            }
            TaskOffset other = (TaskOffset)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.partition != other.partition) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + this.partition;
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            return hashCode;
        }

        @Override
        public TaskOffset duplicate() {
            TaskOffset _duplicate = new TaskOffset();
            _duplicate.subtopologyId = this.subtopologyId;
            _duplicate.partition = this.partition;
            _duplicate.offset = this.offset;
            return _duplicate;
        }

        public String toString() {
            return "TaskOffset(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", partition=" + this.partition + ", offset=" + this.offset + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public int partition() {
            return this.partition;
        }

        public long offset() {
            return this.offset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TaskOffset setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public TaskOffset setPartition(int v) {
            this.partition = v;
            return this;
        }

        public TaskOffset setOffset(long v) {
            this.offset = v;
            return this;
        }
    }

    public static class TopicInfo
    implements Message {
        String name;
        int partitions;
        short replicationFactor;
        List<KeyValue> topicConfigs;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The name of the topic."), new Field("partitions", Type.INT32, "The number of partitions in the topic. Can be 0 if no specific number of partitions is enforced. Always 0 for changelog topics."), new Field("replication_factor", Type.INT16, "The replication factor of the topic. Can be 0 if the default replication factor should be used."), new Field("topic_configs", new CompactArrayOf(KeyValue.SCHEMA_0), "Topic-level configurations as key-value pairs."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicInfo(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicInfo() {
            this.name = "";
            this.partitions = 0;
            this.replicationFactor = 0;
            this.topicConfigs = new ArrayList<KeyValue>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.partitions = _readable.readInt();
            this.replicationFactor = _readable.readShort();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topicConfigs was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<KeyValue> newCollection = new ArrayList<KeyValue>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new KeyValue(_readable, _version, _context));
            }
            this.topicConfigs = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions);
            _writable.writeShort(this.replicationFactor);
            _writable.writeUnsignedVarint(this.topicConfigs.size() + 1);
            _stringBytes = this.topicConfigs.iterator();
            while (_stringBytes.hasNext()) {
                KeyValue topicConfigsElement = (KeyValue)_stringBytes.next();
                topicConfigsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            _size.addBytes(2);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topicConfigs.size() + 1));
            for (KeyValue topicConfigsElement : this.topicConfigs) {
                topicConfigsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicInfo)) {
                return false;
            }
            TopicInfo other = (TopicInfo)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions != other.partitions) {
                return false;
            }
            if (this.replicationFactor != other.replicationFactor) {
                return false;
            }
            if (this.topicConfigs == null ? other.topicConfigs != null : !this.topicConfigs.equals(other.topicConfigs)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.partitions;
            hashCode = 31 * hashCode + this.replicationFactor;
            hashCode = 31 * hashCode + (this.topicConfigs == null ? 0 : this.topicConfigs.hashCode());
            return hashCode;
        }

        @Override
        public TopicInfo duplicate() {
            TopicInfo _duplicate = new TopicInfo();
            _duplicate.name = this.name;
            _duplicate.partitions = this.partitions;
            _duplicate.replicationFactor = this.replicationFactor;
            ArrayList<KeyValue> newTopicConfigs = new ArrayList<KeyValue>(this.topicConfigs.size());
            for (KeyValue _element : this.topicConfigs) {
                newTopicConfigs.add(_element.duplicate());
            }
            _duplicate.topicConfigs = newTopicConfigs;
            return _duplicate;
        }

        public String toString() {
            return "TopicInfo(name=" + (String)(this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + this.partitions + ", replicationFactor=" + this.replicationFactor + ", topicConfigs=" + MessageUtil.deepToString(this.topicConfigs.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public int partitions() {
            return this.partitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public List<KeyValue> topicConfigs() {
            return this.topicConfigs;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicInfo setName(String v) {
            this.name = v;
            return this;
        }

        public TopicInfo setPartitions(int v) {
            this.partitions = v;
            return this;
        }

        public TopicInfo setReplicationFactor(short v) {
            this.replicationFactor = v;
            return this;
        }

        public TopicInfo setTopicConfigs(List<KeyValue> v) {
            this.topicConfigs = v;
            return this;
        }
    }

    public static class CopartitionGroup
    implements Message {
        List<Short> sourceTopics;
        List<Short> sourceTopicRegex;
        List<Short> repartitionSourceTopics;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("source_topics", new CompactArrayOf(Type.INT16), "The topics the topology reads from. Index into the array on the subtopology level."), new Field("source_topic_regex", new CompactArrayOf(Type.INT16), "Regular expressions identifying topics the subtopology reads from. Index into the array on the subtopology level."), new Field("repartition_source_topics", new CompactArrayOf(Type.INT16), "The set of source topics that are internally created repartition topics. Index into the array on the subtopology level."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public CopartitionGroup(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public CopartitionGroup() {
            this.sourceTopics = new ArrayList<Short>(0);
            this.sourceTopicRegex = new ArrayList<Short>(0);
            this.repartitionSourceTopics = new ArrayList<Short>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CopartitionGroup");
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Short> newCollection = new ArrayList<Short>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readShort());
            }
            this.sourceTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopicRegex was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readShort());
            }
            this.sourceTopicRegex = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field repartitionSourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readShort());
            }
            this.repartitionSourceTopics = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUnsignedVarint(this.sourceTopics.size() + 1);
            for (Short sourceTopicsElement : this.sourceTopics) {
                _writable.writeShort(sourceTopicsElement);
            }
            _writable.writeUnsignedVarint(this.sourceTopicRegex.size() + 1);
            for (Short sourceTopicRegexElement : this.sourceTopicRegex) {
                _writable.writeShort(sourceTopicRegexElement);
            }
            _writable.writeUnsignedVarint(this.repartitionSourceTopics.size() + 1);
            for (Short repartitionSourceTopicsElement : this.repartitionSourceTopics) {
                _writable.writeShort(repartitionSourceTopicsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CopartitionGroup");
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.sourceTopics.size() + 1));
            _size.addBytes(this.sourceTopics.size() * 2);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.sourceTopicRegex.size() + 1));
            _size.addBytes(this.sourceTopicRegex.size() * 2);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.repartitionSourceTopics.size() + 1));
            _size.addBytes(this.repartitionSourceTopics.size() * 2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CopartitionGroup)) {
                return false;
            }
            CopartitionGroup other = (CopartitionGroup)obj;
            if (this.sourceTopics == null ? other.sourceTopics != null : !this.sourceTopics.equals(other.sourceTopics)) {
                return false;
            }
            if (this.sourceTopicRegex == null ? other.sourceTopicRegex != null : !this.sourceTopicRegex.equals(other.sourceTopicRegex)) {
                return false;
            }
            if (this.repartitionSourceTopics == null ? other.repartitionSourceTopics != null : !this.repartitionSourceTopics.equals(other.repartitionSourceTopics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.sourceTopics == null ? 0 : this.sourceTopics.hashCode());
            hashCode = 31 * hashCode + (this.sourceTopicRegex == null ? 0 : this.sourceTopicRegex.hashCode());
            hashCode = 31 * hashCode + (this.repartitionSourceTopics == null ? 0 : this.repartitionSourceTopics.hashCode());
            return hashCode;
        }

        @Override
        public CopartitionGroup duplicate() {
            CopartitionGroup _duplicate = new CopartitionGroup();
            ArrayList<Short> newSourceTopics = new ArrayList<Short>(this.sourceTopics.size());
            for (Short s2 : this.sourceTopics) {
                newSourceTopics.add(s2);
            }
            _duplicate.sourceTopics = newSourceTopics;
            ArrayList<Short> newSourceTopicRegex = new ArrayList<Short>(this.sourceTopicRegex.size());
            for (Short _element : this.sourceTopicRegex) {
                newSourceTopicRegex.add(_element);
            }
            _duplicate.sourceTopicRegex = newSourceTopicRegex;
            ArrayList<Short> arrayList = new ArrayList<Short>(this.repartitionSourceTopics.size());
            for (Short _element : this.repartitionSourceTopics) {
                arrayList.add(_element);
            }
            _duplicate.repartitionSourceTopics = arrayList;
            return _duplicate;
        }

        public String toString() {
            return "CopartitionGroup(sourceTopics=" + MessageUtil.deepToString(this.sourceTopics.iterator()) + ", sourceTopicRegex=" + MessageUtil.deepToString(this.sourceTopicRegex.iterator()) + ", repartitionSourceTopics=" + MessageUtil.deepToString(this.repartitionSourceTopics.iterator()) + ")";
        }

        public List<Short> sourceTopics() {
            return this.sourceTopics;
        }

        public List<Short> sourceTopicRegex() {
            return this.sourceTopicRegex;
        }

        public List<Short> repartitionSourceTopics() {
            return this.repartitionSourceTopics;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CopartitionGroup setSourceTopics(List<Short> v) {
            this.sourceTopics = v;
            return this;
        }

        public CopartitionGroup setSourceTopicRegex(List<Short> v) {
            this.sourceTopicRegex = v;
            return this;
        }

        public CopartitionGroup setRepartitionSourceTopics(List<Short> v) {
            this.repartitionSourceTopics = v;
            return this;
        }
    }

    public static class Subtopology
    implements Message {
        String subtopologyId;
        List<String> sourceTopics;
        List<String> sourceTopicRegex;
        List<TopicInfo> stateChangelogTopics;
        List<String> repartitionSinkTopics;
        List<TopicInfo> repartitionSourceTopics;
        List<CopartitionGroup> copartitionGroups;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("subtopology_id", Type.COMPACT_STRING, "String to uniquely identify the subtopology. Deterministically generated from the topology"), new Field("source_topics", new CompactArrayOf(Type.COMPACT_STRING), "The topics the topology reads from."), new Field("source_topic_regex", new CompactArrayOf(Type.COMPACT_STRING), "The regular expressions identifying topics the subtopology reads from."), new Field("state_changelog_topics", new CompactArrayOf(TopicInfo.SCHEMA_0), "The set of state changelog topics associated with this subtopology. Created automatically."), new Field("repartition_sink_topics", new CompactArrayOf(Type.COMPACT_STRING), "The repartition topics the subtopology writes to."), new Field("repartition_source_topics", new CompactArrayOf(TopicInfo.SCHEMA_0), "The set of source topics that are internally created repartition topics. Created automatically."), new Field("copartition_groups", new CompactArrayOf(CopartitionGroup.SCHEMA_0), "A subset of source topics that must be copartitioned."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Subtopology(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Subtopology() {
            this.subtopologyId = "";
            this.sourceTopics = new ArrayList<String>(0);
            this.sourceTopicRegex = new ArrayList<String>(0);
            this.stateChangelogTopics = new ArrayList<TopicInfo>(0);
            this.repartitionSinkTopics = new ArrayList<String>(0);
            this.repartitionSourceTopics = new ArrayList<TopicInfo>(0);
            this.copartitionGroups = new ArrayList<CopartitionGroup>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length;
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Subtopology");
            }
            int length2 = _readable.readUnsignedVarint() - 1;
            if (length2 < 0) {
                throw new RuntimeException("non-nullable field subtopologyId was serialized as null");
            }
            if (length2 > Short.MAX_VALUE) {
                throw new RuntimeException("string field subtopologyId had invalid length " + length2);
            }
            this.subtopologyId = _readable.readString(length2);
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field sourceTopics element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field sourceTopics element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.sourceTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field sourceTopicRegex was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field sourceTopicRegex element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field sourceTopicRegex element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.sourceTopicRegex = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field stateChangelogTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new TopicInfo(_readable, _version, _context)));
            }
            this.stateChangelogTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field repartitionSinkTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field repartitionSinkTopics element was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field repartitionSinkTopics element had invalid length " + length);
                }
                newCollection.add(_readable.readString(length));
            }
            this.repartitionSinkTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field repartitionSourceTopics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new TopicInfo(_readable, _version, _context)));
            }
            this.repartitionSourceTopics = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field copartitionGroups was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((String)((Object)new CopartitionGroup(_readable, _version, _context)));
            }
            this.copartitionGroups = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            Object _stringBytes2 = _cache.getSerializedValue(this.subtopologyId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes2).length + 1);
            _writable.writeByteArray((byte[])_stringBytes2);
            _writable.writeUnsignedVarint(this.sourceTopics.size() + 1);
            _stringBytes2 = this.sourceTopics.iterator();
            while (_stringBytes2.hasNext()) {
                String sourceTopicsElement = (String)_stringBytes2.next();
                _stringBytes = _cache.getSerializedValue(sourceTopicsElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(this.sourceTopicRegex.size() + 1);
            for (String sourceTopicRegexElement : this.sourceTopicRegex) {
                _stringBytes = _cache.getSerializedValue(sourceTopicRegexElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(this.stateChangelogTopics.size() + 1);
            for (TopicInfo stateChangelogTopicsElement : this.stateChangelogTopics) {
                stateChangelogTopicsElement.write(_writable, _cache, _version, _context);
            }
            _writable.writeUnsignedVarint(this.repartitionSinkTopics.size() + 1);
            for (String repartitionSinkTopicsElement : this.repartitionSinkTopics) {
                _stringBytes = _cache.getSerializedValue(repartitionSinkTopicsElement);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeUnsignedVarint(this.repartitionSourceTopics.size() + 1);
            for (TopicInfo repartitionSourceTopicsElement : this.repartitionSourceTopics) {
                repartitionSourceTopicsElement.write(_writable, _cache, _version, _context);
            }
            _writable.writeUnsignedVarint(this.copartitionGroups.size() + 1);
            for (CopartitionGroup copartitionGroupsElement : this.copartitionGroups) {
                copartitionGroupsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Subtopology");
            }
            byte[] _stringBytes2 = this.subtopologyId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes2.length > Short.MAX_VALUE) {
                throw new RuntimeException("'subtopologyId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.subtopologyId, _stringBytes2);
            _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.sourceTopics.size() + 1));
            for (String sourceTopicsElement : this.sourceTopics) {
                _stringBytes = sourceTopicsElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'sourceTopicsElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(sourceTopicsElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.sourceTopicRegex.size() + 1));
            for (String sourceTopicRegexElement : this.sourceTopicRegex) {
                _stringBytes = sourceTopicRegexElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'sourceTopicRegexElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(sourceTopicRegexElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stateChangelogTopics.size() + 1));
            for (TopicInfo stateChangelogTopicsElement : this.stateChangelogTopics) {
                stateChangelogTopicsElement.addSize(_size, _cache, _version, _context);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.repartitionSinkTopics.size() + 1));
            for (String repartitionSinkTopicsElement : this.repartitionSinkTopics) {
                _stringBytes = repartitionSinkTopicsElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'repartitionSinkTopicsElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(repartitionSinkTopicsElement, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.repartitionSourceTopics.size() + 1));
            for (TopicInfo repartitionSourceTopicsElement : this.repartitionSourceTopics) {
                repartitionSourceTopicsElement.addSize(_size, _cache, _version, _context);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.copartitionGroups.size() + 1));
            for (CopartitionGroup copartitionGroupsElement : this.copartitionGroups) {
                copartitionGroupsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Subtopology)) {
                return false;
            }
            Subtopology other = (Subtopology)obj;
            if (this.subtopologyId == null ? other.subtopologyId != null : !this.subtopologyId.equals(other.subtopologyId)) {
                return false;
            }
            if (this.sourceTopics == null ? other.sourceTopics != null : !this.sourceTopics.equals(other.sourceTopics)) {
                return false;
            }
            if (this.sourceTopicRegex == null ? other.sourceTopicRegex != null : !this.sourceTopicRegex.equals(other.sourceTopicRegex)) {
                return false;
            }
            if (this.stateChangelogTopics == null ? other.stateChangelogTopics != null : !this.stateChangelogTopics.equals(other.stateChangelogTopics)) {
                return false;
            }
            if (this.repartitionSinkTopics == null ? other.repartitionSinkTopics != null : !this.repartitionSinkTopics.equals(other.repartitionSinkTopics)) {
                return false;
            }
            if (this.repartitionSourceTopics == null ? other.repartitionSourceTopics != null : !this.repartitionSourceTopics.equals(other.repartitionSourceTopics)) {
                return false;
            }
            if (this.copartitionGroups == null ? other.copartitionGroups != null : !this.copartitionGroups.equals(other.copartitionGroups)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.subtopologyId == null ? 0 : this.subtopologyId.hashCode());
            hashCode = 31 * hashCode + (this.sourceTopics == null ? 0 : this.sourceTopics.hashCode());
            hashCode = 31 * hashCode + (this.sourceTopicRegex == null ? 0 : this.sourceTopicRegex.hashCode());
            hashCode = 31 * hashCode + (this.stateChangelogTopics == null ? 0 : this.stateChangelogTopics.hashCode());
            hashCode = 31 * hashCode + (this.repartitionSinkTopics == null ? 0 : this.repartitionSinkTopics.hashCode());
            hashCode = 31 * hashCode + (this.repartitionSourceTopics == null ? 0 : this.repartitionSourceTopics.hashCode());
            hashCode = 31 * hashCode + (this.copartitionGroups == null ? 0 : this.copartitionGroups.hashCode());
            return hashCode;
        }

        @Override
        public Subtopology duplicate() {
            Subtopology _duplicate = new Subtopology();
            _duplicate.subtopologyId = this.subtopologyId;
            ArrayList<String> newSourceTopics = new ArrayList<String>(this.sourceTopics.size());
            for (String string : this.sourceTopics) {
                newSourceTopics.add(string);
            }
            _duplicate.sourceTopics = newSourceTopics;
            ArrayList<String> newSourceTopicRegex = new ArrayList<String>(this.sourceTopicRegex.size());
            for (String string : this.sourceTopicRegex) {
                newSourceTopicRegex.add(string);
            }
            _duplicate.sourceTopicRegex = newSourceTopicRegex;
            ArrayList<TopicInfo> arrayList = new ArrayList<TopicInfo>(this.stateChangelogTopics.size());
            for (TopicInfo topicInfo : this.stateChangelogTopics) {
                arrayList.add(topicInfo.duplicate());
            }
            _duplicate.stateChangelogTopics = arrayList;
            ArrayList<String> arrayList2 = new ArrayList<String>(this.repartitionSinkTopics.size());
            for (String string : this.repartitionSinkTopics) {
                arrayList2.add(string);
            }
            _duplicate.repartitionSinkTopics = arrayList2;
            ArrayList<TopicInfo> arrayList3 = new ArrayList<TopicInfo>(this.repartitionSourceTopics.size());
            for (TopicInfo _element : this.repartitionSourceTopics) {
                arrayList3.add(_element.duplicate());
            }
            _duplicate.repartitionSourceTopics = arrayList3;
            ArrayList<CopartitionGroup> arrayList4 = new ArrayList<CopartitionGroup>(this.copartitionGroups.size());
            for (CopartitionGroup _element : this.copartitionGroups) {
                arrayList4.add(_element.duplicate());
            }
            _duplicate.copartitionGroups = arrayList4;
            return _duplicate;
        }

        public String toString() {
            return "Subtopology(subtopologyId=" + (String)(this.subtopologyId == null ? "null" : "'" + this.subtopologyId.toString() + "'") + ", sourceTopics=" + MessageUtil.deepToString(this.sourceTopics.iterator()) + ", sourceTopicRegex=" + MessageUtil.deepToString(this.sourceTopicRegex.iterator()) + ", stateChangelogTopics=" + MessageUtil.deepToString(this.stateChangelogTopics.iterator()) + ", repartitionSinkTopics=" + MessageUtil.deepToString(this.repartitionSinkTopics.iterator()) + ", repartitionSourceTopics=" + MessageUtil.deepToString(this.repartitionSourceTopics.iterator()) + ", copartitionGroups=" + MessageUtil.deepToString(this.copartitionGroups.iterator()) + ")";
        }

        public String subtopologyId() {
            return this.subtopologyId;
        }

        public List<String> sourceTopics() {
            return this.sourceTopics;
        }

        public List<String> sourceTopicRegex() {
            return this.sourceTopicRegex;
        }

        public List<TopicInfo> stateChangelogTopics() {
            return this.stateChangelogTopics;
        }

        public List<String> repartitionSinkTopics() {
            return this.repartitionSinkTopics;
        }

        public List<TopicInfo> repartitionSourceTopics() {
            return this.repartitionSourceTopics;
        }

        public List<CopartitionGroup> copartitionGroups() {
            return this.copartitionGroups;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Subtopology setSubtopologyId(String v) {
            this.subtopologyId = v;
            return this;
        }

        public Subtopology setSourceTopics(List<String> v) {
            this.sourceTopics = v;
            return this;
        }

        public Subtopology setSourceTopicRegex(List<String> v) {
            this.sourceTopicRegex = v;
            return this;
        }

        public Subtopology setStateChangelogTopics(List<TopicInfo> v) {
            this.stateChangelogTopics = v;
            return this;
        }

        public Subtopology setRepartitionSinkTopics(List<String> v) {
            this.repartitionSinkTopics = v;
            return this;
        }

        public Subtopology setRepartitionSourceTopics(List<TopicInfo> v) {
            this.repartitionSourceTopics = v;
            return this;
        }

        public Subtopology setCopartitionGroups(List<CopartitionGroup> v) {
            this.copartitionGroups = v;
            return this;
        }
    }
}

