/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import io.confluent.telemetry.api.events.EventEmitter;
import io.confluent.telemetry.api.events.EventEmitterProvider;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Metrics
implements Closeable {
    private final MetricConfig config;
    private final ConcurrentMap<MetricName, KafkaMetric> metrics;
    private final ConcurrentMap<String, Sensor> sensors;
    private final ConcurrentMap<Sensor, List<Sensor>> childrenSensors;
    private final ConcurrentMap<String, EmitWhenNonDefaultMetric> emitWhenNonDefaultMetrics;
    private final List<MetricsReporter> reporters;
    private final Time time;
    private final ScheduledThreadPoolExecutor metricsScheduler;
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);
    private volatile EventEmitterProvider eventEmitterProvider = EventEmitterProvider.DEFAULT;

    public Metrics() {
        this(new MetricConfig());
    }

    public Metrics(Time time) {
        this(new MetricConfig(), new ArrayList<MetricsReporter>(0), time);
    }

    public Metrics(MetricConfig defaultConfig, Time time) {
        this(defaultConfig, new ArrayList<MetricsReporter>(0), time);
    }

    public Metrics(MetricConfig defaultConfig) {
        this(defaultConfig, new ArrayList<MetricsReporter>(0), Time.SYSTEM);
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time) {
        this(defaultConfig, reporters, time, false);
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time, MetricsContext metricsContext) {
        this(defaultConfig, reporters, time, false, metricsContext);
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time, boolean enableExpiration) {
        this(defaultConfig, reporters, time, enableExpiration, new KafkaMetricsContext(""));
    }

    public Metrics(MetricConfig defaultConfig, List<MetricsReporter> reporters, Time time, boolean enableExpiration, MetricsContext metricsContext) {
        this.config = defaultConfig;
        this.sensors = new ConcurrentHashMap<String, Sensor>();
        this.metrics = new ConcurrentHashMap<MetricName, KafkaMetric>();
        this.emitWhenNonDefaultMetrics = new ConcurrentHashMap<String, EmitWhenNonDefaultMetric>();
        this.childrenSensors = new ConcurrentHashMap<Sensor, List<Sensor>>();
        this.reporters = Objects.requireNonNull(reporters);
        this.time = time;
        for (MetricsReporter reporter : reporters) {
            reporter.contextChange(metricsContext);
            reporter.init(new ArrayList<KafkaMetric>());
        }
        for (MetricsReporter reporter : reporters) {
            if (!(reporter instanceof EventEmitterProvider)) continue;
            this.eventEmitterProvider = () -> ((EventEmitterProvider)((Object)reporter)).eventEmitter();
            break;
        }
        if (enableExpiration) {
            this.metricsScheduler = new ScheduledThreadPoolExecutor(1);
            this.metricsScheduler.setThreadFactory(runnable -> KafkaThread.daemon("SensorExpiryThread", runnable));
            this.metricsScheduler.scheduleAtFixedRate(new ExpireSensorTask(), 30L, 30L, TimeUnit.SECONDS);
            this.metricsScheduler.scheduleAtFixedRate(new RegisterEmitWhenNonDefaultMetricsSensorsTask(), 30L, 30L, TimeUnit.SECONDS);
        } else {
            this.metricsScheduler = null;
        }
        this.addMetric(this.metricName("count", "kafka-metrics-count", "total number of registered metrics"), (MetricConfig config, long now) -> this.metrics.size());
    }

    public MetricName metricName(String name, String group, String description, Map<String, String> tags) {
        LinkedHashMap<String, String> combinedTag = new LinkedHashMap<String, String>(this.config.tags());
        combinedTag.putAll(tags);
        return new MetricName(name, group, description, combinedTag);
    }

    public MetricName metricName(String name, String group, String description) {
        return this.metricName(name, group, description, new HashMap<String, String>());
    }

    public MetricName metricName(String name, String group) {
        return this.metricName(name, group, "", new HashMap<String, String>());
    }

    public MetricName metricName(String name, String group, String description, String ... keyValue) {
        return this.metricName(name, group, description, MetricsUtils.getTags(keyValue));
    }

    public MetricName metricName(String name, String group, Map<String, String> tags) {
        return this.metricName(name, group, "", tags);
    }

    public static String toHtmlTable(String domain, Iterable<MetricNameTemplate> allMetrics) {
        TreeMap beansAndAttributes = new TreeMap();
        try (Metrics metrics = new Metrics();){
            for (MetricNameTemplate metricNameTemplate : allMetrics) {
                Map attrAndDesc;
                LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
                for (String s2 : metricNameTemplate.tags()) {
                    tags.put(s2, "{" + s2 + "}");
                }
                MetricName metricName = metrics.metricName(metricNameTemplate.name(), metricNameTemplate.group(), metricNameTemplate.description(), tags);
                String mBeanName = JmxReporter.getMBeanName(domain, metricName);
                if (!beansAndAttributes.containsKey(mBeanName)) {
                    beansAndAttributes.put(mBeanName, new TreeMap());
                }
                if (!(attrAndDesc = (Map)beansAndAttributes.get(mBeanName)).containsKey(metricNameTemplate.name())) {
                    attrAndDesc.put(metricNameTemplate.name(), metricNameTemplate.description());
                    continue;
                }
                throw new IllegalArgumentException("mBean '" + mBeanName + "' attribute '" + metricNameTemplate.name() + "' is defined twice.");
            }
        }
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\">\n<tbody>\n");
        b.append("<tr>\n");
        b.append("<th>Metric/Attribute name</th>\n");
        b.append("<th>Description</th>\n");
        b.append("<th>Mbean name</th>\n");
        b.append("</tr>\n");
        for (Map.Entry entry : beansAndAttributes.entrySet()) {
            for (Map.Entry e2 : ((Map)entry.getValue()).entrySet()) {
                b.append("<tr>\n");
                b.append("<td>");
                b.append((String)e2.getKey());
                b.append("</td>\n");
                b.append("<td>");
                b.append((String)e2.getValue());
                b.append("</td>\n");
                b.append("<td>");
                b.append((String)entry.getKey());
                b.append("</td>\n");
                b.append("</tr>\n");
            }
        }
        b.append("</tbody></table>");
        return b.toString();
    }

    public MetricConfig config() {
        return this.config;
    }

    public Sensor getSensor(String name) {
        return (Sensor)this.sensors.get(Objects.requireNonNull(name));
    }

    public Sensor sensor(String name) {
        return this.sensor(name, Sensor.RecordingLevel.INFO);
    }

    public Sensor sensor(String name, Sensor.RecordingLevel recordingLevel) {
        return this.sensor(name, null, recordingLevel, (Sensor[])null);
    }

    public Sensor sensor(String name, Sensor ... parents) {
        return this.sensor(name, Sensor.RecordingLevel.INFO, parents);
    }

    public Sensor sensor(String name, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        return this.sensor(name, null, recordingLevel, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, Sensor ... parents) {
        return this.sensor(name, config, Sensor.RecordingLevel.INFO, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        return this.sensor(name, config, Long.MAX_VALUE, recordingLevel, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, long inactiveSensorExpirationTimeSeconds, Sensor.RecordingLevel recordingLevel, Consumer<Sensor> removeCallback, Sensor ... parents) {
        Sensor s2 = this.getSensor(name);
        if (s2 == null) {
            s2 = new Sensor(this, name, parents, config == null ? this.config : config, this.time, inactiveSensorExpirationTimeSeconds, recordingLevel, removeCallback);
            this.sensors.put(name, s2);
            if (parents != null) {
                for (Sensor parent : parents) {
                    List children = this.childrenSensors.computeIfAbsent(parent, k -> new ArrayList());
                    children.add(s2);
                }
            }
            log.trace("Added sensor with name {}", (Object)name);
        }
        return s2;
    }

    public synchronized Sensor sensor(String name, MetricConfig config, long inactiveSensorExpirationTimeSeconds, Sensor.RecordingLevel recordingLevel, Sensor ... parents) {
        return this.sensor(name, config, inactiveSensorExpirationTimeSeconds, recordingLevel, Sensor.EMPTY_REMOVE_CALLBACK, parents);
    }

    public synchronized Sensor sensor(String name, MetricConfig config, long inactiveSensorExpirationTimeSeconds, Sensor ... parents) {
        return this.sensor(name, config, inactiveSensorExpirationTimeSeconds, Sensor.RecordingLevel.INFO, parents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSensor(String name) {
        Sensor sensor = (Sensor)this.sensors.get(name);
        if (sensor != null) {
            List childSensors = null;
            Sensor sensor2 = sensor;
            synchronized (sensor2) {
                Metrics metrics = this;
                synchronized (metrics) {
                    if (this.sensors.remove(name, sensor)) {
                        for (KafkaMetric metric : sensor.metrics()) {
                            this.removeMetric(metric.metricName());
                        }
                        sensor.onRemoval();
                        log.trace("Removed sensor with name {}", (Object)name);
                        childSensors = (List)this.childrenSensors.remove(sensor);
                        for (Sensor parent : sensor.parents()) {
                            this.childrenSensors.getOrDefault(parent, Collections.emptyList()).remove(sensor);
                        }
                    }
                }
            }
            if (childSensors != null) {
                for (Sensor childSensor : childSensors) {
                    this.removeSensor(childSensor.name());
                }
            }
        }
    }

    public void addMetric(MetricName metricName, Measurable measurable) {
        this.addMetric(metricName, (MetricConfig)null, measurable);
    }

    public void addMetric(MetricName metricName, MetricConfig config, Measurable measurable) {
        this.addMetric(metricName, config, (MetricValueProvider<?>)measurable);
    }

    public void addMetric(MetricName metricName, MetricConfig config, MetricValueProvider<?> metricValueProvider) {
        KafkaMetric m4 = new KafkaMetric(new Object(), Objects.requireNonNull(metricName), Objects.requireNonNull(metricValueProvider), config == null ? this.config : config, this.time);
        KafkaMetric existingMetric = this.registerMetric(m4);
        if (existingMetric != null) {
            throw new IllegalArgumentException("A metric named '" + String.valueOf(metricName) + "' already exists, can't register another one.");
        }
    }

    public void addMetric(MetricName metricName, MetricValueProvider<?> metricValueProvider) {
        this.addMetric(metricName, null, metricValueProvider);
    }

    public KafkaMetric addMetricIfAbsent(MetricName metricName, MetricConfig config, MetricValueProvider<?> metricValueProvider) {
        KafkaMetric metric = new KafkaMetric(new Object(), Objects.requireNonNull(metricName), Objects.requireNonNull(metricValueProvider), config == null ? this.config : config, this.time);
        KafkaMetric existingMetric = this.registerMetric(metric);
        return existingMetric == null ? metric : existingMetric;
    }

    public synchronized KafkaMetric removeMetric(MetricName metricName) {
        KafkaMetric metric = (KafkaMetric)this.metrics.remove(metricName);
        if (metric != null) {
            for (MetricsReporter reporter : this.reporters) {
                try {
                    reporter.metricRemoval(metric);
                }
                catch (Exception e) {
                    log.error("Error when removing metric from " + reporter.getClass().getName(), (Throwable)e);
                }
            }
            log.trace("Removed metric named {}", (Object)metricName);
        }
        return metric;
    }

    public synchronized void addReporter(MetricsReporter reporter) {
        Objects.requireNonNull(reporter).init(new ArrayList<KafkaMetric>(this.metrics.values()));
        this.reporters.add(reporter);
        if (reporter instanceof EventEmitterProvider && this.eventEmitterProvider == EventEmitterProvider.DEFAULT) {
            this.eventEmitterProvider = () -> ((EventEmitterProvider)((Object)reporter)).eventEmitter();
        }
    }

    public synchronized void removeReporter(MetricsReporter reporter) {
        if (this.reporters.remove(reporter)) {
            reporter.close();
        }
    }

    synchronized KafkaMetric registerMetric(KafkaMetric metric) {
        MetricName metricName = metric.metricName();
        KafkaMetric existingMetric = this.metrics.putIfAbsent(metricName, metric);
        if (existingMetric != null) {
            return existingMetric;
        }
        for (MetricsReporter reporter : this.reporters) {
            try {
                reporter.metricChange(metric);
            }
            catch (Exception e) {
                log.error("Error when registering metric on " + reporter.getClass().getName(), (Throwable)e);
            }
        }
        log.trace("Registered metric named {}", (Object)metricName);
        return null;
    }

    synchronized void registerEmitWhenNonDefaultMetricSensor(String sensorName, MetricName metricName, MetricConfig config, Supplier<Double> metricValueProvider, Double defaultValue) {
        EmitWhenNonDefaultMetric metric = new EmitWhenNonDefaultMetric(metricName, config, metricValueProvider, defaultValue);
        this.emitWhenNonDefaultMetrics.put(sensorName, metric);
        this.addRemoveEmitWhenNonDefaultMetricSensor(sensorName, metric);
    }

    synchronized void removeEmitWhenNonDefaultMetricSensor(String sensorName) {
        this.emitWhenNonDefaultMetrics.remove(sensorName);
        this.removeSensor(sensorName);
    }

    public Map<MetricName, KafkaMetric> metrics() {
        return this.metrics;
    }

    public List<MetricsReporter> reporters() {
        return this.reporters;
    }

    public KafkaMetric metric(MetricName metricName) {
        return (KafkaMetric)this.metrics.get(metricName);
    }

    private void addRemoveEmitWhenNonDefaultMetricSensor(String sensorName, final EmitWhenNonDefaultMetric metric) {
        Double currentValue;
        try {
            currentValue = metric.metricValueProvider.get();
        }
        catch (Exception e) {
            log.debug("Error evaluating EmitWhenNonDefaultMetricSensor for {}, removing old sensor", (Object)sensorName, (Object)e);
            currentValue = null;
        }
        if (currentValue != null && metric.defaultValue != currentValue) {
            Sensor sensor = this.sensor(sensorName, metric.config, new Sensor[0]);
            Value value = new Value(){

                @Override
                public double measure(MetricConfig config, long now) {
                    return metric.metricValueProvider.get();
                }
            };
            sensor.add(metric.metricName, value, metric.config);
        } else {
            Sensor sensor = (Sensor)this.sensors.get(sensorName);
            if (sensor != null) {
                log.debug("Removing sensor {} as value is default", (Object)sensorName);
                this.removeSensor(sensorName);
            }
        }
    }

    Map<Sensor, List<Sensor>> childrenSensors() {
        return Collections.unmodifiableMap(this.childrenSensors);
    }

    public MetricName metricInstance(MetricNameTemplate template, String ... keyValue) {
        return this.metricInstance(template, MetricsUtils.getTags(keyValue));
    }

    public MetricName metricInstance(MetricNameTemplate template, Map<String, String> tags) {
        HashSet<String> runtimeTagKeys = new HashSet<String>(tags.keySet());
        runtimeTagKeys.addAll(this.config().tags().keySet());
        Set<String> templateTagKeys = template.tags();
        if (!runtimeTagKeys.equals(templateTagKeys)) {
            throw new IllegalArgumentException("For '" + template.name() + "', runtime-defined metric tags do not match the tags in the template. Runtime = " + ((Object)runtimeTagKeys).toString() + " Template = " + templateTagKeys.toString());
        }
        return this.metricName(template.name(), template.group(), template.description(), tags);
    }

    @Override
    public void close() {
        if (this.metricsScheduler != null) {
            this.metricsScheduler.shutdown();
            try {
                this.metricsScheduler.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        log.debug("Metrics scheduler closed");
        for (MetricsReporter reporter : this.reporters) {
            try {
                log.debug("Closing reporter {}", (Object)reporter.getClass().getName());
                reporter.close();
            }
            catch (Exception e) {
                log.error("Error when closing " + reporter.getClass().getName(), (Throwable)e);
            }
        }
        log.debug("Metrics reporters closed");
    }

    public EventEmitter eventEmitter() {
        return this.eventEmitterProvider.eventEmitter();
    }

    class ExpireSensorTask
    implements Runnable {
        ExpireSensorTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (Map.Entry sensorEntry : Metrics.this.sensors.entrySet()) {
                Sensor sensor = (Sensor)sensorEntry.getValue();
                synchronized (sensor) {
                    if (((Sensor)sensorEntry.getValue()).hasExpired()) {
                        log.debug("Removing expired sensor {}", sensorEntry.getKey());
                        Metrics.this.removeSensor((String)sensorEntry.getKey());
                    }
                }
            }
        }
    }

    class RegisterEmitWhenNonDefaultMetricsSensorsTask
    implements Runnable {
        RegisterEmitWhenNonDefaultMetricsSensorsTask() {
        }

        @Override
        public void run() {
            for (Map.Entry metricEntry : Metrics.this.emitWhenNonDefaultMetrics.entrySet()) {
                String sensorName = (String)metricEntry.getKey();
                EmitWhenNonDefaultMetric entryValue = (EmitWhenNonDefaultMetric)metricEntry.getValue();
                Metrics.this.addRemoveEmitWhenNonDefaultMetricSensor(sensorName, entryValue);
            }
        }
    }

    private static class EmitWhenNonDefaultMetric {
        final MetricName metricName;
        final MetricConfig config;
        final Supplier<Double> metricValueProvider;
        final double defaultValue;

        public EmitWhenNonDefaultMetric(MetricName metricName, MetricConfig config, Supplier<Double> metricValueProvider, double defaultValue) {
            this.metricName = metricName;
            this.config = config;
            this.metricValueProvider = metricValueProvider;
            this.defaultValue = defaultValue;
        }
    }
}

