/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.internals.ReflectionUtils;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;

public class MetricsUtils
extends ReflectionUtils {
    private static final Map<String, MethodHandle> METHODS;

    private static void addMethod(MethodHandles.Lookup lookup, String methodName, Class<?> ... argTypes) {
        METHODS.put(methodName, MetricsUtils.methodHandle(lookup, Metrics.class, methodName, argTypes));
    }

    private static <T> T invokeMethod(String methodName, Object ... args) {
        return MetricsUtils.invoke(methodName, METHODS.get(methodName), args);
    }

    public static void registerEmitWhenNonDefaultMetricSensor(Metrics metrics, String sensorName, MetricName metricName, MetricConfig config, Supplier<Double> metricValueProvider, Double defaultValue) {
        MetricsUtils.invokeMethod("registerEmitWhenNonDefaultMetricSensor", metrics, sensorName, metricName, config, metricValueProvider, defaultValue);
    }

    public static void removeEmitWhenNonDefaultMetricSensor(Metrics metrics, String sensorName) {
        MetricsUtils.invokeMethod("removeEmitWhenNonDefaultMetricSensor", metrics, sensorName);
    }

    public static double convert(long timeMs, TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return (double)timeMs * 1000.0 * 1000.0;
            }
            case MICROSECONDS: {
                return (double)timeMs * 1000.0;
            }
            case MILLISECONDS: {
                return timeMs;
            }
            case SECONDS: {
                return (double)timeMs / 1000.0;
            }
            case MINUTES: {
                return (double)timeMs / 60000.0;
            }
            case HOURS: {
                return (double)timeMs / 3600000.0;
            }
            case DAYS: {
                return (double)timeMs / 8.64E7;
            }
        }
        throw new IllegalStateException("Unknown unit: " + String.valueOf((Object)unit));
    }

    public static Map<String, String> getTags(String ... keyValue) {
        if (keyValue.length % 2 != 0) {
            throw new IllegalArgumentException("keyValue needs to be specified in pairs");
        }
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>(keyValue.length / 2);
        for (int i = 0; i < keyValue.length; i += 2) {
            tags.put(keyValue[i], keyValue[i + 1]);
        }
        return tags;
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        METHODS = new HashMap<String, MethodHandle>();
        MetricsUtils.addMethod(lookup, "registerEmitWhenNonDefaultMetricSensor", String.class, MetricName.class, MetricConfig.class, Supplier.class, Double.class);
        MetricsUtils.addMethod(lookup, "removeEmitWhenNonDefaultMetricSensor", String.class);
    }
}

