/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.AppendRecordsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class AppendRecordsResponse
extends AbstractResponse {
    private final AppendRecordsResponseData data;

    public AppendRecordsResponse(AppendRecordsResponseData data) {
        super(ApiKeys.APPEND_RECORDS);
        this.data = data;
    }

    @Override
    public AppendRecordsResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        AppendRecordsResponse.updateErrorCounts(errorCounts, Errors.forCode(this.data.errorCode()));
        this.data.topics().forEach(t2 -> t2.partitions().forEach(p -> AppendRecordsResponse.updateErrorCounts(errorCounts, Errors.forCode(p.errorCode()))));
        return errorCounts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public static AppendRecordsResponseData.PartitionData partitionResponse(int partition, Errors error) {
        return new AppendRecordsResponseData.PartitionData().setPartitionIndex(partition).setErrorCode(error.code());
    }

    public static AppendRecordsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AppendRecordsResponse(new AppendRecordsResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

