/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.CellState;
import org.apache.kafka.common.message.CreateCellRequestData;
import org.apache.kafka.common.message.CreateCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateCellResponse;

public class CreateCellRequest
extends AbstractRequest {
    private final CreateCellRequestData data;

    CreateCellRequest(CreateCellRequestData data, short version) {
        super(ApiKeys.CREATE_CELL, version);
        this.data = data;
    }

    @Override
    public CreateCellRequestData data() {
        return this.data;
    }

    public int cellId() {
        return this.data.cellId();
    }

    public byte state() {
        return this.data.state();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t2) {
        ApiError err = ApiError.fromThrowable(t2);
        return new CreateCellResponse(new CreateCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static CreateCellRequest parse(Readable readable, short version, MessageContext context) {
        return new CreateCellRequest(new CreateCellRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateCellRequest> {
        private final CreateCellRequestData data;

        public Builder() {
            super(ApiKeys.CREATE_CELL);
            this.data = new CreateCellRequestData();
        }

        public Builder(CreateCellRequestData data) {
            super(ApiKeys.CREATE_CELL);
            this.data = data;
        }

        public Builder setCellId(int id) {
            this.data.setCellId(id);
            return this;
        }

        public Builder setState(CellState state) {
            this.data.setState(state.code());
            return this;
        }

        @Override
        public CreateCellRequest build(short version) {
            return new CreateCellRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

