/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import org.apache.kafka.common.message.DescribeCellLoadRequestData;
import org.apache.kafka.common.message.DescribeCellLoadResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeCellLoadResponse;

public class DescribeCellLoadRequest
extends AbstractRequest {
    private final DescribeCellLoadRequestData data;

    DescribeCellLoadRequest(DescribeCellLoadRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CELL_LOAD, version);
        this.data = data;
    }

    @Override
    public DescribeCellLoadRequestData data() {
        return this.data;
    }

    public List<Integer> cellIds() {
        return this.data.cellIds();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t2) {
        ApiError err = ApiError.fromThrowable(t2);
        return new DescribeCellLoadResponse(new DescribeCellLoadResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static DescribeCellLoadRequest parse(Readable readable, short version, MessageContext context) {
        return new DescribeCellLoadRequest(new DescribeCellLoadRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeCellLoadRequest> {
        private final DescribeCellLoadRequestData data;

        public Builder() {
            super(ApiKeys.DESCRIBE_CELL_LOAD);
            this.data = new DescribeCellLoadRequestData();
        }

        public Builder(DescribeCellLoadRequestData data) {
            super(ApiKeys.DESCRIBE_CELL_LOAD);
            this.data = data;
        }

        public Builder setCellId(List<Integer> cellIds) {
            this.data.setCellIds(cellIds);
            return this;
        }

        @Override
        public DescribeCellLoadRequest build(short version) {
            return new DescribeCellLoadRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

