/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class LeaveGroupResponse
extends AbstractResponse {
    private final LeaveGroupResponseData data;

    public LeaveGroupResponse(LeaveGroupResponseData data) {
        super(ApiKeys.LEAVE_GROUP);
        this.data = data;
    }

    public LeaveGroupResponse(LeaveGroupResponseData data, short version) {
        super(ApiKeys.LEAVE_GROUP);
        if (version >= 3) {
            this.data = data;
        } else if (data.errorCode() != Errors.NONE.code()) {
            this.data = new LeaveGroupResponseData().setErrorCode(data.errorCode());
        } else {
            if (data.members().size() != 1) {
                throw new UnsupportedVersionException("LeaveGroup response version " + version + " can only contain one member, got " + data.members().size() + " members.");
            }
            this.data = new LeaveGroupResponseData().setErrorCode(data.members().get(0).errorCode());
        }
    }

    public LeaveGroupResponse(List<LeaveGroupResponseData.MemberResponse> memberResponses, Errors topLevelError, int throttleTimeMs, short version) {
        super(ApiKeys.LEAVE_GROUP);
        if (version <= 2) {
            short errorCode = LeaveGroupResponse.getError(topLevelError, memberResponses).code();
            this.data = new LeaveGroupResponseData().setErrorCode(errorCode);
        } else {
            this.data = new LeaveGroupResponseData().setErrorCode(topLevelError.code()).setMembers(memberResponses);
        }
        if (version >= 1) {
            this.data.setThrottleTimeMs(throttleTimeMs);
        }
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public List<LeaveGroupResponseData.MemberResponse> memberResponses() {
        return this.data.members();
    }

    public Errors error() {
        return LeaveGroupResponse.getError(Errors.forCode(this.data.errorCode()), this.data.members());
    }

    public Errors topLevelError() {
        return Errors.forCode(this.data.errorCode());
    }

    private static Errors getError(Errors topLevelError, List<LeaveGroupResponseData.MemberResponse> memberResponses) {
        if (topLevelError != Errors.NONE) {
            return topLevelError;
        }
        for (LeaveGroupResponseData.MemberResponse memberResponse : memberResponses) {
            Errors memberError = Errors.forCode(memberResponse.errorCode());
            if (memberError == Errors.NONE) continue;
            return memberError;
        }
        return Errors.NONE;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> combinedErrorCounts = new HashMap<Errors, Integer>();
        LeaveGroupResponse.updateErrorCounts(combinedErrorCounts, Errors.forCode(this.data.errorCode()));
        this.data.members().forEach(memberResponse -> LeaveGroupResponse.updateErrorCounts(combinedErrorCounts, Errors.forCode(memberResponse.errorCode())));
        return combinedErrorCounts;
    }

    @Override
    public LeaveGroupResponseData data() {
        return this.data;
    }

    public static LeaveGroupResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new LeaveGroupResponse(new LeaveGroupResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public boolean equals(Object other) {
        return other instanceof LeaveGroupResponse && ((LeaveGroupResponse)other).data.equals(this.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }
}

