/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ClientMetricsResourceListing;
import org.apache.kafka.common.message.ListClientMetricsResourcesResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;

public class ListClientMetricsResourcesResponse
extends AbstractResponse {
    private final ListClientMetricsResourcesResponseData data;

    public ListClientMetricsResourcesResponse(ListClientMetricsResourcesResponseData data) {
        super(ApiKeys.LIST_CLIENT_METRICS_RESOURCES);
        this.data = data;
    }

    @Override
    public ListClientMetricsResourcesResponseData data() {
        return this.data;
    }

    public ApiError error() {
        return new ApiError(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return ListClientMetricsResourcesResponse.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    public static ListClientMetricsResourcesResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ListClientMetricsResourcesResponse(new ListClientMetricsResourcesResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Collection<ClientMetricsResourceListing> clientMetricsResources() {
        return this.data.clientMetricsResources().stream().map(entry -> new ClientMetricsResourceListing(entry.name())).collect(Collectors.toList());
    }
}

