/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;

public class OffsetsForLeaderEpochRequest
extends AbstractRequest {
    public static final int CONSUMER_REPLICA_ID = -1;
    public static final int DEBUGGING_REPLICA_ID = -2;
    private final OffsetForLeaderEpochRequestData data;

    public OffsetsForLeaderEpochRequest(OffsetForLeaderEpochRequestData data, short version) {
        super(ApiKeys.OFFSET_FOR_LEADER_EPOCH, version);
        this.data = data;
    }

    @Override
    public OffsetForLeaderEpochRequestData data() {
        return this.data;
    }

    public int replicaId() {
        return this.data.replicaId();
    }

    public static OffsetsForLeaderEpochRequest parse(Readable readable, short version, MessageContext context) {
        return new OffsetsForLeaderEpochRequest(new OffsetForLeaderEpochRequestData(readable, version, context), version);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        OffsetForLeaderEpochResponseData responseData = new OffsetForLeaderEpochResponseData();
        this.data.topics().forEach(topic -> {
            OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult topicData = new OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult().setTopic(topic.topic());
            topic.partitions().forEach(partition -> topicData.partitions().add(new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partition.partition()).setErrorCode(error.code()).setLeaderEpoch(-1).setEndOffset(-1L)));
            responseData.topics().add(topicData);
        });
        return new OffsetsForLeaderEpochResponse(responseData);
    }

    public static boolean supportsTopicPermission(short latestUsableVersion) {
        return latestUsableVersion >= 3;
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetsForLeaderEpochRequest> {
        private final OffsetForLeaderEpochRequestData data;

        Builder(short oldestAllowedVersion, short latestAllowedVersion, OffsetForLeaderEpochRequestData data) {
            super(ApiKeys.OFFSET_FOR_LEADER_EPOCH, oldestAllowedVersion, latestAllowedVersion);
            this.data = data;
        }

        public static Builder forConsumer(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochsByPartition) {
            OffsetForLeaderEpochRequestData data = new OffsetForLeaderEpochRequestData();
            data.setReplicaId(-1);
            data.setTopics(epochsByPartition);
            return new Builder(3, ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), data);
        }

        public static Builder forFollower(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochsByPartition, int replicaId) {
            OffsetForLeaderEpochRequestData data = new OffsetForLeaderEpochRequestData();
            data.setReplicaId(replicaId);
            data.setTopics(epochsByPartition);
            return new Builder(4, 4, data);
        }

        @Override
        public OffsetsForLeaderEpochRequest build(short version) {
            if (version < this.oldestAllowedVersion() || version > this.latestAllowedVersion()) {
                throw new UnsupportedVersionException("Cannot build " + String.valueOf(this) + " with version " + version);
            }
            return new OffsetsForLeaderEpochRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

