/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.ReplicaStatusResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReplicaStatusResponse
extends AbstractResponse {
    private final ReplicaStatusResponseData data;

    public ReplicaStatusResponse(ReplicaStatusResponseData data) {
        super(ApiKeys.REPLICA_STATUS);
        this.data = data;
    }

    @Override
    public ReplicaStatusResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.incrementErrorCount(this.data.errorCode(), errorCounts);
        for (ReplicaStatusResponseData.ReplicaStatusTopicResponse topicResponse : this.data.topics()) {
            for (ReplicaStatusResponseData.ReplicaStatusPartitionResponse partitionResponse : topicResponse.partitions()) {
                this.incrementErrorCount(partitionResponse.errorCode(), errorCounts);
            }
        }
        return errorCounts;
    }

    private void incrementErrorCount(short errorCode, Map<Errors, Integer> errorCounts) {
        Errors error = Errors.forCode(errorCode);
        errorCounts.put(error, errorCounts.getOrDefault((Object)error, 0) + 1);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public void complete(Map<TopicPartition, KafkaFutureImpl<PartitionResult>> result) {
        for (ReplicaStatusResponseData.ReplicaStatusTopicResponse topicResponse : this.data.topics()) {
            for (ReplicaStatusResponseData.ReplicaStatusPartitionResponse partitionResponse : topicResponse.partitions()) {
                TopicPartition topicPartition = new TopicPartition(topicResponse.name(), partitionResponse.partitionIndex());
                KafkaFutureImpl<PartitionResult> future = result.get(topicPartition);
                Objects.requireNonNull(future, "Replica status future must not be null for " + String.valueOf(topicPartition));
                Errors error = Errors.forCode(partitionResponse.errorCode());
                if (error != Errors.NONE) {
                    future.completeExceptionally(error.exception());
                    continue;
                }
                future.complete(new PartitionResult(partitionResponse));
            }
        }
    }

    public static ReplicaStatusResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ReplicaStatusResponse(new ReplicaStatusResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

