/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.message.ReverseConnectionResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReverseConnectionResponse
extends AbstractResponse {
    public final ReverseConnectionResponseData data;

    public ReverseConnectionResponse(ReverseConnectionResponseData data) {
        super(ApiKeys.REVERSE_CONNECTION);
        this.data = data;
    }

    public ReverseConnectionResponse(Errors error, String errorMessage, int throttleTimeMs) {
        super(ApiKeys.REVERSE_CONNECTION);
        this.data = new ReverseConnectionResponseData().setErrorCode(error.code()).setErrorMessage(errorMessage).setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return ReverseConnectionResponse.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public ReverseConnectionResponseData data() {
        return this.data;
    }

    public static ReverseConnectionResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ReverseConnectionResponse(new ReverseConnectionResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    public boolean equals(Object other) {
        return other instanceof ReverseConnectionResponse && ((ReverseConnectionResponse)other).data.equals(this.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }
}

