/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.common.errors.FencedInstanceIdException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoveMembersFromConsumerGroupResultTest {
    private final MemberToRemove instanceOne = new MemberToRemove("instance-1");
    private final MemberToRemove instanceTwo = new MemberToRemove("instance-2");
    private Set<MemberToRemove> membersToRemove;
    private Map<LeaveGroupRequestData.MemberIdentity, Errors> errorsMap;
    private KafkaFutureImpl<Map<LeaveGroupRequestData.MemberIdentity, Errors>> memberFutures;

    @BeforeEach
    public void setUp() {
        this.memberFutures = new KafkaFutureImpl();
        this.membersToRemove = new HashSet<MemberToRemove>();
        this.membersToRemove.add(this.instanceOne);
        this.membersToRemove.add(this.instanceTwo);
        this.errorsMap = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        this.errorsMap.put(this.instanceOne.toMemberIdentity(), Errors.NONE);
        this.errorsMap.put(this.instanceTwo.toMemberIdentity(), Errors.FENCED_INSTANCE_ID);
    }

    @Test
    public void testTopLevelErrorConstructor() {
        this.memberFutures.completeExceptionally((Throwable)Errors.GROUP_AUTHORIZATION_FAILED.exception());
        RemoveMembersFromConsumerGroupResult topLevelErrorResult = new RemoveMembersFromConsumerGroupResult(this.memberFutures, this.membersToRemove);
        TestUtils.assertFutureThrows(GroupAuthorizationException.class, topLevelErrorResult.all());
    }

    @Test
    public void testMemberLevelErrorConstructor() throws InterruptedException, ExecutionException {
        this.createAndVerifyMemberLevelError();
    }

    @Test
    public void testMemberMissingErrorInRequestConstructor() throws InterruptedException, ExecutionException {
        this.errorsMap.remove(this.instanceTwo.toMemberIdentity());
        this.memberFutures.complete(this.errorsMap);
        Assertions.assertFalse((boolean)this.memberFutures.isCompletedExceptionally());
        RemoveMembersFromConsumerGroupResult missingMemberResult = new RemoveMembersFromConsumerGroupResult(this.memberFutures, this.membersToRemove);
        TestUtils.assertFutureThrows(IllegalArgumentException.class, missingMemberResult.all());
        Assertions.assertNull((Object)missingMemberResult.memberResult(this.instanceOne).get());
        TestUtils.assertFutureThrows(IllegalArgumentException.class, missingMemberResult.memberResult(this.instanceTwo));
    }

    @Test
    public void testMemberLevelErrorInResponseConstructor() throws InterruptedException, ExecutionException {
        RemoveMembersFromConsumerGroupResult memberLevelErrorResult = this.createAndVerifyMemberLevelError();
        Assertions.assertThrows(IllegalArgumentException.class, () -> memberLevelErrorResult.memberResult(new MemberToRemove("invalid-instance-id")));
    }

    @Test
    public void testNoErrorConstructor() throws ExecutionException, InterruptedException {
        HashMap<LeaveGroupRequestData.MemberIdentity, Errors> errorsMap = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        errorsMap.put(this.instanceOne.toMemberIdentity(), Errors.NONE);
        errorsMap.put(this.instanceTwo.toMemberIdentity(), Errors.NONE);
        RemoveMembersFromConsumerGroupResult noErrorResult = new RemoveMembersFromConsumerGroupResult(this.memberFutures, this.membersToRemove);
        this.memberFutures.complete(errorsMap);
        Assertions.assertNull((Object)noErrorResult.all().get());
        Assertions.assertNull((Object)noErrorResult.memberResult(this.instanceOne).get());
        Assertions.assertNull((Object)noErrorResult.memberResult(this.instanceTwo).get());
    }

    private RemoveMembersFromConsumerGroupResult createAndVerifyMemberLevelError() throws InterruptedException, ExecutionException {
        this.memberFutures.complete(this.errorsMap);
        Assertions.assertFalse((boolean)this.memberFutures.isCompletedExceptionally());
        RemoveMembersFromConsumerGroupResult memberLevelErrorResult = new RemoveMembersFromConsumerGroupResult(this.memberFutures, this.membersToRemove);
        TestUtils.assertFutureThrows(FencedInstanceIdException.class, memberLevelErrorResult.all());
        Assertions.assertNull((Object)memberLevelErrorResult.memberResult(this.instanceOne).get());
        TestUtils.assertFutureThrows(FencedInstanceIdException.class, memberLevelErrorResult.memberResult(this.instanceTwo));
        return memberLevelErrorResult;
    }
}

