/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.internals.StreamsRebalanceData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamsRebalanceDataTest {
    @Test
    public void testTaskIdEqualsAndHashCode() {
        StreamsRebalanceData.TaskId task = new StreamsRebalanceData.TaskId("subtopologyId1", 1);
        StreamsRebalanceData.TaskId taskEqual = new StreamsRebalanceData.TaskId(task.subtopologyId(), task.partitionId());
        StreamsRebalanceData.TaskId taskUnequalSubtopology = new StreamsRebalanceData.TaskId(task.subtopologyId() + "1", task.partitionId());
        StreamsRebalanceData.TaskId taskUnequalPartition = new StreamsRebalanceData.TaskId(task.subtopologyId(), task.partitionId() + 1);
        Assertions.assertEquals((Object)task, (Object)taskEqual);
        Assertions.assertEquals((int)task.hashCode(), (int)taskEqual.hashCode());
        Assertions.assertNotEquals((Object)task, (Object)taskUnequalSubtopology);
        Assertions.assertNotEquals((int)task.hashCode(), (int)taskUnequalSubtopology.hashCode());
        Assertions.assertNotEquals((Object)task, (Object)taskUnequalPartition);
        Assertions.assertNotEquals((int)task.hashCode(), (int)taskUnequalSubtopology.hashCode());
    }

    @Test
    public void taskIdShouldNotAcceptNulls() {
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.TaskId(null, 1));
        Assertions.assertEquals((Object)"Subtopology ID cannot be null", (Object)exception.getMessage());
    }

    @Test
    public void testTaskIdCompareTo() {
        StreamsRebalanceData.TaskId task = new StreamsRebalanceData.TaskId("subtopologyId1", 1);
        Assertions.assertTrue((task.compareTo(new StreamsRebalanceData.TaskId(task.subtopologyId(), task.partitionId())) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((task.compareTo(new StreamsRebalanceData.TaskId(task.subtopologyId() + "1", task.partitionId())) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((task.compareTo(new StreamsRebalanceData.TaskId(task.subtopologyId(), task.partitionId() + 1)) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new StreamsRebalanceData.TaskId(task.subtopologyId() + "1", task.partitionId()).compareTo(task) > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((new StreamsRebalanceData.TaskId(task.subtopologyId(), task.partitionId() + 1).compareTo(task) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void emptyAssignmentShouldNotBeModifiable() {
        StreamsRebalanceData.Assignment emptyAssignment = StreamsRebalanceData.Assignment.EMPTY;
        Assertions.assertThrows(UnsupportedOperationException.class, () -> emptyAssignment.activeTasks().add(new StreamsRebalanceData.TaskId("subtopologyId1", 1)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> emptyAssignment.standbyTasks().add(new StreamsRebalanceData.TaskId("subtopologyId1", 1)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> emptyAssignment.warmupTasks().add(new StreamsRebalanceData.TaskId("subtopologyId1", 1)));
    }

    @Test
    public void assignmentShouldNotBeModifiable() {
        StreamsRebalanceData.Assignment assignment = new StreamsRebalanceData.Assignment(new HashSet<StreamsRebalanceData.TaskId>(Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 1))), new HashSet<StreamsRebalanceData.TaskId>(Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 2))), new HashSet<StreamsRebalanceData.TaskId>(Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 3))));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> assignment.activeTasks().add(new StreamsRebalanceData.TaskId("subtopologyId2", 1)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> assignment.standbyTasks().add(new StreamsRebalanceData.TaskId("subtopologyId2", 2)));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> assignment.warmupTasks().add(new StreamsRebalanceData.TaskId("subtopologyId2", 3)));
    }

    @Test
    public void assignmentShouldNotAcceptNulls() {
        Exception exception1 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.Assignment(null, Set.of(), Set.of()));
        Assertions.assertEquals((Object)"Active tasks cannot be null", (Object)exception1.getMessage());
        Exception exception2 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.Assignment(Set.of(), null, Set.of()));
        Assertions.assertEquals((Object)"Standby tasks cannot be null", (Object)exception2.getMessage());
        Exception exception3 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.Assignment(Set.of(), Set.of(), null));
        Assertions.assertEquals((Object)"Warmup tasks cannot be null", (Object)exception3.getMessage());
    }

    @Test
    public void testAssignmentEqualsAndHashCode() {
        StreamsRebalanceData.TaskId additionalTask = new StreamsRebalanceData.TaskId("subtopologyId2", 1);
        StreamsRebalanceData.Assignment assignment = new StreamsRebalanceData.Assignment(Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 1)), Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 2)), Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 3)));
        StreamsRebalanceData.Assignment assignmentEqual = new StreamsRebalanceData.Assignment(assignment.activeTasks(), assignment.standbyTasks(), assignment.warmupTasks());
        HashSet<StreamsRebalanceData.TaskId> unequalActiveTasks = new HashSet<StreamsRebalanceData.TaskId>(assignment.activeTasks());
        unequalActiveTasks.add(additionalTask);
        StreamsRebalanceData.Assignment assignmentUnequalActiveTasks = new StreamsRebalanceData.Assignment(unequalActiveTasks, assignment.standbyTasks(), assignment.warmupTasks());
        HashSet<StreamsRebalanceData.TaskId> unequalStandbyTasks = new HashSet<StreamsRebalanceData.TaskId>(assignment.standbyTasks());
        unequalStandbyTasks.add(additionalTask);
        StreamsRebalanceData.Assignment assignmentUnequalStandbyTasks = new StreamsRebalanceData.Assignment(assignment.activeTasks(), unequalStandbyTasks, assignment.warmupTasks());
        HashSet<StreamsRebalanceData.TaskId> unequalWarmupTasks = new HashSet<StreamsRebalanceData.TaskId>(assignment.warmupTasks());
        unequalWarmupTasks.add(additionalTask);
        StreamsRebalanceData.Assignment assignmentUnequalWarmupTasks = new StreamsRebalanceData.Assignment(assignment.activeTasks(), assignment.standbyTasks(), unequalWarmupTasks);
        Assertions.assertEquals((Object)assignment, (Object)assignmentEqual);
        Assertions.assertNotEquals((Object)assignment, (Object)assignmentUnequalActiveTasks);
        Assertions.assertNotEquals((Object)assignment, (Object)assignmentUnequalStandbyTasks);
        Assertions.assertNotEquals((Object)assignment, (Object)assignmentUnequalWarmupTasks);
        Assertions.assertEquals((int)assignment.hashCode(), (int)assignmentEqual.hashCode());
        Assertions.assertNotEquals((int)assignment.hashCode(), (int)assignmentUnequalActiveTasks.hashCode());
        Assertions.assertNotEquals((int)assignment.hashCode(), (int)assignmentUnequalStandbyTasks.hashCode());
        Assertions.assertNotEquals((int)assignment.hashCode(), (int)assignmentUnequalWarmupTasks.hashCode());
    }

    @Test
    public void shouldCopyAssignment() {
        StreamsRebalanceData.Assignment assignment = new StreamsRebalanceData.Assignment(Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 1)), Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 2)), Set.of(new StreamsRebalanceData.TaskId("subtopologyId1", 3)));
        StreamsRebalanceData.Assignment copy = assignment.copy();
        Assertions.assertEquals((Object)assignment, (Object)copy);
        Assertions.assertNotSame((Object)assignment, (Object)copy);
    }

    @Test
    public void shouldCopyEmptyAssignment() {
        StreamsRebalanceData.Assignment emptyAssignment = StreamsRebalanceData.Assignment.EMPTY;
        StreamsRebalanceData.Assignment copy = emptyAssignment.copy();
        Assertions.assertEquals((Object)emptyAssignment, (Object)copy);
        Assertions.assertNotSame((Object)emptyAssignment, (Object)copy);
    }

    @Test
    public void subtopologyShouldNotAcceptNulls() {
        Exception exception1 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.Subtopology(null, Set.of(), Map.of(), Map.of(), List.of()));
        Assertions.assertEquals((Object)"Subtopology ID cannot be null", (Object)exception1.getMessage());
        Exception exception2 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.Subtopology(Set.of(), null, Map.of(), Map.of(), List.of()));
        Assertions.assertEquals((Object)"Repartition sink topics cannot be null", (Object)exception2.getMessage());
        Exception exception3 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.Subtopology(Set.of(), Set.of(), null, Map.of(), List.of()));
        Assertions.assertEquals((Object)"Repartition source topics cannot be null", (Object)exception3.getMessage());
        Exception exception4 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.Subtopology(Set.of(), Set.of(), Map.of(), null, List.of()));
        Assertions.assertEquals((Object)"State changelog topics cannot be null", (Object)exception4.getMessage());
        Exception exception5 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.Subtopology(Set.of(), Set.of(), Map.of(), Map.of(), null));
        Assertions.assertEquals((Object)"Co-partition groups cannot be null", (Object)exception5.getMessage());
    }

    @Test
    public void subtopologyShouldNotBeModifiable() {
        StreamsRebalanceData.Subtopology subtopology = new StreamsRebalanceData.Subtopology(new HashSet<String>(Set.of("sourceTopic1")), new HashSet<String>(Set.of("repartitionSinkTopic1")), Map.of("repartitionSourceTopic1", new StreamsRebalanceData.TopicInfo(Optional.of(1), Optional.of((short)1), Map.of())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), Map.of("stateChangelogTopic1", new StreamsRebalanceData.TopicInfo(Optional.of(0), Optional.of((short)1), Map.of())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), new ArrayList<Set<String>>(List.of(Set.of("sourceTopic1"))));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> subtopology.sourceTopics().add("sourceTopic2"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> subtopology.repartitionSinkTopics().add("repartitionSinkTopic2"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> subtopology.repartitionSourceTopics().put("repartitionSourceTopic2", new StreamsRebalanceData.TopicInfo(Optional.of(1), Optional.of((short)1), Map.of())));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> subtopology.stateChangelogTopics().put("stateChangelogTopic2", new StreamsRebalanceData.TopicInfo(Optional.of(0), Optional.of((short)1), Map.of())));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> subtopology.copartitionGroups().add(Set.of("sourceTopic2")));
    }

    @Test
    public void topicInfoShouldNotAcceptNulls() {
        Exception exception1 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.TopicInfo(null, Optional.of((short)1), Map.of()));
        Assertions.assertEquals((Object)"Number of partitions cannot be null", (Object)exception1.getMessage());
        Exception exception2 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.TopicInfo(Optional.of(1), null, Map.of()));
        Assertions.assertEquals((Object)"Replication factor cannot be null", (Object)exception2.getMessage());
        Exception exception3 = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData.TopicInfo(Optional.of(1), Optional.of((short)1), null));
        Assertions.assertEquals((Object)"Additional topic configs cannot be null", (Object)exception3.getMessage());
    }

    @Test
    public void streamsRebalanceDataShouldNotHaveModifiableSubtopologiesAndClientTags() {
        UUID processId = UUID.randomUUID();
        Optional<StreamsRebalanceData.HostInfo> endpoint = Optional.of(new StreamsRebalanceData.HostInfo("localhost", 9090));
        HashMap subtopologies = new HashMap();
        Map<String, String> clientTags = Map.of("clientTag1", "clientTagValue1");
        StreamsRebalanceData streamsRebalanceData = new StreamsRebalanceData(processId, endpoint, subtopologies, clientTags);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> streamsRebalanceData.subtopologies().put("subtopologyId2", new StreamsRebalanceData.Subtopology(Set.of(), Set.of(), Map.of(), Map.of(), List.of())));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> streamsRebalanceData.clientTags().put("clientTag1", "clientTagValue2"));
    }

    @Test
    public void streamsRebalanceDataShouldNotAcceptNullProcessId() {
        Optional<StreamsRebalanceData.HostInfo> endpoint = Optional.of(new StreamsRebalanceData.HostInfo("localhost", 9090));
        HashMap subtopologies = new HashMap();
        Map<String, String> clientTags = Map.of("clientTag1", "clientTagValue1");
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData(null, endpoint, subtopologies, clientTags));
        Assertions.assertEquals((Object)"Process ID cannot be null", (Object)exception.getMessage());
    }

    @Test
    public void streamsRebalanceDataShouldNotAcceptNullHostInfo() {
        UUID processId = UUID.randomUUID();
        HashMap subtopologies = new HashMap();
        Map<String, String> clientTags = Map.of("clientTag1", "clientTagValue1");
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData(processId, null, subtopologies, clientTags));
        Assertions.assertEquals((Object)"Endpoint cannot be null", (Object)exception.getMessage());
    }

    @Test
    public void streamsRebalanceDataShouldNotAcceptNullSubtopologies() {
        UUID processId = UUID.randomUUID();
        Optional<StreamsRebalanceData.HostInfo> endpoint = Optional.of(new StreamsRebalanceData.HostInfo("localhost", 9090));
        Map<String, String> clientTags = Map.of("clientTag1", "clientTagValue1");
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData(processId, endpoint, null, clientTags));
        Assertions.assertEquals((Object)"Subtopologies cannot be null", (Object)exception.getMessage());
    }

    @Test
    public void streamsRebalanceDataShouldNotAcceptNullClientTags() {
        UUID processId = UUID.randomUUID();
        Optional<StreamsRebalanceData.HostInfo> endpoint = Optional.of(new StreamsRebalanceData.HostInfo("localhost", 9090));
        HashMap subtopologies = new HashMap();
        Exception exception = (Exception)Assertions.assertThrows(NullPointerException.class, () -> new StreamsRebalanceData(processId, endpoint, subtopologies, null));
        Assertions.assertEquals((Object)"Client tags cannot be null", (Object)exception.getMessage());
    }

    @Test
    public void streamsRebalanceDataShouldBeConstructedWithEmptyAssignment() {
        UUID processId = UUID.randomUUID();
        Optional<StreamsRebalanceData.HostInfo> endpoint = Optional.of(new StreamsRebalanceData.HostInfo("localhost", 9090));
        HashMap subtopologies = new HashMap();
        Map<String, String> clientTags = Map.of("clientTag1", "clientTagValue1");
        StreamsRebalanceData streamsRebalanceData = new StreamsRebalanceData(processId, endpoint, subtopologies, clientTags);
        Assertions.assertEquals((Object)StreamsRebalanceData.Assignment.EMPTY, (Object)streamsRebalanceData.reconciledAssignment());
    }

    @Test
    public void streamsRebalanceDataShouldBeConstructedWithEmptyPartitionsByHost() {
        UUID processId = UUID.randomUUID();
        Optional<StreamsRebalanceData.HostInfo> endpoint = Optional.of(new StreamsRebalanceData.HostInfo("localhost", 9090));
        HashMap subtopologies = new HashMap();
        Map<String, String> clientTags = Map.of("clientTag1", "clientTagValue1");
        StreamsRebalanceData streamsRebalanceData = new StreamsRebalanceData(processId, endpoint, subtopologies, clientTags);
        Assertions.assertTrue((boolean)streamsRebalanceData.partitionsByHost().isEmpty());
    }

    @Test
    public void streamsRebalanceDataShouldBeConstructedWithShutDownRequestedSetFalse() {
        UUID processId = UUID.randomUUID();
        Optional<StreamsRebalanceData.HostInfo> endpoint = Optional.of(new StreamsRebalanceData.HostInfo("localhost", 9090));
        HashMap subtopologies = new HashMap();
        Map<String, String> clientTags = Map.of("clientTag1", "clientTagValue1");
        StreamsRebalanceData streamsRebalanceData = new StreamsRebalanceData(processId, endpoint, subtopologies, clientTags);
        Assertions.assertFalse((boolean)streamsRebalanceData.shutdownRequested());
    }

    @Test
    public void streamsRebalanceDataShouldBeConstructedWithEmptyStatuses() {
        UUID processId = UUID.randomUUID();
        Optional<StreamsRebalanceData.HostInfo> endpoint = Optional.of(new StreamsRebalanceData.HostInfo("localhost", 9090));
        Map subtopologies = Map.of();
        Map<String, String> clientTags = Map.of("clientTag1", "clientTagValue1");
        StreamsRebalanceData streamsRebalanceData = new StreamsRebalanceData(processId, endpoint, subtopologies, clientTags);
        Assertions.assertTrue((boolean)streamsRebalanceData.statuses().isEmpty());
    }
}

