/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.provider.EnvVarConfigProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class EnvVarConfigProviderTest {
    private EnvVarConfigProvider envVarConfigProvider = null;

    EnvVarConfigProviderTest() {
    }

    @BeforeEach
    public void setup() {
        Map<String, String> testEnvVars = Map.of("test_var1", "value1", "secret_var2", "value2", "new_var3", "value3", "not_so_secret_var4", "value4");
        this.envVarConfigProvider = new EnvVarConfigProvider(testEnvVars);
        this.envVarConfigProvider.configure(Collections.singletonMap("", ""));
    }

    @Test
    void testGetAllEnvVarsNotEmpty() {
        ConfigData properties = this.envVarConfigProvider.get("");
        Assertions.assertNotEquals((int)0, (int)properties.data().size());
    }

    @Test
    void testGetMultipleKeysAndCompare() {
        ConfigData properties = this.envVarConfigProvider.get("");
        Assertions.assertNotEquals((int)0, (int)properties.data().size());
        Assertions.assertEquals((Object)"value1", properties.data().get("test_var1"));
        Assertions.assertEquals((Object)"value2", properties.data().get("secret_var2"));
        Assertions.assertEquals((Object)"value3", properties.data().get("new_var3"));
        Assertions.assertEquals((Object)"value4", properties.data().get("not_so_secret_var4"));
    }

    @Test
    public void testGetOneKeyWithNullPath() {
        ConfigData config = this.envVarConfigProvider.get(null, Collections.singleton("secret_var2"));
        Map data = config.data();
        Assertions.assertEquals((int)1, (int)data.size());
        Assertions.assertEquals((Object)"value2", data.get("secret_var2"));
    }

    @Test
    public void testGetOneKeyWithEmptyPath() {
        ConfigData config = this.envVarConfigProvider.get("", Collections.singleton("test_var1"));
        Map data = config.data();
        Assertions.assertEquals((int)1, (int)data.size());
        Assertions.assertEquals((Object)"value1", data.get("test_var1"));
    }

    @Test
    void testGetEnvVarsByKeyList() {
        HashSet<String> keyList = new HashSet<String>(Arrays.asList("test_var1", "secret_var2"));
        Set keys = this.envVarConfigProvider.get(null, keyList).data().keySet();
        Assertions.assertEquals(keyList, keys);
    }

    @Test
    void testNotNullPathNonEmptyThrowsException() {
        Assertions.assertThrows(ConfigException.class, () -> this.envVarConfigProvider.get("test-path", Collections.singleton("test_var1")));
    }

    @Test
    void testRegExpEnvVarsSingleEntryKeyList() {
        Map<String, String> testConfigMap = Collections.singletonMap("allowlist.pattern", "secret_.*");
        this.envVarConfigProvider.configure(testConfigMap);
        Set<String> keyList = Collections.singleton("secret_var2");
        Set keys = this.envVarConfigProvider.get(null, Collections.singleton("secret_var2")).data().keySet();
        Assertions.assertEquals(keyList, keys);
    }

    @Test
    void testRegExpEnvVarsNoKeyList() {
        Map<String, String> testConfigMap = Collections.singletonMap("allowlist.pattern", "secret_.*");
        this.envVarConfigProvider.configure(testConfigMap);
        Set keys = this.envVarConfigProvider.get("").data().keySet();
        Assertions.assertEquals(Collections.singleton("secret_var2"), keys);
    }
}

