/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.kafka.common.network.SslTransportLayerTest;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SslTransportTls12Tls13Test {
    private static final int BUFFER_SIZE = 4096;
    private static final Time TIME = Time.SYSTEM;
    private NioEchoServer server;
    private Selector selector;
    private Map<String, Object> sslClientConfigs;
    private Map<String, Object> sslServerConfigs;

    @BeforeEach
    public void setup() throws Exception {
        CertStores serverCertStores = new CertStores(true, "server", "localhost");
        CertStores clientCertStores = new CertStores(false, "client", "localhost");
        this.sslServerConfigs = serverCertStores.getTrustingConfig(clientCertStores);
        this.sslClientConfigs = clientCertStores.getTrustingConfig(serverCertStores);
        LogContext logContext = new LogContext();
        SslChannelBuilder channelBuilder = new SslChannelBuilder(ConnectionMode.CLIENT, null, false, logContext, new ProxyProtocolEngineFactory(ProxyProtocol.NONE), null);
        channelBuilder.configure(this.sslClientConfigs);
        this.selector = new Selector(5000L, new Metrics(), TIME, "MetricGroup", (ChannelBuilder)channelBuilder, logContext);
    }

    @AfterEach
    public void teardown() throws Exception {
        if (this.selector != null) {
            this.selector.close();
        }
        if (this.server != null) {
            this.server.close();
        }
    }

    @Test
    public void testCiphersSuiteForTls12FailsForTls13() throws Exception {
        String cipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";
        this.sslServerConfigs.put("ssl.enabled.protocols", Collections.singletonList("TLSv1.3"));
        this.sslServerConfigs.put("ssl.cipher.suites", Collections.singletonList(cipherSuite));
        this.server = NetworkTestUtils.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), SecurityProtocol.SSL, new TestSecurityConfig(this.sslServerConfigs), null, TIME);
        this.sslClientConfigs.put("ssl.enabled.protocols", Collections.singletonList("TLSv1.3"));
        this.sslClientConfigs.put("ssl.cipher.suites", Collections.singletonList(cipherSuite));
        this.checkAuthenticationFailed();
    }

    @Test
    public void testCiphersSuiteFailForServerTls12ClientTls13() throws Exception {
        String tls12CipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";
        String tls13CipherSuite = "TLS_AES_128_GCM_SHA256";
        this.sslServerConfigs.put("ssl.protocol", "TLSv1.2");
        this.sslServerConfigs.put("ssl.enabled.protocols", Collections.singletonList("TLSv1.2"));
        this.sslServerConfigs.put("ssl.cipher.suites", Collections.singletonList(tls12CipherSuite));
        this.server = NetworkTestUtils.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), SecurityProtocol.SSL, new TestSecurityConfig(this.sslServerConfigs), null, TIME);
        this.sslClientConfigs.put("ssl.protocol", "TLSv1.3");
        this.sslClientConfigs.put("ssl.cipher.suites", Collections.singletonList(tls13CipherSuite));
        this.checkAuthenticationFailed();
    }

    @Test
    public void testCiphersSuiteForTls13() throws Exception {
        String cipherSuite = "TLS_AES_128_GCM_SHA256";
        this.sslServerConfigs.put("ssl.cipher.suites", Collections.singletonList(cipherSuite));
        this.server = NetworkTestUtils.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), SecurityProtocol.SSL, new TestSecurityConfig(this.sslServerConfigs), null, TIME);
        this.sslClientConfigs.put("ssl.cipher.suites", Collections.singletonList(cipherSuite));
        this.checkAuthenticationSucceed();
    }

    @Test
    public void testCiphersSuiteForTls12() throws Exception {
        String cipherSuite = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384";
        this.sslServerConfigs.put("ssl.enabled.protocols", Arrays.asList("TLSv1.2,TLSv1.3".split(",")));
        this.sslServerConfigs.put("ssl.cipher.suites", Collections.singletonList(cipherSuite));
        this.server = NetworkTestUtils.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), SecurityProtocol.SSL, new TestSecurityConfig(this.sslServerConfigs), null, TIME);
        this.sslClientConfigs.put("ssl.enabled.protocols", Arrays.asList("TLSv1.2,TLSv1.3".split(",")));
        this.sslClientConfigs.put("ssl.cipher.suites", Collections.singletonList(cipherSuite));
        this.checkAuthenticationSucceed();
    }

    private void checkAuthenticationFailed() throws IOException, InterruptedException {
        this.sslClientConfigs.put("ssl.enabled.protocols", Collections.singletonList("TLSv1.3"));
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect("0", addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, "0", ChannelState.State.AUTHENTICATION_FAILED);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    private void checkAuthenticationSucceed() throws IOException, InterruptedException {
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect("0", addr, 4096, 4096);
        NetworkTestUtils.waitForChannelReady(this.selector, "0");
        this.server.verifyAuthenticationMetrics(1, 0);
    }

    private void createSelector(Map<String, Object> sslClientConfigs) {
        SslTransportLayerTest.TestSslChannelBuilder channelBuilder = new SslTransportLayerTest.TestSslChannelBuilder(ConnectionMode.CLIENT);
        channelBuilder.configureBufferSizes(null, null, null);
        channelBuilder.configure(sslClientConfigs);
        if (this.selector != null) {
            this.selector.close();
        }
        this.selector = new Selector(500000L, new Metrics(), TIME, "MetricGroup", (ChannelBuilder)channelBuilder, new LogContext());
    }
}

