/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.handler.codec.http2.Http2Headers;
import java.util.Base64;
import java.util.Optional;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.network.netty.K2PStreamMetadata;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class K2PStreamMetadataTest {
    K2PStreamMetadataTest() {
    }

    @ParameterizedTest
    @ValueSource(strings={"test", "12345", "!@#$%^&*()"})
    void encodesStringToBase64Correctly(String input) {
        String encoded = K2PStreamMetadata.base64Encode((String)input).toString();
        Assertions.assertEquals((Object)Base64.getUrlEncoder().encodeToString(input.getBytes(K2PStreamMetadata.DEFAULT_CHARSET)), (Object)encoded);
    }

    @Test
    void encodesEmptyStringToBase64() {
        String encoded = K2PStreamMetadata.base64Encode((String)"").toString();
        Assertions.assertEquals((Object)"", (Object)encoded);
    }

    @Test
    void throwsExceptionWhenEncodingNullValue() {
        Assertions.assertThrows(NullPointerException.class, () -> K2PStreamMetadata.base64Encode(null));
    }

    @ParameterizedTest
    @ValueSource(strings={"dGVzdA==", "MTIzNDU=", "IUAjJCVeJiooKQ=="})
    void decodesValidBase64StringCorrectly(String encodedValue) {
        String decoded = K2PStreamMetadata.base64Decode((CharSequence)encodedValue);
        Assertions.assertEquals((Object)new String(Base64.getUrlDecoder().decode(encodedValue), K2PStreamMetadata.DEFAULT_CHARSET), (Object)decoded);
    }

    @Test
    void returnsNullWhenDecodingNullValue() {
        Assertions.assertNull((Object)K2PStreamMetadata.base64Decode(null));
    }

    @ParameterizedTest
    @ValueSource(strings={"test", "12345", "!@#$%^&*()"})
    void convertsCharSequenceToBytesCorrectly(String input) {
        byte[] result = K2PStreamMetadata.charSequenceToBytes((CharSequence)input);
        Assertions.assertArrayEquals((byte[])input.getBytes(K2PStreamMetadata.DEFAULT_CHARSET), (byte[])result);
    }

    @Test
    void throwsExceptionWhenCharSequenceIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> K2PStreamMetadata.charSequenceToBytes(null));
    }

    @Test
    void convertsEmptyCharSequenceToBytes() {
        byte[] result = K2PStreamMetadata.charSequenceToBytes((CharSequence)"");
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])result);
    }

    @Test
    void returnsNullWhenPrincipalIsNull() {
        Optional<KafkaPrincipalSerde> serde = Optional.of((KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class));
        Assertions.assertNull((Object)K2PStreamMetadata.base64EncodeKafkaPrincipal(null, serde));
    }

    @Test
    void returnsNullWhenSerdeIsEmpty() {
        KafkaPrincipal principal = new KafkaPrincipal("User", "test-user");
        Assertions.assertNull((Object)K2PStreamMetadata.base64EncodeKafkaPrincipal((KafkaPrincipal)principal, Optional.empty()));
    }

    @Test
    void encodesKafkaPrincipalToBase64Correctly() {
        KafkaPrincipal principal = new KafkaPrincipal("User", "test-user");
        KafkaPrincipalSerde serde = (KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class);
        Mockito.when((Object)serde.serialize(principal)).thenReturn((Object)"serialized-principal".getBytes(K2PStreamMetadata.DEFAULT_CHARSET));
        String encoded = K2PStreamMetadata.base64EncodeKafkaPrincipal((KafkaPrincipal)principal, Optional.of(serde));
        Assertions.assertEquals((Object)Base64.getUrlEncoder().encodeToString("serialized-principal".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)), (Object)encoded);
    }

    @Test
    void throwsSerializationExceptionWhenSerdeFails() {
        KafkaPrincipal principal = new KafkaPrincipal("User", "test-user");
        KafkaPrincipalSerde serde = (KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class);
        Mockito.when((Object)serde.serialize(principal)).thenThrow(new Throwable[]{new SerializationException("Serialization failed")});
        Assertions.assertThrows(SerializationException.class, () -> K2PStreamMetadata.base64EncodeKafkaPrincipal((KafkaPrincipal)principal, Optional.of(serde)));
    }

    @Test
    void returnsNullWhenPrincipalHeaderIsNull() {
        Optional<KafkaPrincipalSerde> serde = Optional.of((KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class));
        Assertions.assertNull((Object)K2PStreamMetadata.base64DecodeKafkaPrincipal(null, serde));
    }

    @Test
    void returnsNullWhenSerdeIsEmptyForDecoding() {
        String principalHeader = "dGVzdC1wcmluY2lwYWw=";
        Assertions.assertNull((Object)K2PStreamMetadata.base64DecodeKafkaPrincipal((CharSequence)principalHeader, Optional.empty()));
    }

    @Test
    void decodesKafkaPrincipalFromBase64Correctly() {
        String principalHeader = Base64.getUrlEncoder().encodeToString("serialized-principal".getBytes(K2PStreamMetadata.DEFAULT_CHARSET));
        KafkaPrincipal expectedPrincipal = new KafkaPrincipal("User", "test-user");
        KafkaPrincipalSerde serde = (KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class);
        Mockito.when((Object)serde.deserialize(Base64.getUrlDecoder().decode(principalHeader.toString().getBytes(K2PStreamMetadata.DEFAULT_CHARSET)))).thenReturn((Object)expectedPrincipal);
        KafkaPrincipal decodedPrincipal = K2PStreamMetadata.base64DecodeKafkaPrincipal((CharSequence)principalHeader, Optional.of(serde));
        Assertions.assertEquals((Object)expectedPrincipal, (Object)decodedPrincipal);
    }

    @Test
    void throwsSerializationExceptionWhenDeserializationFails() {
        String principalHeader = Base64.getUrlEncoder().encodeToString("invalid-data".getBytes(K2PStreamMetadata.DEFAULT_CHARSET));
        KafkaPrincipalSerde serde = (KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class);
        Mockito.when((Object)serde.deserialize(Base64.getUrlDecoder().decode(principalHeader.toString().getBytes(K2PStreamMetadata.DEFAULT_CHARSET)))).thenThrow(new Throwable[]{new SerializationException("Deserialization failed")});
        Assertions.assertThrows(SerializationException.class, () -> K2PStreamMetadata.base64DecodeKafkaPrincipal((CharSequence)principalHeader, Optional.of(serde)));
    }

    @Test
    void deserializesAllFieldsCorrectlyFromHttp2Headers() {
        Http2Headers headers = (Http2Headers)Mockito.mock(Http2Headers.class);
        KafkaPrincipal expectedPrincipal = new KafkaPrincipal("User", "test-user");
        KafkaPrincipalSerde serde = (KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-principal"))).thenReturn((Object)"serialized-principal");
        Mockito.when((Object)headers.getBoolean((Object)"x-k2p-client-authed", false)).thenReturn((Object)true);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-tenant"))).thenReturn((Object)"dGVuYW50LWlk");
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-client-addr"))).thenReturn((Object)"MTI3LjAuMC4x");
        Mockito.when((Object)headers.getInt((Object)"x-k2p-client-port")).thenReturn((Object)8080);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-client-software-name"))).thenReturn((Object)"Y2xpZW50LW5hbWU=");
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-client-software-version"))).thenReturn((Object)"MS4w");
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-client-id"))).thenReturn((Object)"Y2xpZW50LWlk");
        Mockito.when((Object)serde.deserialize(Base64.getUrlDecoder().decode("serialized-principal".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)))).thenReturn((Object)expectedPrincipal);
        K2PStreamMetadata k2PStreamMetadata = new K2PStreamMetadata(headers, Optional.of(serde));
        Assertions.assertEquals((Object)expectedPrincipal, (Object)k2PStreamMetadata.principal());
        Assertions.assertTrue((boolean)k2PStreamMetadata.clientAuthenticated());
        Assertions.assertEquals((Object)"tenant-id", (Object)k2PStreamMetadata.tenant());
        Assertions.assertEquals((Object)"127.0.0.1", (Object)k2PStreamMetadata.clientAddress());
        Assertions.assertEquals((int)8080, (Integer)k2PStreamMetadata.clientPort());
        Assertions.assertEquals((Object)"client-name", (Object)k2PStreamMetadata.clientInformation().softwareName());
        Assertions.assertEquals((Object)"1.0", (Object)k2PStreamMetadata.clientInformation().softwareVersion());
        Assertions.assertEquals((Object)"client-id", (Object)k2PStreamMetadata.clientId());
    }

    @Test
    void skipsNullFieldsWhenDeserializingFromHttp2Headers() {
        Http2Headers headers = (Http2Headers)Mockito.mock(Http2Headers.class);
        KafkaPrincipalSerde serde = (KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-principal"))).thenReturn(null);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-tenant"))).thenReturn(null);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-client-addr"))).thenReturn(null);
        Mockito.when((Object)headers.getInt((Object)"x-k2p-client-port")).thenReturn(null);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-client-software-name"))).thenReturn(null);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-client-software-version"))).thenReturn(null);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-client-id"))).thenReturn(null);
        K2PStreamMetadata k2PStreamMetadata = new K2PStreamMetadata(headers, Optional.of(serde));
        Assertions.assertNull((Object)k2PStreamMetadata.principal());
        Assertions.assertFalse((boolean)k2PStreamMetadata.clientAuthenticated());
        Assertions.assertNull((Object)k2PStreamMetadata.tenant());
        Assertions.assertNull((Object)k2PStreamMetadata.clientAddress());
        Assertions.assertNull((Object)k2PStreamMetadata.clientPort());
        Assertions.assertEquals((Object)"unknown", (Object)k2PStreamMetadata.clientInformation().softwareName());
        Assertions.assertEquals((Object)"unknown", (Object)k2PStreamMetadata.clientInformation().softwareVersion());
        Assertions.assertNull((Object)k2PStreamMetadata.clientId());
    }

    @Test
    void doesNotDeserializePrincipalWhenSerdeIsEmpty() {
        Http2Headers headers = (Http2Headers)Mockito.mock(Http2Headers.class);
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-principal"))).thenReturn((Object)"serialized-principal");
        Mockito.when((Object)((CharSequence)headers.get((Object)"x-k2p-tenant"))).thenReturn((Object)"dGVuYW50LWlk");
        K2PStreamMetadata k2PStreamMetadata = new K2PStreamMetadata(headers, Optional.empty());
        Assertions.assertNull((Object)k2PStreamMetadata.principal());
        Assertions.assertEquals((Object)"tenant-id", (Object)k2PStreamMetadata.tenant());
    }

    @Test
    void serializesAllFieldsCorrectlyToHttp2Headers() {
        Http2Headers headers = (Http2Headers)Mockito.mock(Http2Headers.class);
        KafkaPrincipalSerde serde = (KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class);
        KafkaPrincipal principal = (KafkaPrincipal)Mockito.mock(KafkaPrincipal.class);
        Mockito.when((Object)serde.serialize(principal)).thenReturn((Object)"serialized-principal".getBytes(K2PStreamMetadata.DEFAULT_CHARSET));
        K2PStreamMetadata k2PStreamMetadata = new K2PStreamMetadata(Optional.of(serde), principal, true, "tenant-id", "127.0.0.1", Integer.valueOf(8080), "client-name", "1.0", "client-id");
        k2PStreamMetadata.serialize(headers);
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-principal", (Object)Base64.getUrlEncoder().encodeToString("serialized-principal".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
        ((Http2Headers)Mockito.verify((Object)headers)).setBoolean((Object)"x-k2p-client-authed", true);
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-tenant", (Object)K2PStreamMetadata.base64Encode((String)"tenant-id"));
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-client-addr", (Object)Base64.getUrlEncoder().encodeToString("127.0.0.1".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
        ((Http2Headers)Mockito.verify((Object)headers)).setInt((Object)"x-k2p-client-port", 8080);
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-client-software-name", (Object)Base64.getUrlEncoder().encodeToString("client-name".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-client-software-version", (Object)Base64.getUrlEncoder().encodeToString("1.0".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-client-id", (Object)Base64.getUrlEncoder().encodeToString("client-id".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
    }

    @Test
    void skipsNullFieldsWhenSerializingToHttp2Headers() {
        Http2Headers headers = (Http2Headers)Mockito.mock(Http2Headers.class);
        KafkaPrincipalSerde serde = (KafkaPrincipalSerde)Mockito.mock(KafkaPrincipalSerde.class);
        KafkaPrincipal principal = (KafkaPrincipal)Mockito.mock(KafkaPrincipal.class);
        Mockito.when((Object)serde.serialize(principal)).thenReturn((Object)"serialized-principal".getBytes(K2PStreamMetadata.DEFAULT_CHARSET));
        K2PStreamMetadata k2PStreamMetadata = new K2PStreamMetadata(Optional.of(serde), principal, true, "tenant-id", null, null, null, null, null);
        k2PStreamMetadata.serialize(headers);
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-principal", (Object)Base64.getUrlEncoder().encodeToString("serialized-principal".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
        ((Http2Headers)Mockito.verify((Object)headers)).setBoolean((Object)"x-k2p-client-authed", true);
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-tenant", (Object)K2PStreamMetadata.base64Encode((String)"tenant-id"));
        ((Http2Headers)Mockito.verify((Object)headers, (VerificationMode)Mockito.never())).set((Object)((CharSequence)ArgumentMatchers.eq((Object)"x-k2p-client-addr")), (Object)((CharSequence)ArgumentMatchers.any()));
        ((Http2Headers)Mockito.verify((Object)headers, (VerificationMode)Mockito.never())).set((Object)((CharSequence)ArgumentMatchers.eq((Object)"x-k2p-client-port")), (Object)((CharSequence)ArgumentMatchers.any()));
        ((Http2Headers)Mockito.verify((Object)headers, (VerificationMode)Mockito.never())).set((Object)((CharSequence)ArgumentMatchers.eq((Object)"x-k2p-client-software-name")), (Object)((CharSequence)ArgumentMatchers.any()));
        ((Http2Headers)Mockito.verify((Object)headers, (VerificationMode)Mockito.never())).set((Object)((CharSequence)ArgumentMatchers.eq((Object)"x-k2p-client-software-version")), (Object)((CharSequence)ArgumentMatchers.any()));
        ((Http2Headers)Mockito.verify((Object)headers, (VerificationMode)Mockito.never())).set((Object)((CharSequence)ArgumentMatchers.eq((Object)"x-k2p-client-id")), (Object)((CharSequence)ArgumentMatchers.any()));
    }

    @Test
    void doesNotSerializePrincipalWhenSerdeIsEmpty() {
        Http2Headers headers = (Http2Headers)Mockito.mock(Http2Headers.class);
        K2PStreamMetadata k2PStreamMetadata = new K2PStreamMetadata(Optional.empty(), (KafkaPrincipal)Mockito.mock(KafkaPrincipal.class), true, "tenant-id", "127.0.0.1", Integer.valueOf(8080), "client-name", "1.0", "client-id");
        k2PStreamMetadata.serialize(headers);
        ((Http2Headers)Mockito.verify((Object)headers, (VerificationMode)Mockito.never())).set((Object)((CharSequence)ArgumentMatchers.eq((Object)"x-k2p-principal")), (Object)((CharSequence)ArgumentMatchers.any()));
        ((Http2Headers)Mockito.verify((Object)headers)).setBoolean((Object)"x-k2p-client-authed", true);
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-tenant", (Object)K2PStreamMetadata.base64Encode((String)"tenant-id"));
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-client-addr", (Object)Base64.getUrlEncoder().encodeToString("127.0.0.1".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
        ((Http2Headers)Mockito.verify((Object)headers)).setInt((Object)"x-k2p-client-port", 8080);
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-client-software-name", (Object)Base64.getUrlEncoder().encodeToString("client-name".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-client-software-version", (Object)Base64.getUrlEncoder().encodeToString("1.0".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
        ((Http2Headers)Mockito.verify((Object)headers)).set((Object)"x-k2p-client-id", (Object)Base64.getUrlEncoder().encodeToString("client-id".getBytes(K2PStreamMetadata.DEFAULT_CHARSET)));
    }
}

