/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.ReferenceCountUtil;
import java.util.function.BiFunction;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class NettyHttp2StreamHandlerTest {
    private EmbeddedChannel channel;
    private NettyStream mockNettyStream;
    private BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> mockStreamHandlerCreator;
    private NettyStream.StreamHandler mockStreamHandler;
    private NettyHttp2Stream.NettyHttp2StreamHandler nettyHttp2StreamHandler;

    NettyHttp2StreamHandlerTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockNettyStream = (NettyStream)Mockito.mock(NettyStream.class);
        this.mockStreamHandlerCreator = (BiFunction)Mockito.mock(BiFunction.class);
        this.mockStreamHandler = (NettyStream.StreamHandler)Mockito.mock(NettyStream.StreamHandler.class);
        this.nettyHttp2StreamHandler = new NettyHttp2Stream.NettyHttp2StreamHandler(this.mockNettyStream, this.mockStreamHandlerCreator, new LogContext());
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.nettyHttp2StreamHandler});
        Mockito.when((Object)this.mockStreamHandlerCreator.apply((NettyStream)ArgumentMatchers.eq((Object)this.mockNettyStream), (Http2Headers)ArgumentMatchers.any(Http2Headers.class))).thenReturn((Object)this.mockStreamHandler);
    }

    @AfterEach
    void tearDown() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
        }
    }

    @Test
    void testChannelReadHeadersFrameCreatesHandler() {
        Http2Headers mockHeaders = (Http2Headers)Mockito.mock(Http2Headers.class);
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame(mockHeaders);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{headersFrame}));
        ((BiFunction)Mockito.verify(this.mockStreamHandlerCreator)).apply(this.mockNettyStream, mockHeaders);
        Assertions.assertTrue((boolean)this.channel.isActive());
        Assertions.assertNotNull((Object)this.nettyHttp2StreamHandler.streamHandler());
        Assertions.assertTrue((boolean)this.channel.inboundMessages().isEmpty());
    }

    @Test
    void testChannelReadSubsequentHeadersFrameGetIgnore() {
        Http2Headers mockHeaders = (Http2Headers)Mockito.mock(Http2Headers.class);
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame(mockHeaders);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{headersFrame}));
        ((BiFunction)Mockito.verify(this.mockStreamHandlerCreator)).apply(this.mockNettyStream, mockHeaders);
        Assertions.assertTrue((boolean)this.channel.isActive());
        Assertions.assertNotNull((Object)this.nettyHttp2StreamHandler.streamHandler());
        Assertions.assertTrue((boolean)this.channel.inboundMessages().isEmpty());
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{headersFrame}));
        ((BiFunction)Mockito.verify(this.mockStreamHandlerCreator)).apply(this.mockNettyStream, mockHeaders);
        Assertions.assertTrue((boolean)this.channel.isActive());
        Assertions.assertNotNull((Object)this.nettyHttp2StreamHandler.streamHandler());
        Assertions.assertTrue((boolean)this.channel.inboundMessages().isEmpty());
    }

    @Test
    void testChannelReadHeadersFrameFactoryThrows() {
        Http2Headers mockHeaders = (Http2Headers)Mockito.mock(Http2Headers.class);
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame(mockHeaders);
        RuntimeException creationException = new RuntimeException("Failed to create handler");
        Mockito.when((Object)this.mockStreamHandlerCreator.apply((NettyStream)ArgumentMatchers.eq((Object)this.mockNettyStream), (Http2Headers)ArgumentMatchers.any(Http2Headers.class))).thenThrow(new Throwable[]{creationException});
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{headersFrame}));
        ((BiFunction)Mockito.verify(this.mockStreamHandlerCreator)).apply(this.mockNettyStream, mockHeaders);
        Assertions.assertFalse((boolean)this.channel.isActive());
        Assertions.assertNull((Object)this.nettyHttp2StreamHandler.streamHandler());
        Assertions.assertTrue((boolean)this.channel.inboundMessages().isEmpty());
    }

    @Test
    void testChannelReadDataFrameBeforeHeaders() {
        ByteBuf data = Unpooled.buffer().writeBytes("data".getBytes());
        DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(data);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{dataFrame}));
        ((BiFunction)Mockito.verify(this.mockStreamHandlerCreator, (VerificationMode)Mockito.never())).apply((NettyStream)ArgumentMatchers.any(), (Http2Headers)ArgumentMatchers.any());
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler, (VerificationMode)Mockito.never())).handleData((ByteBuf)ArgumentMatchers.any());
        Assertions.assertFalse((boolean)this.channel.isActive());
        Assertions.assertEquals((int)0, (int)dataFrame.refCnt());
        Assertions.assertNull((Object)this.nettyHttp2StreamHandler.streamHandler());
        Assertions.assertTrue((boolean)this.channel.inboundMessages().isEmpty());
    }

    @Test
    void testChannelReadDataFrameAfterHeaders() {
        Http2Headers mockHeaders = (Http2Headers)Mockito.mock(Http2Headers.class);
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame(mockHeaders);
        this.channel.writeInbound(new Object[]{headersFrame});
        ((BiFunction)Mockito.verify(this.mockStreamHandlerCreator)).apply(this.mockNettyStream, mockHeaders);
        ByteBuf data = Unpooled.buffer().writeBytes("data".getBytes());
        DefaultHttp2DataFrame dataFrame = new DefaultHttp2DataFrame(data);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{dataFrame}));
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler)).handleData(data);
        Assertions.assertEquals((int)0, (int)data.refCnt());
        Assertions.assertTrue((boolean)this.channel.isActive());
        Assertions.assertNotNull((Object)this.nettyHttp2StreamHandler.streamHandler());
        Assertions.assertTrue((boolean)this.channel.inboundMessages().isEmpty());
        ReferenceCountUtil.safeRelease((Object)dataFrame);
    }

    @Test
    void testChannelReadUnsupportedData() {
        Object unsupportedMsg = new Object();
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{unsupportedMsg}));
        Assertions.assertFalse((boolean)this.channel.inboundMessages().isEmpty());
        ((BiFunction)Mockito.verify(this.mockStreamHandlerCreator, (VerificationMode)Mockito.never())).apply((NettyStream)ArgumentMatchers.any(), (Http2Headers)ArgumentMatchers.any());
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler, (VerificationMode)Mockito.never())).handleData((ByteBuf)ArgumentMatchers.any());
        Assertions.assertTrue((boolean)this.channel.isActive());
        Assertions.assertNull((Object)this.nettyHttp2StreamHandler.streamHandler());
    }

    @Test
    void testChannelWritabilityChangedBeforeHandler() throws Exception {
        ChannelHandlerContext mockCtx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)mockCtx.channel()).thenReturn((Object)this.channel);
        try {
            this.nettyHttp2StreamHandler.channelWritabilityChanged(mockCtx);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)this.channel.isActive());
        Assertions.assertNull((Object)this.nettyHttp2StreamHandler.streamHandler());
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler, (VerificationMode)Mockito.never())).handleReadyForSend();
        ((NettyStream)Mockito.verify((Object)this.mockNettyStream, (VerificationMode)Mockito.never())).flush();
    }

    @Test
    void testChannelWritabilityChangedWritable() throws Exception {
        this.channel.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)Mockito.mock(Http2Headers.class))});
        this.channel.pipeline().fireChannelWritabilityChanged();
        Assertions.assertTrue((boolean)this.channel.isActive());
        Assertions.assertNotNull((Object)this.nettyHttp2StreamHandler.streamHandler());
        Assertions.assertTrue((boolean)this.channel.isWritable());
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler)).handleReadyForSend();
        ((NettyStream)Mockito.verify((Object)this.mockNettyStream, (VerificationMode)Mockito.never())).flush();
    }

    @Test
    void testExceptionCaughtWithHandler() {
        this.channel.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)Mockito.mock(Http2Headers.class))});
        RuntimeException testException = new RuntimeException("Test Error");
        this.channel.pipeline().fireExceptionCaught((Throwable)testException);
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler)).handleException((Throwable)testException);
        Assertions.assertTrue((boolean)this.channel.isActive());
        Assertions.assertNotNull((Object)this.nettyHttp2StreamHandler.streamHandler());
    }

    @Test
    void testExceptionCaughtWithoutHandler() {
        RuntimeException testException = new RuntimeException("Test Error");
        this.channel.pipeline().fireExceptionCaught((Throwable)testException);
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler, (VerificationMode)Mockito.never())).handleException((Throwable)ArgumentMatchers.any());
        Assertions.assertFalse((boolean)this.channel.isActive());
        Assertions.assertNull((Object)this.nettyHttp2StreamHandler.streamHandler());
    }

    @Test
    void testCloseWithHandler() throws Exception {
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{new DefaultHttp2HeadersFrame((Http2Headers)Mockito.mock(Http2Headers.class))}));
        this.channel.close().get();
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler)).handleClose();
        Assertions.assertFalse((boolean)this.channel.isActive());
        Assertions.assertNotNull((Object)this.nettyHttp2StreamHandler.streamHandler());
    }

    @Test
    void testCloseWithoutHandler() {
        this.channel.close();
        ((NettyStream.StreamHandler)Mockito.verify((Object)this.mockStreamHandler, (VerificationMode)Mockito.never())).handleClose();
        Assertions.assertFalse((boolean)this.channel.isActive());
        Assertions.assertNull((Object)this.nettyHttp2StreamHandler.streamHandler());
    }
}

