/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.EventLoop;
import org.apache.kafka.common.network.netty.AbstractStreamHandler;
import org.apache.kafka.common.network.netty.NettyRawBytesStream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class NettyRawBytesStreamTest {
    private final LogContext logContext = new LogContext();

    @Test
    public void testSetAbstractStreamHandlerSetStreamHandlerUpdatesValues() {
        Channel mockChannel = NettyRawBytesStreamTest.mockChannelWithConfig();
        EventLoop mockEventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)mockChannel.eventLoop()).thenReturn((Object)mockEventLoop);
        Mockito.when((Object)mockEventLoop.inEventLoop()).thenReturn((Object)true);
        NettyRawBytesStream nettyStream = new NettyRawBytesStream(mockChannel, new LogContext());
        TestAbstractStreamHandler abstractStreamHandler = new TestAbstractStreamHandler(this.logContext);
        nettyStream.setAbstractStreamHandler((AbstractStreamHandler)abstractStreamHandler);
        Assertions.assertNull((Object)nettyStream.pipelineStreamHandler.streamHandler());
        Assertions.assertEquals((Object)((Object)abstractStreamHandler), (Object)nettyStream.pipelineStreamHandler);
        NettyStream.StreamHandler mockStreamHandler = (NettyStream.StreamHandler)Mockito.mock(NettyStream.StreamHandler.class);
        nettyStream.setStreamHandler(mockStreamHandler);
        Assertions.assertEquals((Object)mockStreamHandler, (Object)nettyStream.pipelineStreamHandler.streamHandler());
        Assertions.assertEquals((Object)mockStreamHandler, (Object)nettyStream.getStreamHandler());
    }

    @Test
    public void testSetAbstractStreamHandlerInWrongEventLoopThrows() {
        Channel mockChannel = NettyRawBytesStreamTest.mockChannelWithConfig();
        EventLoop mockEventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        ChannelId mockChannelId = (ChannelId)Mockito.mock(ChannelId.class);
        Mockito.when((Object)mockChannel.eventLoop()).thenReturn((Object)mockEventLoop);
        Mockito.when((Object)mockEventLoop.inEventLoop()).thenReturn((Object)false);
        Mockito.when((Object)mockChannel.id()).thenReturn((Object)mockChannelId);
        Mockito.when((Object)mockChannelId.asLongText()).thenReturn((Object)"string-id-123");
        NettyStream.StreamHandler mockStreamHandler = (NettyStream.StreamHandler)Mockito.mock(NettyStream.StreamHandler.class);
        NettyRawBytesStream nettyStream = new NettyRawBytesStream(mockChannel, new LogContext());
        Assertions.assertThrows(IllegalStateException.class, () -> nettyStream.setStreamHandler(mockStreamHandler));
        TestAbstractStreamHandler abstractStreamHandler = new TestAbstractStreamHandler(this.logContext);
        Assertions.assertThrows(IllegalStateException.class, () -> nettyStream.setAbstractStreamHandler(abstractStreamHandler));
        Assertions.assertNull((Object)abstractStreamHandler.streamHandler());
        Assertions.assertNull((Object)nettyStream.pipelineStreamHandler);
    }

    @Test
    public void channelRead0ThrowsIfHandleDataFails() {
        NettyRawBytesStream nettyStream = new NettyRawBytesStream(NettyRawBytesStreamTest.mockChannelWithConfig(), this.logContext);
        NettyStream.StreamHandler mockStreamHandler = (NettyStream.StreamHandler)Mockito.mock(NettyStream.StreamHandler.class);
        ChannelHandlerContext mockChannelHandlerContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        ByteBuf mockByteBuf = (ByteBuf)Mockito.mock(ByteBuf.class);
        ((NettyStream.StreamHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("splat")}).when((Object)mockStreamHandler)).handleData(mockByteBuf);
        NettyRawBytesStream.NettyRawBytesStreamHandler abstractStreamHandler = new NettyRawBytesStream.NettyRawBytesStreamHandler((NettyStream)nettyStream, mockStreamHandler, this.logContext);
        Assertions.assertThrows(RuntimeException.class, () -> abstractStreamHandler.channelRead0(mockChannelHandlerContext, mockByteBuf));
    }

    @Test
    public void channelRead0CallsStreamHandler() {
        NettyRawBytesStream nettyStream = new NettyRawBytesStream(NettyRawBytesStreamTest.mockChannelWithConfig(), this.logContext);
        NettyStream.StreamHandler mockStreamHandler = (NettyStream.StreamHandler)Mockito.mock(NettyStream.StreamHandler.class);
        ChannelHandlerContext mockChannelHandlerContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        ByteBuf mockByteBuf = (ByteBuf)Mockito.mock(ByteBuf.class);
        NettyRawBytesStream.NettyRawBytesStreamHandler abstractStreamHandler = new NettyRawBytesStream.NettyRawBytesStreamHandler((NettyStream)nettyStream, mockStreamHandler, this.logContext);
        abstractStreamHandler.channelRead0(mockChannelHandlerContext, mockByteBuf);
        ((NettyStream.StreamHandler)Mockito.verify((Object)mockStreamHandler)).handleData(mockByteBuf);
    }

    private static Channel mockChannelWithConfig() {
        Channel mockChannel = (Channel)Mockito.mock(Channel.class);
        ChannelConfig mockChannelConfig = (ChannelConfig)Mockito.mock(ChannelConfig.class);
        Mockito.when((Object)mockChannel.config()).thenReturn((Object)mockChannelConfig);
        return mockChannel;
    }

    private static class TestAbstractStreamHandler
    extends AbstractStreamHandler<ByteBuf> {
        public TestAbstractStreamHandler(LogContext logContext) {
            super(null, null, logContext);
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        }
    }
}

