/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.netty.NettyServer;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class NettyServerBuilderTest {
    NettyServerBuilderTest() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void buildCreatesServerBootstrapWithCorrectOptions(boolean flowControlEnabled) {
        NettyServer.Builder builder = new NettyServer.Builder((LogContext)Mockito.mock(LogContext.class), ListenerName.normalised((String)"http2").value(), NettyServer.NettyServerProtocol.HTTP2, (SslContext)Mockito.mock(SslContext.class), (nettyStream, entries) -> null, true).withBossThreads(2).withWorkerThreads(8).withHttp2Settings((Http2Settings)Mockito.mock(Http2Settings.class)).withFlowControlEnabled(flowControlEnabled).withOption(ChannelOption.SO_BACKLOG, (Object)128).withChildOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        NettyServer nettyServer = builder.build();
        Assertions.assertNotNull((Object)nettyServer);
        Assertions.assertNotNull((Object)nettyServer.bossGroup());
        Assertions.assertNotNull((Object)nettyServer.workerGroup());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void buildCreatesUdsServerBootstrapWithCorrectOptions(boolean flowControlEnabled) {
        NettyServer.Builder builder = new NettyServer.Builder((LogContext)Mockito.mock(LogContext.class), ListenerName.normalised((String)"k2proxy").value(), NettyServer.NettyServerProtocol.HTTP2, (SslContext)Mockito.mock(SslContext.class), (nettyStream, entries) -> null, true).withBossThreads(2).withWorkerThreads(8).withHttp2Settings((Http2Settings)Mockito.mock(Http2Settings.class)).withFlowControlEnabled(flowControlEnabled).withOption(ChannelOption.SO_BACKLOG, (Object)128).withChildOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        NettyServer nettyServer = builder.build(true);
        Assertions.assertNotNull((Object)nettyServer);
        Assertions.assertNotNull((Object)nettyServer.bossGroup());
        Assertions.assertNotNull((Object)nettyServer.workerGroup());
    }

    @Test
    void buildCreatesServerBootstrapWithConflictOption() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new NettyServer.Builder((LogContext)Mockito.mock(LogContext.class), ListenerName.normalised((String)"http2").value(), NettyServer.NettyServerProtocol.HTTP2, (SslContext)Mockito.mock(SslContext.class), (nettyStream, entries) -> null, true).withBossThreads(2).withWorkerThreads(8).withHttp2Settings((Http2Settings)Mockito.mock(Http2Settings.class)).withWorkerGroup((EventLoopGroup)new NioEventLoopGroup()).withOption(ChannelOption.SO_BACKLOG, (Object)128).withChildOption(ChannelOption.SO_KEEPALIVE, (Object)true).build());
    }

    @Test
    void buildCreatesServerBootstrapWithoutWorkerGroupSet() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new NettyServer.Builder((LogContext)Mockito.mock(LogContext.class), ListenerName.normalised((String)"http2").value(), NettyServer.NettyServerProtocol.HTTP2, (SslContext)Mockito.mock(SslContext.class), (nettyStream, entries) -> null, true).withBossThreads(2).withHttp2Settings((Http2Settings)Mockito.mock(Http2Settings.class)).withOption(ChannelOption.SO_BACKLOG, (Object)128).withChildOption(ChannelOption.SO_KEEPALIVE, (Object)true).build());
    }
}

