/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.netty.NettyClient;
import org.apache.kafka.common.network.netty.NettyHttp2Connection;
import org.apache.kafka.common.network.netty.NettyHttp2EchoServer;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyServer;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.TestNettyStreamHandler;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;

class NettyServerTest {
    NettyServerTest() {
    }

    @Test
    void startCompletesSuccessfullyWhenPortIsBound() throws Exception {
        ServerBootstrap mockBootstrap = (ServerBootstrap)Mockito.mock(ServerBootstrap.class);
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Channel mockChannel = (Channel)Mockito.mock(Channel.class);
        Mockito.when((Object)mockChannel.localAddress()).thenReturn((Object)new InetSocketAddress(9092));
        ChannelFuture mockChannelFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        Mockito.when((Object)mockBootstrap.bind((SocketAddress)Mockito.any(SocketAddress.class))).thenReturn((Object)mockChannelFuture);
        ((ChannelFuture)Mockito.doAnswer(invocation -> {
            GenericFutureListener listener = (GenericFutureListener)invocation.getArgument(0);
            Mockito.when((Object)mockChannelFuture.isSuccess()).thenReturn((Object)true);
            Mockito.when((Object)mockChannelFuture.channel()).thenReturn((Object)mockChannel);
            listener.operationComplete((Future)mockChannelFuture);
            return null;
        }).when((Object)mockChannelFuture)).addListener((GenericFutureListener)Mockito.any());
        NettyServer serverBootstrap = new NettyServer(mockLogger, mockBootstrap, (ChannelGroup)Mockito.mock(DefaultChannelGroup.class));
        CompletableFuture result = serverBootstrap.start(0);
        Assertions.assertTrue(((Integer)result.get() > 0 ? 1 : 0) != 0, (String)"Bound port must be greater than 0");
        ((Logger)Mockito.verify((Object)mockLogger)).info((String)ArgumentMatchers.eq((Object)"Server started on address {}"), Mockito.any(SocketAddress.class));
    }

    @Test
    void startCompletesExceptionallyWhenBindingFails() {
        ServerBootstrap mockBootstrap = (ServerBootstrap)Mockito.mock(ServerBootstrap.class);
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        ChannelFuture mockChannelFuture = (ChannelFuture)Mockito.mock(ChannelFuture.class);
        RuntimeException cause = new RuntimeException("Bind failed");
        Mockito.when((Object)mockBootstrap.bind((SocketAddress)Mockito.any(SocketAddress.class))).thenReturn((Object)mockChannelFuture);
        ((ChannelFuture)Mockito.doAnswer(invocation -> {
            GenericFutureListener listener = (GenericFutureListener)invocation.getArgument(0);
            Mockito.when((Object)mockChannelFuture.isSuccess()).thenReturn((Object)false);
            Mockito.when((Object)mockChannelFuture.cause()).thenReturn((Object)cause);
            listener.operationComplete((Future)mockChannelFuture);
            return null;
        }).when((Object)mockChannelFuture)).addListener((GenericFutureListener)Mockito.any());
        NettyServer serverBootstrap = new NettyServer(mockLogger, mockBootstrap, (ChannelGroup)Mockito.mock(DefaultChannelGroup.class));
        CompletableFuture result = serverBootstrap.start(0);
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, result::get);
        Assertions.assertEquals((Object)cause, (Object)exception.getCause());
        ((Logger)Mockito.verify((Object)mockLogger)).error((String)ArgumentMatchers.eq((Object)"Failed to start server on address {}"), Mockito.any(SocketAddress.class), ArgumentMatchers.eq((Object)cause));
    }

    @Test
    void startCompletesExceptionallyWhenUnexpectedExceptionOccurs() {
        ServerBootstrap mockBootstrap = (ServerBootstrap)Mockito.mock(ServerBootstrap.class);
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        RuntimeException unexpectedException = new RuntimeException("Unexpected error");
        Mockito.when((Object)mockBootstrap.bind((SocketAddress)Mockito.any(SocketAddress.class))).thenThrow(new Throwable[]{unexpectedException});
        NettyServer serverBootstrap = new NettyServer(mockLogger, mockBootstrap, (ChannelGroup)Mockito.mock(DefaultChannelGroup.class));
        CompletableFuture result = serverBootstrap.start(0);
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, result::get);
        Assertions.assertEquals((Object)unexpectedException, (Object)exception.getCause());
        ((Logger)Mockito.verify((Object)mockLogger)).error((String)ArgumentMatchers.eq((Object)"Failed to start server on address {}"), Mockito.any(SocketAddress.class), ArgumentMatchers.eq((Object)unexpectedException));
    }

    @Test
    void testBuilderStartCompletesSuccessfullyWhenPortIsBound() throws Exception {
        LogContext mockLogContext = (LogContext)Mockito.mock(LogContext.class);
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogContext.logger((Class)Mockito.any(Class.class))).thenReturn((Object)mockLogger);
        NettyServer nettyServer = new NettyServer.Builder(mockLogContext, ListenerName.normalised((String)"http2").value(), NettyServer.NettyServerProtocol.HTTP2, (SslContext)Mockito.mock(SslContext.class), (nettyStream, entries) -> null, true).withWorkerThreads(1).withHttp2Settings((Http2Settings)Mockito.mock(Http2Settings.class)).build();
        CompletableFuture result = nettyServer.start(0);
        Assertions.assertTrue(((Integer)result.get() > 0 ? 1 : 0) != 0, (String)"Bound port must be greater than 0");
        ((Logger)Mockito.verify((Object)mockLogger)).info((String)ArgumentMatchers.eq((Object)"Server started on address {}"), Mockito.any(SocketAddress.class));
        nettyServer.shutdown().join();
        nettyServer.shutdown().join();
    }

    @Test
    void testBuilderStartCompletesExceptionallyWhenBindingFails() {
        LogContext mockLogContext = (LogContext)Mockito.mock(LogContext.class);
        Logger mockLogger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)mockLogContext.logger((Class)Mockito.any(Class.class))).thenReturn((Object)mockLogger);
        NettyServer nettyServer = new NettyServer.Builder(mockLogContext, ListenerName.normalised((String)"k2proxy").value(), NettyServer.NettyServerProtocol.HTTP2, (SslContext)Mockito.mock(SslContext.class), (nettyStream, entries) -> null, true).withWorkerThreads(1).withHttp2Settings((Http2Settings)Mockito.mock(Http2Settings.class)).build();
        CompletableFuture result = nettyServer.start(-1);
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, result::get);
        Assertions.assertEquals((Object)"port out of range:-1", (Object)exception.getCause().getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testShutdownStopAcceptingConnection() throws Exception {
        NettyHttp2EchoServer server = new NettyHttp2EchoServer();
        server.start(false);
        EventLoopGroup eventLoopGroup = Utils.createEventLoopGroup((int)4, (String)"test");
        NettyClient client = new NettyClient(null, eventLoopGroup, new LogContext("NettyServerTest"));
        CountDownLatch dataReceivedLatch = new CountDownLatch(1);
        NettyHttp2Stream stream = null;
        try (TestNettyStreamHandler handler = new TestNettyStreamHandler(dataReceivedLatch);){
            NettyHttp2Connection connection = (NettyHttp2Connection)client.createConnection(server.address(), Integer.valueOf(0x100000), Integer.valueOf(0x100000)).get();
            stream = (NettyHttp2Stream)connection.createStream((Http2Headers)new DefaultHttp2Headers(), (NettyStream.StreamHandler)handler).get();
            byte[] message = "Hello, World!".getBytes();
            ByteBuf dataSent = Unpooled.wrappedBuffer((byte[])message);
            stream.send(dataSent, true).sync().get();
            boolean fetchedData = dataReceivedLatch.await(5L, TimeUnit.MINUTES);
            if (!fetchedData) {
                Assertions.fail((String)"Failed to receive data");
            }
            ByteBuf receivedData = handler.receivedData();
            Assertions.assertArrayEquals((byte[])message, (byte[])ByteBufUtil.getBytes((ByteBuf)receivedData));
            server.beginStop();
            Assertions.assertThrows(ExecutionException.class, () -> client.createConnection(server.address(), Integer.valueOf(0x100000), Integer.valueOf(0x100000)).get(), (String)"Client should not be able to create new connection after server shutdown");
        }
        finally {
            eventLoopGroup.shutdownGracefully();
            if (stream != null) {
                stream.closeStream().get();
            }
        }
        server.stop();
        client.shutdown().join();
    }
}

