/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.NettyStreamChannel;
import org.apache.kafka.common.utils.LogContext;

class TestNettyStream
extends NettyStreamChannel
implements NettyStream {
    private static final AtomicInteger STREAM_ID_GENERATOR = new AtomicInteger(1);
    private final String streamId;
    private final NettyStream.StreamHandler handler;
    private final int maxInflightBytes;
    private final Queue<ByteBuf> pendingWrites = new ArrayDeque<ByteBuf>();
    private final List<ByteBuf> peerReceives = new ArrayList<ByteBuf>();
    private int inFlightSendBytes = 0;
    private int flushCount = 0;

    TestNettyStream(int maxInflightBytes, NettyStream.StreamHandler handler, LogContext logContext) {
        super(logContext);
        this.streamId = String.valueOf(STREAM_ID_GENERATOR.getAndAdd(2));
        this.handler = handler;
        this.maxInflightBytes = maxInflightBytes;
    }

    TestNettyStream(int maxInflightBytes, NettyStream.StreamHandler handler, LogContext logContext, int fileTransferChunkSize, int byteBufferTransferChunkSize) {
        super(logContext, fileTransferChunkSize, byteBufferTransferChunkSize);
        this.streamId = String.valueOf(STREAM_ID_GENERATOR.getAndAdd(2));
        this.handler = handler;
        this.maxInflightBytes = maxInflightBytes;
    }

    public void peerSend(ByteBuf data) {
        this.handler.handleData(data);
    }

    public void peerClose() {
        this.handler.handleClose();
    }

    public ByteBuf peerReceived() {
        ByteBuf result = this.pendingWrites.poll();
        if (result != null) {
            boolean notify;
            this.peerReceives.add(result);
            boolean wasReadyForSending = this.isReadyForSending();
            this.inFlightSendBytes -= result.readableBytes();
            boolean bl = notify = !wasReadyForSending && this.isReadyForSending();
            if (notify) {
                this.handler.handleReadyForSend();
            }
        }
        return result;
    }

    public void peerReceivedAllPendingWrites() {
        while (!this.pendingWrites.isEmpty()) {
            this.peerReceived();
        }
    }

    int flushCount() {
        return this.flushCount;
    }

    List<ByteBuf> peerReceives() {
        return this.peerReceives;
    }

    List<ByteBuf> pendingWrites() {
        return new ArrayList<ByteBuf>(this.pendingWrites);
    }

    public String streamId() {
        return this.streamId;
    }

    public Future<Void> send(ByteBuf data, boolean flush) {
        this.inFlightSendBytes += data.readableBytes();
        this.pendingWrites.add(data);
        if (flush) {
            this.flush();
        }
        return ImmediateEventExecutor.INSTANCE.newSucceededFuture(null);
    }

    public void flush() {
        ++this.flushCount;
    }

    public void receiveMore() {
    }

    public boolean isReadyForSending() {
        return this.inFlightSendBytes <= this.maxInflightBytes;
    }

    public ByteBufAllocator alloc() {
        return ByteBufAllocator.DEFAULT;
    }

    public Future<Void> closeStream() {
        for (ByteBuf buf : this.pendingWrites) {
            buf.release();
        }
        this.pendingWrites.clear();
        for (ByteBuf buf : this.peerReceives) {
            buf.release();
        }
        this.peerReceives.clear();
        return ImmediateEventExecutor.INSTANCE.newSucceededFuture(null);
    }

    public boolean isOpen() {
        return true;
    }

    public SocketAddress remoteAddress() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public SocketAddress localAddress() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NettyStream.Priority priority() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setPriority(NettyStream.Priority priority) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void runOnEventLoop(Runnable op, boolean forceReschedule) {
        op.run();
    }

    public boolean inEventLoop() {
        return true;
    }

    public ScheduledFuture<?> scheduleWithDelayOnEventLoop(Runnable op, long delay, TimeUnit unit) {
        return ImmediateEventExecutor.INSTANCE.schedule(op, delay, unit);
    }

    public TransferableChannel transferableChannel() {
        return this;
    }

    public void setStreamHandler(NettyStream.StreamHandler handler) {
    }

    public NettyStream.StreamHandler getStreamHandler() {
        return null;
    }

    protected NettyStream nettyStream() {
        return this;
    }
}

