/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.common.security.oauthbearer.internals.secured.UnretryableException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class HttpJwtRetrieverTest
extends OAuthBearerTest {
    @Test
    public void test() throws IOException {
        String expectedResponse = "Hiya, buddy";
        HttpURLConnection mockedCon = this.createHttpURLConnection(expectedResponse);
        String response = HttpJwtRetriever.post((HttpURLConnection)mockedCon, null, null, null, null);
        Assertions.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testEmptyResponse() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("");
        Assertions.assertThrows(IOException.class, () -> HttpJwtRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
    }

    @Test
    public void testErrorReadingResponse() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Assertions.assertThrows(IOException.class, () -> HttpJwtRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
    }

    @Test
    public void testErrorResponseUnretryableCode() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("{\"error\":\"some_arg\", \"error_description\":\"some problem with arg\"}".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)mockedCon.getResponseCode()).thenReturn((Object)400);
        UnretryableException ioe = (UnretryableException)Assertions.assertThrows(UnretryableException.class, () -> HttpJwtRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{\"some_arg\" - \"some problem with arg\"}"));
    }

    @Test
    public void testErrorResponseRetryableCode() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("{\"error\":\"some_arg\", \"error_description\":\"some problem with arg\"}".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)mockedCon.getResponseCode()).thenReturn((Object)500);
        IOException ioe = (IOException)Assertions.assertThrows(IOException.class, () -> HttpJwtRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{\"some_arg\" - \"some problem with arg\"}"));
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("{\"errorCode\":\"some_arg\", \"errorSummary\":\"some problem with arg\"}".getBytes(StandardCharsets.UTF_8)));
        ioe = (IOException)Assertions.assertThrows(IOException.class, () -> HttpJwtRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{\"some_arg\" - \"some problem with arg\"}"));
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("{\"err\":\"some_arg\", \"err_des\":\"some problem with arg\"}".getBytes(StandardCharsets.UTF_8)));
        ioe = (IOException)Assertions.assertThrows(IOException.class, () -> HttpJwtRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{\"err\":\"some_arg\", \"err_des\":\"some problem with arg\"}"));
    }

    @Test
    public void testErrorResponseIsInvalidJson() throws IOException {
        HttpURLConnection mockedCon = this.createHttpURLConnection("dummy");
        Mockito.when((Object)mockedCon.getInputStream()).thenThrow(new Throwable[]{new IOException("Can't read")});
        Mockito.when((Object)mockedCon.getErrorStream()).thenReturn((Object)new ByteArrayInputStream("non json error output".getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)mockedCon.getResponseCode()).thenReturn((Object)500);
        IOException ioe = (IOException)Assertions.assertThrows(IOException.class, () -> HttpJwtRetriever.post((HttpURLConnection)mockedCon, null, null, null, null));
        Assertions.assertTrue((boolean)ioe.getMessage().contains("{non json error output}"));
    }

    @Test
    public void testCopy() throws IOException {
        byte[] expected = new byte[4097];
        Random r = new Random();
        r.nextBytes(expected);
        ByteArrayInputStream in = new ByteArrayInputStream(expected);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HttpJwtRetriever.copy((InputStream)in, (OutputStream)out);
        Assertions.assertArrayEquals((byte[])expected, (byte[])out.toByteArray());
    }

    @Test
    public void testCopyError() throws IOException {
        InputStream mockedIn = (InputStream)Mockito.mock(InputStream.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Mockito.when((Object)mockedIn.read((byte[])ArgumentMatchers.any(byte[].class))).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertThrows(IOException.class, () -> HttpJwtRetriever.copy((InputStream)mockedIn, (OutputStream)out));
    }
}

