/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Optional;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.BalancerOperationError;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.BrokerRemovalError;
import org.apache.kafka.clients.admin.BrokerReplicaExclusionStatus;
import org.apache.kafka.clients.admin.BrokerShutdownStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;

public class BrokerRemovalDescription {
    private final Integer brokerId;
    private final BalancerOperationStatus generalOperationStatus;
    private final BrokerShutdownStatus brokerShutdownStatus;
    private final PartitionReassignmentsStatus partitionReassignmentsStatus;
    private final BrokerReplicaExclusionStatus brokerReplicaExclusionStatus;
    private final boolean shutdownScheduled;
    private final Optional<BrokerRemovalError> removalError;
    private final long createTimeMs;
    private final long lastUpdateTimeMs;

    public BrokerRemovalDescription(Integer brokerId, BalancerOperationStatus generalOperationStatus, BrokerShutdownStatus brokerShutdownStatus, PartitionReassignmentsStatus partitionReassignmentsStatus, BrokerReplicaExclusionStatus brokerReplicaExclusionStatus, boolean shutdownScheduled, Optional<BrokerRemovalError> removalError, long createTimeMs, long lastUpdateTimeMs) {
        this.brokerId = brokerId;
        this.brokerShutdownStatus = brokerShutdownStatus;
        this.partitionReassignmentsStatus = partitionReassignmentsStatus;
        this.brokerReplicaExclusionStatus = brokerReplicaExclusionStatus;
        this.shutdownScheduled = shutdownScheduled;
        this.removalError = removalError;
        this.createTimeMs = createTimeMs;
        this.lastUpdateTimeMs = lastUpdateTimeMs;
        this.generalOperationStatus = generalOperationStatus;
    }

    public Integer brokerId() {
        return this.brokerId;
    }

    public long createTimeMs() {
        return this.createTimeMs;
    }

    public long lastUpdateTimeMs() {
        return this.lastUpdateTimeMs;
    }

    public BalancerOperationStatus generalOperationStatus() {
        return this.generalOperationStatus;
    }

    public BrokerReplicaExclusionStatus brokerReplicaExclusionStatus() {
        return this.brokerReplicaExclusionStatus;
    }

    public boolean isShutdownScheduled() {
        return this.shutdownScheduled;
    }

    public BrokerShutdownStatus shutdownStatus() {
        return this.brokerShutdownStatus;
    }

    public PartitionReassignmentsStatus reassignmentsStatus() {
        return this.partitionReassignmentsStatus;
    }

    public Optional<BrokerRemovalError> removalError() {
        return this.removalError;
    }

    public Optional<BalancerOperationError> error() {
        return Optional.ofNullable(this.removalError.orElse(null));
    }

    public String toString() {
        return "BrokerRemovalDescription{brokerId=" + this.brokerId + ", replicaExclusionStatus=" + String.valueOf((Object)this.brokerReplicaExclusionStatus) + ", partitionReassignmentsStatus=" + String.valueOf((Object)this.partitionReassignmentsStatus) + ", brokerShutdownStatus=" + String.valueOf((Object)this.brokerShutdownStatus) + ", removalError=" + String.valueOf(this.removalError) + ", createTime=" + ClientUtils.utcDateFor(this.createTimeMs) + ", updateTime=" + ClientUtils.utcDateFor(this.lastUpdateTimeMs) + "}";
    }
}

