/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterBrokerReplicaExclusionsRequestData
implements ApiMessage {
    int timeoutMs;
    List<BrokerExclusion> brokersToExclude;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("timeout_ms", Type.INT32, "The time in ms to wait for the request to complete."), new Field("brokers_to_exclude", new ArrayOf(BrokerExclusion.SCHEMA_0), "Broker IDs to exclude from replica placement."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterBrokerReplicaExclusionsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterBrokerReplicaExclusionsRequestData() {
        this.timeoutMs = 60000;
        this.brokersToExclude = new ArrayList<BrokerExclusion>(0);
    }

    @Override
    public short apiKey() {
        return 10015;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokersToExclude was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<BrokerExclusion> newCollection = new ArrayList<BrokerExclusion>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerExclusion(_readable, _version, _context));
        }
        this.brokersToExclude = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.timeoutMs);
        _writable.writeInt(this.brokersToExclude.size());
        for (BrokerExclusion brokersToExcludeElement : this.brokersToExclude) {
            brokersToExcludeElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(4);
        for (BrokerExclusion brokersToExcludeElement : this.brokersToExclude) {
            brokersToExcludeElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterBrokerReplicaExclusionsRequestData)) {
            return false;
        }
        AlterBrokerReplicaExclusionsRequestData other = (AlterBrokerReplicaExclusionsRequestData)obj;
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.brokersToExclude == null ? other.brokersToExclude != null : !this.brokersToExclude.equals(other.brokersToExclude)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.brokersToExclude == null ? 0 : this.brokersToExclude.hashCode());
        return hashCode;
    }

    @Override
    public AlterBrokerReplicaExclusionsRequestData duplicate() {
        AlterBrokerReplicaExclusionsRequestData _duplicate = new AlterBrokerReplicaExclusionsRequestData();
        _duplicate.timeoutMs = this.timeoutMs;
        ArrayList<BrokerExclusion> newBrokersToExclude = new ArrayList<BrokerExclusion>(this.brokersToExclude.size());
        for (BrokerExclusion _element : this.brokersToExclude) {
            newBrokersToExclude.add(_element.duplicate());
        }
        _duplicate.brokersToExclude = newBrokersToExclude;
        return _duplicate;
    }

    public String toString() {
        return "AlterBrokerReplicaExclusionsRequestData(timeoutMs=" + this.timeoutMs + ", brokersToExclude=" + MessageUtil.deepToString(this.brokersToExclude.iterator()) + ")";
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<BrokerExclusion> brokersToExclude() {
        return this.brokersToExclude;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterBrokerReplicaExclusionsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public AlterBrokerReplicaExclusionsRequestData setBrokersToExclude(List<BrokerExclusion> v) {
        this.brokersToExclude = v;
        return this;
    }

    public static class BrokerExclusion
    implements Message {
        int brokerId;
        byte exclusionOperationCode;
        String reason;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID to exclude"), new Field("exclusion_operation_code", Type.INT8, "The operation to perform (SET, DELETE)."), new Field("reason", Type.STRING, "The user-provided reason for excluding the broker."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public BrokerExclusion(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public BrokerExclusion() {
            this.brokerId = 0;
            this.exclusionOperationCode = 0;
            this.reason = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerExclusion");
            }
            this.brokerId = _readable.readInt();
            this.exclusionOperationCode = _readable.readByte();
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field reason was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field reason had invalid length " + length);
            }
            this.reason = _readable.readString(length);
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            _writable.writeByte(this.exclusionOperationCode);
            byte[] _stringBytes = _cache.getSerializedValue(this.reason);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerExclusion");
            }
            _size.addBytes(4);
            _size.addBytes(1);
            byte[] _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'reason' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.reason, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerExclusion)) {
                return false;
            }
            BrokerExclusion other = (BrokerExclusion)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.exclusionOperationCode != other.exclusionOperationCode) {
                return false;
            }
            if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + this.exclusionOperationCode;
            hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
            return hashCode;
        }

        @Override
        public BrokerExclusion duplicate() {
            BrokerExclusion _duplicate = new BrokerExclusion();
            _duplicate.brokerId = this.brokerId;
            _duplicate.exclusionOperationCode = this.exclusionOperationCode;
            _duplicate.reason = this.reason;
            return _duplicate;
        }

        public String toString() {
            return "BrokerExclusion(brokerId=" + this.brokerId + ", exclusionOperationCode=" + this.exclusionOperationCode + ", reason=" + (String)(this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public byte exclusionOperationCode() {
            return this.exclusionOperationCode;
        }

        public String reason() {
            return this.reason;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerExclusion setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public BrokerExclusion setExclusionOperationCode(byte v) {
            this.exclusionOperationCode = v;
            return this;
        }

        public BrokerExclusion setReason(String v) {
            this.reason = v;
            return this;
        }
    }
}

