/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.DrainCellRequestData;
import org.apache.kafka.common.message.DrainCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DrainCellResponse;

public class DrainCellRequest
extends AbstractRequest {
    private final DrainCellRequestData data;

    DrainCellRequest(DrainCellRequestData data, short version) {
        super(ApiKeys.DRAIN_CELL, version);
        this.data = data;
    }

    @Override
    public DrainCellRequestData data() {
        return this.data;
    }

    public int cellId() {
        return this.data.cellId();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        return new DrainCellResponse(new DrainCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(t).code()));
    }

    public static DrainCellRequest parse(Readable readable, short version, MessageContext context) {
        return new DrainCellRequest(new DrainCellRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DrainCellRequest> {
        private final DrainCellRequestData data;

        public Builder() {
            super(ApiKeys.DRAIN_CELL);
            this.data = new DrainCellRequestData();
        }

        public Builder(DrainCellRequestData data) {
            super(ApiKeys.DRAIN_CELL);
            this.data = data;
        }

        public Builder setCellId(int id) {
            this.data.setCellId(id);
            return this;
        }

        @Override
        public DrainCellRequest build(short version) {
            return new DrainCellRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

