/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.InitiateShutdownRequestData;
import org.apache.kafka.common.message.InitiateShutdownResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.InitiateShutdownResponse;

public class InitiateShutdownRequest
extends AbstractRequest {
    private InitiateShutdownRequestData data;

    private InitiateShutdownRequest(InitiateShutdownRequestData data, short version) {
        super(ApiKeys.INITIATE_SHUTDOWN, version);
        this.data = data;
    }

    @Override
    public InitiateShutdownRequestData data() {
        return this.data;
    }

    @Override
    public InitiateShutdownResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        InitiateShutdownResponseData responseData = new InitiateShutdownResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new InitiateShutdownResponse(responseData);
    }

    public static InitiateShutdownRequest parse(Readable readable, short version, MessageContext context) {
        return new InitiateShutdownRequest(new InitiateShutdownRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<InitiateShutdownRequest> {
        private final InitiateShutdownRequestData data;

        public Builder(long brokerEpoch) {
            super(ApiKeys.INITIATE_SHUTDOWN);
            this.data = new InitiateShutdownRequestData().setBrokerEpoch(brokerEpoch);
        }

        @Override
        public InitiateShutdownRequest build(short version) {
            return new InitiateShutdownRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

