/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.SaslAuthenticateRequestData;
import org.apache.kafka.common.message.SaslAuthenticateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.SaslAuthenticateResponse;

public class SaslAuthenticateRequest
extends AbstractRequest {
    private final SaslAuthenticateRequestData data;

    public SaslAuthenticateRequest(SaslAuthenticateRequestData data, short version) {
        super(ApiKeys.SASL_AUTHENTICATE, version);
        this.data = data;
    }

    @Override
    public SaslAuthenticateRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        SaslAuthenticateResponseData response = new SaslAuthenticateResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message());
        return new SaslAuthenticateResponse(response);
    }

    public static SaslAuthenticateRequest parse(Readable readable, short version, MessageContext context) {
        return new SaslAuthenticateRequest(new SaslAuthenticateRequestData(readable, version, context), version);
    }

    @Override
    public String toString() {
        SaslAuthenticateRequestData tempData = this.data.duplicate();
        tempData.setAuthBytes(new byte[0]);
        return tempData.toString();
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslAuthenticateRequest> {
        private final SaslAuthenticateRequestData data;

        public Builder(SaslAuthenticateRequestData data) {
            super(ApiKeys.SASL_AUTHENTICATE);
            this.data = data;
        }

        @Override
        public SaslAuthenticateRequest build(short version) {
            return new SaslAuthenticateRequest(this.data, version);
        }

        public String toString() {
            return "(type=SaslAuthenticateRequest)";
        }
    }
}

