/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.ClientSecretHttpRequestFormatter;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ClientSecretHttpRequestFormatterTest {
    ClientSecretHttpRequestFormatterTest() {
    }

    private static void createFormatterAndGetRequestHeader(String clientId, String clientSecret) throws IOException {
        ClientSecretHttpRequestFormatter formatter = new ClientSecretHttpRequestFormatter(clientId, clientSecret, "testScope", false);
        formatter.formatHeaders();
    }

    @Test
    void testInitialization() {
        ClientSecretHttpRequestFormatter formatter = new ClientSecretHttpRequestFormatter("clientId", "clientSecret", "testScope", false);
        Assertions.assertNotNull((Object)formatter);
    }

    @Test
    void testGetRequestHeader() throws IOException {
        ClientSecretHttpRequestFormatter formatter = new ClientSecretHttpRequestFormatter("clientId", "clientSecret", "testScope", false);
        Map headers = formatter.formatHeaders();
        Assertions.assertNotNull((Object)headers);
        Assertions.assertTrue((boolean)headers.containsKey("Authorization"));
        Assertions.assertTrue((boolean)((String)headers.get("Authorization")).startsWith("Basic "));
    }

    @Test
    void testGetRequestBodyWithScope() throws IOException {
        ClientSecretHttpRequestFormatter formatter = new ClientSecretHttpRequestFormatter("clientId", "clientSecret", "testScope", false);
        String requestBody = formatter.formatBody();
        Assertions.assertNotNull((Object)requestBody);
        Assertions.assertTrue((boolean)requestBody.contains("grant_type=client_credentials"));
        Assertions.assertTrue((boolean)requestBody.contains("&scope=testScope"));
    }

    @Test
    void testGetRequestBodyWithoutScope() throws IOException {
        ClientSecretHttpRequestFormatter formatter = new ClientSecretHttpRequestFormatter("clientId", "clientSecret", null, false);
        String requestBody = formatter.formatBody();
        Assertions.assertNotNull((Object)requestBody);
        Assertions.assertTrue((boolean)requestBody.contains("grant_type=client_credentials"));
        Assertions.assertFalse((boolean)requestBody.contains("&scope="));
    }

    @Test
    public void testFormatAuthorizationHeaderMissingValues() {
        Assertions.assertThrows(NullPointerException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader(null, "secret"));
        Assertions.assertThrows(NullPointerException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader("id", null));
        Assertions.assertThrows(NullPointerException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader(null, null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader("", "secret"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader("id", ""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader("", ""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader("  ", "secret"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader("id", "  "));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ClientSecretHttpRequestFormatterTest.createFormatterAndGetRequestHeader("  ", "  "));
    }
}

