/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.clients.admin.internals.ExclusionRequestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExclusionRequestUtilsTest {
    @Test
    public void testValidateReasonThrowsOnInvalidCharacters() {
        char[] invalidChars;
        for (char c : invalidChars = new char[]{'/', '\\', ',', '\u0000', ':', '\"', '\'', ';', '*', '?', '\t', '\r', '\n', '='}) {
            String reason = "Is" + c + "illegal";
            Assertions.assertThrows(IllegalArgumentException.class, () -> ExclusionRequestUtils.validateReason((String)reason));
        }
    }

    @Test
    public void testValidateReasonWithEmptyReasons() {
        ExclusionRequestUtils.validateReason((String)"");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ExclusionRequestUtils.validateNonEmptyReason((String)""));
        ExclusionRequestUtils.validateNonEmptyReason((String)"test reason");
    }

    @Test
    public void testValidateReasonThrowsOnInvalidLength() {
        String chars1028 = String.join((CharSequence)"", Collections.nCopies(257, "Test"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ExclusionRequestUtils.validateReason((String)chars1028));
        String chars1024 = String.join((CharSequence)"", Collections.nCopies(256, "Test"));
        ExclusionRequestUtils.validateReason((String)chars1024);
    }

    @Test
    public void testValidateReasonThrowsOnInvalidReasons() {
        for (String invalidReason : Arrays.asList(".", "..")) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> ExclusionRequestUtils.validateReason((String)invalidReason));
        }
        ExclusionRequestUtils.validateReason((String)"...");
    }

    @Test
    public void testValidateReasonAllowsSpace() {
        String reasonWithSpace = "Broker to be removed from cluster-123";
        ExclusionRequestUtils.validateReason((String)reasonWithSpace);
    }

    @Test
    public void testValidateNumberOnlyReason() {
        String allNumberReason = "1123";
        ExclusionRequestUtils.validateReason((String)allNumberReason);
    }
}

