/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerRecordTest {
    @Test
    public void testShortConstructor() {
        String topic = "topic";
        int partition = 0;
        long offset = 23L;
        String key = "key";
        String value = "value";
        ConsumerRecord record = new ConsumerRecord(topic, partition, offset, (Object)key, (Object)value);
        Assertions.assertEquals((Object)topic, (Object)record.topic());
        Assertions.assertEquals((int)partition, (int)record.partition());
        Assertions.assertEquals((long)offset, (long)record.offset());
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
        Assertions.assertEquals((Object)TimestampType.NO_TIMESTAMP_TYPE, (Object)record.timestampType());
        Assertions.assertEquals((long)-1L, (long)record.timestamp());
        Assertions.assertEquals((int)-1, (int)record.serializedKeySize());
        Assertions.assertEquals((int)-1, (int)record.serializedValueSize());
        Assertions.assertEquals(Optional.empty(), (Object)record.leaderEpoch());
        Assertions.assertEquals(Optional.empty(), (Object)record.deliveryCount());
        Assertions.assertEquals((Object)new RecordHeaders(), (Object)record.headers());
    }

    @Test
    public void testLongConstructor() {
        String topic = "topic";
        int partition = 0;
        long offset = 23L;
        long timestamp = 23434217432432L;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        String key = "key";
        String value = "value";
        int serializedKeySize = 100;
        int serializedValueSize = 1142;
        RecordHeaders headers = new RecordHeaders();
        headers.add((Header)new RecordHeader("header key", "header value".getBytes(StandardCharsets.UTF_8)));
        ConsumerRecord record = new ConsumerRecord(topic, partition, offset, timestamp, timestampType, serializedKeySize, serializedValueSize, (Object)key, (Object)value, (Headers)headers, Optional.empty());
        Assertions.assertEquals((Object)topic, (Object)record.topic());
        Assertions.assertEquals((int)partition, (int)record.partition());
        Assertions.assertEquals((long)offset, (long)record.offset());
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
        Assertions.assertEquals((Object)timestampType, (Object)record.timestampType());
        Assertions.assertEquals((long)timestamp, (long)record.timestamp());
        Assertions.assertEquals((int)serializedKeySize, (int)record.serializedKeySize());
        Assertions.assertEquals((int)serializedValueSize, (int)record.serializedValueSize());
        Assertions.assertEquals(Optional.empty(), (Object)record.leaderEpoch());
        Assertions.assertEquals(Optional.empty(), (Object)record.deliveryCount());
        Assertions.assertEquals((Object)headers, (Object)record.headers());
        Optional<Integer> leaderEpoch = Optional.of(10);
        Optional<Short> deliveryCount = Optional.of((short)1);
        record = new ConsumerRecord(topic, partition, offset, timestamp, timestampType, serializedKeySize, serializedValueSize, (Object)key, (Object)value, (Headers)headers, leaderEpoch, deliveryCount);
        Assertions.assertEquals((Object)topic, (Object)record.topic());
        Assertions.assertEquals((int)partition, (int)record.partition());
        Assertions.assertEquals((long)offset, (long)record.offset());
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
        Assertions.assertEquals((Object)timestampType, (Object)record.timestampType());
        Assertions.assertEquals((long)timestamp, (long)record.timestamp());
        Assertions.assertEquals((int)serializedKeySize, (int)record.serializedKeySize());
        Assertions.assertEquals((int)serializedValueSize, (int)record.serializedValueSize());
        Assertions.assertEquals(leaderEpoch, (Object)record.leaderEpoch());
        Assertions.assertEquals(deliveryCount, (Object)record.deliveryCount());
        Assertions.assertEquals((Object)headers, (Object)record.headers());
    }
}

