/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.concurrent.Future;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.common.network.netty.NettyClient;
import org.apache.kafka.common.network.netty.NettyClientTestBase;
import org.apache.kafka.common.network.netty.NettyHttp2Stream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.TestNettyStreamHandler;
import org.apache.kafka.common.network.netty.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=1L, unit=TimeUnit.MINUTES)
public class NettyHttp2StreamTest
extends NettyClientTestBase {
    private NettyClient client;

    @Timeout(value=30L, unit=TimeUnit.SECONDS)
    @BeforeEach
    public void setupClient() {
        this.client = new NettyClient(NettyHttp2StreamTest.acceptAllSslContext(), this.eventLoopGroup, logContext);
    }

    @AfterEach
    public void closeClient() {
        this.client.shutdown().join();
    }

    @Test
    public void testStreamChannelHasCorrectHandlers() throws Exception {
        this.runStreamTestCode(stream -> {
            List<ChannelHandler> handlers = TestUtils.handlers(stream.channel());
            Assertions.assertEquals((int)1, (int)handlers.size());
            boolean hasHttp2Handler = handlers.stream().anyMatch(handler -> handler instanceof NettyHttp2Stream.NettyHttp2StreamHandler);
            Assertions.assertTrue((boolean)hasHttp2Handler, (String)"Channel does not have HTTP/2 stream handler");
        });
    }

    @Test
    public void testFlushReleasesBuffer() throws Exception {
        String msg = "Hello, world!";
        ByteBuf data = Unpooled.buffer((int)msg.length());
        ByteBufUtil.writeAscii((ByteBuf)data, (CharSequence)msg);
        Assertions.assertEquals((int)1, (int)data.refCnt());
        this.runStreamTestCode(stream -> {
            try {
                Future flushFuture = stream.send(data, true);
                flushFuture.sync().get();
                Assertions.assertTrue((flushFuture.isSuccess() && flushFuture.isDone() ? 1 : 0) != 0, (String)"Write future should complete successfully.");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assertions.assertEquals((int)0, (int)data.refCnt(), (String)"Buffer not released after flush");
        });
    }

    @Test
    public void testStreamIdIsValid() throws Exception {
        this.runStreamTestCode(stream -> Assertions.assertTrue((Integer.parseInt(stream.streamId()) > 0 ? 1 : 0) != 0, (String)("Invalid stream Id: " + stream.streamId())));
    }

    private void runStreamTestCode(Consumer<NettyHttp2Stream> streamConsumer) throws Exception {
        NettyHttp2Stream stream = null;
        TestNettyStreamHandler handler = new TestNettyStreamHandler(new CountDownLatch(1));
        try {
            CompletableFuture streamFuture = this.client.createStream(NettyHttp2StreamTest.serverAddress(), Integer.valueOf(0x100000), Integer.valueOf(0x100000), (NettyStream.StreamHandler)handler, (Http2Headers)new DefaultHttp2Headers());
            stream = (NettyHttp2Stream)streamFuture.get();
            streamConsumer.accept(stream);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                stream.closeStream().get();
                Assertions.assertTrue((boolean)handler.isStreamChannelClosed(), (String)"Stream channel close callback not received");
            }
        }
    }
}

