/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.SelectablePlugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.netty.TestNettyHttp2Selector;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;

public class TestNettyHttp2SelectablePlugin
implements SelectablePlugin {
    private static volatile int numThreads = 2;
    private static final AtomicReference<EventLoopGroup> eventLoopGroup = new AtomicReference();

    public static void numThreads(int numThreads) {
        TestNettyHttp2SelectablePlugin.numThreads = numThreads;
    }

    protected SslContext sslContext() {
        return null;
    }

    public Selectable newSelectable(Metrics metrics, String metricGrpPrefix, LogContext logContext) {
        if (eventLoopGroup.get() == null) {
            eventLoopGroup.set(EventLoopGroupHolder.eventLoopGroup);
        }
        return new TestNettyHttp2Selector(eventLoopGroup.get(), this.sslContext(), logContext);
    }

    private static class EventLoopGroupHolder {
        static final EventLoopGroup eventLoopGroup = Utils.createEventLoopGroup((int)numThreads, (String)"selector");

        private EventLoopGroupHolder() {
        }
    }
}

