/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.message.DeleteAclsResponseData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteAclsResponseTest {
    private static final short V1 = 1;
    private static final DeleteAclsResponseData.DeleteAclsMatchingAcl LITERAL_ACL1 = new DeleteAclsResponseData.DeleteAclsMatchingAcl().setResourceType(ResourceType.TOPIC.code()).setResourceName("foo").setPatternType(PatternType.LITERAL.code()).setPrincipal("User:ANONYMOUS").setHost("127.0.0.1").setOperation(AclOperation.READ.code()).setPermissionType(AclPermissionType.DENY.code());
    private static final DeleteAclsResponseData.DeleteAclsMatchingAcl LITERAL_ACL2 = new DeleteAclsResponseData.DeleteAclsMatchingAcl().setResourceType(ResourceType.GROUP.code()).setResourceName("group").setPatternType(PatternType.LITERAL.code()).setPrincipal("User:*").setHost("127.0.0.1").setOperation(AclOperation.WRITE.code()).setPermissionType(AclPermissionType.ALLOW.code());
    private static final DeleteAclsResponseData.DeleteAclsMatchingAcl PREFIXED_ACL1 = new DeleteAclsResponseData.DeleteAclsMatchingAcl().setResourceType(ResourceType.GROUP.code()).setResourceName("prefix").setPatternType(PatternType.PREFIXED.code()).setPrincipal("User:*").setHost("127.0.0.1").setOperation(AclOperation.CREATE.code()).setPermissionType(AclPermissionType.ALLOW.code());
    private static final DeleteAclsResponseData.DeleteAclsMatchingAcl UNKNOWN_ACL = new DeleteAclsResponseData.DeleteAclsMatchingAcl().setResourceType(ResourceType.UNKNOWN.code()).setResourceName("group").setPatternType(PatternType.LITERAL.code()).setPrincipal("User:*").setHost("127.0.0.1").setOperation(AclOperation.WRITE.code()).setPermissionType(AclPermissionType.ALLOW.code());
    private static final DeleteAclsResponseData.DeleteAclsFilterResult LITERAL_RESPONSE = new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(LITERAL_ACL1, LITERAL_ACL2));
    private static final DeleteAclsResponseData.DeleteAclsFilterResult PREFIXED_RESPONSE = new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Arrays.asList(LITERAL_ACL1, PREFIXED_ACL1));
    private static final DeleteAclsResponseData.DeleteAclsFilterResult UNKNOWN_RESPONSE = new DeleteAclsResponseData.DeleteAclsFilterResult().setMatchingAcls(Collections.singletonList(UNKNOWN_ACL));

    @Test
    public void shouldThrowOnIfUnknown() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(10).setFilterResults(Collections.singletonList(UNKNOWN_RESPONSE)), 1));
    }

    @Test
    public void shouldRoundTripV1() {
        DeleteAclsResponse original = new DeleteAclsResponse(new DeleteAclsResponseData().setThrottleTimeMs(10).setFilterResults(Arrays.asList(LITERAL_RESPONSE, PREFIXED_RESPONSE)), 1);
        ByteBufferAccessor readable = original.serialize((short)1);
        DeleteAclsResponse result = DeleteAclsResponse.parse((Readable)readable, (short)1, (MessageContext)MessageContext.IDENTITY);
        Assertions.assertEquals((Object)original.filterResults(), (Object)result.filterResults());
    }
}

