/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndTxnResponseTest {
    @Test
    public void testConstructor() {
        int throttleTimeMs = 10;
        EndTxnResponseData data = new EndTxnResponseData().setErrorCode(Errors.NOT_COORDINATOR.code()).setThrottleTimeMs(throttleTimeMs);
        Map<Errors, Integer> expectedErrorCounts = Collections.singletonMap(Errors.NOT_COORDINATOR, 1);
        Iterator iterator = ApiKeys.END_TXN.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            EndTxnResponse response = new EndTxnResponse(data);
            Assertions.assertEquals(expectedErrorCounts, (Object)response.errorCounts());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
            Assertions.assertEquals((Object)(version >= 1 ? 1 : 0), (Object)response.shouldClientThrottle(version));
            response = EndTxnResponse.parse((Readable)response.serialize(version), (short)version, (MessageContext)MessageContext.IDENTITY);
            Assertions.assertEquals(expectedErrorCounts, (Object)response.errorCounts());
            Assertions.assertEquals((int)throttleTimeMs, (int)response.throttleTimeMs());
            Assertions.assertEquals((Object)(version >= 1 ? 1 : 0), (Object)response.shouldClientThrottle(version));
        }
    }
}

