/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.BalancerConfigs;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerProtocol;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolCommand;
import org.apache.kafka.common.requests.DetailedRequestAuditLogFilter;
import org.apache.kafka.common.requests.SamplingRequestLogFilter;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.fips.FipsValidator;
import org.apache.kafka.common.security.mtls.MTlsConnectionManager;
import org.apache.kafka.common.security.mtls.MTlsTruststoreManager;
import org.apache.kafka.common.security.mtls.NoopMTlsConnectionManager;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.interceptor.DefaultBrokerInterceptor;
import org.apache.kafka.server.license.LicenseValidator;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.multitenant.MultiTenantMetadataLoader;
import org.apache.kafka.server.multitenant.MultiTenantSecretsStore;
import org.apache.kafka.server.multitenant.UserMetadataStore;
import org.apache.kafka.server.quota.MultiTenantQuotaConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentConfigs {
    private static final Logger log = LoggerFactory.getLogger(ConfluentConfigs.class);
    public static final String CONFLUENT_PREFIX = "confluent.";
    public static final String TRAFFIC_PREFIX = "confluent.traffic.";
    public static final String CLUSTER_LINK_PREFIX = "confluent.cluster.link.";
    public static final String CDC_TOPIC_METADATA_CONFIG_PREFIX = "confluent.cdc.topic.metadata.";
    public static final String BROKER_SESSION_ID_PROP = "broker.session.uuid";
    public static final String CONFIGS_LOGGING_ENABLED_PROP = "confluent.configs.logging.enabled";
    public static final String REGIONAL_METADATA_CLIENT_CLASS_CONFIG = "confluent.regional.metadata.client.class";
    public static final String REGIONAL_METADATA_CLIENT_CLASS_DEFAULT = null;
    public static final String REGIONAL_METADATA_CLIENT_CLASS_DOC = "Name of the class implementing 'RegionalMetadataClient' interface to fetch metadata from the regional metadata store";
    public static final String REGIONAL_RESOURCE_MANAGER_CLIENT_SCHEDULER_THREADS = "confluent.regional.resource.manager.client.scheduler.threads";
    public static final int REGIONAL_RESOURCE_MANAGER_CLIENT_SCHEDULER_THREADS_DEFAULT = 2;
    public static final String REGIONAL_RESOURCE_MANAGER_CLIENT_SCHEDULER_THREADS_DOC = "The number of scheduler threads used by the resource manager client to talk to the service";
    public static final String REGIONAL_RESOURCE_MANAGER_ENDPOINT_URL = "confluent.regional.resource.manager.endpoint";
    public static final String REGIONAL_RESOURCE_MANAGER_ENDPOINT_URL_DEFAULT = null;
    public static final String REGIONAL_RESOURCE_MANAGER_ENDPOINT_URL_DOC = "The http(s) endpoint url of the resource manager providing the regional metadata";
    public static final String REGIONAL_RESOURCE_MANAGER_GRPC_ENDPOINT_URL = "confluent.regional.resource.manager.grpc.endpoint";
    public static final String REGIONAL_RESOURCE_MANAGER_GRPC_ENDPOINT_URL_DEFAULT = null;
    public static final String REGIONAL_RESOURCE_MANAGER_GRPC_ENDPOINT_URL_DOC = "The GRPC endpoint url of the resource manager providing the regional metadata";
    public static final String REGIONAL_RESOURCE_MANAGER_WATCH_ENDPOINT_URL_DEFAULT = null;
    public static final String REGIONAL_RESOURCE_MANAGER_WATCH_ENDPOINT_URL_DOC = "The grpc endpoint url of the resource manager hosting the watch service";
    public static final String DATA_FLOW_POLICY_WATCH_MONITOR_MS_CONFIG = "confluent.dataflow.policy.watch.monitor.ms";
    public static final Long DATA_FLOW_POLICY_WATCH_MONITOR_MS_DEFAULT = TimeUnit.MINUTES.toMillis(5L);
    public static final String DATA_FLOW_POLICY_WATCH_MONITOR_MS_DOC = "How often to monitor the watch and restart if it has errors.This is the maximum time, and the check could happen sooner.";
    public static final String BROKER_INTERCEPTOR_CLASS_CONFIG = "broker.interceptor.class";
    public static final Class<?> BROKER_INTERCEPTOR_CLASS_DEFAULT = DefaultBrokerInterceptor.class;
    public static final String MULTITENANT_AUTHORIZER_CLASS_NAME = "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer";
    public static final String MULTITENANT_METADATA_CLASS_CONFIG = "multitenant.metadata.class";
    public static final String MULTITENANT_METADATA_CLASS_DEFAULT = null;
    public static final String MULTITENANT_METADATA_DIR_CONFIG = "multitenant.metadata.dir";
    public static final String MULTITENANT_METADATA_DIR_DEFAULT = null;
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_CONFIG = "multitenant.metadata.ssl.certs.path";
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_DEFAULT = null;
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_CONFIG = "multitenant.metadata.reload.delay.ms";
    public static final Long MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT = TimeUnit.MINUTES.toMillis(2L);
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_DOC = "Interval (in ms) between full reloads of logical cluster metadata. Defaults to 2 minutes.";
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_CONFIG = "multitenant.tenant.delete.delay";
    public static final Long MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT = TimeUnit.DAYS.toMillis(7L);
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_DOC = "Delay between the time the tenant is marked as deactivated in JSON file, until we actually start deleting topics. This defaults to 7 days to allow plenty of times for operators and users to regret their decisions and do something about it";
    public static final String MULTITENANT_TENANT_DELETE_CHECK_MS_CONFIG = "multitenant.tenant.delete.check.ms";
    public static final Long MULTITENANT_TENANT_DELETE_CHECK_MS_DEFAULT = TimeUnit.MINUTES.toMillis(2L);
    public static final String MULTITENANT_TENANT_DELETE_CHECK_MS_DOC = "How often to check the list of deactivated tenants for those that needs be deleted. This is the maximum time, and the check could happen sooner. The actual time for tenant deletion is in the interval " + MULTITENANT_TENANT_DELETE_CHECK_MS_DEFAULT + "[0, " + MULTITENANT_TENANT_DELETE_CHECK_MS_DEFAULT + "].";
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_CONFIG = "multitenant.tenant.delete.batch.size";
    public static final Integer MULTITENANT_TENANT_DELETE_BATCH_SIZE_DEFAULT = 10;
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_DOC = "Batch size for topic deletion of deactivated tenants. We wait for each batch to complete before sending another";
    public static final String MULTITENANT_SCHEMA_VALIDATION_ENABLED_CONFIG = "confluent.schema.validator.multitenant.enable";
    public static final String MULTITENANT_SCHEMA_VALIDATION_ENABLED_DOC = "Controls enablement of the schema validation plugin in the cloud";
    public static final boolean MULTITENANT_SCHEMA_VALIDATION_ENABLED_DEFAULT = false;
    public static final String MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_CONFIG = "confluent.multitenant.interceptor.balancer.apis.enabled";
    public static final String MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_DOC = "Denotes whether the multi-tenant interceptor will enable requests for the Self-Balancing Clusters (SBC) APIs.";
    public static final boolean MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_DEFAULT = false;
    public static final String API_VISIBILITY_CONFIG = "confluent.api.visibility";
    public static final String API_VISIBILITY_DOC = "API visibility to be advertised by the broker. " + String.valueOf((Object)ApiMessageType.ApiVisibility.DEFAULT) + " enables all Apache Kafka APIs and Confluent APIs intended for on-prem. " + String.valueOf((Object)ApiMessageType.ApiVisibility.CONFLUENT_CLOUD) + " additionally enables Confluent Cloud-specific APIs.";
    public static final ApiMessageType.ApiVisibility API_VISIBILITY_DEFAULT = ApiMessageType.ApiVisibility.DEFAULT;
    public static final String MULTITENANT_OAUTH_SUPERUSER_DISABLE = "multitenant.oauth.superuser.disable";
    public static final boolean MULTITENANT_OAUTH_SUPERUSER_DISABLE_DEFAULT = true;
    public static final String ENABLE_DATAPLANE_RBAC_FOR_PKC = "confluent.metadata.kafka.enable.dataplane.rbac";
    public static final boolean ENABLE_DATAPLANE_RBAC_FOR_PKC_DEFAULT = false;
    public static final String SUPPORT_USER_RESOURCE_ID_IN_ACL = "multitenant.authorizer.support.resource.ids";
    public static final boolean SUPPORT_USER_RESOURCE_ID_IN_ACL_DEFAULT = false;
    public static final String SUPPORT_USER_RESOURCE_ID_IN_ACL_DOC = "Enable using resourceId in kafka ACL APIs";
    private static final String SCHEMA_REGISTRY_URL = "schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "confluent.schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to look up schemas.";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_CONFIG = "confluent.schema.validator.interceptor.class";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_DOC = "Interceptor class used during schema validation";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_DEFAULT = "io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator";
    public static final String CONTEXT_NAME_SCHEMA_VALIDATION_FEATURE_ENABLED_CONFIG = "confluent.schema.validation.context.name.enable";
    public static final boolean CONTEXT_NAME_SCHEMA_VALIDATION_FEATURE_ENABLED_DEFAULT = false;
    public static final String CONTEXT_NAME_SCHEMA_VALIDATION_FEATURE_ENABLED_DOC = "Feature flag for context specific broker side schema validation.";
    public static final String SCHEMA_VALIDATION_SAMPLES_PER_MIN_CONFIG = "confluent.schema.validator.samples.per.min";
    public static final String SCHEMA_VALIDATION_SAMPLES_PER_MIN_DOC = "Number of error samples that will be printed per minute during schema validation";
    public static final Integer SCHEMA_VALIDATION_SAMPLES_PER_MIN_DEFAULT = 0;
    public static final String MAX_CACHE_SIZE_CONFIG = "confluent.schema.registry.max.cache.size";
    public static final String MAX_CACHE_SIZE_DOC = "Maximum size of each LRU cache used to cache responses from the schema registry. There is one cache to hold the ID to schema mappings and another to hold the schemas that are registered to a subject.";
    public static final int MAX_CACHE_SIZE_DEFAULT = 10000;
    public static final String WAIT_FOR_AUTHORIZER = "confluent.wait.for.authorizer.startup";
    public static final String MAX_RETRIES_CONFIG = "confluent.schema.registry.max.retries";
    public static final String MAX_RETRIES_DOC = "Maximum number of times to retry schema registry read operations.";
    public static final int MAX_RETRIES_DEFAULT = 1;
    public static final String RETRIES_WAIT_MS_CONFIG = "confluent.schema.registry.retries.wait.ms";
    public static final String RETRIES_WAIT_MS_DOC = "Time in milliseconds to wait before each retry.";
    public static final int RETRIES_WAIT_MS_DEFAULT = 0;
    public static final String MISSING_ID_QUERY_RANGE_CONFIG = "confluent.missing.id.query.range";
    public static final String MISSING_ID_QUERY_RANGE_DOC = "The range above max schema ID to make calls to Schema Registry";
    public static final int MISSING_ID_QUERY_RANGE_DEFAULT = 20000;
    public static final String MISSING_ID_CACHE_TTL_CONFIG = "confluent.missing.id.cache.ttl.sec";
    public static final String MISSING_ID_CACHE_TTL_DOC = "The TTL in seconds for caching missing schema IDs";
    public static final long MISSING_ID_CACHE_TTL_DEFAULT = 60L;
    public static final String MISSING_SCHEMA_CACHE_TTL_CONFIG = "confluent.missing.schema.cache.ttl.sec";
    public static final String MISSING_SCHEMA_CACHE_TTL_DOC = "The TTL in seconds for caching missing schemas";
    public static final long MISSING_SCHEMA_CACHE_TTL_DEFAULT = 60L;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String USER_INFO_CONFIG = "confluent.basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = null;
    public static final String USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.bearer.auth.credentials.source";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Bearer Auth header. ";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "confluent.bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_DEFAULT = null;
    public static final String BEARER_AUTH_TOKEN_DOC = "Specify the Bearer token to be used for authentication";
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL = "confluent.bearer.auth.issuer.endpoint.url";
    public static final String BEARER_AUTH_ISSUER_ENDPOINT_URL_DOC = "The HTTP(S)-based URL for the OAuth/OIDC identity provider which issues access token";
    public static final String BEARER_AUTH_CLIENT_ID = "confluent.bearer.auth.client.id";
    public static final String BEARER_AUTH_CLIENT_ID_DOC = "Client Id used to obtain Client Credentials Grant from OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-4.4\"> ";
    public static final String BEARER_AUTH_CLIENT_SECRET = "confluent.bearer.auth.client.secret";
    public static final String BEARER_AUTH_CLIENT_SECRET_DOC = "Client secret used to obtain Client Credentials Grant from OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-4.4\"> ";
    public static final String BEARER_AUTH_SCOPE = "confluent.bearer.auth.scope";
    public static final String BEARER_AUTH_SCOPE_DOC = "Access Token Scope used to obtain Client Credentials Grant OAuth/OIDC identity provider <a href=\"rfc-editor.org/rfc/rfc6749.html#section-3.3\"> ";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME = "confluent.bearer.auth.scope.claim.name";
    public static final String DEFAULT_BEARER_AUTH_SCOPE_CLAIM_NAME = "scope";
    public static final String BEARER_AUTH_SCOPE_CLAIM_NAME_DOC = "The OAuth claim for the scope is often named \"scope\", but this (optional) setting can provide a different name to use for the scope included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.";
    public static final String BEARER_ASSERTION_CLAIM_ISS = "confluent.bearer.assertion.claim.iss";
    public static final String BEARER_ASSERTION_CLAIM_ISS_DOC = "The value to be added to the Issuer claim \"iss\" which will be included in the client assertion created locally";
    public static final String BEARER_ASSERTION_CLAIM_SUB = "confluent.bearer.assertion.claim.sub";
    public static final String BEARER_ASSERTION_CLAIM_SUB_DOC = "The value to be added to the Subject claim \"sub\" which will be included in the client assertion created locally";
    public static final String BEARER_ASSERTION_CLAIM_AUD = "confluent.bearer.assertion.claim.aud";
    public static final String BEARER_ASSERTION_CLAIM_AUD_DOC = "The value to be added to the Audience claim \"aud\" which will be included in the client assertion created locally";
    public static final String BEARER_ASSERTION_CLAIM_JTI_INCLUDE = "confluent.bearer.assertion.claim.jti.include";
    public static final String BEARER_ASSERTION_CLAIM_JTI_INCLUDE_DOC = "The (optional) setting for specifying whether to include jti claim or not";
    public static final String BEARER_ASSERTION_CLAIM_NBF_INCLUDE = "confluent.bearer.assertion.claim.nbf.include";
    public static final String BEARER_ASSERTION_CLAIM_NBF_INCLUDE_DOC = "The (optional) setting for specifying whether to include \"not before\" (nbf) claim or notIf set to true, nbf claim with (current time - 1 minute) will be included in the client assertion";
    public static final String BEARER_ASSERTION_CLAIM_EXP_MINUTES = "confluent.bearer.assertion.claim.exp.minutes";
    public static final String BEARER_ASSERTION_CLAIM_EXP_MINUTES_DOC = "The (Optional) expiration time for the client assertion in minutesThe default value is 5 minutes";
    public static final String BEARER_ASSERTION_PRIVATE_KEY_FILE = "confluent.bearer.assertion.private.key.file";
    public static final String BEARER_ASSERTION_PRIVATE_KEY_FILE_DOC = "The location for the private key to be used for signing client assertion in PEM formatRequired for local client assertion creation";
    public static final String BEARER_ASSERTION_PRIVATE_KEY_PASSPHRASE = "confluent.bearer.assertion.private.key.passphrase";
    public static final String BEARER_ASSERTION_PRIVATE_KEY_PASSPHRASE_DOC = "The passphrase required for decrypting the private key (in case of PKCS#8 format pem file) ";
    public static final String BEARER_ASSERTION_FILE = "confluent.bearer.assertion.file";
    public static final String BEARER_ASSERTION_LOCATION_DOC = "The location/path on disc at which a signed client assertion is presentThis will be passed directly to the token endpoint.";
    public static final String BEARER_ASSERTION_TEMPLATE_FILE = "confluent.bearer.assertion.template.file";
    public static final String BEARER_ASSERTION_TEMPLATE_FILE_DOC = "The location for the JSON file which contains additional header and payload claims to be included in the client assertion";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME = "confluent.bearer.auth.sub.claim.name";
    public static final String DEFAULT_BEARER_AUTH_SUB_CLAIM_NAME = "sub";
    public static final String BEARER_AUTH_SUB_CLAIM_NAME_DOC = "The OAuth claim for the subject is often named \"sub\", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER = "confluent.bearer.auth.logical.cluster";
    public static final String BEARER_AUTH_LOGICAL_CLUSTER_DOC = "Additional property which can added in Request header to Schema Registry";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID = "confluent.bearer.auth.identity.pool.id";
    public static final String BEARER_AUTH_IDENTITY_POOL_ID_DOC = "Additional property which can added in Request header to Schema Registry. This maybe used as Principal Id for Authorization";
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS = "confluent.bearer.auth.cache.expiry.buffer.seconds";
    public static final Short BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DEFAULT = 300;
    public static final String BEARER_AUTH_CACHE_EXPIRY_BUFFER_SECONDS_DOC = "The amount of buffer time between expiration times of the OAuth Token and corresponding cache which hold the token. Ideally we would want to get a new token before the current one expires. Legal values are between 0 and 3600 (1 hour); a default value of  300 (5 minutes) is used if no value is specified. This value is ignored if it exceeds the remaining lifetime of a token from the moment it is retrieved into schema registry.";
    public static final String SSL_PROTOCOL_CONFIG = "confluent.ssl.protocol";
    public static final String SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLSv1.2, which is fine for most cases. Allowed values in recent JVMs are TLSv1.2 and TLSv1.3. TLS, TLSv1.1, SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "confluent.ssl.keystore.type";
    public static final String SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is optional for client.";
    public static final String SSL_KEYSTORE_LOCATION_CONFIG = "confluent.ssl.keystore.location";
    public static final String SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String SSL_KEYSTORE_PASSWORD_CONFIG = "confluent.ssl.keystore.password";
    public static final String SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file. This is optional for client and only needed if ssl.keystore.location is configured. ";
    public static final String SSL_KEY_PASSWORD_CONFIG = "confluent.ssl.key.password";
    public static final String SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file. This is optional for client.";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "confluent.ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store file.";
    public static final String SSL_TRUSTSTORE_LOCATION_CONFIG = "confluent.ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file. ";
    public static final String SSL_TRUSTSTORE_PASSWORD_CONFIG = "confluent.ssl.truststore.password";
    public static final String SSL_TRUSTSTORE_PASSWORD_DOC = "The password for the trust store file. If a password is not set access to the truststore is still available, but integrity checking is disabled.";
    public static final String PRODUCER_MIN_ACKS_CONFIG = "confluent.min.acks";
    public static final String TENANT_QUOTA_CALLBACK_CLASS = "io.confluent.kafka.multitenant.quota.TenantQuotaCallback";
    public static final String BACKPRESSURE_TYPES_CONFIG = "confluent.backpressure.types";
    public static final String BACKPRESSURE_TYPES_DEFAULT = null;
    public static final String BACKPRESSURE_TYPES_DOC = "Comma separated list of resource types for which broker back-pressure is enabled. Backpressure is not enabled by default. Accepted values: 'request', 'produce', 'fetch', 'clusterlinkrequest'.Invalid values are ignored. This config is ignored if client.quota.callback.class is not set, or set to class other than TenantQuotaCallback. In other words, broker back-pressure can be enabled for multi-tenant clusters only.";
    public static final String BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_CONFIG = "confluent.backpressure.request.min.broker.limit";
    public static final Long BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT = 200L;
    public static final String BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DOC = "The minimum broker request quota, i.e., request backpressure would not reduce the broker request quota any further even if the request overload is still detected. Broker-wide request quota, if not unlimited, caps the combined dynamic request quotas of currently active tenants. All values are accepted, but values below 10 will result in the minimum limit of 10.";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_CONFIG = "confluent.backpressure.request.queue.size.percentile";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_DEFAULT = "p95";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_DOC = "Queue size percentile used by request backpressure. For example, p95 means that when the number of requests in the request queue exceeds 80% of `queued.max.requests` in more than 5% of cases, the backpressure mechanism starts reducing the total broker request quota. Accepted values: `p90`, `p95`, `p98`, `p99`. Setting an invalid value will default to `p95`.";
    public static final String MAX_BROKER_LOAD_CONFIG = "confluent.max.broker.load";
    public static final double MAX_BROKER_LOAD_DEFAULT = 1.0;
    public static final String MAX_BROKER_LOAD_DOC = "The max broker load allowed for a broker, before backpressure is applied";
    public static final String BACKPRESSURE_PRODUCE_THROUGHPUT_CONFIG = "confluent.backpressure.disk.produce.bytes.per.second";
    public static final long BACKPRESSURE_PRODUCE_THROUGHPUT_DEFAULT = 131072L;
    public static final String BACKPRESSURE_PRODUCE_THROUGHPUT_DOC = "The cumulative bandwidth (in Bytes/s) available to all the producers in the broker";
    public static final String BACKPRESSURE_DISK_ENABLE_CONFIG = "confluent.backpressure.disk.enable";
    public static final boolean BACKPRESSURE_DISK_ENABLE_DEFAULT = false;
    public static final String BACKPRESSURE_DISK_ENABLE_DOC = "This flag will be used to turn on the disk based backpressure";
    public static final String BACKPRESSURE_DISK_THRESHOLD_BYTES_CONFIG = "confluent.backpressure.disk.free.threshold.bytes";
    public static final long BACKPRESSURE_DISK_THRESHOLD_BYTES_DEFAULT = 0x500000000L;
    public static final String BACKPRESSURE_DISK_THRESHOLD_BYTES_DOC = "The disk space available (in bytes) considered as the minimum across all the log dirs, below which the broker will limit aggregate produce bandwidth from all clients to the bandwidth specified in confluent.backpressure.disk.produce.bytes.per.second";
    public static final String BACKPRESSURE_DISK_RECOVERY_FACTOR_CONFIG = "confluent.backpressure.disk.threshold.recovery.factor";
    public static final double BACKPRESSURE_DISK_RECOVERY_FACTOR_DEFAULT = 1.5;
    public static final String BACKPRESSURE_DISK_RECOVERY_FACTOR_DOC = "The multiplier for the free disk threshold (specified via confluent.backpressure.disk.free.threshold.bytes) above which the throttling would be deactivated";
    public static final String BROKER_LIMIT_PRODUCER_CONFIG = "confluent.broker.limit.producer.bytes.per.second";
    public static final Long BROKER_LIMIT_PRODUCER_DEFAULT = Long.MAX_VALUE;
    public static final String BROKER_LIMIT_PRODUCER_DOC = "Broker-wide produce bandwidth limit in bytes per second. Broker will throttle produce requests to ensure that the cumulative bandwidth does not exceed this limit. Default setting is no limit.";
    public static final String BROKER_LIMIT_CONSUMER_CONFIG = "confluent.broker.limit.consumer.bytes.per.second";
    public static final Long BROKER_LIMIT_CONSUMER_DEFAULT = Long.MAX_VALUE;
    public static final String BROKER_LIMIT_CONSUMER_DOC = "Broker-wide consumer bandwidth limit in bytes per second. Broker will throttle fetch requests to ensure that the cumulative bandwidth does not exceed this limit. Default setting is no limit.";
    public static final String HOT_PARTITION_RATIO_CONFIG = "confluent.hot.partition.ratio";
    public static final double HOT_PARTITION_RATIO_DEFAULT = 0.8;
    public static final String HOT_PARTITION_RATIO_DOC = "The threshold to define hot partitions. A partition is hot if its ingress throughput is higher than equal to confluent.broker.limit.producer.bytes.per.second * confluent.hot.partition.ratio, or its egress throughput is higher than or equal to confluent.broker.limit.consumer.bytes.per.second * confluent.hot.partition.ratio. Setting the ratio to a negative value or zero disables hot partition metrics.";
    public static final String TENANT_PRODUCE_QUOTA_MULTIPLIER_CONFIG = "confluent.quota.tenant.produce.multiplier";
    public static final Double TENANT_PRODUCE_QUOTA_MULTIPLIER_DEFAULT = 1.0;
    public static final String TENANT_PRODUCE_QUOTA_MULTIPLIER_DOC = "Broker-wide produce bandwidth limit multiplier for tenant quotas.";
    public static final String TENANT_FETCH_QUOTA_MULTIPLIER_CONFIG = "confluent.quota.tenant.fetch.multiplier";
    public static final Double TENANT_FETCH_QUOTA_MULTIPLIER_DEFAULT = 1.0;
    public static final String TENANT_FETCH_QUOTA_MULTIPLIER_DOC = "Broker-wide fetch bandwidth limit multiplier for tenant quotas.";
    public static final String ENABLE_BROKER_REPORT_MIN_USAGE_MODE_CONFIG = "confluent.enable.broker.reporting.min.usage.mode";
    public static final Boolean ENABLE_BROKER_REPORT_MIN_USAGE_MODE_DEFAULT = true;
    public static final String ENABLE_BROKER_REPORT_MIN_USAGE_MODE_DOC = "When value is true, a minimal amount of usage is set to be 102400 (100Kbps) reported by each broker and used by QuotaCoordinator to calculate dynamic quota";
    public static final String QUOTA_DYNAMIC_ADJUSTMENT_MIN_USAGE_CONFIG = "confluent.quota.dynamic.adjustment.min.usage";
    public static final Integer QUOTA_DYNAMIC_ADJUSTMENT_MIN_USAGE_DEFAULT = 102400;
    public static final String QUOTA_DYNAMIC_ADJUSTMENT_MIN_USAGE_DOC = "Minimal quota consumption used by QuotaCoordinator to calculate quota for the broker.";
    public static final String QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_CONFIG = "confluent.quota.dynamic.reporting.interval.ms";
    public static final Long QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_DEFAULT = Duration.ofSeconds(30L).toMillis();
    public static final String QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_DOC = "Broker-wide quota consumption reporting interval, in milli seconds.";
    public static final String QUOTA_DYNAMIC_PUBLISHING_INTERVAL_MS_CONFIG = "confluent.quota.dynamic.publishing.interval.ms";
    public static final Long QUOTA_DYNAMIC_PUBLISHING_INTERVAL_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
    public static final String QUOTA_DYNAMIC_PUBLISHING_INTERVAL_MS_DOC = "Broker-wide quota publishing interval, in milliseconds.";
    public static final String QUOTA_COMPUTING_USAGE_ADJUSTMENT_CONFIG = "confluent.quota.computing.usage.adjustment";
    public static final Double QUOTA_COMPUTING_USAGE_ADJUSTMENT_DEFAULT = 0.5;
    public static final String QUOTA_COMPUTING_USAGE_ADJUSTMENT_DOC = "How much to adjust the entity's usage by if it's being throttled.";
    public static final String MAX_CONNECTION_REAP_AMOUNT_CONFIG = "max.connections.reap.amount";
    public static final int MAX_CONNECTION_REAP_AMOUNT_DEFAULT = 0;
    public static final String MAX_CONNECTION_REAP_AMOUNT_DOC = "Connections will start to get closed once connection count is greater than max.connections - max.connections.reap.amount";
    public static final String PROTECTED_LISTENERS_CONFIG = "max.connections.protected.listeners";
    public static final String PROTECTED_LISTENERS_DEFAULT = "";
    public static final String PROTECTED_LISTENERS_DOC = "Comma separated list of listener names that are protected from the max connection limit and creation rate. Note that this config is only applicable if there is at least one other non-protected listener.";
    public static final String CONNECTION_CREATION_RATE_FLOOR_CONFIG = "floor.max.connection.creation.rate";
    public static final String CONNECTION_CREATION_RATE_FLOOR_DOC = "The minimum rate that self-tuned connection creation rate quota will reduce to. This property can only be configured at a per-listener level. If unconfigured, connection rate auto-tuning will be disabled.";
    public static final String VALID_BROKER_RACK_SET_CONFIG = "confluent.valid.broker.rack.set";
    public static final String VALID_BROKER_RACK_SET_DOC = "Comma-delimited list of rack ids that are considered valid.";
    public static final String VALID_BROKER_RACK_SET_DEFAULT = null;
    public static final String RACK_ID_MIGRATION_MAP_CONFIG = "confluent.rack.id.mapping";
    public static final String RACK_ID_MIGRATION_MAP_DEFAULT = null;
    public static final String RACK_ID_MIGRATION_MAP_DOC = "This config map is used when rack num to rack ID migration is enabled";
    public static final String AUTO_ENABLE_TELEMETRY_REPORTER_CONFIG = "confluent.reporters.telemetry.auto.enable";
    public static final String AUTO_ENABLE_TELEMETRY_REPORTER_DOC = "Auto-enable telemetry on the broker. This will add the telemetry reporter to the broker's 'metric.reporters' property if it is not already present. Disabling this property will prevent Self-balancing Clusters from working properly.";
    public static final boolean AUTO_ENABLE_TELEMETRY_REPORTER_DEFAULT = true;
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_ENABLED_CONFIG = "confluent.telemetry.external.client.metrics.push.enabled";
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_ENABLED_DOC = "True if client metrics are enabled, which can to be reported to Confluent Cloud";
    public static final boolean TELEMETRY_EXTERNAL_CLIENT_METRICS_ENABLED_DEFAULT = false;
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_DELTA_TEMPORALITY_CONFIG = "confluent.telemetry.external.client.metrics.delta.temporality";
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_DELTA_TEMPORALITY_DOC = "False if delta temporality should be disabled for telemetry metrics";
    public static final boolean TELEMETRY_EXTERNAL_CLIENT_METRICS_DELTA_TEMPORALITY_DEFAULT = true;
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_INSTANCE_CACHE_SIZE_CONFIG = "confluent.telemetry.external.client.metrics.instance.cache.size";
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_INSTANCE_CACHE_SIZE_DOC = "The size of the Client Instance Cache (KIP-714).";
    public static final int TELEMETRY_EXTERNAL_CLIENT_METRICS_INSTANCE_CACHE_SIZE_DEFAULT = 16384;
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_SUPPORTED_COMPRESSION_TYPES_CONFIG = "confluent.telemetry.external.client.metrics.supported.compression.types";
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_SUPPORTED_COMPRESSION_TYPES_DEFAULT = "zstd,lz4,gzip,snappy";
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_SUPPORTED_COMPRESSION_TYPES_DOC = "A comma-separated list of compression types supported for client telemetry.";
    public static final String METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_CONFIG = "confluent.metadata.max.leader.balance.changes.per.slice";
    public static final String METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_DOC = "This configuration determines the maximum number of leader elections to perform during one partition leader balancing operation. Use this configuration and {METADATA_LEADER_BALANCE_SLICE_DELAY_MS_CONFIG} to controller how quickly the controller performs leader elections. The default value is {METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_DEFAULT}.";
    public static final int METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_DEFAULT = 1000;
    public static final String METADATA_LEADER_BALANCE_SLICE_DELAY_MS_CONFIG = "confluent.metadata.leader.balance.slice.delay.ms";
    public static final String METADATA_LEADER_BALANCE_SLICE_DELAY_MS_DOC = "This configuration determines how much time the controller will wait between leader balancing operation. Use this configuration and {METADATA_MAX_LEADER_BALANCE_CHANGES_PER_SLICE_CONFIG} to controller how quickly the controller performs leader elections. The default value is {METADATA_LEADER_BALANCE_SLICE_DELAY_MS_DEFAULT}.";
    public static final int METADATA_LEADER_BALANCE_SLICE_DELAY_MS_DEFAULT = 100;
    public static final String METADATA_JVM_WARMUP_MS_CONFIG = "confluent.metadata.jvm.warmup.ms";
    public static final String METADATA_JVM_WARMUP_MS_DOC = "This configuration determines how much time the controller will wait between balancing internal topic partitions and external topic partitions, It is the time for jvm to warm up the PRODUCE and FETCH paths before moving any customer visible partition leaders.";
    public static final int METADATA_JVM_WARMUP_MS_DEFAULT = 60000;
    public static final String METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_CONFIG = "confluent.metadata.max.controlled.shutdown.partition.changes.per.slice";
    public static final String METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_DOC = "This configuration determines the maximum number of partition changes performed concurrently by the controller. Use this configuration and {METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_CONFIG} to controller how quickly the controller performs partition changes during controlled shutdown. The default value is {METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_DEFAULT}.";
    public static final int METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_DEFAULT = 1000;
    public static final String METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_CONFIG = "confluent.metadata.controlled.shutdown.partition.slice.delay.ms";
    public static final String METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_DOC = "This configuration determines how much time the controller will wait between partition changes. Use this configuration and {METADATA_MAX_CONTROLLED_SHUTDOWN_PARTITION_CHANGES_PER_SLICE_CONFIG} to controller how quickly the controller performs partition changes during controlled shutdown. The default value is {METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_DEFAULT}.";
    public static final int METADATA_CONTROLLED_SHUTDOWN_PARTITION_SLICE_DELAY_MS_DEFAULT = 100;
    public static final String TELEMETRY_ENABLED_CONFIG = "confluent.telemetry.enabled";
    public static final String TELEMETRY_ENABLED_DOC = "True if telemetry data can to be reported to Confluent Cloud";
    public static final boolean TELEMETRY_ENABLED_DEFAULT = false;
    public static final String ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_CONFIG = "confluent.alter.broker.health.max.demoted.brokers";
    public static final Integer ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_DEFAULT = Integer.MAX_VALUE;
    public static final String ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_DOC = "The maximum number of brokers that can be demoted when limit is enforced. Int.MaxValue means that any number of brokers can be demoted.";
    public static final String ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_PERCENTAGE_CONFIG = "confluent.alter.broker.health.max.demoted.brokers.percentage";
    public static final Integer ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_PERCENTAGE_DEFAULT = 0;
    public static final String ALTER_BROKER_HEALTH_MAX_DEMOTED_BROKERS_PERCENTAGE_DOC = "The maximum percentage of brokers that can be demoted when limit is enforced. We always allow at least one broker to be demoted given 3 live brokers, but will allow demotion of more if the configured percentage of brokers in the cluster is greater than one. Valid values are 0 (minimum (1) broker can be demoted) to 100 (all brokers can be demoted).";
    public static final String ALTER_BROKER_HEALTH_RETRY_BACKOFF_MS_CONFIG = "confluent.automatic.alter.broker.health.retry.backoff.ms";
    public static final Integer AUTOMATIC_ALTER_BROKER_HEALTH_RETRY_BACKOFF_MS_DEFAULT = 2000;
    public static final String AUTOMATIC_ALTER_BROKER_HEALTH_RETRY_BACKOFF_MS_DOC = "Before each retry, the system needs time to recover from the state that caused the previous failure. This config determines the amount of time to wait before retrying. The delay will grow exponentially by factor of 2.";
    public static final String BROKER_TYPE_CONFIG = "confluent.broker.type";
    public static final String BROKER_TYPE_DEFAULT = "confluent_platform";
    public static final String BROKER_TYPE_DOC = "Specifies the type of broker, can be either 'confluent_cloud' or 'confluent_platform'";
    public static final String BROKER_TYPE_TOPIC_ENABLED_CONFIG = "confluent.broker.type.topic.enabled";
    public static final boolean BROKER_TYPE_TOPIC_ENABLED_DEFAULT = true;
    public static final String BROKER_TYPE_TOPIC_ENABLED_DOC = "True if a topic to reveal the type of the cluster should be created.";
    public static final String ENABLE_ACL_STATE = "confluent.multitenant.authorizer.enable.acl.state";
    public static final boolean ENABLE_ACL_STATE_DEFAULT = false;
    public static final String ENABLE_ACL_STATE_DOC = "Enable using AclState in kafka ACL APIs";
    public static final String CONFLUENT_BALANCER_PREFIX = "confluent.balancer.";
    public static final String BALANCER_CLASS_CONFIG = "confluent.balancer.class";
    public static final String BALANCER_CLASS_DOC = "The class providing DataBalancer services for the Kafka controller.";
    public static final String BALANCER_CLASS_DEFAULT = "io.confluent.databalancer.SbcDataBalanceManager";
    public static final String BALANCER_ENABLE_SBK_CONFIG = "enable";
    public static final String BALANCER_ENABLE_CONFIG = "confluent.balancer.enable";
    public static final boolean BALANCER_ENABLE_DEFAULT = false;
    public static final String BALANCER_ENABLE_DOC = "This config controls whether the balancer is enabled";
    public static final String BALANCER_AUTO_HEAL_MODE_SBK_CONFIG = "heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_CONFIG = "confluent.balancer.heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_DEFAULT = BalancerConfigs.BALANCER_AUTO_HEAL_MODE_DEFAULT;
    public static final String BALANCER_AUTO_HEAL_MODE_DOC = BalancerConfigs.BALANCER_AUTO_HEAL_MODE_DOC;
    public static final String BALANCER_V2_ADDITION_ENABLED_SBC_CONFIG = "v2.addition.enabled";
    public static final String BALANCER_V2_ADDITION_ENABLED_CONFIG = "confluent.balancer.v2.addition.enabled";
    public static final boolean BALANCER_V2_ADDITION_ENABLED_DEFAULT = false;
    public static final String BALANCER_V2_ADDITION_ENABLED_SBC_DOC = "A boolean denoting whether the version 2 of the broker addition operation is enabled. Because V2 broker addition relies exclusively on self healing to add the broker to the cluster, its enablement also depends on incremental balancing being enabled ('confluent.balancer.incremental.balancing.enabled'). To enable V2 broker addition, configure both this config and 'confluent.balancer.incremental.balancing.enabled' to true.";
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_SBK_CONFIG = "heal.broker.failure.threshold.ms";
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_CONFIG = "confluent.balancer.heal.broker.failure.threshold.ms";
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT = BalancerConfigs.BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT;
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED = BalancerConfigs.BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED;
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_DOC = "This config specifies how long the balancer will wait after detecting a broker failure before triggering a balancing action. -1 means that broker failures will not trigger balancing actions";
    public static final String BALANCER_THROTTLE_SBK_CONFIG = "throttle.bytes.per.second";
    public static final String BALANCER_THROTTLE_CONFIG = "confluent.balancer.throttle.bytes.per.second";
    public static final Long BALANCER_THROTTLE_NO_THROTTLE = BalancerConfigs.BALANCER_THROTTLE_NO_THROTTLE;
    public static final Long BALANCER_THROTTLE_AUTO_THROTTLE = BalancerConfigs.BALANCER_THROTTLE_AUTO_THROTTLE;
    public static final Long BALANCER_THROTTLE_MIN = BalancerConfigs.BALANCER_THROTTLE_MIN;
    public static final Long BALANCER_THROTTLE_DEFAULT = BalancerConfigs.BALANCER_THROTTLE_DEFAULT;
    public static final String BALANCER_THROTTLE_DOC = "This config specifies the upper bound for bandwidth in bytes to move replicas around for replica reassignment. A value of -1 disables throttling entirely.";
    public static final String BALANCER_REPLICA_CAPACITY_SBK_CONFIG = "max.replicas";
    public static final String BALANCER_REPLICA_CAPACITY_CONFIG = "confluent.balancer.max.replicas";
    public static final Long BALANCER_REPLICA_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_REPLICA_CAPACITY_DEFAULT;
    public static final String BALANCER_REPLICA_CAPACITY_DOC = "The replica capacity is the maximum number of replicas the balancer will place on a single broker.";
    public static final String BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_SBK_CONFIG = "capacity.threshold.upper.limit";
    public static final String BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_CONFIG = "confluent.balancer.capacity.threshold.upper.limit";
    public static final Double BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_DEFAULT = BalancerConfigs.BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_DEFAULT;
    public static final String BALANCER_CAPACITY_THRESHOLD_UPPER_LIMIT_DOC = "Upper limit on capacity threshold config. If balancing fail with original capacity thresholds defined for each resource, SBC will try to bump it up to this limit (maybe in multiple stages) and try to balance again. Balancing will fail only if capacity threshold is set to this value and brokers can't be balanced.";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_SBK_CONFIG = "disk.max.load";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_CONFIG = "confluent.balancer.disk.max.load";
    public static final Double BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT = BalancerConfigs.BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT;
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_DOC = "This config specifies the maximum load for disk usage as a proportion of disk capacity. Valid values are between 0 and 1.";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_SBK_CONFIG = "disk.min.free.space.gb";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_CONFIG = "confluent.balancer.disk.min.free.space.gb";
    public static final Integer BALANCER_DISK_MIN_FREE_SPACE_DEFAULT = BalancerConfigs.BALANCER_DISK_MIN_FREE_SPACE_DEFAULT;
    public static final String BALANCER_DISK_MIN_FREE_SPACE_DOC = "The minimum amount of disk space, in GB, that needs to remain unused on a broker. Valid values are between 0 and disk size. The balancer will enforce the stricter bound between this config and 'confluent.balancer.disk.max.load'.";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_SBK_CONFIG = "disk.min.free.space.lower.limit.gb";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_CONFIG = "confluent.balancer.disk.min.free.space.lower.limit.gb";
    public static final Integer BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_DEFAULT = BalancerConfigs.BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_DEFAULT;
    public static final String BALANCER_DISK_MIN_FREE_SPACE_LOWER_LIMIT_DOC = "The lower limit on minimum amount of free disk space, in gigabytes, that needs to remain unused on a broker. On failing to balance, SBC will reset the min disk space config DISK_CAPACITY_MIN_FREE_SPACE_CONFIG to this value and will try to balance again.The balancer will enforce the stricter bound between this config and 'confluent.balancer.disk.max.load'.";
    public static final String BALANCER_NETWORK_IN_CAPACITY_SBK_CONFIG = "network.in.max.bytes.per.second";
    public static final String BALANCER_NETWORK_IN_CAPACITY_CONFIG = "confluent.balancer.network.in.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_IN_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_NETWORK_IN_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_IN_CAPACITY_MIN = BalancerConfigs.BALANCER_NETWORK_IN_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_IN_CAPACITY_DOC = "This config specifies the upper capacity limit for network incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_SBK_CONFIG = "network.out.max.bytes.per.second";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_CONFIG = "confluent.balancer.network.out.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_NETWORK_OUT_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_MIN = BalancerConfigs.BALANCER_NETWORK_OUT_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_OUT_CAPACITY_DOC = "This config specifies the upper capacity limit for network outgoing bytes per second per broker. The Confluent DataBalancer will attempt to keep outgoing data throughput below this limit.";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_SBK_CONFIG = "exclude.topic.names";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG = "confluent.balancer.exclude.topic.names";
    public static final List<?> BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT = BalancerConfigs.BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_DOC = "This config accepts a list of topic names that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.names=[topic1, topic2]' ";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_BASE_CONFIG = "exclude.topic.prefixes";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG = "confluent.balancer.exclude.topic.prefixes";
    public static final List<?> BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT = BalancerConfigs.BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_DOC = "This config accepts a list of topic prefixes that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.prefixes=[prefix1, prefix2]' would exclude topics 'prefix1-suffix1', 'prefix1-suffix2', 'prefix2-suffix3', but not 'abc-prefix1-xyz' and 'def-prefix2'";
    public static final String BALANCER_API_STATE_TOPIC_SBK_CONFIG = "api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_CONFIG = "confluent.balancer.api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_DEFAULT = "_confluent_balancer_api_state";
    public static final String BALANCER_API_STATE_TOPIC_DOC = "Name of topic to use to store state of Confluent DataBalancer API. The topic will be used to store progress/failure of the api and will be used in case of recovery to resume long running operations like remove or add broker.";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_SBK_CONFIG = "topic.replication.factor";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG = "confluent.balancer.topic.replication.factor";
    public static final Short BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT = BalancerConfigs.BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT;
    public static final String BALANCER_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for all topics that are created and needed by the Confluent DataBalancer. This includes Sample Store and API state topics.";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_SBK_CONFIG = "task.history.retention.days";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_CONFIG = "confluent.balancer.task.history.retention.days";
    public static final Integer BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT = BalancerConfigs.BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT;
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DOC = "Number of days for which self balancing cluster's task history will be retained.";
    public static final String BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG = "confluent.balancer.max.capacity.balancing.delta.percentage";
    public static final Double BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DEFAULT = BalancerConfigs.BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DEFAULT;
    public static final String BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DOC = "The extra percentage of total capacity that SBC will attempt to balance below the allowed capacity once it gets triggered to fix a broker hitting its maximum allowed capacity for a given resource.";
    public static final String MULTI_TENANT_SASL_SECRETS_STORE_CLASS_NAME = "io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsStore";
    public static final String CONFLUENT_CDC_API_KEYS_PREFIX = "confluent.cdc.api.keys.";
    public static final String CDC_API_KEYS_TOPIC_CONFIG = "confluent.cdc.api.keys.topic";
    public static final String CDC_API_KEYS_TOPIC_DEFAULT = "";
    public static final String CDC_API_KEYS_TOPIC_DOC = "Name of the internal topic holding api keys";
    public static final String CDC_TOPIC_LOAD_TIMEOUT_MS_CONFIG = "confluent.cdc.api.keys.topic.load.timeout.ms";
    public static final Long CDC_TOPIC_LOAD_TIMEOUT_MS_DEFAULT = Duration.ofMinutes(10L).toMillis();
    public static final String CDC_TOPIC_LOAD_TIMEOUT_MS_DOC = "Time (in milliseconds) to wait before giving up on trying to consume the topics for logical clusters api keys and tenant metadata. Default is 10min";
    public static final String CONFLUENT_CDC_LKC_METADATA_PREFIX = "confluent.cdc.lkc.metadata.";
    public static final String CDC_LKC_METADATA_TOPIC_CONFIG = "confluent.cdc.lkc.metadata.topic";
    public static final String CDC_LKC_METADATA_TOPIC_DEFAULT = "";
    public static final String CDC_LKC_METADATA_TOPIC_DOC = "Name of the internal topic holding lkc metadata";
    public static final String MULTI_TENANT_METADATA_LOADER_CLASS_NAME = "io.confluent.kafka.multitenant.KafkaLogicalClusterMetadataLoader";
    public static final String MULTI_TENANT_QUOTA_CONSUMER_CLASS_NAME = "io.confluent.kafka.multitenant.quota.TenantClientQuotaConsumer";
    public static final String CONFLUENT_CDC_CLIENT_QUOTAS_PREFIX = "confluent.cdc.client.quotas.";
    public static final String CDC_CLIENT_QUOTAS_ENABLE_CONFIG = "confluent.cdc.client.quotas.enable";
    public static final boolean CDC_CLIENT_QUOTAS_ENABLE_DEFAULT = false;
    public static final String CDC_CLIENT_QUOTAS_ENABLE_DOC = "Should the broker try and read client qutoas from internal topic";
    public static final String CDC_CLIENT_QUOTAS_TOPIC_CONFIG = "confluent.cdc.client.quotas.topic.name";
    public static final String CDC_CLIENT_QUOTAS_TOPIC_DEFAULT = "";
    public static final String CDC_CLIENT_QUOTAS_TOPIC_DOC = "Name of the internal topic holding client quotas";
    public static final String NETWORK_ID_ROUTES_UPDATER_CLASS_NAME = "io.confluent.kafka.traffic.TopicBasedTrafficNetworkIdRoutesUpdater";
    public static final String CONFLUENT_TRAFFIC_CDC_NETWORK_ID_ROUTES_PREFIX = "confluent.traffic.cdc.network.id.routes.";
    public static final String CDC_NETWORK_ID_ROUTES_ENABLE_CONFIG = "confluent.traffic.cdc.network.id.routes.enable";
    public static final boolean CDC_NETWORK_ID_ROUTES_ENABLE_DEFAULT = false;
    public static final String CDC_NETWORK_ID_ROUTES_ENABLE_DOC = "Should the broker try and read networkId routes from internal topic";
    public static final String CDC_NETWORK_ID_ROUTES_TOPIC_CONFIG = "confluent.traffic.cdc.network.id.routes.topic.name";
    public static final String CDC_NETWORK_ID_ROUTES_TOPIC_DEFAULT = "_confluent-network_id_routes";
    public static final String CDC_NETWORK_ID_ROUTES_TOPIC_DOC = "Name of the internal topic holding networkId routes";
    public static final String CDC_NETWORK_ID_ROUTES_PERIODIC_START_TASK_MS_CONFIG = "confluent.traffic.cdc.network.id.routes.periodic.start.task.ms";
    public static final Long CDC_NETWORK_ID_ROUTES_PERIODIC_START_TASK_MS_DEFAULT = Duration.ofMinutes(5L).toMillis();
    public static final String CDC_NETWORK_ID_ROUTES_PERIODIC_START_TASK_MS_DOC = "Time (in milliseconds) to periodically check for routes topic existence  and start the consumer if topic is available. Default is 5min";
    public static final String CDC_NETWORK_ID_ROUTES_LISTENER_NAMES = "confluent.traffic.cdc.network.id.routes.listener.names";
    public static final String CDC_NETWORK_ID_ROUTES_LISTENER_NAMES_DEFAULT = "EXTERNAL_BACKCHANNEL";
    public static final String CDC_NETWORK_ID_ROUTES_LISTENER_NAMES_DOC = "Name of the listeners that need to wait for the TopicBasedTrafficNetworkIdRoutesUpdater to start before accepting requests";
    public static final String CDC_USER_METADATA_STORE_CLASS_NAME = "io.confluent.kafka.server.plugins.auth.DefaultUserMetaDataStore";
    public static final String CONFLUENT_CDC_USER_METADATA_PREFIX = "confluent.cdc.user.metadata.";
    public static final String CDC_USER_METADATA_ENABLE_CONFIG = "confluent.cdc.user.metadata.enable";
    public static final boolean CDC_USER_METADATA_ENABLE_DEFAULT = false;
    public static final String CDC_USER_METADATA_ENABLE_DOC = "Should the broker read user metadata from internal topics";
    public static final String CDC_USER_METADATA_TOPIC_CONFIG = "confluent.cdc.user.metadata.topic";
    public static final String CDC_USER_METADATA_TOPIC_DEFAULT = "_confluent-user_metadata";
    public static final String CDC_USER_METADATA_TOPIC_DOC = "Name of the topic holding user metadata";
    public static final String CDC_USER_DELETION_HANDLER_CLASS_NAME = "io.confluent.kafka.server.plugins.auth.UserDeletionEventHandler";
    public static final String CDC_USER_DELETION_HANDLER_ENABLE_CONFIG = "confluent.cdc.user.deletion.handler.enable";
    public static final boolean CDC_USER_DELETION_HANDLER_ENABLE_DEFAULT = false;
    public static final String CDC_USER_DELETION_HANDLER_DOC = "Enable the User deletion handler to soft delete the ACLs for deleted users";
    public static final String OPERATOR_MANAGED_CONFIG = "confluent.operator.managed";
    public static final boolean OPERATOR_MANAGED_DEFAULT = false;
    public static final String OPERATOR_MANAGED_DOC = "This config indicates if the Confluent Operator was involved in generating the broker configuration.";
    public static final String ANSIBLE_MANAGED_CONFIG = "confluent.ansible.managed";
    public static final boolean ANSIBLE_MANAGED_DEFAULT = false;
    public static final String ANSIBLE_MANAGED_DOC = "This config indicates if Ansible was involved in generating the broker configuration.";
    public static final String MULTITENANT_LISTENER_NAMES_CONFIG = "confluent.multitenant.listener.names";
    public static final String MULTITENANT_LISTENER_NAMES_DEFAULT = null;
    public static final String MULTITENANT_LISTENER_NAMES_DOC = "Comma separated list of listener names used for communications with tenants. It MUST BE SPECIFIED IN MULTI-TENANT environment! It is needed to enable both broker request (time on network and IO threads)backpressure, and for a proper startup of the topic based tenant metadata plugins. Note that this should bedisjoint from inter.broker.listener.name (which should not receive connections from tenants)";
    public static final String INTERNAL_TENANT_SCOPED_LISTENER_NAME_CONFIG = "confluent.internal.tenant.scoped.listener.name";
    public static final String INTERNAL_TENANT_SCOPED_LISTENER_NAME_DEFAULT = "INTERNAL_TENANT_SCOPED";
    public static final String INTERNAL_TENANT_SCOPED_LISTENER_NAME_DOC = "The name of internal tenant scoped listener";
    public static final String REQUEST_LOG_FILTER_CLASS_CONFIG = "confluent.request.log.filter.class";
    public static final String REQUEST_LOG_FILTER_DEFAULT = SamplingRequestLogFilter.class.getName();
    public static final String REQUEST_LOG_FILTER_CLASS_DOC = "Class of request log filter which can be used to select a subset of requests for logging. Every request handler thread will get a separate instance of this class and it is only consulted if the request log level is set to INFO or higher. If DEBUG or TRACE logging is enabled, then all requests get logged regardless of filtering.";
    public static final String DETAILED_REQUEST_AUDIT_LOG_FILTER_CLASS_CONFIG = "confluent.security.event.logger.detailed.audit.logs.filter.class";
    public static final String DETAILED_REQUEST_AUDIT_LOG_FILTER_DEFAULT = DetailedRequestAuditLogFilter.class.getName();
    public static final String DETAILED_REQUEST_AUDIT_LOG_FILTER_CLASS_DOC = "Class of detailed request audit log filter which can be used to enable a subset of requests for audit logging.";
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS = "confluent.apply.create.topic.policy.to.create.partitions";
    public static final boolean APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DEFAULT = false;
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DOC = "If this is set, CreateTopicsPolicy will also apply to CreatePartitions.";
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX = "confluent.verify.group.subscription.prefix";
    public static final boolean VERIFY_GROUP_SUBSCRIPTION_PREFIX_DEFAULT = false;
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX_DOC = "If this is set, the group coordinator will verify that the subscriptions are prefixed with the tenant.";
    public static final String STRAY_LOG_DELETE_DELAY_MS_CONFIG = "confluent.stray.log.delete.delay.ms";
    public static final long STRAY_LOG_DELETE_DELAY_MS_DEFAULT = 604800000L;
    public static final String STRAY_LOG_DELETE_DELAY_MS_DOC = "Backoff time before actual deletion of stray logs";
    public static final String STRAY_LOG_MAX_DELETIONS_PER_RUN_CONFIG = "confluent.stray.log.max.deletions.per.run";
    public static final int STRAY_LOG_MAX_DELETIONS_PER_RUN_DEFAULT = 72;
    public static final String STRAY_LOG_MAX_DELETIONS_PER_RUN_DOC = "Max number of logs to be deleted in a single run of stray log deletion job.";
    public static final String CRN_AUTHORITY_PREFIX = "confluent.authorizer.authority.";
    public static final String CRN_AUTHORITY_NAME_CONFIG = "confluent.authorizer.authority.name";
    public static final String CRN_AUTHORITY_NAME_DEFAULT = "";
    public static final String CRN_AUTHORITY_NAME_DOC = "The DNS name of the authority that this clusteruses to authorize. This should be a name for the cluster hosting metadata topics.";
    public static final String EVENT_LOGGER_PREFIX = "event.logger.";
    public static final String AUDIT_PREFIX = "confluent.security.";
    public static final String AUDIT_PREFIX_REMOTE_CONFIG = "confluent.security.remoteconfig.";
    public static final String AUDIT_REMOTE_CONFIG_CLOUD = "cloud.";
    public static final String AUDIT_EVENT_LOGGER_PREFIX = "confluent.security.event.logger.";
    public static final String AUDIT_KAFKA_EXPORTER_SASL_JAAS_CONFIG = "confluent.security.event.logger.exporter.kafka.sasl.jaas.config";
    public static final String AUDIT_KAFKA_EXPORTER_SASL_JAAS_CONFIG_PREFIX = "confluent.security.event.logger.exporter.kafka.sasl.jaas.config.";
    public static final String AUDIT_EVENT_ROUTER_PREFIX = "confluent.security.event.router.";
    public static final String AUDIT_EVENT_ROUTER_CONFIG_PREFIX = "confluent.security.event.router.config.";
    public static final String AUDIT_EVENT_ROUTER_CONFIG = "confluent.security.event.router.config";
    public static final String AUDIT_EVENT_ROUTER_DEFAULT = "";
    public static final String AUDIT_EVENT_ROUTER_DOC = "JSON configuration for routing events to topics";
    public static final String AUDIT_LOGGER_ENABLE_CONFIG = "confluent.security.event.logger.enable";
    public static final String AUDIT_LOGGER_ENABLE_DEFAULT = "true";
    public static final String AUDIT_LOGGER_ENABLE_DOC = "Whether the event logger is enabled";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_CONFIG = "confluent.security.event.logger.exporter.kafka.topic.replicas";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_DEFAULT = "3";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_DOC = "Replication factor for audit log topics";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS = "confluent.security.event.logger.authentication.enable";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS_DEFAULT = "false";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS_DOC = "Enable authentication audit logs";
    public static final String AUDIT_LOGGING_PHYSICAL_CLUSTER_ID = "confluent.security.event.logger.physical.cluster.id";
    public static final String AUDIT_LOGGING_PHYSICAL_CLUSTER_ID_DEFAULT = "";
    public static final String AUDIT_LOGGING_PHYSICAL_CLUSTER_ID_DOC = "Physical cluster id of the source cluster";
    public static final String RATE_LIMIT_AUTHENTICATION_AUDIT_LOGS = "confluent.security.event.logger.authentication.event.rate.limit";
    public static final int RATE_LIMIT_AUTHENTICATION_AUDIT_LOGS_DEFAULT = -1;
    public static final String RATE_LIMIT_AUTHENTICATION_AUDIT_LOGS_DOC = "Configuration to control and limit the rate at which authentication audit events are sent to the clearing house per second";
    public static final String RATE_LIMIT_AUTHORIZATION_AUDIT_LOGS = "confluent.security.event.logger.authorization.event.rate.limit";
    public static final int RATE_LIMIT_AUTHORIZATION_AUDIT_LOGS_DEFAULT = -1;
    public static final String RATE_LIMIT_AUTHORIZATION_AUDIT_LOGS_DOC = "Configuration to control and limit the rate at which authorization audit events are sent to the clearing house per second";
    public static final String RATE_LIMIT_KAFKA_REQUEST_AUDIT_LOGS = "confluent.security.event.logger.kafka.request.rate.limit";
    public static final int RATE_LIMIT_KAFKA_REQUEST_AUDIT_LOGS_DEFAULT = -1;
    public static final String RATE_LIMIT_KAFKA_REQUEST_AUDIT_LOGS_DOC = "Configuration to control and limit the rate at which kafka requests (kafka management, produce or consume) are processed to extract and send audit events to the clearing house per second.";
    public static final String NAMED_ROUTER_CONFIG_ENABLED = "confluent.security.event.router.named.config.enabled";
    public static final boolean NAMED_ROUTER_CONFIG_ENABLED_DEFAULT = false;
    public static final String NAMED_ROUTER_CONFIG_ENABLED_DOC = "Configuration to enable named router configuration for routing events to topics. This configuration would be used for Disaster Recovery Switch for Cloud Auditlogs Kafka";
    public static final String CLUSTER_REGISTRY_CONFIG = "confluent.metadata.server.cluster.registry.clusters";
    public static final String CLUSTER_REGISTRY_CONFIG_DEFAULT = "[]";
    public static final String CLUSTER_REGISTRY_CONFIG_DOC = "JSON defining initial state of Cluster Registry. This should not be set manually, instead Cluster Registry http apis should be used.";
    public static final String ENABLE_FIPS_CONFIG = "enable.fips";
    public static final String ENABLE_FIPS_DEFAULT = "false";
    public static final String ENABLE_FIPS_DOC = "Enable FIPS mode on the server. If FIPS mode is enabled, broker listener security protocols, TLS versions and cipher suites will be validated based on FIPS compliance requirement.";
    public static final String ENABLE_BC_APPROVED_MODE_CONFIG = "confluent.security.bc.approved.mode.enable";
    public static final String ENABLE_BC_APPROVED_MODE_DEFAULT = "false";
    public static final String ENABLE_BC_APPROVED_MODE_DOC = "Enable bouncycastle approved mode on cluster. If enabled, the kafka process will start with bc specific JVM flag to enable approved mode. Within the code This flag can be used to conditionally execute FIPS compliant code.";
    public static final String TRAFFIC_NETWORK_ID_CONFIG = "confluent.traffic.network.id";
    public static final String TRAFFIC_NETWORK_ID_DEFAULT = "";
    public static final String TRAFFIC_NETWORK_ID_DOC = "The network ID that this cluster belongs to.";
    public static final String TRAFFIC_NETWORK_TYPE_CONFIG = "confluent.traffic.network.type";
    public static final String TRAFFIC_NETWORK_TYPE_DEFAULT = "";
    public static final String TRAFFIC_NETWORK_TYPE_DOC = "The network type that this cluster belongs to. This is only used in Confluent Cloud.  The value will be updated with the value from regional Resource Manager. It will be used when regional Resource Manager is unavailable";
    public static final String DEFAULT_DATA_POLICY_ENFORCEMENT_CONFIG = "confluent.default.data.policy.enforcement";
    public static final boolean DEFAULT_DATA_POLICY_ENFORCEMENT_DEFAULT = true;
    public static final String DEFAULT_DATA_POLICY_ENFORCEMENT_DOC = "Enforce the default data policy by default. This can be set to false for ease of testing for esku cluster.";
    public static final String EMIT_NETWORK_TYPE_TAG_CONFIG = "confluent.emit.network.type.tag";
    public static final boolean EMIT_NETWORK_TYPE_TAG_DEFAULT = false;
    public static final String EMIT_NETWORK_TYPE_TAG_DOC = "Emitting network type tag in kafka metrics";
    public static final String DEFAULT_NETWORKING_TYPE_CONFIG = "confluent.emit.network.type.default";
    public static final String DEFAULT_NETWORKING_TYPE_DEFAULT = "";
    public static final String DEFAULT_NETWORKING_TYPE_DOC = "Default networking type to be used when the network type is not present in the request";
    public static final String CLUSTER_LINK_ENABLE_CONFIG = "confluent.cluster.link.enable";
    public static final boolean CLUSTER_LINK_ENABLE_DEFAULT = true;
    public static final String CLUSTER_LINK_ENABLE_DOC = "Enable cluster linking feature.";
    public static final String CLUSTER_LINK_K2_MIRROR_TOPIC_METADATA_ENABLE_CONFIG = "confluent.cluster.link.k2.mirror.topic.metadata.enable";
    public static final boolean CLUSTER_LINK_K2_MIRROR_TOPIC_METADATA_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_K2_MIRROR_TOPIC_METADATA_ENABLE_DOC = "Enable cluster linking mirror topic metadata being stored in K2.";
    public static final String CLUSTER_LINK_INTRANET_CONNECTIVITY_ENABLE_CONFIG = "confluent.cluster.link.intranet.connectivity.enable";
    public static final boolean CLUSTER_LINK_INTRANET_CONNECTIVITY_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_INTRANET_CONNECTIVITY_ENABLE_DOC = "Enables intranet connectivity between confluent cloud clusters for cluster linking. It is a dynamic configuration to disable the feature dynamically but not enabling the feature dynamically";
    public static final String CLUSTER_LINK_INTRANET_CONNECTIVITY_MIGRATION_ENABLE_CONFIG = "confluent.cluster.link.intranet.connectivity.migration.enable";
    public static final boolean CLUSTER_LINK_INTRANET_CONNECTIVITY_MIGRATION_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_INTRANET_CONNECTIVITY_MIGRATION_ENABLE_DOC = "Dynamic configuration that enables intranet connectivity migration for existing links.";
    public static final String CLUSTER_LINK_INTRANET_CONNECTIVITY_DENIED_ORG_IDS_CONFIG = "confluent.cluster.link.intranet.connectivity.denied.org.ids";
    public static final String CLUSTER_LINK_INTRANET_CONNECTIVITY_DENIED_ORG_IDS = "";
    public static final String CLUSTER_LINK_INTRANET_CONNECTIVITY_DENIED_ORG_IDS_DOC = "Denies intranet connectivity for cluster linking between confluent cloud clusters for the specified org ids.";
    public static final String CLUSTER_LINK_BOOTSTRAP_TRANSLATION_FEATURE_ENABLE_CONFIG = "confluent.cluster.link.bootstrap.translation.feature.enable";
    public static final boolean CLUSTER_LINK_BOOTSTRAP_TRANSLATION_FEATURE_ENABLE_DEFAULT = true;
    public static final String CLUSTER_LINK_BOOTSTRAP_TRANSLATION_FEATURE_ENABLE_DOC = "Dynamic config to enable bootstrap translation feature during create/alter cluster link at runtime. This config is a wrapper over confluent.cluster.link.intranet.connectivity.enable which can't be enabled dynamically due to startup component dependencies";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_TOTAL_BYTES_CONFIG = "confluent.cluster.link.fetch.response.total.bytes";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_MIN_BYTES_CONFIG = "confluent.cluster.link.fetch.response.min.bytes";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_TOTAL_BYTES_DOC = "Maximum amount of data fetched by all cluster link fetchers in the default fetcher pool in a broker. If total 'replica.fetch.response.max.bytes' for all fetchers in the default pool on the broker exceeds this value, all cluster link fetchers reduce their response size to meet this limit. Minimum value for each fetcher can be configured using 'confluent.cluster.link.fetch.response.min.bytes'.";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_MIN_BYTES_DOC = "Minimum fetch response size used by cluster link fetchers in the default pool if the total size is limited by 'confluent.cluster.link.fetch.response.total.bytes'.";
    public static final String CLUSTER_LINK_INSYNC_FETCH_RESPONSE_TOTAL_BYTES_CONFIG = "confluent.cluster.link.insync.fetch.response.total.bytes";
    public static final String CLUSTER_LINK_INSYNC_FETCH_RESPONSE_MIN_BYTES_CONFIG = "confluent.cluster.link.insync.fetch.response.min.bytes";
    public static final String CLUSTER_LINK_INSYNC_FETCH_RESPONSE_TOTAL_BYTES_DOC = "Maximum amount of data fetched by all cluster link fetchers in the in-sync fetcher pool in a broker when cluster links are configured to use isolated fetcher pools.  If total 'replica.fetch.response.max.bytes' for all fetchers on the broker exceeds this value, all in-sync cluster link fetchers reduce their response size to meet this limit. Minimum value for each fetcher can be configured using 'confluent.cluster.link.insync.fetch.response.min.bytes'.";
    public static final String CLUSTER_LINK_INSYNC_FETCH_RESPONSE_MIN_BYTES_DOC = "Minimum fetch response size used by in-sync cluster link fetchers in the in-sync pool if the total size is limited by 'confluent.cluster.link.insync.fetch.response.total.bytes'.";
    public static final String CLUSTER_LINK_IO_MAX_BYTES_PER_SECOND_CONFIG = "confluent.cluster.link.io.max.bytes.per.second";
    public static final String CLUSTER_LINK_IO_MAX_BYTES_PER_SECOND_DOC = "A long value representing the upper bound (bytes/sec) on throughput for cluster link replication. It is suggested that the limit be kept above 1MB/s for accurate behaviour.";
    public static final String CLUSTER_LINK_LOCAL_REVERSE_CONNECTION_LISTENER_MAP_CONFIG = "confluent.cluster.link.local.reverse.connection.listener.map";
    public static final String CLUSTER_LINK_LOCAL_REVERSE_CONNECTION_LISTENER_MAP_DOC = "A map from listener name to listener name for configuring the cluster link local.listener.name, which is used to establish local end of reverse connections.";
    public static final String CLUSTER_LINK_ALLOW_CONFIG_PROVIDERS_CONFIG = "confluent.cluster.link.allow.config.providers";
    public static final boolean CLUSTER_LINK_ALLOW_CONFIG_PROVIDERS_DEFAULT = true;
    public static final String CLUSTER_LINK_ALLOW_CONFIG_PROVIDERS_DOC = "Allow cluster link to use config providers to resolve the cluster link configurations.";
    public static final String CLUSTER_LINK_FETCHER_AUTO_TUNE_ENABLE_CONFIG = "confluent.cluster.link.fetcher.auto.tune.enable";
    public static final boolean CLUSTER_LINK_FETCHER_AUTO_TUNE_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_FETCHER_AUTO_TUNE_ENABLE_DOC = "Enable cluster link fetcher auto tuning. The number of cluster link fetchers will be automatically increased or decreased to achieve optimal cluster link throughput.";
    public static final String CLUSTER_LINK_ALLOW_TRUNCATION_BELOW_HWM_CONFIG = "confluent.cluster.link.allow.truncation.below.hwm";
    public static final boolean CLUSTER_LINK_ALLOW_TRUNCATION_BELOW_HWM_DEFAULT = false;
    public static final String CLUSTER_LINK_ALLOW_TRUNCATION_BELOW_HWM_DOC = "Allow cluster link to truncate the mirror topic partitions below high watermark. The value can be overwritten by cluster link configuration \"allow.truncation.below.high.watermark\".";
    public static final String CLUSTER_LINK_NUM_FETCHERS_CONFIG = "confluent.cluster.link.num.fetchers";
    public static final int CLUSTER_LINK_NUM_FETCHERS_DEFAULT = 1;
    public static final String CLUSTER_LINK_NUM_FETCHERS_DOC = "Number of fetchers used to replicate messages from source brokers in a cluster link. This is the maximum number of connections between each broker pair. If 'fetcher.thread.pool.mode=LINK', this is the maximum number of fetcher threads for the link, if 'fetcher.thread.pool.mode=ENDPOINT', this is the maximum number of fetcher threads for connections between each broker pair.";
    public static final String ENABLE_FIPS_CONNECT_DOC = "Enable FIPS mode on the server. If FIPS mode is enabled, worker listener security protocols, TLS versions and cipher suites and rest protocols will be validated based on FIPS compliance requirement.";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_CONFIG = "confluent.cluster.link.replication.quota.mode";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_DOC = "The default mode for cluster link quota for all tenants that applies to 'confluent.cluster.link.io.max.bytes.per.second' if not overridden by confluent.cluster.link.replication.quota.mode.per.tenant.overrides. The mode indicates which inbound traffic is counted towards the limit. Valid values are '" + String.valueOf((Object)ClusterLinkQuotaMode.CLUSTER_LINK_ONLY) + "' and '" + String.valueOf((Object)ClusterLinkQuotaMode.TOTAL_INBOUND) + "'.";
    public static final String CLUSTER_LINK_TENANT_REPLICATION_QUOTA_ENABLE_CONFIG = "confluent.cluster.link.tenant.replication.quota.enable";
    public static final boolean CLUSTER_LINK_TENANT_REPLICATION_QUOTA_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_TENANT_REPLICATION_QUOTA_ENABLE_DOC = "Enable tenant replication quotas for cluster linking on this cluster.";
    public static final String CLUSTER_LINK_TENANT_REQUEST_QUOTA_ENABLE_CONFIG = "confluent.cluster.link.tenant.request.quota.enable";
    public static final boolean CLUSTER_LINK_TENANT_REQUEST_QUOTA_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_TENANT_REQUEST_QUOTA_ENABLE_DOC = "Enable tenant request quotas for cluster linking on this cluster, this will be true for multi tenant clusters and false for dedicated clusters.";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_PER_TENANT_OVERRIDES_CONFIG = "confluent.cluster.link.replication.quota.mode.per.tenant.overrides";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_PER_TENANT_OVERRIDES_DEFAULT = "";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_PER_TENANT_OVERRIDES_DOC = "A comma-separated list of per-tenant overrides to the default cluster link quota mode. An example value is \"lkc-abcd:CLUSTER_LINK_ONLY\",\"lkc-efgh:TOTAL_INBOUND\"";
    public static final String CLUSTER_LINK_MAX_CLIENT_CONNECTIONS_CONFIG = "confluent.cluster.link.max.client.connections";
    public static final int CLUSTER_LINK_MAX_CLIENT_CONNECTIONS_DEFAULT = Integer.MAX_VALUE;
    public static final String CLUSTER_LINK_MAX_CLIENT_CONNECTIONS_DOC = "The maximum number of active cluster linking client connections allowed on the broker.";
    public static final String NUM_CLUSTER_LINK_REPLICATION_QUOTAS_SAMPLES_CONFIG = "confluent.cluster.link.replication.quota.window.num";
    public static final String NUM_CLUSTER_LINK_REPLICATION_QUOTAS_SAMPLES_DOC = "The number of samples to retain in memory for cluster link replication quotas";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS_CONFIG = "confluent.cluster.link.replication.quota.window.size.seconds";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS_DOC = "The time span of each sample for cluster link replication quotas";
    public static final String CLUSTER_LINK_REQUEST_QUOTA_CAPACITY_CONFIG = "confluent.cluster.link.request.quota.capacity";
    public static final String CLUSTER_LINK_REQUEST_QUOTA_CAPACITY_DOC = "The total capacity i.e. broker quota limit for the total amount of time cluster link requests can spend on fetcher and background threads if tenant quotas are enabled. This is configured as total percentage of CPU i.e. a value of 400 means cluster link can use up to 4 CPUs.";
    public static final String CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_CONFIG = "confluent.cluster.link.request.quota.request.percentage.multiplier";
    public static final Double CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_DEFAULT = 1.0;
    public static final String CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_DOC = "The multiplier used to derive broker cluster link request percentage from the broker request percentage, for e.g. a multiplier of 0.1 gives 10% request capacity to cluster link of what the normal produce/consume gets, the default value is 1.0.";
    public static final String CLUSTER_LINK_METADATA_TOPIC_ENABLE_CONFIG = "confluent.cluster.link.metadata.topic.enable";
    public static final String CLUSTER_LINK_METADATA_TOPIC_ENABLE_DOC = "Whether the cluster link metadata topic should be created and used. The leader of each of this topic's partitions can run asynchronous tasks across multiple links. This is used to distribute work for the tasks across the links, instead of running all tasks on the Kafka Controller. This config is only relevant for ZK mode in cases where there are multiple cluster links, and must be set prior to migrating to KRaft. In KRaft mode, this config is always true.";
    public static final String CLUSTER_LINK_METADATA_TOPIC_PARTITIONS_CONFIG = "confluent.cluster.link.metadata.topic.partitions";
    public static final String CLUSTER_LINK_METADATA_TOPIC_PARTITIONS_DOC = "Number of partitions for the cluster linking metadata topic";
    public static final int CLUSTER_LINK_METADATA_TOPIC_NUM_PARTITIONS_DEFAULT = 50;
    public static final String CLUSTER_LINK_METADATA_TOPIC_REPLICATION_FACTOR_CONFIG = "confluent.cluster.link.metadata.topic.replication.factor";
    public static final String CLUSTER_LINK_METADATA_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor the for the cluster linking metadata topic";
    public static final String CLUSTER_LINK_METADATA_TOPIC_MIN_ISR_CONFIG = "confluent.cluster.link.metadata.topic.min.isr";
    public static final String CLUSTER_LINK_METADATA_TOPIC_MIN_ISR_DOC = "The minimum number of in sync replicas for the cluster linking metadata topic";
    public static final String CLUSTER_LINK_METADATA_TOPIC_CREATE_RETRY_DELAY_MS_CONFIG = "confluent.cluster.link.metadata.topic.create.retry.delay.ms";
    public static final String CLUSTER_LINK_METADATA_TOPIC_CREATE_RETRY_DELAY_MS_DOC = "The retry delay in milliseconds when the attempt to create cluster linking metadata topic is failed";
    public static final String CLUSTER_LINK_ALLOW_LEGACY_MESSAGE_FORMAT_CONFIG = "confluent.cluster.link.allow.legacy.message.format";
    public static final Boolean CLUSTER_LINK_ALLOW_LEGACY_MESSAGE_FORMAT_DEFAULT = false;
    public static final String CLUSTER_LINK_ALLOW_LEGACY_MESSAGE_FORMAT_DOC = "Whether or not to allow mirroring v0/v1 messages into the topic";
    public static final String CLUSTER_LINK_ENABLE_LOCAL_ADMIN_CONFIG = "confluent.cluster.link.enable.local.admin";
    public static final Boolean CLUSTER_LINK_ENABLE_LOCAL_ADMIN_DEFAULT = false;
    public static final String CLUSTER_LINK_ENABLE_LOCAL_ADMIN_DOC = "Whether internal cluster link operations may use an optimized local admin that obtains metadata from its metadata cache and sends some requests directly to KRaft controller.";
    public static final String CLUSTER_LINK_LOCAL_ADMIN_MULTITENANT_ENABLE_CONFIG = "confluent.cluster.link.local.admin.multitenant.enable";
    public static final Boolean CLUSTER_LINK_LOCAL_ADMIN_MULTITENANT_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_LOCAL_ADMIN_MULTITENANT_ENABLE_DOC = "Whether separate local admin clients should be used for each tenant to enable tenant quotas and policies to be applied for requests from the client to the KRaft controller.";
    public static final String CLUSTER_LINK_ENABLE_METRICS_REDUCTION_CONFIG = "confluent.cluster.link.enable.metrics.reduction";
    public static final Boolean CLUSTER_LINK_ENABLE_METRICS_REDUCTION_DEFAULT = false;
    public static final String CLUSTER_LINK_ENABLE_METRICS_REDUCTION_DOC = "Controls whether certain metrics emitted per link are reduced to emit only when they have a non default value.";
    public static final String CLUSTER_LINK_ENABLE_METRICS_REDUCTION_ADVANCED_CONFIG = "confluent.cluster.link.enable.metrics.reduction.advanced";
    public static final Boolean CLUSTER_LINK_ENABLE_METRICS_REDUCTION_ADVANCED_DEFAULT = false;
    public static final String CLUSTER_LINK_ENABLE_METRICS_REDUCTION_ADVANCED_DOC = "Controls whether certain advanced metrics reduction features like link cardinality collapse by using a placeholder are enabled, this feature breaks backward compatibility so it should be enabled with caution.";
    public static final String CLUSTER_LINK_NUM_BACKGROUND_THREADS_CONFIG = "confluent.cluster.link.num.background.threads";
    public static final int CLUSTER_LINK_NUM_BACKGROUND_THREADS_DEFAULT = 1;
    public static final String CLUSTER_LINK_NUM_BACKGROUND_THREADS_DOC = "Maximum number of threads used for cluster linking background tasks including periodic migration of metadata.";
    public static final String CLUSTER_LINK_BACKGROUND_THREAD_AFFINITY_CONFIG = "confluent.cluster.link.background.thread.affinity";
    public static final ClusterLinkThreadAffinity CLUSTER_LINK_BACKGROUND_THREAD_AFFINITY_DEFAULT = ClusterLinkThreadAffinity.LINK;
    public static final String CLUSTER_LINK_BACKGROUND_THREAD_AFFINITY_DOC = "Indicates the grouping of cluster links for allocation of background scheduler threads configured using confluent.cluster.link.num.background.threads. Valid values are " + new HashSet<ClusterLinkThreadAffinity>(Arrays.asList(ClusterLinkThreadAffinity.values())).stream().map(Enum::toString).collect(Collectors.joining(",")) + " By default, all tasks of a link share the same thread.";
    public static final String CLUSTER_LINK_CLIENTS_MAX_IDLE_MS_CONFIG = "confluent.cluster.link.clients.max.idle.ms";
    public static final Long CLUSTER_LINK_CLIENTS_MAX_IDLE_MS_DEFAULT = TimeUnit.MILLISECONDS.convert(36500L, TimeUnit.DAYS);
    public static final String CLUSTER_LINK_CLIENTS_MAX_IDLE_MS_DOC = "The interval in milliseconds after which idle cluster link clients and associated threads are closed.";
    public static final String CLUSTER_LINK_MIRROR_TRANSITION_BATCH_SIZE_CONFIG = "confluent.cluster.link.mirror.transition.batch.size";
    public static final int CLUSTER_LINK_MIRROR_TRANSITION_BATCH_SIZE_DEFAULT = 10;
    public static final String CLUSTER_LINK_MIRROR_TRANSITION_BATCH_SIZE_DOC = "The maximum number of mirror topic transition tasks that are run concurrently while processing mirror state transitions like promote, failover and failback. In multi-tenant environments, this limit may be exceeded to guarantee that at least one task is run for each tenant, even if all running tasks of other tenants are blocked.";
    public static final String CLUSTER_LINK_PERIODIC_TASK_BATCH_SIZE_CONFIG = "confluent.cluster.link.periodic.task.batch.size";
    public static final int CLUSTER_LINK_PERIODIC_TASK_BATCH_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final String CLUSTER_LINK_PERIODIC_TASK_BATCH_SIZE_DOC = "The maximum number of periodic cluster link tasks that are run concurrently. In multi-tenant environments, this limit may be exceeded to guarantee that at least one task is run for each tenant when ready, even if all running tasks of other tenants are blocked.";
    public static final String CLUSTER_LINK_PERIODIC_TASK_BATCH_INTERVAL_MS_CONFIG = "confluent.cluster.link.periodic.task.min.interval.ms";
    public static final int CLUSTER_LINK_PERIODIC_TASK_BATCH_INTERVAL_MS_DEFAULT = 1000;
    public static final String CLUSTER_LINK_PERIODIC_TASK_BATCH_INTERVAL_MS_DOC = "Minimum interval between iterations for periodic cluster link background tasks when batching is enabled.  Tasks are considered for execution in the next iteration after they become ready.";
    public static final String CLUSTER_LINK_ADMIN_REQUEST_BATCH_SIZE_CONFIG = "confluent.cluster.link.admin.request.batch.size";
    public static final int CLUSTER_LINK_ADMIN_REQUEST_BATCH_SIZE_DEFAULT = 1;
    public static final String CLUSTER_LINK_ADMIN_REQUEST_BATCH_SIZE_DOC = "The maximum number of mirror topics, partitions or consumer groups from multiple background task admin requests that may be batched together. No batching is performed with the default size of 1. Individual requests containing resources exceeding this limit are processed as-is without splitting.";
    public static final String CLUSTER_LINK_ADMIN_MAX_IN_FLIGHT_REQUESTS_CONFIG = "confluent.cluster.link.admin.max.in.flight.requests";
    public static final int CLUSTER_LINK_ADMIN_MAX_IN_FLIGHT_REQUESTS_DEFAULT = 1000;
    public static final String CLUSTER_LINK_ADMIN_MAX_IN_FLIGHT_REQUESTS_DOC = "The maximum number of in-flight requests that are queued on a cluster link admin client when batching is enabled with confluent.cluster.link.admin.request.batch.size greater than 1.";
    public static final String CLUSTER_LINK_AVAILABILITY_CHECK_MODE_CONFIG = "confluent.cluster.link.availability.check.mode";
    public static final ClusterLinkAvailabilityCheckMode CLUSTER_LINK_AVAILABILITY_CHECK_MODE_DEFAULT = ClusterLinkAvailabilityCheckMode.ALL;
    public static final String CLUSTER_LINK_AVAILABILITY_CHECK_MODE_DOC = "Configure the brokers on which remote availability check is scheduled for cluster links.";
    public static final String CLUSTER_LINK_SWITCHOVER_ENABLE_CONFIG = "confluent.cluster.link.switchover.enable";
    public static final boolean CLUSTER_LINK_SWITCHOVER_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_SWITCHOVER_ENABLE_DOC = "Specifies if client switchover using cluster linking is enabled.";
    public static final String CLUSTER_LINK_SWITCHOVER_LISTENERS_CONFIG = "confluent.cluster.link.switchover.listeners";
    public static final List<String> CLUSTER_LINK_SWITCHOVER_LISTENERS_DEFAULT = Collections.emptyList();
    public static final String CLUSTER_LINK_SWITCHOVER_LISTENERS_DOC = "Comma separated list of listeners on which client switchover is enabled if confluent.cluster.link.switchover.enable=true.";
    public static final String CLUSTER_LINK_SWITCHOVER_SERVER_STATES_CONFIG = "confluent.cluster.link.switchover.server.states";
    public static final List<String> CLUSTER_LINK_SWITCHOVER_SERVER_STATES_DEFAULT = Collections.emptyList();
    public static final String CLUSTER_LINK_SWITCHOVER_SERVER_STATES_DOC = "Switchover states for this cluster, configured as a comma separated list. Each switchover state is of the format 'link=unprefixedLinkName:primary=clusterId1:secondary=clusterId2'. On Confluent Cloud, switchover state is persisted in a global switchover resource, but we may override the value using this dynamic broker configuration for Operations. If not overridden using this dynamic broker config, the value in the global switchover resource will be used.";
    public static final String CLUSTER_LINK_SWITCHOVER_DISABLED_PRINCIPALS_CONFIG = "confluent.cluster.link.switchover.disabled.principals";
    public static final List<String> CLUSTER_LINK_SWITCHOVER_DISABLED_PRINCIPALS_DEFAULT = Collections.emptyList();
    public static final String CLUSTER_LINK_SWITCHOVER_DISABLED_PRINCIPALS_DOC = "Comma-separated user principals of clients for which switchover is disabled. By default, all non-internal clients on the listeners configured in 'confluent.cluster.link.switchover.listeners' have switchover enabled. This dynamic broker config may be used to disable switchover of specific clients for Operations.";
    public static final String CLIENT_SWITCHOVER_DISABLE_CONFIG = "confluent.client.switchover.disable";
    public static final boolean CLIENT_SWITCHOVER_DISABLE_DEFAULT = false;
    public static final String CLIENT_SWITCHOVER_DISABLE_DOC = "Client configuration option that specifies if switchover should be disabled for the client even if switchover is enabled on the broker. This is an internal config used to disable client switchover in internal clients.";
    public static final String CLUSTER_LINK_PERSISTENT_CONNECTION_BACKOFF_MAX_MS_CONFIG = "confluent.cluster.link.persistent.connection.backoff.max.ms";
    public static final long CLUSTER_LINK_PERSISTENT_CONNECTION_BACKOFF_MAX_MS_DEFAULT = 0L;
    public static final String CLUSTER_LINK_PERSISTENT_CONNECTION_BACKOFF_MAX_MS_DOC = "The max backoff time in milliseconds between each persistent connection, if set the value to 0, there won't be backoff.";
    public static final String CLUSTER_LINK_K1_TO_K2_MIGRATION_ENABLE_CONFIG = "confluent.cluster.link.k1.to.k2.migration.enable";
    public static final boolean CLUSTER_LINK_K1_TO_K2_MIGRATION_ENABLE_CONFIG_DEFAULT = false;
    public static final String CLUSTER_LINK_K1_TO_K2_MIGRATION_ENABLE_CONFIG_DOC = "Enables migration from K1 clusters including Apache Kafka and Confluent Platform clusters to K2 using K1 cluster linking implementation.";
    public static final String CCLOUD_HOST_SUFFIXES_CONFIG = "confluent.ccloud.host.suffixes";
    public static final String CCLOUD_HOST_SUFFIXES_DEFAULT = ".confluent.cloud,.cpdev.cloud,.confluentgov.com,.confluentgov-internal.com";
    public static final String CCLOUD_HOST_SUFFIXES_DOC = "Comma separated list of confluent cloud host suffixes used to determine things like whether this is a cloud to cloud cluster link. It MUST BE SPECIFIED IN CCLOUD environment!. An example of config value is \".cpdev.cloud,.confluent.cloud\" ";
    public static final String CCLOUD_INTRANET_HOST_SUFFIXES_CONFIG = "confluent.ccloud.intranet.host.suffixes";
    public static final String CCLOUD_INTRANET_HOST_SUFFIXES_DEFAULT = ".intranet.stag.cpdev.cloud,.intranet.stag.cpdev-untrusted.cloud,.intranet.devel.cpdev.cloud,.intranet.devel.cpdev-untrusted.cloud,.intranet.confluent.cloud,.intranet.confluent-untrusted.cloud";
    public static final String CCLOUD_INTRANET_HOST_SUFFIXES_DOC = "Comma separated list of host suffixes used to determine things like whether this is a  confluent cloud intranet endpoint. It MUST BE SPECIFIED IN CCLOUD environment!. An example of config value is \".intranet.devel.cpdev.cloud,.intranet.confluent.cloud\" ";
    public static final String CCLOUD_REVOKED_CERTIFICATE_IDS_CONFIG = "confluent.security.revoked.certificate.ids";
    public static final String CCLOUD_REVOKED_CERTIFICATE_IDS_DEFAULT = "";
    public static final String CCLOUD_REVOKED_CERTIFICATE_IDS_DOC = "JSON configuration for revoked certificate ids, this is used to block mTLS authentication of revoked certificates. The format of property is [{\"issuer\":\"C = US, O = Let's Encrypt, CN = R3\",\"serialNumbers\":[\"b5f6f3b84479c5e8\",\"618f7a9150bfb1bb\"]}] and the issuer is in RFC 2253 format. The serialNumbers is a list of hex encoded serial numbers without the colon.";
    public static final String INTERNAL_REST_SERVER_BIND_PORT_CONFIG = "confluent.internal.rest.server.bind.port";
    public static final Integer INTERNAL_REST_SERVER_BIND_PORT_DEFAULT = null;
    public static final String INTERNAL_REST_SERVER_BIND_PORT_DOC = "The port to bind the internal rest server to.";
    public static final String INTERNAL_REST_SERVER_SSL_ENABLED_CONFIG = "confluent.internal.rest.server.ssl.enable";
    public static final Boolean INTERNAL_REST_SERVER_SSL_ENABLED_DEFAULT = false;
    public static final String INTERNAL_REST_SERVER_SSL_ENABLED_DOC = "Whether to enable SSL for internal broker rest server, defaults to false";
    public static final String HTTP_SERVER_START_TIMEOUT_MS_CONFIG = "confluent.http.server.start.timeout.ms";
    public static final Long HTTP_SERVER_START_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
    public static final String HTTP_SERVER_START_TIMEOUT_MS_DOC = "How long to wait for the Kafka HTTP server to start up, in milliseconds. Default is 60s.";
    public static final String HTTP_SERVER_STOP_TIMEOUT_MS_CONFIG = "confluent.http.server.stop.timeout.ms";
    public static final Long HTTP_SERVER_STOP_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(30L).toMillis();
    public static final String HTTP_SERVER_STOP_TIMEOUT_MS_DOC = "How long to wait for the Kafka HTTP server to shutdown, in milliseconds. Default is 30s.";
    public static final String RESOURCE_LABEL_PREFIX = "resource.";
    public static final String RESOURCE_LABEL_TYPE = "resource.type";
    public static final String RESOURCE_LABEL_VERSION = "resource.version";
    public static final String RESOURCE_LABEL_COMMIT_ID = "resource.commit.id";
    public static final String MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.broker.max.producer.rate";
    public static final String MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_DOC = "Maximum producer quota in bytes/s per tenant per broker";
    public static final long MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_DEFAULT = 0xC80000L;
    public static final String MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.broker.max.consumer.rate";
    public static final String MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_DOC = "Maximum consumer quota in bytes/s per tenant per broker";
    public static final long MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_DEFAULT = 0xC80000L;
    public static final String INTERNAL_TENANT_THROTTLING_ENABLE_CONFIG = "confluent.quota.tenant.internal.throttling.enable";
    public static final String INTERNAL_TENANT_THROTTLING_ENABLE_DOC = "Whether or not internal tenant throttling is enabled";
    public static final boolean INTERNAL_TENANT_THROTTLING_ENABLE_DEFAULT = false;
    public static final String MAX_BROKER_INTERNAL_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.internal.broker.max.producer.rate";
    public static final String MAX_BROKER_INTERNAL_TENANT_PRODUCER_BYTE_RATE_DOC = "Maximum produce quota in bytes/s per internal tenant per broker";
    public static final long MAX_BROKER_INTERNAL_TENANT_PRODUCER_BYTE_RATE_DEFAULT = Long.MAX_VALUE;
    public static final String MAX_BROKER_INTERNAL_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.internal.broker.max.consumer.rate";
    public static final String MAX_BROKER_INTERNAL_TENANT_CONSUMER_BYTE_RATE_DOC = "Maximum consumer quota in bytes/s per internal tenant per broker";
    public static final long MAX_BROKER_INTERNAL_TENANT_CONSUMER_BYTE_RATE_DEFAULT = Long.MAX_VALUE;
    public static final String MAX_BROKER_INTERNAL_TENANT_CONTROLLER_MUTATION_RATE_CONFIG = "confluent.quota.tenant.internal.broker.max.controller.mutation.rate";
    public static final String MAX_BROKER_INTERNAL_TENANT_CONTROLLER_MUTATION_RATE_DOC = "Maximum controller mutation quota in bytes/s per internal tenant per broker";
    public static final long MAX_BROKER_INTERNAL_TENANT_CONTROLLER_MUTATION_RATE_DEFAULT = Long.MAX_VALUE;
    public static final String DEFAULT_PRODUCER_ID_RATE_PER_TENANT_CONFIG = "confluent.quota.tenant.default.producer.id.rate";
    public static final String DEFAULT_PRODUCER_ID_RATE_PER_TENANT_DOC = "Producer id quota count per tenant per broker";
    public static final double DEFAULT_PRODUCER_ID_RATE_PER_TENANT_DEFAULT = 2.147483647E9;
    public static final String TENANT_USER_QUOTAS_ENABLE_CONFIG = "confluent.quota.tenant.user.quotas.enable";
    public static final String TENANT_USER_QUOTAS_ENABLE_DOC = "If enabled, return service-account quotas from TenantQuotaCallback.";
    public static final boolean TENANT_USER_QUOTAS_ENABLE_DEFAULT = false;
    public static final String MULTITENANT_LISTENER_PREFIX_ENABLE = "confluent.multitenant.listener.hostname.cluster.prefix.enable";
    public static final String MULTITENANT_LISTENER_PREFIX_ENABLE_DOC = "If enabled, return tenant-specific broker endpoints by prepending tenant cluster id to the advertised hostname configured for multi-tenant listeners";
    public static final boolean MULTITENANT_LISTENER_PREFIX_ENABLE_DEFAULT = false;
    public static final String PARSE_SNI_HOST_NAME_ENABLED = "confluent.multitenant.parse.sni.host.name.enable";
    public static final String PARSE_SNI_HOST_NAME_ENABLED_DOC = "When enabled, parse the SNI host name upon SASL_SSL connection establishment.";
    public static final boolean PARSE_SNI_HOST_NAME_ENABLED_DEFAULT = false;
    public static final String PARSE_LKC_ID_ENABLED_CONFIG = "confluent.multitenant.parse.lkc.id.enable";
    public static final String PARSE_LKC_ID_ENABLED_DOC = "When enabled, parse the LKC Id upon SASL_SSL connection establishment.";
    public static final boolean PARSE_LKC_ID_ENABLED_DEFAULT = false;
    public static final String PPV2_ENDPOINT_SCHEME_ENABLE = "confluent.ppv2.endpoint.scheme.enable";
    public static final String PPV2_ENDPOINT_SCHEME_ENABLE_DOC = "If enabled, the broker endpoints are generated from fqdn properties such as fqdn-template, in proxy protocol v2 headers.";
    public static final boolean PPV2_ENDPOINT_SCHEME_ENABLE_DEFAULT = false;
    public static final String PPV2_ENDPOINT_SCHEME_MAP_BROKER_ZONE_TO_GATEWAY_ZONE_ENABLE = "confluent.ppv2.endpoint.scheme.map.broker.zone.to.gateway.zone";
    public static final String PPV2_ENDPOINT_SCHEME_MAP_BROKER_ZONE_TO_GATEWAY_ZONE_ENABLE_DOC = "If true, broker zonal endpoints are generated using gateway zones. Each broker zone is mapped to a gateway zone. And the mapped gateway zone is used in the zonal endpoint. Otherwise, broker zone is used as it is in the broker zonal endpoint.";
    public static final boolean PPV2_ENDPOINT_SCHEME_MAP_BROKER_ZONE_TO_GATEWAY_ZONE_ENABLE_DEFAULT = false;
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATES = "confluent.ppv2.endpoint.scheme.templates";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATES_DOC = "Relevant when PPV2_ENDPOINT_SCHEME_ENABLE is true. A comma separated list of mappings( ex - <mapping1>,<mapping2> .. <mappingN).\nEach <mapping> represents a fqdn-template in to format of <templateId>:<fqdn-template-string>. Example - \nAccessPointV1:$svcId-$accessPointId.$region.$cloud.accesspoint.glb.confluent.cloud,AccessPointTargetedZonalV1:$svcId-$targetId-$accessPointId.$zoneId.$region.$cloud.accesspoint.glb.confluent.cloud\nThis example has 2 templates corresponding to template-ids, AccessPointV1 and AccessPointTargetedZonalV1.";
    public static final String PPV2_ENDPOINT_SCHEME_BOOTSTRAP_BROKER_TEMPLATE_MAPPINGS = "confluent.ppv2.endpoint.scheme.bootstrap.broker.template.mappings";
    public static final String PPV2_ENDPOINT_SCHEME_BOOSTRAP_BROKER_TEMPLATE_MAPPINGS_DOC = "Relevant when PPV2_ENDPOINT_SCHEME_ENABLE is true. A comma separated list of mappings( ex - <boostrap_templateId1>:<broker_templateId1>,<boostrap_templateId2>:<broker_templateId2>).\nThis will be used to lookup the broker's fqdn template from corresponding incoming bootstrap template. Example would be - \nAccessPointV1:AccessPointTargetedZonalV1";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATE_VARIABLES = "confluent.ppv2.endpoint.scheme.template.variables";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATE_VARIABLES_DOC = "Relevant when PPV2_ENDPOINT_SCHEME_ENABLE is true. A comma separated list of variables( ex - <variable1>,<variable2> .. <variableN).\nThis is an exhaustive list of template variables possible in fqdn-templates, Ex - \n{$svcId, $regionId, $zoneId, $cloudId, $accessPointId, $targetId}";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATE_VARIABLE_REGION = "confluent.ppv2.endpoint.scheme.template.variable.region";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATE_VARIABLE_REGION_DOC = "Relevant when PPV2_ENDPOINT_SCHEME_ENABLE is true. The value of $region template variable.";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATE_VARIABLE_CLOUD = "confluent.ppv2.endpoint.scheme.template.variable.cloud";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATE_VARIABLE_CLOUD_DOC = "Relevant when PPV2_ENDPOINT_SCHEME_ENABLE is true. The value of $cloud template variable.";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATE_VARIABLE_DOMAIN = "confluent.ppv2.endpoint.scheme.template.variable.domain";
    public static final String PPV2_ENDPOINT_SCHEME_TEMPLATE_VARIABLE_DOMAIN_DOC = "Relevant when PPV2_ENDPOINT_SCHEME_ENABLE is true. The value of $domain template variable.";
    public static final String TOPIC_REPLICA_ASSIGNOR_BUILDER = "confluent.topic.replica.assignor.builder.class";
    public static final String TOPIC_REPLICA_ASSIGNOR_DOC = "The configurable builder class for the replica assignor used to assign replicas on topic/partition creation without explicit assignment.";
    public static final String TOPIC_REPLICA_ASSIGNOR_DEFAULT = "";
    public static final String SPIFFE_ID_PRINCIPAL_EXTRACTION_RULES = "confluent.spiffe.id.principal.extraction.rules";
    public static final String SPIFFE_ID_PRINCIPAL_EXTRACTION_RULES_DOC = "Used to specify the rules for mapping SPIFFE IDs to principals. The parameter can be either an empty string (\"\") or a list of rules separated by commas. Each rule follows the format \"RULE:(regex)!(extraction logic)!(case)\". A rule comprises three parts separated by \"!\": a regular expression to match the incoming SPIFFE ID, a pattern for extracting the principal if the ID matches, and an optional specification for converting the extracted principal to uppercase (U) or lowercase (L). Multiple rules can be provided, each separated by commas.";
    public static final String SPIFFE_ID_PRINCIPAL_EXTRACTION_RULES_DEFAULT = "";
    public static final String METADATA_COLLECTOR_ENABLE = "confluent.catalog.collector.enable";
    public static final String METADATA_COLLECTOR_ENABLE_DOC = "When enabled, collect metadata for catalog.";
    public static final boolean METADATA_COLLECTOR_ENABLE_DEFAULT = false;
    public static final String METADATA_COLLECTOR_FULL_CONFIGS_ENABLE = "confluent.catalog.collector.full.configs.enable";
    public static final String METADATA_COLLECTOR_FULL_CONFIGS_ENABLE_DOC = "When enabled, collect full topic configs. Other wise collect subset of topic configs";
    public static final boolean METADATA_COLLECTOR_FULL_CONFIGS_ENABLE_DEFAULT = false;
    public static final String METADATA_COLLECTOR_SNAPSHOT_INITIAL_DELAY_SEC = "confluent.catalog.collector.snapshot.init.delay.sec";
    public static final String METADATA_COLLECTOR_SNAPSHOT_INITIAL_DELAY_DOC = "The configurable initial delay in seconds for the collector to take snapshot";
    public static final int METADATA_COLLECTOR_SNAPSHOT_INITIAL_DELAY_DEFAULT = 60;
    public static final String METADATA_COLLECTOR_SNAPSHOT_INTERVAL_SEC = "confluent.catalog.collector.snapshot.interval.sec";
    public static final String METADATA_COLLECTOR_SNAPSHOT_INTERVAL_DOC = "The configurable interval in seconds for the collector to take snapshot";
    public static final int METADATA_COLLECTOR_SNAPSHOT_INTERVAL_DEFAULT = 300;
    public static final String METADATA_COLLECTOR_DESTINATION_TOPIC = "confluent.catalog.collector.destination.topic";
    public static final String METADATA_COLLECTOR_DESTINATION_TOPIC_DOC = "The topic where metadata collector will emit events to.";
    public static final String METADATA_COLLECTOR_DESTINATION_TOPIC_DEFAULT = "telemetry.events.data_catalog_source";
    public static final String METADATA_COLLECTOR_MAX_BYTES_PER_SNAPSHOT = "confluent.catalog.collector.max.bytes.per.snapshot";
    public static final String METADATA_COLLECTOR_MAX_BYTES_PER_SNAPSHOT_DOC = "The maximum bytes allow per snapshot";
    public static final Integer METADATA_COLLECTOR_MAX_BYTES_PER_SNAPSHOT_DEFAULT = 850000;
    public static final String METADATA_COLLECTOR_MAX_ZOOKEEPER_REQUEST_PER_SEC = "confluent.catalog.collector.max.zookeeper.request.per.sec";
    public static final String METADATA_COLLECTOR_MAX_ZOOKEEPER_REQUEST_PER_SEC_DOC = "The maximum number of requests per second that collector allow to make to zookeeper";
    public static final Integer METADATA_COLLECTOR_MAX_ZOOKEEPER_REQUEST_PER_SEC_DEFAULT = 100;
    public static final String METADATA_COLLECTOR_MAX_TOPICS_PROCESS = "confluent.catalog.collector.max.topics.process";
    public static final String METADATA_COLLECTOR_MAX_TOPICS_PROCESS_DOC = "The maximum number of topics in batch that collector allow to process when start up. This config only apply for zookeeper based controller.";
    public static final Integer METADATA_COLLECTOR_MAX_TOPICS_PROCESS_DEFAULT = 500;
    public static final String METADATA_COLLECTOR_MULTITENANT_TOPICS_ENABLE = "confluent.catalog.collector.multitenant.topics.enable";
    public static final String METADATA_COLLECTOR_MULTITENANT_TOPICS_ENABLE_DOC = "When enabled, collect metadata for tenant topics only. Other wise collect metadata for all topics. Should always be true for CCloud";
    public static final boolean METADATA_COLLECTOR_MULTITENANT_TOPICS_ENABLE_DEFAULT = true;
    public static final String METADATA_RBAC_AUTH_UPDATE_CONTROLLER_ENABLE = "confluent.metadata.rbac_auth.update.controller.enable";
    public static final boolean METADATA_RBAC_AUTH_UPDATE_CONTROLLER_ENABLE_DEFAULT = false;
    public static final String METADATA_RBAC_AUTH_UPDATE_CONTROLLER_ENABLE_DOC = "flag to enable rbac auth rules write to controller logs";
    public static final String METADATA_RBAC_AUTH_READ_CONTROLLER_ENABLE = "confluent.metadata.rbac_auth.read.controller.enable";
    public static final boolean METADATA_RBAC_AUTH_READ_CONTROLLER_ENABLE_DEFAULT = false;
    public static final String METADATA_RBAC_AUTH_READ_CONTROLLER_ENABLE_DOC = "flag to enable rbac auth rules read from controller logs";
    public static final String DELAY_CLOSING_INVALID_REQUEST_ENABLE = "confluent.connection.invalid.request.delay.enable";
    public static final String DELAY_CLOSING_INVALID_REQUEST_ENABLE_DOC = "When enabled, delay closing connections that fail in request parsing.The delay used will be from `\"connection.failed.authentication.delay.ms\"`";
    public static final boolean DELAY_CLOSING_INVALID_REQUEST_ENABLE_DEFAULT = false;
    public static final String MAX_CONNECTIONS_PER_TENANT = "max.connections.per.tenant";
    public static final String MAX_CONNECTIONS_PER_TENANT_DOC = "The maximum number of connections we allow from each tenant. This can be set to 0 if there are overrides configured using 'max.connections.per.tenant' property. New connections from the tenant are dropped if the limit is reached.";
    public static final int MAX_CONNECTIONS_PER_TENANT_DEFAULT = 0;
    public static final String MAX_CONNECTION_CREATION_RATE_PER_IP = "confluent.max.connection.creation.rate.per.ip";
    public static final String MAX_CONNECTION_CREATION_RATE_PER_IP_DOC = "An int representing the upper bound of connection rate accepted for each IP. This config is a static equivalent to the dynamic connection_creation_rate quota for the default IP entity";
    public static final String MAX_CONNECTION_CREATION_RATE_PER_TENANT = "confluent.max.connection.creation.rate.per.tenant";
    public static final String MAX_CONNECTION_CREATION_RATE_PER_TENANT_DOC = "An int representing the upper bound of connection rate accepted for each tenant. This config is a static equivalent to the dynamic tenant connection_creation_rate quota for the default tenant entity";
    public static final String MAX_LISTENER_CONNECTION_RATE_PER_IP = "confluent.max.connection.rate.per.ip";
    public static final String MAX_LISTENER_CONNECTION_RATE_PER_IP_DOC = "A double representing the max for autotuning the connection rate accepted for each IP.";
    public static final String MAX_LISTENER_CONNECTION_RATE_PER_TENANT = "confluent.max.connection.rate.per.tenant";
    public static final String MAX_LISTENER_CONNECTION_RATE_PER_TENANT_DOC = "A double representing the max for autotuning the connection rate accepted for each tenant.";
    public static final String FLOOR_LISTENER_CONNECTION_RATE_PER_IP = "confluent.floor.connection.rate.per.ip";
    public static final String FLOOR_LISTENER_CONNECTION_RATE_PER_IP_DOC = "A double representing the floor for autotuning the connection rate accepted for each IP.";
    public static final String FLOOR_LISTENER_CONNECTION_RATE_PER_TENANT = "confluent.floor.connection.rate.per.tenant";
    public static final String FLOOR_LISTENER_CONNECTION_RATE_PER_TENANT_DOC = "A double representing the floor for autotuning the connection rate accepted for each tenant.";
    public static final String STEP_LISTENER_CONNECTION_RATE_PER_IP = "confluent.step.connection.rate.per.ip";
    public static final String STEP_LISTENER_CONNECTION_RATE_PER_IP_DOC = "A double representing the increment size for autotuning the connection rate accepted for each IP. Defaults to 0.0 (no autotuning).";
    public static final String STEP_LISTENER_CONNECTION_RATE_PER_TENANT = "confluent.step.connection.rate.per.tenant";
    public static final String STEP_LISTENER_CONNECTION_RATE_PER_TENANT_DOC = "A double representing the increment size for autotuning the connection rate accepted for each tenant. Defaults to 0.0 (no autotuning).";
    public static final String IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD = "max.connection.creation.rate.per.ip.enable.threshold";
    public static final String IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DOC = "A double representing the proportional threshold for listener connection rate after which to apply IP rate limits";
    public static final double IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DEFAULT = 0.0;
    public static final String TENANT_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD = "max.connection.creation.rate.per.tenant.enable.threshold";
    public static final String TENANT_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DOC = "A double representing the proportional threshold for listener connection rate after which to apply tenant rate limits";
    public static final double TENANT_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DEFAULT = 0.0;
    public static final String MAX_CONNECTION_THROTTLE_MS = "confluent.max.connection.throttle.ms";
    public static final String MAX_CONNECTION_THROTTLE_MS_DOC = "An int representing the max time in milliseconds to throttle accepting a connection. If not set \"quota.window.size.seconds\" will be used to bound connection acceptance throttling.";
    public static final Long MAX_CONNECTION_THROTTLE_MS_DEFAULT = null;
    public static final String MIN_CONNECTION_THROTTLE_MS = "confluent.min.connection.throttle.ms";
    public static final String MIN_CONNECTION_THROTTLE_MS_DOC = "An int representing the min time in milliseconds to throttle accepting a connection.";
    public static final Long MIN_CONNECTION_THROTTLE_MS_DEFAULT = 0L;
    public static final String IDLE_EXPIRY_MANAGER_IGNORE_IDLENESS_REQUESTS_CONFIG = "confluent.connections.idle.expiry.manager.ignore.idleness.requests";
    public static final String IDLE_EXPIRY_MANAGER_IGNORE_IDLENESS_REQUESTS_DEFAULT = "";
    public static final String IDLE_EXPIRY_MANAGER_IGNORE_IDLENESS_REQUESTS_DOC = "A list of request types, representing requests where idle expiry manager will ignore updating their idleness.";
    public static final String CONNECTIONS_MAX_AGE_MS = "connections.max.age.ms";
    public static final Long CONNECTIONS_MAX_AGE_MS_DEFAULT;
    public static final Long CONNECTIONS_MAX_AGE_MS_MAX;
    public static final String CONNECTIONS_MAX_AGE_MS_DOC;
    public static final String CONNECTIONS_MIN_EXPIRE_INTERVAL_MS = "connection.min.expire.interval.ms";
    public static final String CONNECTIONS_MIN_EXPIRE_INTERVAL_DOC = "Minimum interval in milliseconds between closing of expired connections on a single server socket processor thread.";
    public static final Long CONNECTIONS_MIN_EXPIRE_INTERVAL_DEFAULT;
    public static final String CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_CONFIG = "confluent.close.connections.on.credential.delete";
    public static final String CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_DOC = "When enabled, broker will terminate all existing connections using a deleted credential if the broker is notified of a deleted credential by a broker plugin that manages credentials.";
    public static final boolean CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_DEFAULT = false;
    public static final String PASSWORD_ENCODER_OLD_SECRET_TTL_MS_CONFIG = "confluent.password.encoder.old.secret.ttl.ms";
    public static final String PASSWORD_ENCODER_OLD_SECRET_TTL_MS_DOC = "The minimum amount of time in milliseconds that configs encrypted using old encryption secret 'password.encoder.old.secret' should be retained.";
    public static final long PASSWORD_ENCODER_OLD_SECRET_TTL_MS_DEFAULT = Long.MAX_VALUE;
    public static final String MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.follower.broker.min.producer.rate";
    public static final String MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_DOC = "Minimum producer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions";
    public static final long MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_DEFAULT = 0xA00000L;
    public static final String MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.follower.broker.min.consumer.rate";
    public static final String MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_DOC = "Minimum consumer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions";
    public static final long MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_DEFAULT = 0xA00000L;
    public static final String DURABILITY_AUDIT_ENABLE = "confluent.durability.audit.enable";
    public static final String DURABILITY_AUDIT_ENABLE_DOC = "If enabled, this will start the long-lived durability audits";
    public static final boolean DURABILITY_AUDIT_ENABLE_DEFAULT = false;
    public static final String DURABILITY_AUDIT_CHECKS = "confluent.durability.audit.checks";
    public static final String DURABILITY_AUDIT_CHECKS_DOC = "Comma-separated list of the audit checks types that will be allowed by AuditManager.";
    public static final String DURABILITY_AUDIT_CHECKS_DEFAULT = "PeriodicalAudit,ChecksumAudit";
    public static final String DURABILITY_ALLOWED_EVENTS = "confluent.durability.events.allowed";
    public static final String DURABILITY_ALLOWED_EVENTS_DOC = "Comma-separated list of the event types that will be accepted by AuditManager.";
    public static final String DURABILITY_ALLOWED_EVENTS_DEFAULT = "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType";
    public static final String DURABILITY_IGNORED_EVENTS_LOG_MESSAGE_ALLOWED_EVENTS = "confluent.durability.audit.log.ignored.event.types";
    public static final String DURABILITY_IGNORED_EVENTS_LOG_MESSAGE_ALLOWED_EVENTS_DOC = "Comma-separated list of the event types that are logged in INFO level when the events are ignored during materialization.";
    public static final String DURABILITY_IGNORED_EVENTS_LOG_MESSAGE_ALLOWED_EVENTS_DEFAULT = "";
    public static final String DURABILITY_AUDIT_IDEMPOTENT_PRODUCER = "confluent.durability.audit.idempotent.producer";
    public static final String DURABILITY_AUDIT_IDEMPOTENT_PRODUCER_DOC = "Option to use idempotent producer for durability audit";
    public static final boolean DURABILITY_AUDIT_IDEMPOTENT_PRODUCER_DEFAULT = false;
    public static final String DURABILITY_TOPIC_REPLICATION_FACTOR = "confluent.durability.topic.replication.factor";
    public static final String DURABILITY_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor of durability audit's internal topic";
    public static final Integer DURABILITY_TOPIC_REPLICATION_FACTOR_DEFAULT;
    public static final String DURABILITY_TOPIC_PARTITION_COUNT = "confluent.durability.topic.partition.count";
    public static final String DURABILITY_TOPIC_PARTITION_COUNT_DOC = "Partition count of durability audit's internal topic";
    public static final Integer DURABILITY_TOPIC_PARTITION_COUNT_DEFAULT;
    public static final String DURABILITY_AUDIT_IO_BYTES_PER_SEC = "confluent.durability.audit.io.bytes.per.sec";
    public static final String DURABILITY_AUDIT_IO_BYTES_PER_SEC_DOC = "The rate at which we want to throttle I/O operations in DA, current used only for compacted topics";
    public static final long DURABILITY_AUDIT_IO_BYTES_PER_SEC_DEFAULT = 0xA00000L;
    public static final String DURABILITY_AUDIT_REPORTING_BATCH_MS = "confluent.durability.audit.reporting.batch.ms";
    public static final String DURABILITY_AUDIT_REPORTING_BATCH_MS_DOC = "Time to linger and consolidate durability audit error metrics before reporting";
    public static final Integer DURABILITY_AUDIT_REPORTING_BATCH_MS_DEFAULT;
    public static final String DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS = "confluent.durability.audit.batch.flush.frequency.ms";
    public static final String DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DOC = "Frequency of flushing batch events of durability audit";
    public static final Integer DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DEFAULT;
    public static final String DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS = "confluent.durability.audit.initial.job.delay.ms";
    public static final String DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DOC = "Initial durability audit job delay";
    public static final Long DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT;
    public static final String DURABILITY_AUDIT_TIER_COMPACTION_AUDIT_DURATION_MS = "confluent.durability.audit.tier.compaction.audit.duration.ms";
    public static final String DURABILITY_AUDIT_TIER_COMPACTION_AUDIT_DURATION_MS_DOC = "Maximum allowed duration of the tier compaction audits";
    public static final Long DURABILITY_AUDIT_TIER_COMPACTION_AUDIT_DURATION_MS_DEFAULT;
    public static final String DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_CONFIG = "confluent.quota.tenant.default.controller.mutation.rate";
    public static final String DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_DOC = "The rate per tenant at which mutations are accepted for the create topics request, the create partitions request and the delete topics request. The rate is accumulated by the number of partitions created or deleted.";
    public static final double DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_DEFAULT = 2.147483647E9;
    public static final String MAX_REPLICAS_PER_BROKER_CONFIG = "confluent.plugins.topic.policy.max.replicas.per.broker";
    public static final String MAX_REPLICAS_PER_BROKER_DOC = "The maximum replicas per broker.";
    public static final int MAX_REPLICAS_PER_BROKER_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_PARTITIONS_PER_TENANT_CONFIG = "confluent.plugins.topic.policy.max.partitions.per.tenant";
    public static final String MAX_PARTITIONS_PER_TENANT_DOC = "The maximum partitions per tenant.";
    public static final int MAX_PARTITIONS_PER_TENANT_DEFAULT = 512;
    public static final String MAX_PARTITIONS_PER_CLUSTER_CONFIG = "confluent.plugins.topic.policy.max.partitions.per.cluster";
    public static final String MAX_PARTITIONS_PER_CLUSTER_DOC = "The maximum partitions per physical cluster.";
    public static final int MAX_PARTITIONS_PER_CLUSTER_DEFAULT = Integer.MAX_VALUE;
    public static final String MAX_TOPICS_PER_CLUSTER_CONFIG = "confluent.plugins.topic.policy.max.topics.per.cluster";
    public static final String MAX_TOPICS_PER_CLUSTER_DOC = "The maximum topics per physical cluster.";
    public static final int MAX_TOPICS_PER_CLUSTER_DEFAULT = Integer.MAX_VALUE;
    public static final String MIN_CELL_SIZE_CONFIG = "confluent.cells.min.size";
    public static final String MIN_CELL_SIZE_DOC = "The minimum brokers per cell.";
    public static final short MIN_CELL_SIZE_DEFAULT = 6;
    public static final String MAX_CELL_SIZE_CONFIG = "confluent.cells.max.size";
    public static final String MAX_CELL_SIZE_DOC = "The maximum brokers per cell.";
    public static final short MAX_CELL_SIZE_DEFAULT = 15;
    public static final String CELL_SIZE_CONFIG = "confluent.cells.default.size";
    public static final String CELL_SIZE_DOC = "The default number of brokers per cell.";
    public static final short CELL_SIZE_DEFAULT = 15;
    public static final String ENABLE_CELLS_CONFIG = "confluent.cells.enable";
    public static final String ENABLE_CELLS_DOC = "Whether to enable the cells feature (sub-flags also need to be enabled to turn on cells)";
    public static final boolean ENABLE_CELLS_DEFAULT = false;
    public static final String ENABLE_CELLS_IMPLICIT_CREATION_CONFIG = "confluent.cells.implicit.creation.enable";
    public static final String ENABLE_CELLS_IMPLICIT_CREATION_DOC = "Whether to enable implicit cell creation";
    public static final boolean ENABLE_CELLS_IMPLICIT_CREATION_DEFAULT = false;
    public static final String TENANT_STRIPE_FACTOR_CONFIG = "confluent.cells.tenant.stripe.factor";
    public static final String TENANT_STRIPE_FACTOR_DOC = "Stripe factor for tenant creation";
    public static final short TENANT_STRIPE_FACTOR_DEFAULT = 1;
    public static final String K2_CELL_BASE_BROKER_INDEX_CONFIG = "confluent.cells.k2.base.broker.index";
    public static final String K2_CELL_BASE_BROKER_INDEX_DOC = "K2 cell base broker index. Brokers above the index are K2 brokers.";
    public static final int K2_CELL_BASE_BROKER_INDEX_DEFAULT = -1;
    public static final String FAIL_UNSATISFIED_PLACEMENT_CONSTRAINTS_CONFIG = "confluent.fail.unsatisfied.placement.constraints";
    public static final String FAIL_UNSATISFIED_PLACEMENT_CONSTRAINTS_DOC = "Fail topic creation if there are insufficient brokers to satisfy topic configurations like replication factor.";
    public static final boolean FAIL_UNSATISFIED_PLACEMENT_CONSTRAINTS_DEFAULT = false;
    public static final String ENABLE_CELL_LOAD_REFRESHER_CONFIG = "confluent.cells.load.refresher.enable";
    public static final String ENABLE_CELL_LOAD_REFRESHER_DOC = "Whether to enable the cell load refresher";
    public static final boolean ENABLE_CELL_LOAD_REFRESHER_DEFAULT = true;
    public static final String CELL_METRICS_REFRESH_PERIOD_MS = "confluent.cell.metrics.refresh.period.ms";
    public static final long CELL_METRICS_REFRESH_PERIOD_DEFAULT = 60000L;
    public static final String CELL_METRICS_REFRESH_PERIOD_DOC = "The period in milliseconds between cell metrics refreshes";
    public static final String OMIT_NETWORK_PROCESSOR_METRIC_TAG = "confluent.omit.network.processor.metric.tag";
    public static final String OMIT_NETWORK_PROCESSOR_METRIC_TAG_DOC = "Whether to omit network processed metric tag.";
    public static final boolean OMIT_NETWORK_PROCESSOR_METRIC_TAG_DEFAULT = false;
    public static final String TRACK_TENANT_ID_PER_IP = "confluent.track.tenant.id.per.ip";
    public static final String TRACK_TENANT_ID_PER_IP_DOC = "Whether to track tenant id per ip on the broker if passing authentication.";
    public static final boolean TRACK_TENANT_ID_PER_IP_DEFAULT = false;
    public static final String TRACK_API_KEY_PER_IP = "confluent.track.api.key.per.ip";
    public static final String TRACK_API_KEY_PER_IP_DOC = "Whether to track api key per ip on the broker if failing authentication.";
    public static final boolean TRACK_API_KEY_PER_IP_DEFAULT = false;
    public static final String TRACK_IP_MAPPING_MAX_SIZE_CONFIG = "confluent.track.per.ip.max.size";
    public static final String TRACK_IP_MAPPING_MAX_SIZE_DOC = "Max size of the ip to api key and ip to tenantId mapping.";
    public static final int TRACK_IP_MAPPING_MAX_SIZE_DEFAULT = 100000;
    public static final String DEFAULT_PARTITION_PLACEMENT_STRATEGY_CONFIG = "confluent.topic.partition.default.placement";
    public static final String DEFAULT_PARTITION_PLACEMENT_STRATEGY_DOC = "The default partition placement strategy (partition in cell, tenant in cell, or cluster wide)";
    public static final int DEFAULT_PARTITION_PLACEMENT_STRATEGY = 2;
    public static final String MAX_DEST_LINKS_PER_TENANT_CONFIG = "confluent.plugins.cluster.link.policy.max.destination.links.per.tenant";
    public static final String MAX_DEST_LINKS_PER_TENANT_DOC = "The maximum destination cluster links per tenant.";
    public static final int MAX_DEST_LINKS_PER_TENANT_DEFAULT = 10;
    public static final String MAX_SOURCE_LINKS_PER_TENANT_CONFIG = "confluent.plugins.cluster.link.policy.max.source.links.per.tenant";
    public static final String MAX_SOURCE_LINKS_PER_TENANT_DOC = "The maximum source cluster links per tenant. This limit is only applicable to source initiated links.";
    public static final int MAX_SOURCE_LINKS_PER_TENANT_DEFAULT = 10;
    private static final String BROKER_LOAD_PREFIX = "confluent.broker.load.";
    public static final String BROKER_LOAD_ENABLED_CONFIG = "confluent.broker.load.enabled";
    public static final String BROKER_LOAD_ENABLED_DOC = "Whether the broker load metric is enabled";
    public static final boolean BROKER_LOAD_ENABLED_DEFAULT = false;
    public static final String BROKER_LOAD_TENANT_METRIC_ENABLE_CONFIG = "confluent.broker.load.tenant.metric.enable";
    public static final String BROKER_LOAD_TENANT_METRIC_ENABLE_DOC = "Whether the broker load metric should be customer-visible by tagging it with their logical Kafka clusters";
    public static final boolean BROKER_LOAD_TENANT_METRIC_ENABLE_DEFAULT = false;
    public static final String BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_CONFIG = "confluent.broker.load.update.metric.tags.interval.ms";
    public static final String BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DOC = "Interval for which to update the broker load metric tags in case of Kafka LKC changes";
    public static final long BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DEFAULT;
    public static final String BROKER_LOAD_WINDOW_SIZE_MS_CONFIG = "confluent.broker.load.window.size.ms";
    public static final String BROKER_LOAD_WINDOW_SIZE_MS_DOC = "The interval (in milliseconds) between request or connection samples for calculating the broker load";
    public static final long BROKER_LOAD_WINDOW_SIZE_MS_DEFAULT;
    public static final String BROKER_LOAD_NUM_SAMPLES_CONFIG = "confluent.broker.load.num.samples";
    public static final String BROKER_LOAD_NUM_SAMPLES_DOC = "The number of samples to include in a calculation window";
    public static final int BROKER_LOAD_NUM_SAMPLES_DEFAULT = 60;
    public static final String BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_CONFIG = "confluent.broker.load.average.service.request.time.ms";
    public static final String BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_DOC = "The average time taken to service a request on the broker";
    public static final double BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_DEFAULT = 0.1;
    public static final String BROKER_LOAD_WORKLOAD_COEFFICIENT_CONFIG = "confluent.broker.load.workload.coefficient";
    public static final String BROKER_LOAD_WORKLOAD_COEFFICIENT_DOC = "A constant to tune the broker load for a specific workload characteristic";
    public static final double BROKER_LOAD_WORKLOAD_COEFFICIENT_DEFAULT = 20.0;
    public static final String BROKER_LOAD_DELAY_METRIC_START_MS_CONFIG = "confluent.broker.load.delay.metric.start.ms";
    public static final String BROKER_LOAD_START_METRIC_DELAY_MS_DOC = "The time (in milliseconds) to delay the start of the broker load metric after we start processing requests";
    public static final long BROKER_LOAD_START_METRIC_DELAY_MS_DEFAULT;
    public static final String BROKER_LOAD_ADVERTISED_LIMIT_LOAD_CONFIG = "confluent.broker.load.advertised.limit.load";
    public static final String BROKER_LOAD_ADVERTISED_LIMIT_LOAD_DOC = "The value of the broker load metric when the advertised limit is hit";
    public static final double BROKER_LOAD_ADVERTISED_LIMIT_LOAD_DEFAULT = 0.8;
    public static final String PROXY_PROTOCOL_VERSION = "confluent.proxy.protocol.version";
    public static final String PROXY_PROTOCOL_VERSION_DOC = "The version of the PROXY protocol that the broker will use, or NONE if the PROXY protocol will not be used. Possible values include V1, V2, COMBINED, and NONE. If using the COMBINED value. The broker will check the header to determine V1 or V2. This value can be overridden for each listener by prefixing the config with the normalized listener name. For example, to enable V1 of the protocol for the EXTERNAL listener, set <code>listener.name.external.confluent.proxy.protocol.version=V1</code>.Because the inter-broker listener and any admin listeners will likely not be accessed through a proxy, the typical configuration would be to use the default value of NONE and enable the protocol explicitly for a subset of listeners. See http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt for more information on the PROXY protocol.";
    public static final String PROXY_PROTOCOL_VERSION_DEFAULT;
    public static final String PROXY_PROTOCOL_FALLBACK_ENABLED = "confluent.proxy.protocol.fallback.enabled";
    public static final String PROXY_PROTOCOL_FALLBACK_ENABLED_DOC = "If true, and if <code>confluent.proxy.protocol.version</code> is not set to <code>NONE</code>, the network layer will accept both PROXY and non-PROXY protocol requests. If the PROXY header is present, it will parse it and interpret the specified client IP address and port appropriately; if not, it will fall back to a normal, non-PROXY request. This value can be overridden for each listener by prefixing the config with the normalized listener name.";
    public static final Boolean PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT;
    public static final String PROXY_PROTOCOL_CLIENT_VERSION = "confluent.proxy.protocol.client.version";
    public static final String PROXY_PROTOCOL_CLIENT_VERSION_DOC = "The version of the PROXY protocol that the client will use, or NONE if the PROXY protocol will not be used. This value must match that of the brokers to which the client is connecting. If the brokers are using COMBINED to support both PROXY protocol versions, then this value can be either V1 or V2. See the confluent.proxy.protocol.version configuration option for the broker configuration. See http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt for more information on the PROXY protocol.";
    public static final String PROXY_PROTOCOL_CLIENT_VERSION_DEFAULT;
    public static final String PROXY_PROTOCOL_CLIENT_ADDRESS = "confluent.proxy.protocol.client.address";
    public static final String PROXY_PROTOCOL_CLIENT_ADDRESS_DOC = "This configuration specifies the connection initiator's IP address. While the configuration option is of type String, the user configuring the client should pass in a value representing an IPv4 or IPv6 address, since the broker will be attempting to parse one of those two IP address types. Note that this should be IP address, not a host name. This configuration option is conditionally required. The default value is null, but if the confluent.proxy.protocol.client.version is set to a valid protocol version, it is an error if this configuration option is not set.";
    public static final String PROXY_PROTOCOL_CLIENT_PORT = "confluent.proxy.protocol.client.port";
    public static final String PROXY_PROTOCOL_CLIENT_PORT_DOC = "This configuration specifies the connection initiator's port. The configuration option is of type Integer, though the port range is within the limits of a 16-bit value. This configuration option is conditionally required. The default value is null, but if the confluent.proxy.protocol.client.version is set to a valid protocol version, it is an error if this configuration option is not set.";
    public static final String PROXY_PROTOCOL_CLIENT_MODE = "confluent.proxy.protocol.client.mode";
    public static final String PROXY_PROTOCOL_CLIENT_MODE_DOC;
    public static final String PROXY_PROTOCOL_CLIENT_MODE_DEFAULT;
    public static final String PROXY_PROTOCOL_TLV_PARSER = "confluent.proxy.protocol.parser";
    public static final String PROXY_PROTOCOL_TLV_PARSER_DOC = "The parser to use for parsing TLVs of PPv2. Without specified a default one will be used, other implementations can be provided by plugins.";
    public static final String LKC_ID = "confluent.lkc.id";
    public static final String LKC_ID_DOC;
    public static final String CONSUMER_LAG_EMITTER_ENABLED_CONFIG = "confluent.consumer.lag.emitter.enabled";
    public static final String CONSUMER_LAG_EMITTER_ENABLED_DOC = "Enables consumer lag emitter. The emitter records lag for all consumer groups in the server.";
    public static final boolean CONSUMER_LAG_EMITTER_ENABLED_DEFAULT = false;
    public static final String CONSUMER_LAG_EMITTER_INTERVAL_MS_CONFIG = "confluent.consumer.lag.emitter.interval.ms";
    public static final String CONSUMER_LAG_EMITTER_INTERVAL_MS_DOC = "Interval in which consumer lag is recorded.";
    public static final Long CONSUMER_LAG_EMITTER_INTERVAL_MS_DEFAULT;
    public static final String CHECKSUM_ENABLED_FILES_CONFIG = "confluent.checksum.enabled.files";
    public static final String CHECKSUM_ENABLED_FILES_DOC = "Contains the list of object types in comma separated format for which checksum should be enabled. \"all\" will enable checksums for all files where available, \"none\" will disable checksums for all files, and \"tierstate\" will enable checksums for only tier state files. Currently only \"tierstate\" object type is supported .NOTE: Turning on may prevent downgrades safely to versions that don't support checksumsNOTE: This config is independent of record level batch CRCs";
    public static final String CHECKSUM_ENABLED_FILES_TIERSTATE = "tierstate";
    public static final String CHECKSUM_ENABLED_FILES_ALL = "all";
    public static final String CHECKSUM_ENABLED_FILES_NONE = "none";
    public static final String CHECKSUM_ENABLED_FILES_DEFAULT = "none";
    public static final String TIER_S3_BUCKET = "confluent.tier.s3.bucket";
    public static final String TIER_S3_REGION = "confluent.tier.s3.region";
    public static final String TIER_S3_PREFIX = "confluent.tier.s3.prefix";
    public static final String TIER_S3_SSE_ALGORITHM = "confluent.tier.s3.sse.algorithm";
    public static final String TIER_S3_SSE_CUSTOMER_ENCRYPTION_KEY = "confluent.tier.s3.sse.customer.encryption.key";
    public static final String TIER_S3_CRED_FILE_PATH = "confluent.tier.s3.cred.file.path";
    public static final String TIER_S3_ENDPOINT_OVERRIDE = "confluent.tier.s3.aws.endpoint.override";
    public static final String TIER_S3_FORCE_PATH_STYLE_ACCESS = "confluent.tier.s3.force.path.style.access";
    public static final String TIER_S3_V2_ENABLED = "confluent.tier.s3.v2.enabled";
    public static final String TIER_S3_SIGNER_OVERRIDE = "confluent.tier.s3.aws.signer.override";
    public static final String TIER_S3_AUTO_ABORT_THRESHOLD_BYTES = "confluent.tier.s3.auto.abort.threshold.bytes";
    public static final String TIER_S3_ASSUME_ROLE_ARN = "confluent.tier.s3.assumerole.arn";
    public static final String TIER_S3_USER_AGENT_PREFIX = "confluent.tier.s3.user.agent.prefix";
    public static final String TIER_S3_SSL_PROTOCOL = "confluent.tier.s3.ssl.protocol";
    public static final String TIER_S3_SSL_ENABLED_PROTOCOLS = "confluent.tier.s3.ssl.enabled.protocols";
    public static final String TIER_S3_SSL_TRUST_STORE_LOCATION = "confluent.tier.s3.ssl.truststore.location";
    public static final String TIER_S3_SSL_TRUST_STORE_PASSWORD = "confluent.tier.s3.ssl.truststore.password";
    public static final String TIER_S3_SSL_TRUST_STORE_TYPE = "confluent.tier.s3.ssl.truststore.type";
    public static final String TIER_S3_SSL_KEYSTORE_LOCATION = "confluent.tier.s3.ssl.keystore.location";
    public static final String TIER_S3_SSL_KEYSTORE_PASSWORD = "confluent.tier.s3.ssl.keystore.password";
    public static final String TIER_S3_SSL_KEYSTORE_TYPE = "confluent.tier.s3.ssl.keystore.type";
    public static final String TIER_S3_SSL_KEY_PASSWORD = "confluent.tier.s3.ssl.key.password";
    public static final String TIER_S3_SSL_PROVIDER = "confluent.tier.s3.ssl.provider";
    public static final String TIER_S3_SECURITY_PROVIDERS = "confluent.tier.s3.security.providers";
    public static final String TIER_S3_STORAGE_CLASS_OVERRIDE = "confluent.tier.s3.storage.class.override";
    public static final String TIER_S3_IPV6_ENABLED = "confluent.tier.s3.ipv6.enabled";
    public static final String REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_CONFIG = "confluent.require.compatible.keystore.updates";
    public static final String REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DOC = "This configuration controls whether strict compatibility is required when dynamically updating broker keystores. When enabled, dynamically updated keystores must contain the same number of certificates and each certificate must have matching distinguished names and the alternative names must be a superset of the old certificate. If disabled, then no compatibility checks will be done.";
    public static final Boolean REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DEFAULT;
    public static final String ELIGIBLE_CONTROLLERS_CONFIG = "confluent.eligible.controllers";
    public static final String ELIGIBLE_CONTROLLERS_DOC = "This configuration provides the ability for zk-based clusters to set an explicit list of the brokers that are eligible to become controller. Brokers which are not included in this list will not attempt to become controller by creating the `/controller` znode. If the current controller is not among the eligible controllers when the configuration is changed dynamically, it will resign so that one of the eligible controllers can be elected. Additionally, when changed dynamically, at least one of the eligible controllers must be online. The default value is an empty list, which we treat as indicating that all brokers are eligible to become controller.";
    public static final List<String> ELIGIBLE_CONTROLLERS_DEFAULT;
    public static final String TRANSACTION_LOGGING_VERBOSITY_CONFIG = "confluent.transaction.logging.verbosity";
    public static final String TRANSACTION_LOGGING_VERBOSITY_DOC = "This configuration controls the verbosity of transaction-related logging. When enabled with a value of 1 or 2, additional logging as well as more verbose logging messages will be displayed at the INFO log level. This is useful when we need to dynamically enable extra logging for a particular cluster indefinitely. The default of 0 means no additional logging. The difference between levels 1 and 2 is that the latter will print all partitions included in each transaction while the former will only print a sampling.";
    public static final Integer TRANSACTION_LOGGING_VERBOSITY_DEFAULT;
    public static final String MIN_SEGMENT_MS_CONFIG = "confluent.min.segment.ms";
    public static final long MIN_SEGMENT_MS_DEFAULT = 1L;
    public static final String MIN_SEGMENT_MS_DOC = "Minimum period of time to force a segment roll. Segment will be rolled after the maximum of the topic's configured segment.ms and min.segment.ms has passed.";
    public static final String MAX_SEGMENT_MS_CONFIG = "confluent.max.segment.ms";
    public static final long MAX_SEGMENT_MS_DEFAULT = Long.MAX_VALUE;
    public static final String MAX_SEGMENT_MS_DOC = "Maximum period of time to force a segment roll. Segment will be rolled after the minimum of the topic's configured segment.ms and max.segment.ms has passed.";
    public static final String SYSTEM_TIME_BASED_ROLL_ENABLE_CONFIG = "confluent.system.time.roll.enable";
    public static final boolean SYSTEM_TIME_BASED_ROLL_ENABLE_DEFAULT = false;
    public static final String SYSTEM_TIME_BASED_ROLL_ENABLE_DOC = "Roll a segment based on system time rather than user timestamp";
    public static final String ROLL_CHECK_INTERVAL_MS_CONFIG = "confluent.roll.check.interval.ms";
    public static final long ROLL_CHECK_INTERVAL_MS_DEFAULT = 300000L;
    public static final String ROLL_CHECK_INTERVAL_MS_DOC = "The interval in milliseconds to check if the active segment should be rolled";
    public static final String EAGER_ROLL_ENABLE_CONFIG = "confluent.segment.eager.roll.enable";
    public static final boolean EAGER_ROLL_ENABLE_DEFAULT = false;
    public static final String EAGER_ROLL_ENABLE_DOC = "If enabled, active segments will roll at a recurring interval whenever the roll conditions are met";
    public static final String MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_CONFIG = "confluent.multitenant.listener.hostname.subdomain.suffix.enable";
    public static final Boolean MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DEFAULT;
    public static final String MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DOC = "If enabled, append the DNS subdomain parsed from the SNI header to the advertised hostname configured for multitenant listeners";
    public static final String SUBDOMAIN_SEPARATOR_MAP_CONFIG = "confluent.subdomain.separator.map";
    public static final String SUBDOMAIN_SEPARATOR_MAP_DEFAULT;
    public static final String SUBDOMAIN_SEPARATOR_MAP_DOC = "A map from DNS subdomains to separators, used to construct hostnames when using split-path DNS. If defined, the map must include an entry with a 'default' key.";
    public static final String SUBDOMAIN_PREFIX_CONFIG = "confluent.subdomain.prefix";
    public static final String SUBDOMAIN_PREFIX_DEFAULT;
    public static final String SUBDOMAIN_PREFIX_DOC = "A prefix string that the broker can use to identify the DNS subdomain from the SNI header. Everything in the SNI header from this value to the end will be considered the subdomain.";
    public static final String SUBDOMAIN_SEPARATOR_VARIABLE_CONFIG = "confluent.subdomain.separator.variable";
    public static final String SUBDOMAIN_SEPARATOR_VARIABLE_DEFAULT = "%sep";
    public static final String SUBDOMAIN_SEPARATOR_VARIABLE_DOC = "The string that will be replaced in dynamic broker hostnames by the appropriate separator string from confluent.subdomain.separator.map";
    public static final String METRICS_REPORTER_BOOTSTRAP_SERVERS_CONFIG = "confluent.metrics.reporter.bootstrap.servers";
    public static final String METRICS_REPORTER_BOOTSTRAP_SERVERS_DOC = "Bootstrap servers for metrics reporting.";
    public static final String METRICS_REPORTER_BOOTSTRAP_SERVERS_DEFAULT = "kafka-0:9071";
    public static final String OTEL_TRACE_EXPORTER_CUSTOM_ENDPOINT_DOC = "Allow to set customized opentelemetry trace endpoint to export span traces. (eg: jaeger)";
    public static final String OTEL_TRACE_EXPORTER_CUSTOM_ENDPOINT_DEFAULT = "default";
    public static final String FETCH_PARTITION_PRUNING_ENABLE_CONFIG = "confluent.fetch.partition.pruning.enable";
    public static final String FETCH_PARTITION_PRUNING_ENABLE_DOC = "Specifies if inactive partitions could be ignored when a fetch request from a follower is processed.";
    public static final boolean FETCH_PARTITION_PRUNING_ENABLE_DEFAULT = true;
    public static final String CONSUMER_FETCH_PARTITION_PRUNING_ENABLE_CONFIG = "confluent.consumer.fetch.partition.pruning.enable";
    public static final String CONSUMER_FETCH_PARTITION_PRUNING_ENABLE_DOC = "Specifies if inactive partitions could be ignored when a fetch request from a consumer is processed.";
    public static final boolean CONSUMER_FETCH_PARTITION_PRUNING_ENABLE_DEFAULT = true;
    public static final String FETCH_FROM_FOLLOWER_REQUIRE_LEADER_EPOCH_CONFIG = "confluent.fetch.from.follower.require.leader.epoch.enable";
    public static final String FETCH_FROM_FOLLOWER_REQUIRE_LEADER_EPOCH_DOC = "Fetching from follower is only allowed if a leader epoch is provided.";
    public static final boolean FETCH_FROM_FOLLOWER_REQUIRE_LEADER_EPOCH_DEFAULT = false;
    public static final String DEFER_ISR_SHRINK_ENABLE_CONFIG = "confluent.defer.isr.shrink.enable";
    public static final String DEFER_ISR_SHRINK_ENABLE_DOC = "Defer ISR shrinking for partitions that only have messages with acks = \"all\" if shrinking ISR would make partition fall under min ISR.";
    public static final boolean DEFER_ISR_SHRINK_ENABLE_DEFAULT = false;
    public static final String REQUEST_PIPELINING_ENABLE_CONFIG = "confluent.request.pipelining.enable";
    public static final String REQUEST_PIPELINING_ENABLE_DOC = "Setting this configuration to true enables the broker to process multiple in-flight produce requests per connection.";
    public static final boolean REQUEST_PIPELINING_ENABLE_DEFAULT = true;
    public static final String REQUEST_PIPELINING_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_CONFIG = "confluent.request.pipelining.max.in.flight.requests.per.connection";
    public static final String REQUEST_PIPELINING_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_DOC = "This configures the maximum number of in-flight requests per connection if request pipelining is enabled.";
    public static final int REQUEST_PIPELINING_MAX_IN_FLIGHT_REQUESTS_PER_CONNECTION_DEFAULT = 5;
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_UPLOAD_ENABLE_CONFIG = "confluent.cluster.metadata.snapshot.tier.upload.enable";
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_UPLOAD_ENABLE_DOC = "Setting this configuration to true, enables KRaft metadata snapshots to be backed up to object store";
    public static final boolean CLUSTER_METADATA_SNAPSHOT_TIER_UPLOAD_ENABLE_DEFAULT = false;
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_ENABLE_CONFIG = "confluent.cluster.metadata.snapshot.tier.delete.enable";
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_ENABLE_DOC = "Setting this configuration to true, enables KRaft metadata snapshots backed up to object store to be deleted";
    public static final boolean CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_ENABLE_DEFAULT = false;
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_RETENTION_MS_CONFIG = "confluent.cluster.metadata.snapshot.tier.delete.retention.ms";
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_RETENTION_MS_DOC = "This configures the time duration after which KRaft metadata snapshots backed up to object store should be deleted";
    public static final long CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_RETENTION_MS_DEFAULT;
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_MAINTAIN_MIN_SNAPSHOTS_CONFIG = "confluent.cluster.metadata.snapshot.tier.delete.maintain.min.snapshots";
    public static final String CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_MAINTAIN_MIN_SNAPSHOTS_DOC = "This configures the minimum number of KRaft metadata snapshots backed up to object store that should always be maintained";
    public static final int CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_MAINTAIN_MIN_SNAPSHOTS_DEFAULT = 3;
    public static final String SSL_ENABLE_DYNAMIC_STORE_UPDATE = "confluent.ssl.enable.dynamic.store.update";
    public static final String SSL_ENABLE_DYNAMIC_STORE_UPDATE_DOC = "The config is to enable dynamic update of ssl keystore and truststore when user modifies the key store or trust files. This config doesn't apply to custom factories or stores configured using ssl.keystore.certificate.chain";
    public static final String BROKER_CLIENTS_SSL_FILE_STORE_RELOAD_ENABLE_CONFIG = "confluent.broker.clients.ssl.file.store.reload.enable";
    public static final String BROKER_CLIENTS_SSL_FILE_STORE_RELOAD_ENABLE_CONFIG_DOC = "This config enables dynamic reload of SSL key/trust file stores on file update for internal clients running on the broker. default is disabled.";
    public static final String BROKER_LISTENERS_SSL_FILE_STORE_RELOAD_ENABLE_CONFIG = "confluent.broker.listeners.ssl.file.store.reload.enable";
    public static final String BROKER_LISTENERS_SSL_FILE_STORE_RELOAD_ENABLE_CONFIG_DOC = "This config enables dynamic reload of SSL key/trust file stores on file update for ssl based listeners running on the broker. default is disabled.";
    public static final String LISTENER_PROXY_MODE_LOCAL_DEFAULT_CONFIG = "confluent.proxy.mode.local.default";
    public static final boolean LISTENER_PROXY_MODE_LOCAL_DEFAULT = false;
    public static final String LISTENER_PROXY_MODE_LOCAL_DEFAULT_ENABLED_DOC = "Boolean value stating whether connections to this listener should be handled like LOCAL proxy connections if no PROXY mode is specified.";
    public static final String ZK_METADATA_MIGRATION_TRIGGER_FILE_CONFIG = "confluent.zookeeper.metadata.migration.trigger.file.path";
    public static final String ZK_METADATA_MIGRATION_TRIGGER_FILE_DOC = "Setting this config enables the delay of ZooKeeper to KRaft metadata migration. If set, the migration will not begin until the file specified by this config exists.";
    public static final String ZK_METADATA_MIGRATION_CONTROLLER_CHECK_DISABLE_CONFIG = "confluent.zookeeper.metadata.migration.controller.check.disable";
    public static final String ZK_METADATA_MIGRATION_CONTROLLER_CHECK_DISABLE_DOC = "Disable the pre-migration check of the controller quorum readiness.";
    public static final String METADATA_ENCRYPTOR_REQUIRED_CONFIG = "confluent.metadata.encryptor.required";
    public static final String METADATA_ENCRYPTOR_REQUIRED_DOC = "When true, the node will fail to start if no metadata log encryptor is available.";
    public static final String METADATA_ENCRYPTOR_SECRET_FILE_CONFIG = "confluent.metadata.encryptor.secret.file";
    public static final String METADATA_ENCRYPTOR_SECRET_FILE_DOC = "K8s secret file to read for metadata encryptor secrets.";
    public static final String HEAP_WATCHER_TENURED_PREFIX = "confluent.heap.tenured.notify.";
    public static final String HEAP_WATCHER_TENURED_ENABLED_CONFIG = "confluent.heap.tenured.notify.enabled";
    public static final String HEAP_WATCHER_TENURED_ENABLED_DOC = "Should we alert on almost-OOMs when the tenured heap pool is above the alert limit";
    public static final boolean HEAP_WATCHER_TENURED_ENABLED_DEFAULT = false;
    public static final String HEAP_WATCHER_TENURED_NOTIFY_BYTES_CONFIG = "confluent.heap.tenured.notify.bytes";
    public static final String HEAP_WATCHER_TENURED_NOTIFY_BYTES_DOC = "Alert on almost-OOM when the tenured heap pool is above this size, in bytes. 0 means disabled.";
    public static final int HEAP_WATCHER_TENURED_NOTIFY_BYTES_DEFAULT = 0;
    public static final String TOPIC_POLICY_USE_COMPUTED_ASSIGNMENTS_CONFIG = "confluent.topic.policy.use.computed.assignments";
    public static final String TOPIC_POLICY_USE_COMPUTED_ASSIGNMENTS_DOC = "Whether to pass the computed topic assignments for a new topic to CreateTopicPolicy. True in Cloud, false in Confluent Platform";
    public static final boolean TOPIC_POLICY_USE_COMPUTED_ASSIGNMENTS_DEFAULT = false;
    public static final String MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_PREFIX = "confluent.multitenant.interceptor.collect.client.apiversions.";
    public static final String MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_CONFIG = "confluent.multitenant.interceptor.collect.client.apiversions.metric";
    public static final String MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_DOC = "Whether to collect the client_info_rate metric, tagging it with the client software and client id on a ApiVersions request. This could result in a memory exhaustion for a very high cardinality of client ids. Should only be true in ccloud, false everywhere else";
    public static final boolean MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_DEFAULT = false;
    public static final String MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_MAX_PER_TENANT_CONFIG = "confluent.multitenant.interceptor.collect.client.apiversions.max.per.tenant";
    public static final String MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_MAX_PER_TENANT_DOC = "The maximum number of client ids to track for the client_info_rate metric. This is a per-tenant limit, and once we go over the limit, we'll just stop collecting. Only take affect if confluent.multitenant.interceptor.collect.client.apiversions.metric value is set to true";
    public static final int MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_MAX_PER_TENANT_DEFAULT = 1000;
    public static final String UNIQUE_DEPRECATED_REQUEST_METRICS_PER_TENANT_CONFIG = "confluent.unique.deprecated.request.metrics.per.tenant";
    public static final String UNIQUE_DEPRECATED_REQUEST_METRICS_PER_TENANT_DOC = "The maximum number of unique deprecated request metrics per tenant";
    public static final int UNIQUE_DEPRECATED_REQUEST_METRICS_PER_TENANT_DEFAULT = 1000;
    public static final String NUM_PARTITIONS = "num.partitions";
    public static final int NUM_PARTITIONS_DEFAULT = 1;
    public static final String VIRTUAL_TOPIC_ENABLED_CONFIG = "confluent.virtual.topic.creation.enabled";
    public static final String VIRTUAL_TOPIC_ENABLED_DOC = "Whether virtual topic creation is enabled or not";
    public static final boolean VIRTUAL_TOPIC_ENABLED_DEFAULT = false;
    public static final String OAUTH_REQUIRE_CONFLUENT_ISSUER = "confluent.require.confluent.issuer";
    public static final String OAUTH_REQUIRE_CONFLUENT_ISSUER_DOC = "Whether to require that OAuth tokens handled on this listener have \"Confluent\" as the issuer. This config can be set on a per-listener basis. This configuration is deprecated. Use \"confluent.oauth.flat.networking.verification.enable\" instead.";
    public static final boolean OAUTH_REQUIRE_CONFLUENT_ISSUER_DEFAULT = false;
    public static final String OAUTH_FLAT_NETWORKING_VERIFICATION_ENABLE = "confluent.oauth.flat.networking.verification.enable";
    public static final String OAUTH_FLAT_NETWORKING_VERIFICATION_ENABLE_DOC = "Whether to enable flat networking verification. When verification is enabled, the OAuth tokens handled by this listener is  required to have \"Confluent\" issuer or the clients is required to pass the default data policy. For backward compatibility, the verification will be enabled when \"confluent.require.confluent.issuer\" is true. This config can be set on a per-listener basis.";
    public static final boolean OAUTH_FLAT_NETWORKING_VERIFICATION_ENABLE_DEFAULT = false;
    public static final String OAUTH_REQUIRE_CALLING_RESOURCE_IDENTITY = "confluent.require.calling.resource.identity";
    public static final String OAUTH_REQUIRE_CALLING_RESOURCE_IDENTITY_DOC = "Whether to require that OAuth tokens handled on this listener havea non-empty \"calling_resource_identity\" claim when the issuer is \"Confluent\". This config can be set on a per-listener basis.";
    public static final boolean OAUTH_REQUIRE_CALLING_RESOURCE_IDENTITY_DEFAULT = false;
    public static final String DESCRIBE_TOPIC_PARTITIONS_API_ENABLED_CONFIG = "confluent.describe.topic.partitions.enabled";
    public static final String DESCRIBE_TOPIC_PARTITIONS_API_ENABLED_DOC = "Whether the DescribeTopicPartitions API is enabled.";
    public static final boolean DESCRIBE_TOPIC_PARTITIONS_API_ENABLED_DEFAULT = true;
    public static final String ADMIN_CLIENT_DESCRIBE_TOPIC_PARTITIONS_API_ENABLED_CONFIG = "confluent.admin.client.describe.topic.partitions.enabled";
    public static final String ADMIN_CLIENT_DESCRIBE_TOPIC_PARTITIONS_API_ENABLED_DOC = "Whether the DescribeTopicPartitions API is enabled for the admin clients.";
    public static final boolean ADMIN_CLIENT_DESCRIBE_TOPIC_PARTITIONS_API_ENABLED_DEFAULT = true;
    public static final String MTLS_ENABLE_CONFIG = "confluent.mtls.enable";
    public static final String MTLS_ENABLE_DOC = "Whether mTLS is enabled for CCloud, default to false.";
    public static final boolean MTLS_ENABLE_DEFAULT = false;
    public static final String MTLS_LISTENER_NAME_CONFIG = "confluent.mtls.listener.name";
    public static final String MTLS_LISTENER_NAME_DOC = "Listener name of the endpoint that is used for mTLS, default to EXTERNAL";
    public static final String MTLS_LISTENER_NAME_DEFAULT = "EXTERNAL";
    public static final String MTLS_TRUSTSTORE_MANAGER_CLASS_CONFIG = "confluent.mtls.truststore.manager.class.name";
    public static final String MTLS_TRUSTSTORE_MANAGER_CLASS_DOC;
    public static final String MTLS_CONNECTION_MANAGER_CLASS_NAME = "io.confluent.security.mtls.DefaultMTlsConnectionManager";
    public static final String MTLS_SASL_AUTHENTICATOR_REQUEST_MAX_BYTES_CONFIG = "confluent.mtls.sasl.authenticator.request.max.bytes";
    public static final String MTLS_SASL_AUTHENTICATOR_REQUEST_MAX_BYTES_DOC = "The maximum number of bytes in a request that is allowed for authenticated mTLS clients.";
    public static final int MTLS_SASL_AUTHENTICATOR_REQUEST_MAX_BYTES_DEFAULT = 0x6400000;
    public static final String MTLS_BUILD_CLIENT_CERT_CHAIN_CONFIG = "confluent.mtls.build.client.cert.chain.enable";
    public static final String MTLS_BUILD_CLIENT_CERT_CHAIN_DOC = "Whether to build client certificate chain, default to false.";
    public static final boolean MTLS_BUILD_CLIENT_CERT_CHAIN_DEFAULT = false;
    public static final String MTLS_TRUSTSTORE_ALTER_CONFIGS_TIMEOUT_MS_CONFIG = "confluent.mtls.truststore.alter.configs.timeout.ms";
    public static final String MTLS_TRUSTSTORE_ALTER_CONFIGS_TIMEOUT_MS_DOC = "Timeout in milliseconds for the admin call to alter configs for reloading mTLS truststore.";
    public static final int MTLS_TRUSTSTORE_ALTER_CONFIGS_TIMEOUT_MS_DEFAULT;
    public static final String OAUTH_UNION_OF_POOLS_ENABLE_CONFIG = "confluent.oauth.union.of.pools.enable";
    public static final String OAUTH_UNION_OF_POOLS_ENABLE_DOC = "Whether OAuth union of pools is enabled for CCloud, default to false.";
    public static final boolean OAUTH_UNION_OF_POOLS_ENABLE_DEFAULT = false;
    public static final String ACCP_ENABLED_CONFIG = "confluent.accp.enabled";
    public static final boolean ACCP_ENABLED_DEFAULT = false;
    public static final String ACCP_ENABLED_DOC = "Whether ACCP is enabled, default to false. Enabling this config means we will force to use DefaultSslEngineFactory and ignore ssl.provider when creating SSL Context.";
    public static final String LAT_NETWORK_CONTEXT_VERIFICATION_ENABLE = "confluent.lat.network.context.verification.enable";
    public static final boolean LAT_NETWORK_CONTEXT_VERIFICATION_ENABLE_DEFAULT = false;
    public static final String LAT_NETWORK_CONTEXT_VERIFICATION_ENABLE_DOC = "Whether to enable verification of the network context in the LAT token. If enabled, the network context must be present and match the expected value.";
    public static final String CLIENT_METRICS_SUBSCRIPTION_PREFIX = "confluent.telemetry.external.client.metrics.subscription.";
    public static final String CLIENT_METRICS_SUBSCRIPTION_METRICS = "metrics";
    public static final String CLIENT_METRICS_SUBSCRIPTION_INTERVAL_MS = "interval.ms";
    public static final String CLIENT_METRICS_SUBSCRIPTION_MATCH = "match";
    public static final String CLIENT_METRICS_SUBSCRIPTION_METRICS_LIST = "metrics.list";
    public static final String CLIENT_METRICS_SUBSCRIPTION_INTERVAL_MS_LIST = "interval.ms.list";
    public static final String CLIENT_METRICS_SUBSCRIPTION_MATCH_LIST = "match.list";
    public static final String CLIENT_METRICS_SUBSCRIPTION_METRICS_CONFIG_LIST = "confluent.telemetry.external.client.metrics.subscription.metrics.list";
    public static final String CLIENT_METRICS_SUBSCRIPTION_METRICS_LIST_DOC = "A prefix match on the requested metrics is performed in clients to determine subscribed metrics.";
    public static final String CLIENT_METRICS_SUBSCRIPTION_INTERVAL_MS_CONFIG_LIST = "confluent.telemetry.external.client.metrics.subscription.interval.ms.list";
    public static final String CLIENT_METRICS_SUBSCRIPTION_INTERVAL_MS_LIST_DOC = "The interval at which the client should push the metrics to the broker.";
    public static final String CLIENT_METRICS_SUBSCRIPTION_MATCH_CONFIG_LIST = "confluent.telemetry.external.client.metrics.subscription.match.list";
    public static final String CLIENT_METRICS_SUBSCRIPTION_MATCH_LIST_DOC = "The comma separated list of client match patterns, in case if there is no matching pattern specified then broker considers that as all match which means the associated metrics applies to all the clients.";
    public static final String VALID_SNI_HOSTNAMES_CONFIG = "confluent.valid.sni.hostnames";
    public static final String VALID_SNI_HOSTNAMES_DOC = "The valid SNI hostnames to check for logging invalid external SNI hostname.";
    public static final String VALID_SNI_HOSTNAMES_DEFAULT = "";
    public static final String VALID_SNI_HOSTNAMES_EXCLUDE_SUFFIX_CONFIG = "confluent.valid.sni.hostnames.exclude.suffix";
    public static final String VALID_SNI_HOSTNAMES_EXCLUDE_SUFFIX_DOC = "The suffix of SNI hostnames that we want to exclude from logging invalid external SNI hostname.";
    public static final String VALID_SNI_HOSTNAMES_EXCLUDE_SUFFIX_DEFAULT = "";
    public static final String EMIT_PROXY_PROTOCOL_METRICS = "confluent.emit.proxy.protocol.metrics";
    public static final String EMIT_PROXY_PROTOCOL_METRICS_DOC = "Whether to emit connection rate metrics per PROXY protocol verison";
    public static final boolean EMIT_PROXY_PROTOCOL_METRICS_DEFAULT = false;
    public static final String CLIENT_TOPIC_METRICS_MANAGER = "confluent.client.topic.metrics.manager";
    public static final String CLIENT_TOPIC_METRICS_MANAGER_DOC = "The fully qualified name of Metrics Manager class for recording client-level topic bytes/records metrics. Should be used only for Platform.";
    public static final String CLIENT_TOPIC_MAX_METRICS_COUNT_CONFIG = "confluent.client.topic.max.metrics.count";
    public static final String CLIENT_TOPIC_MAX_METRICS_COUNT_DOC = "Max count of client topic bytes/records metrics to be tracked.";
    public static final Long CLIENT_TOPIC_MAX_METRICS_COUNT_DEFAULT;
    public static final String CLIENT_TOPIC_METRICS_EXPIRY_SEC_CONFIG = "confluent.client.topic.metrics.expiry.sec";
    public static final String CLIENT_TOPIC_METRICS_EXPIRY_SEC_DOC = "Expiry time for client topic bytes/records metrics.";
    public static final Long CLIENT_TOPIC_METRICS_EXPIRY_SEC_DEFAULT;
    public static final String CLIENT_TOPIC_METRICS_IGNORE_TOPIC_PATTERN_CONFIG = "confluent.client.topic.metrics.ignore_internal_topic_pattern";
    public static final String CLIENT_TOPIC_METRICS_IGNORE_TOPIC_PATTERN_DOC = "Whether to ignore internal topics when recording client topic bytes/records metrics.";
    public static final String CLIENT_TOPIC_METRICS_IGNORE_TOPIC_PATTERN_DEFAULT = "_.*";
    public static final String CLIENT_TOPIC_METRICS_IGNORE_CLIENT_ID_PATTERN_CONFIG = "confluent.client.topic.metrics.ignore_client_id_pattern";
    public static final String CLIENT_TOPIC_METRICS_IGNORE_CLIENT_ID_PATTERN_DOC = "Pattern to ignore for internal client IDs when recording client topic bytes/records metrics. This is useful to avoid tracking metrics for internal clients those are used for replication";
    public static final String CLIENT_TOPIC_METRICS_IGNORE_CLIENT_ID_PATTERN_DEFAULT = "(?:link-.*-)?broker-\\d+-fetcher-\\d+(?:-pool-.*)?";
    public static final String ZONE_TAGGED_REQUEST_METRICS_ENABLE_CONFIG = "confluent.zone.tagged.request.metrics.enable";
    public static final String ZONE_TAGGED_REQUEST_METRICS_ENABLE_DOC = "Whether to tag all tenant request metrics with zone data. The zone data includes tags for the client zone ID, the Confluent gateway endpoint zone ID, and the serving broker zone ID. Note that additional configs might be needed to ensure that the zone data is captured and available for tagging.";
    public static final boolean ZONE_TAGGED_REQUEST_METRICS_ENABLE_DEFAULT = false;
    public static final String CALLING_RESOURCE_IDENTITY_TYPE_MAP_CONFIG = "confluent.calling.resource.identity.type.map";
    public static final String CALLING_RESOURCE_IDENTITY_TYPE_MAP_DOC = "Map between a regular expression matching the 'calling_resource_identity' field in a DPAT token claim and io.confluent.kafka.multitenant.CallingResourceIdentityType. Concretely, the user could define the mapping as <code>cc-unified-storage:CONFLUENT_TABLEFLOW,cc-tableflow-gateway-service:CONFLUENT_TABLEFLOW</code>. As shown, key and value are separated by a colon and map entries are separated by commas. When designing regular expression patterns for resource matching, ensure their scopes do not overlap. If multiple patterns match the same input, the system will unpredictably select one CallingResourceIdentityType from the conflicting matches.";
    public static final String CALLING_RESOURCE_IDENTITY_TYPE_MAP_DEFAULT = "";
    public static final String LISTENER_PROTOCOL_CONFIG = "confluent.listener.protocol";
    public static final String LISTENER_PROTOCOL_DOC = "The protocol to use for the listener. Valid values are TCP or HTTP2. This is used to determine the protocol to use for the listener. Must be used with listener name prefix. For example, to use HTTP/2 protocol for the EXTERNAL listener, set <code>listener.name.external.confluent.listener.protocol=HTTP2</code>.The default is TCP.";
    public static final String LISTENER_PROTOCOL_DEFAULT;
    public static final String NETTY_NUM_BOSS_THREADS_CONFIG = "confluent.protocol.netty.num.boss.threads";
    public static final String NETTY_NUM_BOSS_THREADS_DOC = "The number of boss threads to use for the netty server. This is used to determine the number of boss threads to use for the netty server. Must be used with listener name prefix. For example, to use 2 boss threads for the EXTERNAL listener, set <code>listener.name.external.confluent.protocol.netty.num.boss.threads=2</code>.The default is 1.";
    public static final int NETTY_NUM_BOSS_THREADS_DEFAULT = 1;
    public static final String NETTY_NUM_WORKER_THREADS_CONFIG = "confluent.protocol.netty.num.worker.threads";
    public static final String NETTY_NUM_WORKER_THREADS_DOC = "The number of worker threads to use for the netty server. This is used to determine the number of worker threads to use for the netty server. Must be used with listener name prefix. For example, to use 2 worker threads for the EXTERNAL listener, set <code>listener.name.external.confluent.protocol.netty.num.worker.threads=2</code>.The default is 4.";
    public static final int NETTY_NUM_WORKER_THREADS_DEFAULT = 4;
    public static final String HTTP2_CONNECTION_WINDOW_SIZE_CONFIG = "confluent.protocol.netty.http2.connection.window.size";
    public static final String HTTP2_CONNECTION_WINDOW_SIZE_DOC = "The connection window size for HTTP/2 connections. This is used to determine the connection window size for HTTP/2 connections. Must be used with listener name prefix. For example, to use 30MiB connection window size for the EXTERNAL listener, set <code>listener.name.external.confluent.protocol.netty.http2.connection.window.size=31457280</code>.The default is 30MiB.";
    public static final int HTTP2_CONNECTION_WINDOW_SIZE_DEFAULT = 0x1E00000;
    public static final String HTTP2_INITIAL_WINDOW_SIZE_CONFIG = "confluent.protocol.netty.http2.initial.window.size";
    public static final String HTTP2_INITIAL_WINDOW_SIZE_DOC = "The initial window size for HTTP/2 connections. This is used to determine the initial window size for HTTP/2 connections. Must be used with listener name prefix. For example, to use 150KiB initial window size for the EXTERNAL listener, set <code>listener.name.external.confluent.protocol.netty.http2.initial.window.size=153600</code>.The default is 150KiB.";
    public static final int HTTP2_INITIAL_WINDOW_SIZE_DEFAULT = 153600;
    public static final String HTTP2_MAX_FRAME_SIZE_CONFIG = "confluent.protocol.netty.http2.max.frame.size";
    public static final String HTTP2_MAX_FRAME_SIZE_DOC = "The maximum frame size for HTTP/2 connections. This is used to determine the maximum frame size for HTTP/2 connections. Must be used with listener name prefix. For example, to use 16KiB maximum frame size for the EXTERNAL listener, set <code>listener.name.external.confluent.protocol.netty.http2.max.frame.size=16384</code>.The default is 16KiB.";
    public static final int HTTP2_MAX_FRAME_SIZE_DEFAULT = 16384;
    public static final String HTTP2_STREAM_GRACEFUL_CLOSE_TIMEOUT_MS = "confluent.protocol.netty.http2.stream.graceful.close.timeout.ms";
    public static final String HTTP2_STREAM_GRACEFUL_CLOSE_TIMEOUT_MS_DOC = "The timeout in milliseconds for gracefully closing an HTTP/2 stream. This is used to determine the timeout for gracefully closing an HTTP/2 stream. Must be used with listener name prefix. For example, to use 10 seconds for the EXTERNAL listener, set <code>listener.name.external.confluent.protocol.netty.http2.stream.graceful.close.timeout.ms=10000</code>.The default is 60 seconds.";
    public static final int HTTP2_STREAM_GRACEFUL_CLOSE_TIMEOUT_MS_DEFAULT;
    public static final String HTTP2_FLOW_CONTROL_CONFIG = "confluent.protocol.netty.http2.flow.control.enabled";
    public static final String HTTP2_FLOW_CONTROL_DOC = "The flag to enable flow control for HTTP/2 connections. Must be used with listener name prefix. For example, to enable HTTP/2 flow control for the EXTERNAL listener, set <code>listener.name.external.confluent.protocol.netty.http2.flow.control.enabled=true</code>.The default is true.";
    public static final boolean HTTP2_FLOW_CONTROL_DEFAULT = true;
    public static final String REJECT_INVALID_SNI_HOSTNAMES_CONFIG = "confluent.reject.invalid.sni.hostnames";
    public static final String REJECT_INVALID_SNI_HOSTNAMES_DOC = "If set to true, the broker will reject any new connections with an invalid or missing SNI hostnames during the authentication of new clients";
    public static final boolean REJECT_INVALID_SNI_HOSTNAMES_DEFAULT = false;

    public static BrokerInterceptor buildBrokerInterceptor(ConnectionMode connectionMode, Map<String, ?> configs) {
        if (connectionMode == ConnectionMode.CLIENT) {
            return null;
        }
        BrokerInterceptor interceptor = new DefaultBrokerInterceptor();
        if (configs.containsKey(BROKER_INTERCEPTOR_CLASS_CONFIG)) {
            Class interceptorClass = (Class)configs.get(BROKER_INTERCEPTOR_CLASS_CONFIG);
            interceptor = (BrokerInterceptor)Utils.newInstance(interceptorClass);
        }
        interceptor.configure(configs);
        return interceptor;
    }

    public static boolean clusterLinkMetricReductionAdvancedEnabled(Map<String, ?> configs) {
        Boolean enabled = (Boolean)configs.get(CLUSTER_LINK_ENABLE_METRICS_REDUCTION_ADVANCED_CONFIG);
        return enabled == null ? false : enabled;
    }

    public static boolean multiTenantInterceptorCollectApiVersionsEnabled(Map<String, ?> configs) {
        Boolean multiTenantInterceptorCollectApiVersions = (Boolean)configs.get(MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_CONFIG);
        return multiTenantInterceptorCollectApiVersions == null ? false : multiTenantInterceptorCollectApiVersions;
    }

    public static int multiTenantInterceptorCollectApiVersionsMaxPerTenant(Map<String, ?> configs) {
        Integer multiTenantInterceptorCollectApiVersionsMaxPerTenant = (Integer)configs.get(MULTITENANT_INTERCEPTOR_RECORD_API_VERSIONS_MAX_PER_TENANT_CONFIG);
        return multiTenantInterceptorCollectApiVersionsMaxPerTenant == null ? 1000 : multiTenantInterceptorCollectApiVersionsMaxPerTenant;
    }

    public static int uniqueDeprecatedRequestMetricsPerTenant(Map<String, ?> configs) {
        Integer uniqueDeprecatedRequestMetricsPerTenant = (Integer)configs.get(UNIQUE_DEPRECATED_REQUEST_METRICS_PER_TENANT_CONFIG);
        return uniqueDeprecatedRequestMetricsPerTenant == null ? 1000 : uniqueDeprecatedRequestMetricsPerTenant;
    }

    public static MultiTenantMetadata buildMultitenantMetadata(Map<String, ?> configs, Metrics metrics) {
        MultiTenantMetadata meta = null;
        if (configs.get(MULTITENANT_METADATA_CLASS_CONFIG) != null) {
            Class multitenantMetadataClass = (Class)configs.get(MULTITENANT_METADATA_CLASS_CONFIG);
            try {
                meta = (MultiTenantMetadata)Utils.newParameterizedInstance(multitenantMetadataClass.getName(), Metrics.class, metrics);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException(e);
            }
            meta.configure(configs);
        }
        return meta;
    }

    public static MultiTenantMetadataLoader buildMultiTenantMetadataLoader(AbstractConfig config, Map<String, ?> interBrokerClientConfigs, Metrics metrics) {
        MultiTenantMetadataLoader metadataLoader = null;
        String topicName = config.getString(CDC_LKC_METADATA_TOPIC_CONFIG);
        if (topicName != null && !topicName.isEmpty()) {
            Map<String, Object> interBrokerClientConfigForMultiTenantMetadataLoader = ConfluentConfigs.maybePopulateInterBrokerBootstrapServersOnControllers(config, interBrokerClientConfigs);
            try {
                metadataLoader = (MultiTenantMetadataLoader)Utils.newParameterizedInstance(MULTI_TENANT_METADATA_LOADER_CLASS_NAME, Map.class, interBrokerClientConfigForMultiTenantMetadataLoader, Metrics.class, metrics, Time.class, Time.SYSTEM);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException(e);
            }
            metadataLoader.configure(config.values());
        }
        return metadataLoader;
    }

    public static MultiTenantSecretsStore buildMultiTenantSecretsStore(AbstractConfig config, Map<String, ?> interBrokerClientConfig, Metrics metrics) {
        MultiTenantSecretsStore secretsStore = null;
        String topicName = config.getString(CDC_API_KEYS_TOPIC_CONFIG);
        if (topicName != null && !topicName.isEmpty()) {
            Map<String, Object> interBrokerClientConfigForMultiTenantSecretsStore = ConfluentConfigs.maybePopulateInterBrokerBootstrapServersOnControllers(config, interBrokerClientConfig);
            try {
                secretsStore = (MultiTenantSecretsStore)Utils.newParameterizedInstance(MULTI_TENANT_SASL_SECRETS_STORE_CLASS_NAME, Map.class, interBrokerClientConfigForMultiTenantSecretsStore, Metrics.class, metrics);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException(e);
            }
            secretsStore.configure(config.values());
        }
        return secretsStore;
    }

    public static List<String> multitenantListenerNames(AbstractConfig config, ListenerName interBrokerListenerName) {
        return ConfluentConfigs.multitenantListenerNames(config.values(), interBrokerListenerName);
    }

    public static List<String> multitenantListenerNames(Map<String, ?> config, ListenerName interBrokerListenerName) {
        return ConfluentConfigs.listenerNames(MULTITENANT_LISTENER_NAMES_CONFIG, config, interBrokerListenerName);
    }

    public static Double linkRequestPercentageMultiplier(Map<String, ?> config) {
        Double multipler = (Double)config.get(CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_CONFIG);
        if (multipler == null) {
            multipler = CLUSTER_LINK_REQUEST_QUOTA_REQUEST_PERCENTAGE_MULTIPLIER_DEFAULT;
        }
        return multipler;
    }

    public static List<String> sslListenerNames(Map<String, ?> config) {
        ArrayList<String> sslEnabledListenerNames = new ArrayList<String>();
        String securityProtocolMapValue = (String)config.get("listener.security.protocol.map");
        if (securityProtocolMapValue != null) {
            String[] securityProtocolMap;
            for (String listenerEntry : securityProtocolMap = securityProtocolMapValue.split("\\s*,\\s*")) {
                String[] keyVal = listenerEntry.split(":");
                if (keyVal.length != 2) {
                    log.warn("Invalid listener security protocol map entry {}, skipping", (Object)listenerEntry);
                    continue;
                }
                if (!keyVal[1].toUpperCase(Locale.ROOT).contains("SSL")) continue;
                sslEnabledListenerNames.add(ListenerName.normalised(keyVal[0]).value());
            }
        }
        return sslEnabledListenerNames;
    }

    public static List<String> multitenantSslListenerNames(Map<String, ?> config, ListenerName interBrokerListenerName) {
        HashSet<String> sslListeners = new HashSet<String>(ConfluentConfigs.sslListenerNames(config));
        return ConfluentConfigs.multitenantListenerNames(config, interBrokerListenerName).stream().filter(sslListeners::contains).collect(Collectors.toList());
    }

    public static List<String> listenerNames(String listenersConfigName, Map<String, ?> config, ListenerName interBrokerListenerName) {
        List<String> listenerNames;
        String listenerNamesString = (String)config.get(listenersConfigName);
        if (listenerNamesString == null) {
            listenerNames = Collections.emptyList();
        } else {
            listenerNames = Arrays.stream(listenerNamesString.split("\\s*,\\s*")).filter(v -> !v.isEmpty()).map(v -> ListenerName.normalised(v).value()).collect(Collectors.toList());
            if (interBrokerListenerName != null && listenerNames.contains(interBrokerListenerName.value())) {
                throw new ConfigException(listenersConfigName + " contains the internal listener " + interBrokerListenerName.value());
            }
        }
        return listenerNames;
    }

    public static List<String> ccloudHostSuffixes(Map<String, ?> config) {
        String ccloudHostSuffixesString = (String)config.get(CCLOUD_HOST_SUFFIXES_CONFIG);
        if (ccloudHostSuffixesString == null) {
            ccloudHostSuffixesString = CCLOUD_HOST_SUFFIXES_DEFAULT;
        }
        List<String> ccloudHostSuffixes = Arrays.stream(ccloudHostSuffixesString.split("\\s*,\\s*")).filter(v -> !v.isEmpty()).collect(Collectors.toList());
        return ccloudHostSuffixes;
    }

    public static List<String> ccloudIntranetHostSuffixes(Map<String, ?> config) {
        String intranetHostSuffixesString = (String)config.get(CCLOUD_INTRANET_HOST_SUFFIXES_CONFIG);
        if (intranetHostSuffixesString == null) {
            intranetHostSuffixesString = CCLOUD_INTRANET_HOST_SUFFIXES_DEFAULT;
        }
        List<String> intranetHostSuffixes = Arrays.stream(intranetHostSuffixesString.split("\\s*,\\s*")).filter(v -> !v.isEmpty()).collect(Collectors.toList());
        return intranetHostSuffixes;
    }

    public static MultiTenantQuotaConsumer buildMultitenantQuotaConsumer(AbstractConfig config, Endpoint interBrokerEndpoint, Metrics metrics) {
        MultiTenantQuotaConsumer multiTenantQuotaConsumer;
        if (!config.getBoolean(CDC_CLIENT_QUOTAS_ENABLE_CONFIG).booleanValue()) {
            return null;
        }
        Map<String, Object> clientConfig = ConfluentConfigs.clientConfigsForEndpoint(config, interBrokerEndpoint);
        try {
            multiTenantQuotaConsumer = (MultiTenantQuotaConsumer)Utils.newParameterizedInstance(MULTI_TENANT_QUOTA_CONSUMER_CLASS_NAME, Map.class, clientConfig, Metrics.class, metrics);
        }
        catch (ClassNotFoundException e) {
            throw new KafkaException(e);
        }
        multiTenantQuotaConsumer.configure(config.values());
        return multiTenantQuotaConsumer;
    }

    public static UserMetadataStore buildUserMetadataStore(AbstractConfig config, Map<String, ?> interBrokerClientConfig, Metrics metrics) {
        UserMetadataStore userMetadataStore;
        Boolean enable = config.getBoolean(CDC_USER_METADATA_ENABLE_CONFIG);
        if (!enable.booleanValue() || enable == null) {
            return null;
        }
        String topic = config.getString(CDC_USER_METADATA_TOPIC_CONFIG);
        if (topic == null || topic.isEmpty()) {
            throw new ConfigException("Value for config confluent.cdc.user.metadata.topic can not be empty when user metadata store are enabled");
        }
        Map<String, Object> interBrokerClientConfigForUserMetadataStore = ConfluentConfigs.maybePopulateInterBrokerBootstrapServersOnControllers(config, interBrokerClientConfig);
        try {
            userMetadataStore = (UserMetadataStore)Utils.newParameterizedInstance(CDC_USER_METADATA_STORE_CLASS_NAME, Map.class, interBrokerClientConfigForUserMetadataStore, Metrics.class, metrics);
        }
        catch (ClassNotFoundException e) {
            throw new KafkaException(e);
        }
        userMetadataStore.configure(config.values());
        return userMetadataStore;
    }

    private static Map<String, Object> maybePopulateInterBrokerBootstrapServersOnControllers(AbstractConfig config, Map<String, ?> interBrokerClientConfig) {
        HashMap<String, Object> dstConfig = new HashMap<String, Object>(interBrokerClientConfig);
        Object processRoles = config.originals().get("process.roles");
        if (processRoles != null && processRoles.toString().equalsIgnoreCase("controller")) {
            String metadataSecurityProtocol;
            Object metadataBootstrapServersObject = config.originals().get("confluent.metadata.bootstrap.servers");
            Object metadataSecurityProtocolObject = config.originals().get("confluent.metadata.security.protocol");
            String metadataBootstrapServers = metadataBootstrapServersObject == null ? null : metadataBootstrapServersObject.toString();
            String string = metadataSecurityProtocol = metadataSecurityProtocolObject == null ? null : metadataSecurityProtocolObject.toString();
            if (metadataBootstrapServers != null && !metadataBootstrapServers.trim().isEmpty()) {
                dstConfig.put("bootstrap.servers", metadataBootstrapServers);
            }
            if (metadataSecurityProtocol != null && !metadataSecurityProtocol.trim().isEmpty()) {
                dstConfig.put("security.protocol", metadataSecurityProtocol);
            }
            ConfluentConfigs.updatePrefixedConfigs(config.originals(), dstConfig, CDC_TOPIC_METADATA_CONFIG_PREFIX, false);
        }
        return dstConfig;
    }

    public static LicenseValidator buildLicenseValidator(AbstractConfig config, Endpoint interBrokerEndpoint) {
        Configurable licenseValidator = null;
        ServiceLoader<LicenseValidator> validators = ServiceLoader.load(LicenseValidator.class);
        for (LicenseValidator validator : validators) {
            if (!validator.enabled()) continue;
            licenseValidator = validator;
            break;
        }
        if (licenseValidator == null) {
            throw new IllegalStateException("License validator not found");
        }
        licenseValidator.configure(ConfluentConfigs.clientConfigsForEndpoint(config, interBrokerEndpoint));
        return licenseValidator;
    }

    public static Map<String, Object> brokerToClientConfigs(Map<String, Object> originals, Map<String, ?> values) {
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(originals);
        Set<String> brokerConfigNames = values.keySet();
        clientConfigs.keySet().removeIf(n -> brokerConfigNames.contains(n) && !AdminClientConfig.configNames().contains(n) || n.startsWith("listener.name."));
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigsForEndpoint(AbstractConfig brokerConfig, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.clientConfigsForEndpoint(brokerConfig.originals(), brokerConfig.values(), interBrokerEndpoint);
    }

    public static Map<String, Object> interBrokerClientConfigs(AbstractConfig brokerConfig, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.clientConfigsForEndpoint(brokerConfig.originals(), brokerConfig.values(), interBrokerEndpoint);
    }

    public static Map<String, Object> clientConfigsForEndpoint(Map<String, Object> originals, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.clientConfigsForEndpoint(originals, Collections.emptyMap(), interBrokerEndpoint);
    }

    public static Map<String, Object> clientConfigsForEndpoint(Map<String, Object> originals, Map<String, ?> values, Endpoint interBrokerEndpoint) {
        ListenerName listenerName = new ListenerName(interBrokerEndpoint.listener());
        SecurityProtocol securityProtocol = interBrokerEndpoint.securityProtocol();
        Map<String, Object> clientConfigs = ConfluentConfigs.clientConfigsForEndpoint(originals, values, listenerName, securityProtocol);
        String ibpHost = interBrokerEndpoint.host() == null ? "" : interBrokerEndpoint.host();
        clientConfigs.put("bootstrap.servers", ibpHost + ":" + interBrokerEndpoint.port());
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigsForEndpoint(Map<String, Object> originals, Map<String, ?> values, ListenerName listenerName, SecurityProtocol securityProtocol) {
        Map<String, Object> clientConfigs = ConfluentConfigs.brokerToClientConfigs(originals, values);
        ConfluentConfigs.enableSslDynamicStoreUpdate(originals, clientConfigs);
        String listenerPrefix = listenerName.configPrefix();
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            String saslMechanism = (String)originals.get("sasl.mechanism.inter.broker.protocol");
            saslMechanism = saslMechanism != null ? saslMechanism : "GSSAPI";
            clientConfigs.put("sasl.mechanism", saslMechanism);
            String mechanismPrefix = listenerName.saslMechanismConfigPrefix(saslMechanism);
            ConfluentConfigs.updatePrefixedConfigs(originals, clientConfigs, mechanismPrefix);
            if (!clientConfigs.containsKey("sasl.jaas.config")) {
                String jaasConfig = JaasContext.listenerSaslJaasConfig(listenerName, saslMechanism);
                clientConfigs.put("sasl.jaas.config", jaasConfig);
            }
        }
        ConfluentConfigs.updatePrefixedConfigs(originals, clientConfigs, listenerPrefix);
        clientConfigs.put("security.protocol", securityProtocol.name);
        clientConfigs.remove("principal.builder.class");
        clientConfigs.computeIfAbsent("metadata.recovery.strategy", unused -> MetadataRecoveryStrategy.NONE.name);
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigs(AbstractConfig config, String configPrefix, ClientType clientType, String topicPrefix, String componentId) {
        Map<String, Object> srcConfigs = config.originals();
        srcConfigs.keySet().removeAll(config.values().keySet());
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(srcConfigs);
        clientConfigs.remove("metric.reporters");
        clientConfigs.put("enable.metrics.push", false);
        clientConfigs.remove("principal.builder.class");
        clientConfigs.put("client.id", String.format("%s-%s-%s", topicPrefix, clientType.type, componentId));
        ConfluentConfigs.enableSslDynamicStoreUpdate(srcConfigs, clientConfigs);
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix + clientType.type + ".");
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix);
        clientConfigs.computeIfAbsent("metadata.recovery.strategy", unused -> MetadataRecoveryStrategy.NONE.name);
        return clientConfigs;
    }

    public static void enableSslDynamicStoreUpdate(Map<String, ?> originals, Map<String, Object> clientConfigs) {
        String enableSslDynamicStoreUpdate = (String)originals.get(BROKER_CLIENTS_SSL_FILE_STORE_RELOAD_ENABLE_CONFIG);
        if (Boolean.parseBoolean(enableSslDynamicStoreUpdate)) {
            clientConfigs.put(SSL_ENABLE_DYNAMIC_STORE_UPDATE, AUDIT_LOGGER_ENABLE_DEFAULT);
        }
    }

    public static boolean clientConfigsLoggingEnabled(Map<String, ?> originals) {
        return Boolean.parseBoolean(originals.getOrDefault(CONFIGS_LOGGING_ENABLED_PROP, AUDIT_LOGGER_ENABLE_DEFAULT).toString());
    }

    public static boolean requireCompatibleKeystores(Map<String, ?> configs) {
        Object value = configs.get(REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_CONFIG);
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.require.compatible.keystore.updates` (must be a boolean)");
    }

    public static FipsValidator buildFipsValidator() {
        FipsValidator fipsValidator = null;
        ServiceLoader<FipsValidator> validators = ServiceLoader.load(FipsValidator.class);
        for (FipsValidator validator : validators) {
            if (!validator.fipsEnabled()) continue;
            fipsValidator = validator;
            break;
        }
        if (fipsValidator == null) {
            throw new IllegalStateException("FIPS validator not found");
        }
        return fipsValidator;
    }

    private static void updatePrefixedConfigs(Map<String, Object> configs, Map<String, Object> dstConfigs, String prefix) {
        ConfluentConfigs.updatePrefixedConfigs(configs, dstConfigs, prefix, true);
    }

    public static void updatePrefixedConfigs(Map<String, Object> configs, Map<String, Object> dstConfigs, String prefix, Boolean deletePrefixConfigFromConfigs) {
        Set<String> prefixed = configs.keySet().stream().filter(n -> n.startsWith(prefix)).collect(Collectors.toSet());
        prefixed.forEach(name -> {
            dstConfigs.remove(name);
            dstConfigs.put(name.substring(prefix.length()), configs.get(name));
        });
        if (deletePrefixConfigFromConfigs.booleanValue()) {
            configs.keySet().removeAll(prefixed);
        }
    }

    public static boolean getMTlsEnable(Map<String, ?> configs) {
        Object value = configs.get(MTLS_ENABLE_CONFIG);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.enable` (must be a boolean)");
    }

    public static boolean getOAuthUnionOfPoolsEnable(Map<String, ?> configs) {
        Object value = configs.get(OAUTH_UNION_OF_POOLS_ENABLE_CONFIG);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.oauth.union.of.pools.enable` (must be a boolean)");
    }

    public static boolean getNetworkContextVerificationEnable(Map<String, ?> configs) {
        Object value = configs.get(LAT_NETWORK_CONTEXT_VERIFICATION_ENABLE);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.lat.network.context.verification.enable` (must be a boolean)");
    }

    public static String getMTlsListenerName(Map<String, ?> configs) {
        Object value = configs.get(MTLS_LISTENER_NAME_CONFIG);
        if (value == null) {
            return MTLS_LISTENER_NAME_DEFAULT;
        }
        if (value instanceof String) {
            return ((String)value).trim();
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.listener.name` (must be a string)");
    }

    public static Class<? extends MTlsTruststoreManager> getMTlsTruststoreManagerClass(Map<String, ?> configs) {
        Object value = configs.get(MTLS_TRUSTSTORE_MANAGER_CLASS_CONFIG);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Class.forName((String)value).asSubclass(MTlsTruststoreManager.class);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.truststore.manager.class.name` (class not found)");
            }
            catch (ClassCastException e) {
                throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.truststore.manager.class.name` (class does not implemented " + MTlsTruststoreManager.class.getSimpleName() + " interface)");
            }
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.truststore.manager.class.name` (must be a string)");
    }

    public static MTlsConnectionManager buildMTlsConnectionManager(Map<String, ?> configs) {
        MTlsConnectionManager connectionManager;
        Class<MTlsConnectionManager> connectionManagerClass;
        try {
            connectionManagerClass = Class.forName(MTLS_CONNECTION_MANAGER_CLASS_NAME).asSubclass(MTlsConnectionManager.class);
        }
        catch (ClassCastException | ClassNotFoundException e) {
            log.warn("Failed to load MTlsConnectionManager class, fallback to NoopMTlsConnectionManager", (Throwable)e);
            connectionManagerClass = NoopMTlsConnectionManager.class;
        }
        try {
            connectionManager = Utils.newInstance(connectionManagerClass);
        }
        catch (Exception e) {
            throw new KafkaException("Failed to instantiate MTlsConnectionManager", e);
        }
        connectionManager.configure(configs);
        return connectionManager;
    }

    public static int getMTlsSaslAuthenticatorRequestMaxBytes(Map<String, ?> configs) {
        Object value = configs.get(MTLS_SASL_AUTHENTICATOR_REQUEST_MAX_BYTES_CONFIG);
        if (value == null) {
            return 0x6400000;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.sasl.authenticator.request.max.bytes` (must be an integer)");
            }
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.sasl.authenticator.request.max.bytes` (must be an integer)");
    }

    public static boolean getMTlsBuildClientCertChain(Map<String, ?> configs) {
        Object value = configs.get(MTLS_BUILD_CLIENT_CERT_CHAIN_CONFIG);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.build.client.cert.chain.enable` (must be a boolean)");
    }

    public static int getMTlsTruststoreAlterConfigsTimeoutMs(Map<String, ?> configs) {
        Object value = configs.get(MTLS_TRUSTSTORE_ALTER_CONFIGS_TIMEOUT_MS_CONFIG);
        if (value == null) {
            return MTLS_TRUSTSTORE_ALTER_CONFIGS_TIMEOUT_MS_DEFAULT;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.truststore.alter.configs.timeout.ms` (must be an integer)");
            }
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.mtls.truststore.alter.configs.timeout.ms` (must be an integer)");
    }

    public static ListenerProtocol getListenerProtocol(Map<String, ?> configs) {
        Object value = configs.get(LISTENER_PROTOCOL_CONFIG);
        if (value == null) {
            return ListenerProtocol.TCP;
        }
        if (value instanceof String) {
            return ListenerProtocol.valueOf(((String)value).toUpperCase(Locale.ROOT));
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `confluent.listener.protocol` (must be a string)");
    }

    public static ApplicationProtocolConfig getApplicationProtocolConfig(Map<String, ?> configs) {
        ListenerProtocol listenerProtocol = ConfluentConfigs.getListenerProtocol(configs);
        return listenerProtocol == ListenerProtocol.HTTP2 ? new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2"}) : ApplicationProtocolConfig.DISABLED;
    }

    public static int getIntValueOrDefault(Map<String, ?> configs, String configName, int defaultValue) {
        Object value = configs.get(configName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `" + configName + "` (must be an integer)");
            }
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `" + configName + "` (must be an integer)");
    }

    public static long getLongValueOrDefault(Map<String, ?> configs, String configName, long defaultValue) {
        Object value = configs.get(configName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `" + configName + "` (must be a long)");
            }
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `" + configName + "` (must be a long)");
    }

    public static boolean getBooleanValueOrDefault(Map<String, ?> configs, String configName, boolean defaultValue) {
        Object value = configs.get(configName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        throw new ConfigException("Invalid value `" + String.valueOf(value) + "` for configuration `" + configName + "` (must be a boolean)");
    }

    static {
        CONNECTIONS_MAX_AGE_MS_MAX = CONNECTIONS_MAX_AGE_MS_DEFAULT = Long.valueOf(TimeUnit.MILLISECONDS.convert(36500L, TimeUnit.DAYS));
        CONNECTIONS_MAX_AGE_MS_DOC = "Max connection age timeout: the server socket processor threads close connections older than this. Can be set per-listener. Must be positive and less than 100 years (" + CONNECTIONS_MAX_AGE_MS_MAX + " ms).";
        CONNECTIONS_MIN_EXPIRE_INTERVAL_DEFAULT = 250L;
        DURABILITY_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
        DURABILITY_TOPIC_PARTITION_COUNT_DEFAULT = 50;
        DURABILITY_AUDIT_REPORTING_BATCH_MS_DEFAULT = 1800000;
        DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DEFAULT = 900000;
        DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT = 900000L;
        DURABILITY_AUDIT_TIER_COMPACTION_AUDIT_DURATION_MS_DEFAULT = 14400000L;
        BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        BROKER_LOAD_WINDOW_SIZE_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        BROKER_LOAD_START_METRIC_DELAY_MS_DEFAULT = Duration.ofMinutes(3L).toMillis();
        PROXY_PROTOCOL_VERSION_DEFAULT = ProxyProtocol.NONE.toString();
        PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT = false;
        PROXY_PROTOCOL_CLIENT_VERSION_DEFAULT = PROXY_PROTOCOL_VERSION_DEFAULT;
        PROXY_PROTOCOL_CLIENT_MODE_DOC = "This configuration specifies the origin of the connection: remote (PROXY, the default) or local (LOCAL) node. This configuration is only valid when confluent.proxy.protocol.client.version is set to " + String.valueOf((Object)ProxyProtocol.V2) + " and ignored otherwise.";
        PROXY_PROTOCOL_CLIENT_MODE_DEFAULT = ProxyProtocolCommand.PROXY.name();
        LKC_ID_DOC = "This configuration specifies the LKC of the originating caller.This configuration is only valid when confluent.proxy.protocol.client.version is set to " + String.valueOf((Object)ProxyProtocol.V2) + " and ignored otherwise.";
        CONSUMER_LAG_EMITTER_INTERVAL_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DEFAULT = true;
        ELIGIBLE_CONTROLLERS_DEFAULT = Collections.emptyList();
        TRANSACTION_LOGGING_VERBOSITY_DEFAULT = 0;
        MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DEFAULT = false;
        SUBDOMAIN_SEPARATOR_MAP_DEFAULT = null;
        SUBDOMAIN_PREFIX_DEFAULT = null;
        CLUSTER_METADATA_SNAPSHOT_TIER_DELETE_RETENTION_MS_DEFAULT = Duration.ofDays(7L).toMillis();
        MTLS_TRUSTSTORE_MANAGER_CLASS_DOC = "Class that implements " + MTlsTruststoreManager.class.getSimpleName() + " interface.";
        MTLS_TRUSTSTORE_ALTER_CONFIGS_TIMEOUT_MS_DEFAULT = (int)TimeUnit.MINUTES.toMillis(5L);
        CLIENT_TOPIC_MAX_METRICS_COUNT_DEFAULT = 1000L;
        CLIENT_TOPIC_METRICS_EXPIRY_SEC_DEFAULT = 3600L;
        LISTENER_PROTOCOL_DEFAULT = ListenerProtocol.TCP.toString();
        HTTP2_STREAM_GRACEFUL_CLOSE_TIMEOUT_MS_DEFAULT = (int)Duration.ofSeconds(60L).toMillis();
    }

    public static enum ClientType {
        PRODUCER("producer", ProducerConfig.configNames()),
        CONSUMER("consumer", ConsumerConfig.configNames()),
        ADMIN("admin", AdminClientConfig.configNames()),
        COORDINATOR("coordinator", ConsumerConfig.configNames());

        final String type;
        final Set<String> configNames;

        private ClientType(String type, Set<String> configNames) {
            this.type = type;
            this.configNames = configNames;
        }
    }

    public static enum ClusterLinkQuotaMode {
        CLUSTER_LINK_ONLY,
        TOTAL_INBOUND;

    }

    public static enum ClusterLinkThreadAffinity {
        LINK,
        TENANT;

    }

    public static enum ClusterLinkAvailabilityCheckMode {
        LINK_COORDINATOR,
        ALL;

    }

    public static class EligibleControllersValidator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            if (!(value instanceof List)) {
                throw new ConfigException("Unexpected value `" + String.valueOf(value) + "` for config `" + name + "` (should be a comma-separated list of broker IDs)");
            }
            List lst = (List)value;
            for (Object item : lst) {
                if (item instanceof Integer) continue;
                if (item instanceof String) {
                    try {
                        Integer.parseInt((String)item);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ConfigException("Unexpected list item `" + String.valueOf(item) + "` found in config `" + name + "` (each list item should be an integral broker ID)");
                    }
                }
                throw new ConfigException("Unexpected list item `" + String.valueOf(item) + "` found in config `" + name + "` (each list item should be an integral broker ID)");
            }
        }
    }

    public static class ChecksumEnabledFilesValidator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            if (value == null) {
                throw new ConfigException(name, (Object)null);
            }
            ConfigDef.ValidList validList = ConfigDef.ValidList.in(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL, ConfluentConfigs.CHECKSUM_ENABLED_FILES_TIERSTATE, "none");
            validList.ensureValid(name, value);
            List values = (List)value;
            if (values.contains(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL) && values.contains("none")) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain one of all or none");
            }
            if (values.contains(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL) && values.size() != 1) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain all");
            }
            if (values.contains("none") && values.size() != 1) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain none");
            }
        }
    }

    public static enum BalancerSelfHealMode {
        EMPTY_BROKER,
        ANY_UNEVEN_LOAD;

    }
}

