/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class AlterMirrorsRequestDataJsonConverter {
    public static AlterMirrorsRequestData read(JsonNode _node, short _version) {
        AlterMirrorsRequestData _object = new AlterMirrorsRequestData();
        JsonNode _opsNode = _node.get("ops");
        if (_opsNode == null) {
            if (_version <= 1) {
                throw new RuntimeException("AlterMirrorsRequestData: unable to locate field 'ops', which is mandatory in version " + _version);
            }
            _object.ops = new ArrayList<AlterMirrorsRequestData.OpData>(0);
        } else {
            if (!_opsNode.isArray()) {
                throw new RuntimeException("AlterMirrorsRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<AlterMirrorsRequestData.OpData> _collection = new ArrayList<AlterMirrorsRequestData.OpData>(_opsNode.size());
            _object.ops = _collection;
            for (Object _element : _opsNode) {
                _collection.add(OpDataJsonConverter.read((JsonNode)_element, _version));
            }
        }
        JsonNode _mirrorOperationsNode = _node.get("mirrorOperations");
        if (_mirrorOperationsNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("AlterMirrorsRequestData: unable to locate field 'mirrorOperations', which is mandatory in version " + _version);
            }
            _object.mirrorOperations = new ArrayList<AlterMirrorsRequestData.MirrorOperation>(0);
        } else {
            if (!_mirrorOperationsNode.isArray()) {
                throw new RuntimeException("AlterMirrorsRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<AlterMirrorsRequestData.MirrorOperation> _collection = new ArrayList<AlterMirrorsRequestData.MirrorOperation>(_mirrorOperationsNode.size());
            _object.mirrorOperations = _collection;
            for (JsonNode _element : _mirrorOperationsNode) {
                _collection.add(MirrorOperationJsonConverter.read(_element, _version));
            }
        }
        JsonNode _validateOnlyNode = _node.get("validateOnly");
        if (_validateOnlyNode == null) {
            throw new RuntimeException("AlterMirrorsRequestData: unable to locate field 'validateOnly', which is mandatory in version " + _version);
        }
        if (!_validateOnlyNode.isBoolean()) {
            throw new RuntimeException("AlterMirrorsRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.validateOnly = _validateOnlyNode.asBoolean();
        JsonNode _timeoutMsNode = _node.get("timeoutMs");
        if (_timeoutMsNode == null) {
            throw new RuntimeException("AlterMirrorsRequestData: unable to locate field 'timeoutMs', which is mandatory in version " + _version);
        }
        _object.timeoutMs = MessageUtil.jsonNodeToInt(_timeoutMsNode, "AlterMirrorsRequestData");
        return _object;
    }

    public static JsonNode write(AlterMirrorsRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version <= 1) {
            ArrayNode _opsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AlterMirrorsRequestData.OpData opData : _object.ops) {
                _opsArray.add(OpDataJsonConverter.write(opData, _version, _serializeRecords));
            }
            _node.set("ops", (JsonNode)_opsArray);
        } else if (!_object.ops.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ops at version " + _version);
        }
        if (_version >= 2) {
            ArrayNode _mirrorOperationsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AlterMirrorsRequestData.MirrorOperation mirrorOperation : _object.mirrorOperations) {
                _mirrorOperationsArray.add(MirrorOperationJsonConverter.write(mirrorOperation, _version, _serializeRecords));
            }
            _node.set("mirrorOperations", (JsonNode)_mirrorOperationsArray);
        } else if (!_object.mirrorOperations.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default mirrorOperations at version " + _version);
        }
        _node.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)_object.validateOnly));
        _node.set("timeoutMs", (JsonNode)new IntNode(_object.timeoutMs));
        return _node;
    }

    public static JsonNode write(AlterMirrorsRequestData _object, short _version) {
        return AlterMirrorsRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class OpDataJsonConverter {
        public static AlterMirrorsRequestData.OpData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.OpData _object = new AlterMirrorsRequestData.OpData();
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OpData");
            }
            JsonNode _stopMirrorTopicNode = _node.get("stopMirrorTopic");
            if (_stopMirrorTopicNode == null) {
                throw new RuntimeException("OpData: unable to locate field 'stopMirrorTopic', which is mandatory in version " + _version);
            }
            if (_stopMirrorTopicNode.isNull()) {
                _object.stopMirrorTopic = null;
            } else {
                if (!_stopMirrorTopicNode.isArray()) {
                    throw new RuntimeException("OpData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<AlterMirrorsRequestData.StopMirrorTopicData> _collection = new ArrayList<AlterMirrorsRequestData.StopMirrorTopicData>(_stopMirrorTopicNode.size());
                _object.stopMirrorTopic = _collection;
                for (Object _element : _stopMirrorTopicNode) {
                    _collection.add(StopMirrorTopicDataJsonConverter.read((JsonNode)_element, _version));
                }
            }
            JsonNode _clearMirrorTopicNode = _node.get("clearMirrorTopic");
            if (_clearMirrorTopicNode == null) {
                throw new RuntimeException("OpData: unable to locate field 'clearMirrorTopic', which is mandatory in version " + _version);
            }
            if (_clearMirrorTopicNode.isNull()) {
                _object.clearMirrorTopic = null;
            } else {
                if (!_clearMirrorTopicNode.isArray()) {
                    throw new RuntimeException("OpData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<AlterMirrorsRequestData.ClearMirrorTopicData> _collection = new ArrayList<AlterMirrorsRequestData.ClearMirrorTopicData>(_clearMirrorTopicNode.size());
                _object.clearMirrorTopic = _collection;
                for (JsonNode _element : _clearMirrorTopicNode) {
                    _collection.add(ClearMirrorTopicDataJsonConverter.read(_element, _version));
                }
            }
            JsonNode _pauseMirrorTopicNode = _node.get("pauseMirrorTopic");
            if (_pauseMirrorTopicNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("OpData: unable to locate field 'pauseMirrorTopic', which is mandatory in version " + _version);
                }
                _object.pauseMirrorTopic = null;
            } else if (_pauseMirrorTopicNode.isNull()) {
                _object.pauseMirrorTopic = null;
            } else {
                if (!_pauseMirrorTopicNode.isArray()) {
                    throw new RuntimeException("OpData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<AlterMirrorsRequestData.PauseMirrorTopicData> _collection = new ArrayList<AlterMirrorsRequestData.PauseMirrorTopicData>(_pauseMirrorTopicNode.size());
                _object.pauseMirrorTopic = _collection;
                for (JsonNode _element : _pauseMirrorTopicNode) {
                    _collection.add(PauseMirrorTopicDataJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.OpData _object, short _version, boolean _serializeRecords) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OpData");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            if (_object.stopMirrorTopic == null) {
                _node.set("stopMirrorTopic", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _stopMirrorTopicArray = new ArrayNode(JsonNodeFactory.instance);
                for (AlterMirrorsRequestData.StopMirrorTopicData stopMirrorTopicData : _object.stopMirrorTopic) {
                    _stopMirrorTopicArray.add(StopMirrorTopicDataJsonConverter.write(stopMirrorTopicData, _version, _serializeRecords));
                }
                _node.set("stopMirrorTopic", (JsonNode)_stopMirrorTopicArray);
            }
            if (_object.clearMirrorTopic == null) {
                _node.set("clearMirrorTopic", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _clearMirrorTopicArray = new ArrayNode(JsonNodeFactory.instance);
                for (AlterMirrorsRequestData.ClearMirrorTopicData clearMirrorTopicData : _object.clearMirrorTopic) {
                    _clearMirrorTopicArray.add(ClearMirrorTopicDataJsonConverter.write(clearMirrorTopicData, _version, _serializeRecords));
                }
                _node.set("clearMirrorTopic", (JsonNode)_clearMirrorTopicArray);
            }
            if (_version >= 1) {
                if (_object.pauseMirrorTopic == null) {
                    _node.set("pauseMirrorTopic", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _pauseMirrorTopicArray = new ArrayNode(JsonNodeFactory.instance);
                    for (AlterMirrorsRequestData.PauseMirrorTopicData pauseMirrorTopicData : _object.pauseMirrorTopic) {
                        _pauseMirrorTopicArray.add(PauseMirrorTopicDataJsonConverter.write(pauseMirrorTopicData, _version, _serializeRecords));
                    }
                    _node.set("pauseMirrorTopic", (JsonNode)_pauseMirrorTopicArray);
                }
            } else if (_object.pauseMirrorTopic != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default pauseMirrorTopic at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.OpData _object, short _version) {
            return OpDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class MirrorOperationJsonConverter {
        public static AlterMirrorsRequestData.MirrorOperation read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.MirrorOperation _object = new AlterMirrorsRequestData.MirrorOperation();
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorOperation");
            }
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("MirrorOperation: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("MirrorOperation expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topic = _topicNode.asText();
            JsonNode _operationCodeNode = _node.get("operationCode");
            if (_operationCodeNode == null) {
                throw new RuntimeException("MirrorOperation: unable to locate field 'operationCode', which is mandatory in version " + _version);
            }
            _object.operationCode = MessageUtil.jsonNodeToByte(_operationCodeNode, "MirrorOperation");
            JsonNode _mirrorOperationDataNode = _node.get("mirrorOperationData");
            if (_mirrorOperationDataNode == null) {
                if (_version >= 4) {
                    throw new RuntimeException("MirrorOperation: unable to locate field 'mirrorOperationData', which is mandatory in version " + _version);
                }
                _object.mirrorOperationData = null;
            } else {
                _object.mirrorOperationData = _mirrorOperationDataNode.isNull() ? null : MirrorOperationDataJsonConverter.read(_mirrorOperationDataNode, _version);
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.MirrorOperation _object, short _version, boolean _serializeRecords) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorOperation");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            _node.set("operationCode", (JsonNode)new ShortNode((short)_object.operationCode));
            if (_version >= 4) {
                if (_object.mirrorOperationData == null) {
                    _node.set("mirrorOperationData", (JsonNode)NullNode.instance);
                } else {
                    _node.set("mirrorOperationData", MirrorOperationDataJsonConverter.write(_object.mirrorOperationData, _version, _serializeRecords));
                }
            } else if (_object.mirrorOperationData != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorOperationData at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.MirrorOperation _object, short _version) {
            return MirrorOperationJsonConverter.write(_object, _version, true);
        }
    }

    public static class StopMirrorTopicDataJsonConverter {
        public static AlterMirrorsRequestData.StopMirrorTopicData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.StopMirrorTopicData _object = new AlterMirrorsRequestData.StopMirrorTopicData();
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("StopMirrorTopicData: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("StopMirrorTopicData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topic = _topicNode.asText();
            JsonNode _synchronizeNode = _node.get("synchronize");
            if (_synchronizeNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("StopMirrorTopicData: unable to locate field 'synchronize', which is mandatory in version " + _version);
                }
                _object.synchronize = true;
            } else {
                if (!_synchronizeNode.isBoolean()) {
                    throw new RuntimeException("StopMirrorTopicData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.synchronize = _synchronizeNode.asBoolean();
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.StopMirrorTopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            if (_version >= 1) {
                _node.set("synchronize", (JsonNode)BooleanNode.valueOf((boolean)_object.synchronize));
            } else if (!_object.synchronize) {
                throw new UnsupportedVersionException("Attempted to write a non-default synchronize at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.StopMirrorTopicData _object, short _version) {
            return StopMirrorTopicDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PauseMirrorTopicDataJsonConverter {
        public static AlterMirrorsRequestData.PauseMirrorTopicData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.PauseMirrorTopicData _object = new AlterMirrorsRequestData.PauseMirrorTopicData();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PauseMirrorTopicData");
            }
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("PauseMirrorTopicData: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("PauseMirrorTopicData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topic = _topicNode.asText();
            JsonNode _enableNode = _node.get("enable");
            if (_enableNode == null) {
                throw new RuntimeException("PauseMirrorTopicData: unable to locate field 'enable', which is mandatory in version " + _version);
            }
            if (!_enableNode.isBoolean()) {
                throw new RuntimeException("PauseMirrorTopicData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.enable = _enableNode.asBoolean();
            JsonNode _linkLevelNode = _node.get("linkLevel");
            if (_linkLevelNode == null) {
                throw new RuntimeException("PauseMirrorTopicData: unable to locate field 'linkLevel', which is mandatory in version " + _version);
            }
            if (!_linkLevelNode.isBoolean()) {
                throw new RuntimeException("PauseMirrorTopicData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.linkLevel = _linkLevelNode.asBoolean();
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.PauseMirrorTopicData _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PauseMirrorTopicData");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            _node.set("enable", (JsonNode)BooleanNode.valueOf((boolean)_object.enable));
            _node.set("linkLevel", (JsonNode)BooleanNode.valueOf((boolean)_object.linkLevel));
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.PauseMirrorTopicData _object, short _version) {
            return PauseMirrorTopicDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class MirrorOperationDataJsonConverter {
        public static AlterMirrorsRequestData.MirrorOperationData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.MirrorOperationData _object = new AlterMirrorsRequestData.MirrorOperationData();
            if (_version < 4) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorOperationData");
            }
            JsonNode _sourceTopicIdNode = _node.get("sourceTopicId");
            if (_sourceTopicIdNode == null) {
                throw new RuntimeException("MirrorOperationData: unable to locate field 'sourceTopicId', which is mandatory in version " + _version);
            }
            if (!_sourceTopicIdNode.isTextual()) {
                throw new RuntimeException("MirrorOperationData expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.sourceTopicId = Uuid.fromString(_sourceTopicIdNode.asText());
            JsonNode _sourceTopicNameNode = _node.get("sourceTopicName");
            if (_sourceTopicNameNode == null) {
                throw new RuntimeException("MirrorOperationData: unable to locate field 'sourceTopicName', which is mandatory in version " + _version);
            }
            if (!_sourceTopicNameNode.isTextual()) {
                throw new RuntimeException("MirrorOperationData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.sourceTopicName = _sourceTopicNameNode.asText();
            JsonNode _expectedLocalTopicIdNode = _node.get("expectedLocalTopicId");
            if (_expectedLocalTopicIdNode == null) {
                throw new RuntimeException("MirrorOperationData: unable to locate field 'expectedLocalTopicId', which is mandatory in version " + _version);
            }
            if (!_expectedLocalTopicIdNode.isTextual()) {
                throw new RuntimeException("MirrorOperationData expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.expectedLocalTopicId = Uuid.fromString(_expectedLocalTopicIdNode.asText());
            JsonNode _stoppedLogEndOffsetsNode = _node.get("stoppedLogEndOffsets");
            if (_stoppedLogEndOffsetsNode == null) {
                if (_version >= 5) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'stoppedLogEndOffsets', which is mandatory in version " + _version);
                }
                _object.stoppedLogEndOffsets = null;
            } else if (_stoppedLogEndOffsetsNode.isNull()) {
                _object.stoppedLogEndOffsets = null;
            } else {
                if (!_stoppedLogEndOffsetsNode.isArray()) {
                    throw new RuntimeException("MirrorOperationData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<Long> _collection = new ArrayList<Long>(_stoppedLogEndOffsetsNode.size());
                _object.stoppedLogEndOffsets = _collection;
                for (JsonNode _element : _stoppedLogEndOffsetsNode) {
                    _collection.add(MessageUtil.jsonNodeToLong(_element, "MirrorOperationData element"));
                }
            }
            JsonNode _mirrorTopicErrorCodeNode = _node.get("mirrorTopicErrorCode");
            if (_mirrorTopicErrorCodeNode == null) {
                if (_version >= 6) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'mirrorTopicErrorCode', which is mandatory in version " + _version);
                }
                _object.mirrorTopicErrorCode = 0;
            } else {
                _object.mirrorTopicErrorCode = MessageUtil.jsonNodeToShort(_mirrorTopicErrorCodeNode, "MirrorOperationData");
            }
            JsonNode _stoppedEpochsNode = _node.get("stoppedEpochs");
            if (_stoppedEpochsNode == null) {
                if (_version >= 7) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'stoppedEpochs', which is mandatory in version " + _version);
                }
                _object.stoppedEpochs = null;
            } else if (_stoppedEpochsNode.isNull()) {
                _object.stoppedEpochs = null;
            } else {
                if (!_stoppedEpochsNode.isArray()) {
                    throw new RuntimeException("MirrorOperationData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<Integer> _collection = new ArrayList<Integer>(_stoppedEpochsNode.size());
                _object.stoppedEpochs = _collection;
                for (Object _element : _stoppedEpochsNode) {
                    _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, "MirrorOperationData element"));
                }
            }
            JsonNode _truncationOffsetsNode = _node.get("truncationOffsets");
            if (_truncationOffsetsNode == null) {
                if (_version >= 8) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'truncationOffsets', which is mandatory in version " + _version);
                }
                _object.truncationOffsets = null;
            } else if (_truncationOffsetsNode.isNull()) {
                _object.truncationOffsets = null;
            } else {
                if (!_truncationOffsetsNode.isArray()) {
                    throw new RuntimeException("MirrorOperationData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<Long> _collection = new ArrayList<Long>(_truncationOffsetsNode.size());
                _object.truncationOffsets = _collection;
                for (Object _element : _truncationOffsetsNode) {
                    _collection.add(MessageUtil.jsonNodeToLong((JsonNode)_element, "MirrorOperationData element"));
                }
            }
            JsonNode _truncationEpochsNode = _node.get("truncationEpochs");
            if (_truncationEpochsNode == null) {
                if (_version >= 8) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'truncationEpochs', which is mandatory in version " + _version);
                }
                _object.truncationEpochs = null;
            } else if (_truncationEpochsNode.isNull()) {
                _object.truncationEpochs = null;
            } else {
                if (!_truncationEpochsNode.isArray()) {
                    throw new RuntimeException("MirrorOperationData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<Integer> _collection = new ArrayList<Integer>(_truncationEpochsNode.size());
                _object.truncationEpochs = _collection;
                for (Object _element : _truncationEpochsNode) {
                    _collection.add(MessageUtil.jsonNodeToInt((JsonNode)_element, "MirrorOperationData element"));
                }
            }
            JsonNode _mirrorStartOffsetsNode = _node.get("mirrorStartOffsets");
            if (_mirrorStartOffsetsNode == null) {
                if (_version >= 8) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'mirrorStartOffsets', which is mandatory in version " + _version);
                }
                _object.mirrorStartOffsets = null;
            } else if (_mirrorStartOffsetsNode.isNull()) {
                _object.mirrorStartOffsets = null;
            } else {
                if (!_mirrorStartOffsetsNode.isArray()) {
                    throw new RuntimeException("MirrorOperationData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<Long> _collection = new ArrayList<Long>(_mirrorStartOffsetsNode.size());
                _object.mirrorStartOffsets = _collection;
                for (JsonNode _element : _mirrorStartOffsetsNode) {
                    _collection.add(MessageUtil.jsonNodeToLong(_element, "MirrorOperationData element"));
                }
            }
            JsonNode _linkNameNode = _node.get("linkName");
            if (_linkNameNode == null) {
                if (_version >= 9) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'linkName', which is mandatory in version " + _version);
                }
                _object.linkName = null;
            } else if (_linkNameNode.isNull()) {
                _object.linkName = null;
            } else {
                if (!_linkNameNode.isTextual()) {
                    throw new RuntimeException("MirrorOperationData expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.linkName = _linkNameNode.asText();
            }
            JsonNode _stoppedSequenceNumberNode = _node.get("stoppedSequenceNumber");
            if (_stoppedSequenceNumberNode == null) {
                if (_version >= 9) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'stoppedSequenceNumber', which is mandatory in version " + _version);
                }
                _object.stoppedSequenceNumber = 0L;
            } else {
                _object.stoppedSequenceNumber = MessageUtil.jsonNodeToLong(_stoppedSequenceNumberNode, "MirrorOperationData");
            }
            JsonNode _includePartitionLevelTruncationDataNode = _node.get("includePartitionLevelTruncationData");
            if (_includePartitionLevelTruncationDataNode == null) {
                if (_version >= 10) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'includePartitionLevelTruncationData', which is mandatory in version " + _version);
                }
                _object.includePartitionLevelTruncationData = false;
            } else {
                if (!_includePartitionLevelTruncationDataNode.isBoolean()) {
                    throw new RuntimeException("MirrorOperationData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.includePartitionLevelTruncationData = _includePartitionLevelTruncationDataNode.asBoolean();
            }
            JsonNode _switchoverErrorCodeNode = _node.get("switchoverErrorCode");
            if (_switchoverErrorCodeNode == null) {
                if (_version >= 11) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'switchoverErrorCode', which is mandatory in version " + _version);
                }
                _object.switchoverErrorCode = (short)-1;
            } else {
                _object.switchoverErrorCode = MessageUtil.jsonNodeToShort(_switchoverErrorCodeNode, "MirrorOperationData");
            }
            JsonNode _switchoverErrorMessageNode = _node.get("switchoverErrorMessage");
            if (_switchoverErrorMessageNode == null) {
                if (_version >= 11) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'switchoverErrorMessage', which is mandatory in version " + _version);
                }
                _object.switchoverErrorMessage = "unchanged";
            } else {
                if (!_switchoverErrorMessageNode.isTextual()) {
                    throw new RuntimeException("MirrorOperationData expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.switchoverErrorMessage = _switchoverErrorMessageNode.asText();
            }
            JsonNode _switchoverMessagesTruncatedNode = _node.get("switchoverMessagesTruncated");
            if (_switchoverMessagesTruncatedNode == null) {
                if (_version >= 11) {
                    throw new RuntimeException("MirrorOperationData: unable to locate field 'switchoverMessagesTruncated', which is mandatory in version " + _version);
                }
                _object.switchoverMessagesTruncated = -1L;
            } else {
                _object.switchoverMessagesTruncated = MessageUtil.jsonNodeToLong(_switchoverMessagesTruncatedNode, "MirrorOperationData");
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.MirrorOperationData _object, short _version, boolean _serializeRecords) {
            if (_version < 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorOperationData");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("sourceTopicId", (JsonNode)new TextNode(_object.sourceTopicId.toString()));
            _node.set("sourceTopicName", (JsonNode)new TextNode(_object.sourceTopicName));
            _node.set("expectedLocalTopicId", (JsonNode)new TextNode(_object.expectedLocalTopicId.toString()));
            if (_version >= 5) {
                if (_object.stoppedLogEndOffsets == null) {
                    _node.set("stoppedLogEndOffsets", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _stoppedLogEndOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
                    for (Long l : _object.stoppedLogEndOffsets) {
                        _stoppedLogEndOffsetsArray.add((JsonNode)new LongNode(l.longValue()));
                    }
                    _node.set("stoppedLogEndOffsets", (JsonNode)_stoppedLogEndOffsetsArray);
                }
            } else if (_object.stoppedLogEndOffsets != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default stoppedLogEndOffsets at version " + _version);
            }
            if (_version >= 6) {
                _node.set("mirrorTopicErrorCode", (JsonNode)new ShortNode(_object.mirrorTopicErrorCode));
            }
            if (_version >= 7) {
                if (_object.stoppedEpochs == null) {
                    _node.set("stoppedEpochs", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _stoppedEpochsArray = new ArrayNode(JsonNodeFactory.instance);
                    for (Integer n : _object.stoppedEpochs) {
                        _stoppedEpochsArray.add((JsonNode)new IntNode(n.intValue()));
                    }
                    _node.set("stoppedEpochs", (JsonNode)_stoppedEpochsArray);
                }
            }
            if (_version >= 8) {
                if (_object.truncationOffsets == null) {
                    _node.set("truncationOffsets", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _truncationOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
                    for (Long l : _object.truncationOffsets) {
                        _truncationOffsetsArray.add((JsonNode)new LongNode(l.longValue()));
                    }
                    _node.set("truncationOffsets", (JsonNode)_truncationOffsetsArray);
                }
            } else if (_object.truncationOffsets != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default truncationOffsets at version " + _version);
            }
            if (_version >= 8) {
                if (_object.truncationEpochs == null) {
                    _node.set("truncationEpochs", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _truncationEpochsArray = new ArrayNode(JsonNodeFactory.instance);
                    for (Integer n : _object.truncationEpochs) {
                        _truncationEpochsArray.add((JsonNode)new IntNode(n.intValue()));
                    }
                    _node.set("truncationEpochs", (JsonNode)_truncationEpochsArray);
                }
            }
            if (_version >= 8) {
                if (_object.mirrorStartOffsets == null) {
                    _node.set("mirrorStartOffsets", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _mirrorStartOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
                    for (Long l : _object.mirrorStartOffsets) {
                        _mirrorStartOffsetsArray.add((JsonNode)new LongNode(l.longValue()));
                    }
                    _node.set("mirrorStartOffsets", (JsonNode)_mirrorStartOffsetsArray);
                }
            } else if (_object.mirrorStartOffsets != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorStartOffsets at version " + _version);
            }
            if (_version >= 9) {
                if (_object.linkName == null) {
                    _node.set("linkName", (JsonNode)NullNode.instance);
                } else {
                    _node.set("linkName", (JsonNode)new TextNode(_object.linkName));
                }
            }
            if (_version >= 9) {
                _node.set("stoppedSequenceNumber", (JsonNode)new LongNode(_object.stoppedSequenceNumber));
            }
            if (_version >= 10) {
                _node.set("includePartitionLevelTruncationData", (JsonNode)BooleanNode.valueOf((boolean)_object.includePartitionLevelTruncationData));
            }
            if (_version >= 11) {
                _node.set("switchoverErrorCode", (JsonNode)new ShortNode(_object.switchoverErrorCode));
            }
            if (_version >= 11) {
                _node.set("switchoverErrorMessage", (JsonNode)new TextNode(_object.switchoverErrorMessage));
            }
            if (_version >= 11) {
                _node.set("switchoverMessagesTruncated", (JsonNode)new LongNode(_object.switchoverMessagesTruncated));
            }
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.MirrorOperationData _object, short _version) {
            return MirrorOperationDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class ClearMirrorTopicDataJsonConverter {
        public static AlterMirrorsRequestData.ClearMirrorTopicData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.ClearMirrorTopicData _object = new AlterMirrorsRequestData.ClearMirrorTopicData();
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("ClearMirrorTopicData: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("ClearMirrorTopicData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.topic = _topicNode.asText();
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.ClearMirrorTopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.ClearMirrorTopicData _object, short _version) {
            return ClearMirrorTopicDataJsonConverter.write(_object, _version, true);
        }
    }
}

