/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.ByteUtils;

public class AppendRecordsRequestData
implements ApiMessage {
    long replicaEpoch;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("replica_epoch", Type.INT64, "The broker epoch of the follower."), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_0), "The topics to push."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AppendRecordsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AppendRecordsRequestData() {
        this.replicaEpoch = -1L;
        this.topics = new ArrayList<TopicData>(0);
    }

    @Override
    public short apiKey() {
        return 10037;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.replicaEpoch = _readable.readLong();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicData> newCollection = new ArrayList<TopicData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicData(_readable, _version, _context));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeLong(this.replicaEpoch);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (TopicData topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(8);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicData topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AppendRecordsRequestData)) {
            return false;
        }
        AppendRecordsRequestData other = (AppendRecordsRequestData)obj;
        if (this.replicaEpoch != other.replicaEpoch) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + ((int)(this.replicaEpoch >> 32) ^ (int)this.replicaEpoch);
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public AppendRecordsRequestData duplicate() {
        AppendRecordsRequestData _duplicate = new AppendRecordsRequestData();
        _duplicate.replicaEpoch = this.replicaEpoch;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
        for (TopicData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "AppendRecordsRequestData(replicaEpoch=" + this.replicaEpoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public long replicaEpoch() {
        return this.replicaEpoch;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AppendRecordsRequestData setReplicaEpoch(long v) {
        this.replicaEpoch = v;
        return this;
    }

    public AppendRecordsRequestData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public static class TopicData
    implements Message {
        Uuid topicId;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_id", Type.UUID, "The unique topic ID"), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_0), "The partitions to push."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicData() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<PartitionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionData> newCollection = new ArrayList<PartitionData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionData(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topicId = this.topicId;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        long replicationSessionId;
        int currentLeaderEpoch;
        long appendOffset;
        long highWatermark;
        BaseRecords records;
        long logStartOffset;
        boolean endReplicationSession;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("replication_session_id", Type.INT64, "The replication session ID."), new Field("current_leader_epoch", Type.INT32, "The current leader epoch of the partition."), new Field("append_offset", Type.INT64, "The corresponding log offset for the record batch."), new Field("high_watermark", Type.INT64, "The current high water mark."), new Field("records", Type.COMPACT_RECORDS, "The record data to be replicated."), Field.TaggedFieldsSection.of(0, new Field("log_start_offset", Type.INT64, "The current log start offset."), 1, new Field("end_replication_session", Type.BOOLEAN, "Whether to switch back to fetch mode for the partition.")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.replicationSessionId = -1L;
            this.currentLeaderEpoch = -1;
            this.appendOffset = -1L;
            this.highWatermark = -1L;
            this.records = null;
            this.logStartOffset = -1L;
            this.endReplicationSession = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.replicationSessionId = _readable.readLong();
            this.currentLeaderEpoch = _readable.readInt();
            this.appendOffset = _readable.readLong();
            this.highWatermark = _readable.readLong();
            int length = _readable.readUnsignedVarint() - 1;
            this.records = length < 0 ? null : _readable.readRecords(length);
            this.logStartOffset = -1L;
            this.endReplicationSession = false;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        this.logStartOffset = _readable.readLong();
                        continue block4;
                    }
                    case 1: {
                        this.endReplicationSession = _readable.readByte() != 0;
                        continue block4;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.replicationSessionId);
            _writable.writeInt(this.currentLeaderEpoch);
            _writable.writeLong(this.appendOffset);
            _writable.writeLong(this.highWatermark);
            if (this.records == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.records.sizeInBytes() + 1);
                _writable.writeRecords(this.records);
            }
            if (this.logStartOffset != -1L) {
                ++_numTaggedFields;
            }
            if (this.endReplicationSession) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            if (this.logStartOffset != -1L) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.logStartOffset);
            }
            if (this.endReplicationSession) {
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.endReplicationSession ? (byte)1 : 0);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(4);
            _size.addBytes(8);
            _size.addBytes(8);
            if (this.records == null) {
                _size.addBytes(1);
            } else {
                _size.addZeroCopyBytes(this.records.sizeInBytes());
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.records.sizeInBytes() + 1));
            }
            if (this.logStartOffset != -1L) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(8);
            }
            if (this.endReplicationSession) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.replicationSessionId != other.replicationSessionId) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            if (this.appendOffset != other.appendOffset) {
                return false;
            }
            if (this.highWatermark != other.highWatermark) {
                return false;
            }
            if (!Objects.equals(this.records, other.records)) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            if (this.endReplicationSession != other.endReplicationSession) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.replicationSessionId >> 32) ^ (int)this.replicationSessionId);
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + ((int)(this.appendOffset >> 32) ^ (int)this.appendOffset);
            hashCode = 31 * hashCode + ((int)(this.highWatermark >> 32) ^ (int)this.highWatermark);
            hashCode = 31 * hashCode + Objects.hashCode(this.records);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + (this.endReplicationSession ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.replicationSessionId = this.replicationSessionId;
            _duplicate.currentLeaderEpoch = this.currentLeaderEpoch;
            _duplicate.appendOffset = this.appendOffset;
            _duplicate.highWatermark = this.highWatermark;
            _duplicate.records = this.records == null ? null : MemoryRecords.readableRecords(((MemoryRecords)this.records).buffer().duplicate());
            _duplicate.logStartOffset = this.logStartOffset;
            _duplicate.endReplicationSession = this.endReplicationSession;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", replicationSessionId=" + this.replicationSessionId + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", appendOffset=" + this.appendOffset + ", highWatermark=" + this.highWatermark + ", records=" + String.valueOf(this.records) + ", logStartOffset=" + this.logStartOffset + ", endReplicationSession=" + (this.endReplicationSession ? "true" : "false") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long replicationSessionId() {
            return this.replicationSessionId;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public long appendOffset() {
            return this.appendOffset;
        }

        public long highWatermark() {
            return this.highWatermark;
        }

        public BaseRecords records() {
            return this.records;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public boolean endReplicationSession() {
            return this.endReplicationSession;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setReplicationSessionId(long v) {
            this.replicationSessionId = v;
            return this;
        }

        public PartitionData setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public PartitionData setAppendOffset(long v) {
            this.appendOffset = v;
            return this;
        }

        public PartitionData setHighWatermark(long v) {
            this.highWatermark = v;
            return this;
        }

        public PartitionData setRecords(BaseRecords v) {
            this.records = v;
            return this;
        }

        public PartitionData setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public PartitionData setEndReplicationSession(boolean v) {
            this.endReplicationSession = v;
            return this;
        }
    }
}

