/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.common.network.ProxyTlvValidator;

public class ProxyTlvType {
    public static final int PP2_TYPE_CFLT = 239;
    public static final int PP2_SUBTYPE_CFLT_LKC_ID = 1;
    public static final int PP2_SUBTYPE_CFLT_CCLOUD_TRAFFIC_TYPE = 2;
    public static final int PP2_SUBTYPE_CFLT_INGRESS_GATEWAY_ID = 16;
    public static final int PP2_SUBTYPE_CFLT_ACCESS_POINT_ID = 17;
    public static final int PP2_SUBTYPE_CFLT_AVAILABILITY_ZONE_ID = 18;
    public static final int PP2_SUBTYPE_CFLT_FQDN_TEMPLATE = 19;
    public static final int PP2_SUBTYPE_CFLT_INGRESS_TYPE = 20;
    public static final int PP2_SUBTYPE_CFLT_PRIVATE_ENDPOINT_ID = 21;
    public static final int PP2_SUBTYPE_CFLT_GATEWAY_ZONES = 22;
    private static final Set<ProxyTlvType> REGISTERED_TYPES = new HashSet<ProxyTlvType>();
    public static final ProxyTlvType LKC_ID = new Builder(239).subtype(1).validator(bytes -> {
        String lkcId = ProxyTlvType.lkcString(bytes);
        if (lkcId.trim().isEmpty()) {
            throw new IOException("The LKC ID in the TLV is missing");
        }
        if (!lkcId.startsWith("lkc-")) {
            throw new IOException("The LKC ID in the TLV (" + lkcId + ") is malformed");
        }
    }).valueComputer(ProxyTlvType::lkcString).build();
    public static final ProxyTlvType CCLOUD_TRAFFIC_TYPE = new Builder(239).subtype(2).validator(bytes -> CCloudTrafficType.valueOf(bytes)).valueComputer(CCloudTrafficType::valueOf).build();
    public static final ProxyTlvType INGRESS_GATEWAY_ID = new Builder(239).subtype(16).validator(bytes -> {
        String ingressGatewayId = ProxyTlvType.tlvStringASCII(bytes);
        if (ingressGatewayId.trim().isEmpty()) {
            throw new IOException("The Ingress Gateway Id in the TLV is missing");
        }
    }).valueComputer(ProxyTlvType::tlvStringASCII).build();
    public static final String PPV2_INGRESS_GATEWAY_ID_CLIENT_CONFIG = "confluent.ccloud.ingress.gateway.id";
    public static final ProxyTlvType ACCESS_POINT_ID = new Builder(239).subtype(17).validator(bytes -> {
        String accessPointId = ProxyTlvType.tlvStringASCII(bytes);
        if (accessPointId.trim().isEmpty()) {
            throw new IOException("The Access Point Id in the TLV is missing");
        }
    }).valueComputer(ProxyTlvType::tlvStringASCII).build();
    public static final String PPV2_ACCESS_POINT_ID_CLIENT_CONFIG = "confluent.ccloud.access.point.id";
    public static final ProxyTlvType AVAILABILITY_ZONE_ID = new Builder(239).subtype(18).validator(bytes -> {
        String availabilityZoneId = ProxyTlvType.tlvStringASCII(bytes);
        if (availabilityZoneId.trim().isEmpty()) {
            throw new IOException("The Availability Zone Id in the TLV is missing");
        }
    }).valueComputer(ProxyTlvType::tlvStringASCII).build();
    public static final String PPV2_AVAILABILITY_ZONE_ID_CLIENT_CONFIG = "confluent.ccloud.availability.zone.id";
    public static final ProxyTlvType FQDN_TEMPLATE = new Builder(239).subtype(19).validator(bytes -> {
        String accessPointId = ProxyTlvType.tlvStringASCII(bytes);
        if (accessPointId.trim().isEmpty()) {
            throw new IOException("The FQDN Template in the TLV is missing");
        }
    }).valueComputer(ProxyTlvType::tlvStringASCII).build();
    public static final String PPV2_FQDN_TEMPLATE_CLIENT_CONFIG = "confluent.ccloud.fqdn.template";
    public static final ProxyTlvType INGRESS_TYPE = new Builder(239).subtype(20).validator(bytes -> {
        String ingressType = ProxyTlvType.tlvStringASCII(bytes);
        if (ingressType.trim().isEmpty()) {
            throw new IOException("The Ingress Type in the TLV is missing");
        }
    }).valueComputer(ProxyTlvType::tlvStringASCII).build();
    public static final String PPV2_INGRESS_TYPE_CLIENT_CONFIG = "confluent.ccloud.ingress.type";
    public static final ProxyTlvType PRIVATE_ENDPOINT_ID = new Builder(239).subtype(21).validator(bytes -> {
        String privateEndpointId = ProxyTlvType.tlvStringASCII(bytes);
        if (privateEndpointId.trim().isEmpty()) {
            throw new IOException("The Private Endpoint Id in the TLV is missing");
        }
    }).valueComputer(ProxyTlvType::tlvStringASCII).build();
    public static final String PPV2_PRIVATE_ENDPOINT_ID_CLIENT_CONFIG = "confluent.ccloud.private.endpoint.id";
    public static final ProxyTlvType GATEWAY_ZONES = new Builder(239).subtype(22).validator(bytes -> {
        String gatewayZones = ProxyTlvType.tlvStringASCII(bytes);
        if (gatewayZones.trim().isEmpty()) {
            throw new IOException("The gateway zones in the TLV are missing");
        }
    }).valueComputer(bytes -> {
        String gatewayZones = ProxyTlvType.tlvStringASCII(bytes);
        String[] parts = gatewayZones.split(",");
        HashSet<String> zones = new HashSet<String>();
        for (String part : parts) {
            zones.add(part.trim());
        }
        return zones;
    }).build();
    public static final String PPV2_GATEWAY_ZONES_CLIENT_CONFIG = "confluent.ccloud.gateway.zones";
    public static final String PPV2_TLVS_CLIENT_CONFIG = "confluent.ccloud.ppv2.tlvs";
    public final int type;
    public final Optional<Integer> subtype;
    public final Optional<ProxyTlvValidator> validator;
    private final Optional<Function<byte[], Object>> valueComputer;

    public static String lkcString(byte[] bytes) {
        return new String(Arrays.copyOfRange(bytes, 1, bytes.length), StandardCharsets.UTF_8);
    }

    public static String tlvStringASCII(byte[] bytes) {
        return new String(Arrays.copyOfRange(bytes, 1, bytes.length), StandardCharsets.US_ASCII);
    }

    public ProxyTlvType(int type) {
        this(type, Optional.empty());
    }

    public ProxyTlvType(int type, Optional<Integer> subtype) {
        this(type, subtype, Optional.empty(), Optional.empty());
    }

    public ProxyTlvType(int type, Optional<Integer> subtype, Optional<ProxyTlvValidator> validator, Optional<Function<byte[], Object>> valueComputer) {
        this.type = type;
        this.subtype = subtype;
        this.validator = validator;
        this.valueComputer = valueComputer;
    }

    public static Set<ProxyTlvType> registeredTypes() {
        return Collections.unmodifiableSet(REGISTERED_TYPES);
    }

    public int type() {
        return this.type;
    }

    public Optional<Integer> subtype() {
        return this.subtype;
    }

    public Optional<ProxyTlvValidator> validator() {
        return this.validator;
    }

    public Object computeValue(byte[] value) {
        return this.valueComputer.map(objectFunction -> objectFunction.apply(value)).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyTlvType that = (ProxyTlvType)o;
        return this.type == that.type && this.subtype.equals(that.subtype);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.subtype);
    }

    public String toString() {
        return new StringJoiner(", ", ProxyTlvType.class.getSimpleName() + "[", "]").add("type=" + this.type).add("subtype=" + String.valueOf(this.subtype)).toString();
    }

    static class Builder {
        final int type;
        Optional<Integer> subtype = Optional.empty();
        Optional<ProxyTlvValidator> validator = Optional.empty();
        Optional<Function<byte[], Object>> valueComputer = Optional.empty();

        Builder(int type) {
            this.type = type;
        }

        Builder subtype(int subtype) {
            this.subtype = Optional.of(subtype);
            return this;
        }

        Builder validator(ProxyTlvValidator validator) {
            this.validator = Optional.of(validator);
            return this;
        }

        Builder valueComputer(Function<byte[], Object> valueComputer) {
            this.valueComputer = Optional.of(valueComputer);
            return this;
        }

        ProxyTlvType build() {
            ProxyTlvType ptt = new ProxyTlvType(this.type, this.subtype, this.validator, this.valueComputer);
            REGISTERED_TYPES.add(ptt);
            return ptt;
        }
    }
}

