/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolNegotiator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerProtocol;
import org.apache.kafka.common.network.netty.ssl.ReconfigurableSslContext;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.NettySslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.Utils;

public class Http2SslContext
extends ReconfigurableSslContext {
    private final SslFactory sslFactory;
    private final ConnectionMode mode;

    private Http2SslContext(ConnectionMode mode, String clientAuthConfigOverride) {
        this.mode = mode;
        this.sslFactory = new SslFactory(mode, clientAuthConfigOverride, false);
    }

    public static Http2SslContext forClient() {
        return new Http2SslContext(ConnectionMode.CLIENT, null);
    }

    public static Http2SslContext forServer(String clientAuthConfigOverride) {
        return new Http2SslContext(ConnectionMode.SERVER, clientAuthConfigOverride);
    }

    public static Http2SslContext forServer() {
        return Http2SslContext.forServer(null);
    }

    public boolean isClient() {
        return this.mode == ConnectionMode.CLIENT;
    }

    public List<String> cipherSuites() {
        String[] cipherSuites = this.sslEngineFactory().cipherSuites();
        return cipherSuites == null ? Collections.emptyList() : Arrays.asList(cipherSuites);
    }

    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        if (this.isClient()) {
            return this.sslEngineFactory().clientApplicationProtocolNegotiator();
        }
        return this.sslEngineFactory().serverApplicationProtocolNegotiator();
    }

    public SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.newEngine(byteBufAllocator, null, -1);
    }

    public SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String peerHost, int peerPort) {
        if (this.isClient()) {
            return this.sslEngineFactory().createClientSslEngine(byteBufAllocator, peerHost, peerPort, this.sslFactory.endpointIdentificationAlgorithm());
        }
        return this.sslEngineFactory().createServerSslEngine(byteBufAllocator, peerHost, peerPort);
    }

    public SSLSessionContext sessionContext() {
        if (this.isClient()) {
            return this.sslEngineFactory().clientSessionContext();
        }
        return this.sslEngineFactory().serverSessionContext();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.ensureValidConfigs(configs);
        this.sslFactory.configure(configs);
        Http2SslContext.ensureNettySslEngineFactory(this.sslFactory.sslEngineFactory());
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return this.sslFactory.reconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        this.ensureValidConfigs(configs);
        SslEngineFactory newSslEngineFactory = null;
        try {
            newSslEngineFactory = this.sslFactory.createNewSslEngineFactory(configs);
            Http2SslContext.ensureNettySslEngineFactory(newSslEngineFactory);
        }
        catch (IllegalStateException e) {
            throw new ConfigException("SSL reconfiguration failed due to " + String.valueOf(e));
        }
        finally {
            Utils.closeQuietly(newSslEngineFactory, "close ssl engine factory for validation");
        }
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        this.ensureValidConfigs(configs);
        this.sslFactory.reconfigure(configs);
        Http2SslContext.ensureNettySslEngineFactory(this.sslFactory.sslEngineFactory());
    }

    @Override
    public void close() throws IOException {
        this.sslFactory.close();
    }

    private void ensureValidConfigs(Map<String, ?> configs) {
        if (configs == null || configs.isEmpty()) {
            throw new ConfigException("SSL configuration cannot be null or empty");
        }
        if (ConfluentConfigs.getListenerProtocol(configs) != ListenerProtocol.HTTP2) {
            throw new ConfigException(Http2SslContext.class.getSimpleName() + " can only be used with HTTP/2 protocol");
        }
        if (Boolean.parseBoolean(String.valueOf(configs.get("confluent.accp.enabled")))) {
            throw new ConfigException("ACCP is not compatible with " + NettySslEngineFactory.class.getSimpleName());
        }
        if (this.mode == ConnectionMode.SERVER && !NettySslEngineFactory.configsContainKeystore(configs)) {
            throw new ConfigException("SSL keystore must be configured for server mode");
        }
        Class sslEngineFactoryClass = (Class)configs.get("ssl.engine.factory.class");
        if (!NettySslEngineFactory.class.equals((Object)sslEngineFactoryClass)) {
            throw new ConfigException("SSL engine factory must be of type " + NettySslEngineFactory.class.getSimpleName());
        }
        if (!NettySslEngineFactory.isConfigurable(configs, this.mode)) {
            throw new ConfigException(NettySslEngineFactory.class.getSimpleName() + " is not configurable in " + String.valueOf((Object)this.mode) + " mode");
        }
    }

    private static void ensureNettySslEngineFactory(SslEngineFactory sslEngineFactory) {
        if (!(sslEngineFactory instanceof NettySslEngineFactory)) {
            throw new ConfigException("SSL engine factory must be of type " + NettySslEngineFactory.class.getSimpleName());
        }
    }

    private NettySslEngineFactory sslEngineFactory() {
        return (NettySslEngineFactory)this.sslFactory.sslEngineFactory();
    }
}

