/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.kafka.common.requests.TransactionResult;

public class EndTxnRequest
extends AbstractRequest {
    public static final short LAST_STABLE_VERSION_BEFORE_TRANSACTION_V2 = 4;
    private final EndTxnRequestData data;

    private EndTxnRequest(EndTxnRequestData data, short version) {
        super(ApiKeys.END_TXN, version);
        this.data = data;
    }

    public TransactionResult result() {
        if (this.data.committed()) {
            return TransactionResult.COMMIT;
        }
        return TransactionResult.ABORT;
    }

    @Override
    public EndTxnRequestData data() {
        return this.data;
    }

    @Override
    public EndTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new EndTxnResponse(new EndTxnResponseData().setErrorCode(Errors.forException(e).code()).setThrottleTimeMs(throttleTimeMs));
    }

    public static EndTxnRequest parse(Readable readable, short version, MessageContext context) {
        return new EndTxnRequest(new EndTxnRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<EndTxnRequest> {
        public final EndTxnRequestData data;
        public final boolean isTransactionV2Enabled;

        public Builder(EndTxnRequestData data, boolean isTransactionV2Enabled) {
            this(data, false, isTransactionV2Enabled);
        }

        public Builder(EndTxnRequestData data, boolean enableUnstableLastVersion, boolean isTransactionV2Enabled) {
            super(ApiKeys.END_TXN, enableUnstableLastVersion);
            this.data = data;
            this.isTransactionV2Enabled = isTransactionV2Enabled;
        }

        @Override
        public EndTxnRequest build(short version) {
            if (!this.isTransactionV2Enabled) {
                version = (short)Math.min(version, 4);
            }
            return new EndTxnRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

