/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;

public class OffsetCommitRequest
extends AbstractRequest {
    public static final int DEFAULT_GENERATION_ID = -1;
    public static final String DEFAULT_MEMBER_ID = "";
    public static final long DEFAULT_RETENTION_TIME = -1L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    private final OffsetCommitRequestData data;

    public OffsetCommitRequest(OffsetCommitRequestData data, short version) {
        super(ApiKeys.OFFSET_COMMIT, version);
        this.data = data;
    }

    @Override
    public OffsetCommitRequestData data() {
        return this.data;
    }

    public Map<TopicPartition, Long> offsets() {
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        for (OffsetCommitRequestData.OffsetCommitRequestTopic topic : this.data.topics()) {
            for (OffsetCommitRequestData.OffsetCommitRequestPartition partition : topic.partitions()) {
                offsets.put(new TopicPartition(topic.name(), partition.partitionIndex()), partition.committedOffset());
            }
        }
        return offsets;
    }

    public static OffsetCommitResponseData getErrorResponse(OffsetCommitRequestData request, Errors error) {
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        request.topics().forEach(topic -> {
            OffsetCommitResponseData.OffsetCommitResponseTopic responseTopic = new OffsetCommitResponseData.OffsetCommitResponseTopic().setTopicId(topic.topicId()).setName(topic.name());
            response.topics().add(responseTopic);
            topic.partitions().forEach(partition -> responseTopic.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code())));
        });
        return response;
    }

    @Override
    public OffsetCommitResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new OffsetCommitResponse(OffsetCommitRequest.getErrorResponse(this.data, Errors.forException(e)).setThrottleTimeMs(throttleTimeMs));
    }

    @Override
    public OffsetCommitResponse getErrorResponse(Throwable e) {
        return this.getErrorResponse(0, e);
    }

    public static OffsetCommitRequest parse(Readable readable, short version, MessageContext context) {
        return new OffsetCommitRequest(new OffsetCommitRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetCommitRequest> {
        private final OffsetCommitRequestData data;

        private Builder(OffsetCommitRequestData data, short oldestAllowedVersion, short latestAllowedVersion) {
            super(ApiKeys.OFFSET_COMMIT, oldestAllowedVersion, latestAllowedVersion);
            this.data = data;
        }

        public static Builder forTopicIdsOrNames(OffsetCommitRequestData data, boolean enableUnstableLastVersion) {
            return new Builder(data, ApiKeys.OFFSET_COMMIT.oldestVersion(), ApiKeys.OFFSET_COMMIT.latestVersion(enableUnstableLastVersion));
        }

        public static Builder forTopicNames(OffsetCommitRequestData data) {
            return new Builder(data, ApiKeys.OFFSET_COMMIT.oldestVersion(), 9);
        }

        @Override
        public OffsetCommitRequest build(short version) {
            if (this.data.groupInstanceId() != null && version < 7) {
                throw new UnsupportedVersionException("The broker offset commit api version " + version + " does not support usage of config group.instance.id.");
            }
            if (version >= 10) {
                this.data.topics().forEach(topic -> {
                    if (topic.topicId() == null || topic.topicId().equals(Uuid.ZERO_UUID)) {
                        throw new UnsupportedVersionException("The broker offset commit api version " + version + " does require usage of topic ids.");
                    }
                });
            } else {
                this.data.topics().forEach(topic -> {
                    if (topic.name() == null || topic.name().isEmpty()) {
                        throw new UnsupportedVersionException("The broker offset commit api version " + version + " does require usage of topic names.");
                    }
                });
            }
            return new OffsetCommitRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

